/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Document;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class DocumentDataSource
implements DataSource {
    private Document mDocument;

    public DocumentDataSource(Document document) {
        if (document == null) {
            throw new NullPointerException("document cannot be null");
        }
        this.mDocument = document;
    }

    public String getContentType() {
        return this.mDocument.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.mDocument.getContentStream();
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.error((Object)"Unable to get document content", e);
            throw new IOException(e.toString());
        }
    }

    public String getName() {
        return this.mDocument.getName();
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }
}

