/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mime.ParsedDocument;
import com.zimbra.cs.store.MailboxBlob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends MailItem {
    protected String mContentType;
    protected String mCreator;
    protected String mFragment;
    private static final String CN_FRAGMENT = "fragment";
    private static final String CN_MIME_TYPE = "mime_type";
    private static final String CN_FILE_NAME = "filename";
    private static final String CN_EDITOR = "edited_by";

    public Document(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
    }

    public String getContentType() {
        return this.mContentType;
    }

    @Override
    public String getSender() {
        return this.getCreator();
    }

    public String getCreator() {
        return this.mCreator == null ? "" : this.mCreator;
    }

    public String getFragment() {
        return this.mFragment == null ? "" : this.mFragment;
    }

    @Override
    boolean isTaggable() {
        return true;
    }

    @Override
    boolean isCopyable() {
        return true;
    }

    @Override
    boolean isMovable() {
        return true;
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    boolean isIndexed() {
        return true;
    }

    @Override
    boolean canHaveChildren() {
        return false;
    }

    @Override
    int getMaxRevisions() throws ServiceException {
        return this.getAccount().getIntAttr("zimbraNotebookMaxRevisions", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexDocument> generateIndexData(boolean doConsistencyCheck) throws MailItem.TemporaryIndexingException {
        ParsedDocument pd = null;
        try {
            MailboxBlob mblob = this.getBlob();
            if (mblob == null) {
                ZimbraLog.index.warn("Unable to fetch blob for Document id " + this.mId + " version " + this.mVersion + " on volume " + this.getLocator());
                throw new MailItem.TemporaryIndexingException();
            }
            Mailbox mailbox = this.mMailbox;
            synchronized (mailbox) {
                pd = new ParsedDocument(mblob.getLocalBlob(), this.getName(), this.getContentType(), this.getChangeDate(), this.getCreator());
                if (pd.hasTemporaryAnalysisFailure()) {
                    throw new MailItem.TemporaryIndexingException();
                }
            }
            IndexDocument doc = pd.getDocument();
            if (doc != null) {
                ArrayList<IndexDocument> toRet = new ArrayList<IndexDocument>(1);
                toRet.add(doc);
                return toRet;
            }
            return new ArrayList<IndexDocument>(0);
        }
        catch (IOException e) {
            ZimbraLog.index.warn((Object)("Error generating index data for Wiki Document " + this.getId() + ". Item will not be indexed"), e);
            return new ArrayList<IndexDocument>(0);
        }
        catch (ServiceException e) {
            ZimbraLog.index.warn((Object)("Error generating index data for Wiki Document " + this.getId() + ". Item will not be indexed"), e);
            return new ArrayList<IndexDocument>(0);
        }
    }

    @Override
    public void reanalyze(Object obj) throws ServiceException {
        if (!(obj instanceof ParsedDocument)) {
            throw ServiceException.FAILURE("cannot reanalyze non-ParsedDocument object", null);
        }
        if ((this.mData.flags & Flag.BITMASK_UNCACHED) != 0) {
            throw ServiceException.FAILURE("cannot reanalyze an old item revision", null);
        }
        ParsedDocument pd = (ParsedDocument)obj;
        this.mContentType = pd.getContentType();
        this.mCreator = pd.getCreator();
        this.mFragment = pd.getFragment();
        this.mData.date = (int)(pd.getCreatedDate() / 1000L);
        this.mData.name = pd.getFilename();
        this.mData.subject = pd.getFilename();
        pd.setVersion(this.getVersion());
        if (this.mData.size != (long)pd.getSize()) {
            this.markItemModified(16);
            this.mMailbox.updateSize((long)pd.getSize() - this.mData.size, false);
            this.getFolder().updateSize(0, (long)pd.getSize() - this.mData.size);
            this.mData.size = pd.getSize();
        }
        this.saveData(null);
    }

    protected static MailItem.UnderlyingData prepareCreate(byte type, int id, Folder folder, String name, String mimeType, ParsedDocument pd, Metadata meta, MailItem.CustomMetadata custom) throws ServiceException {
        if (folder == null || !folder.canContain((byte)8)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!folder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        name = Document.validateItemName(name);
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        Mailbox mbox = folder.getMailbox();
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = type;
        data.folderId = folder.getId();
        if (!folder.inSpam() || mbox.getAccount().getBooleanAttr("zimbraJunkMessagesIndexingEnabled", false)) {
            data.indexId = mbox.generateIndexId(id);
        }
        data.imapId = id;
        data.date = (int)(pd.getCreatedDate() / 1000L);
        data.size = pd.getSize();
        data.name = name;
        data.subject = name;
        data.setBlobDigest(pd.getDigest());
        data.metadata = Document.encodeMetadata(meta, DEFAULT_COLOR_RGB, 1, extended, mimeType, pd.getCreator(), pd.getFragment()).toString();
        return data;
    }

    static Document create(int id, Folder folder, String filename, String type, ParsedDocument pd, MailItem.CustomMetadata custom) throws ServiceException {
        assert (id != -1);
        Mailbox mbox = folder.getMailbox();
        MailItem.UnderlyingData data = Document.prepareCreate((byte)8, id, folder, filename, type, pd, null, custom);
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("Adding Document %s: id=%d, folderId=%d, folderName=%s.", filename, data.id, folder.getId(), folder.getName());
        DbMailItem.create(mbox, data, null);
        Document doc = new Document(mbox, data);
        doc.finishCreation(null);
        pd.setVersion(doc.getVersion());
        return doc;
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        MetadataList revlist = meta.getList("rev", true);
        if (revlist != null && !revlist.isEmpty()) {
            try {
                Metadata rev = revlist.getMap(revlist.size() - 1);
                this.mCreator = rev.get("cr", null);
                this.mFragment = rev.get("f", null);
                int version = (int)rev.getLong("ver", 1L);
                if (version > 1 && rev.getLong("ver", 1L) != 1L) {
                    meta.put("ver", version);
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        super.decodeMetadata(meta);
        this.mContentType = meta.get("ct");
        this.mCreator = meta.get("cr", this.mCreator);
        this.mFragment = meta.get("f", this.mFragment);
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return Document.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mContentType, this.mCreator, this.mFragment);
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, String mimeType, String creator, String fragment) {
        if (meta == null) {
            meta = new Metadata();
        }
        meta.put("ct", mimeType);
        meta.put("cr", creator);
        meta.put("f", fragment);
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Document.getNameForType(this)).append(": {");
        sb.append(CN_FILE_NAME).append(": ").append(this.getName()).append(", ");
        sb.append(CN_EDITOR).append(": ").append(this.getCreator()).append(", ");
        sb.append(CN_MIME_TYPE).append(": ").append(this.mContentType).append(", ");
        sb.append(CN_FRAGMENT).append(": ").append(this.mFragment);
        this.appendCommonMembers(sb).append(", ");
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected boolean trackUserAgentInMetadata() {
        return true;
    }
}

