/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataCallback;
import com.zimbra.cs.mailbox.SenderList;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.session.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conversation
extends MailItem {
    private String mEncodedSenders;
    protected SenderList mSenderList;
    private static final int RECALCULATE_CHANGE_MASK = 526359;

    Conversation(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 4 && this.mData.type != 12) {
            throw new IllegalArgumentException();
        }
    }

    public String getNormalizedSubject() {
        return ParsedMessage.normalize(this.getSubject());
    }

    @Override
    public String getSender() {
        return "";
    }

    public int getMessageCount() {
        return (int)this.mData.size;
    }

    @Override
    public int getInternalFlagBitmask() {
        return 0;
    }

    SenderList getSenderList() throws ServiceException {
        this.loadSenderList();
        return this.mSenderList;
    }

    void instantiateSenderList() {
        if (this.mSenderList != null && (long)this.mSenderList.size() == this.mData.size) {
            return;
        }
        this.mSenderList = null;
        if (this.mEncodedSenders != null) {
            String encoded = this.mEncodedSenders;
            this.mEncodedSenders = null;
            try {
                this.mSenderList = SenderList.parse(encoded);
                if ((long)this.mSenderList.size() != this.mData.size) {
                    this.mSenderList = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean loadSenderList() throws ServiceException {
        this.instantiateSenderList();
        if (this.mSenderList != null) {
            return false;
        }
        this.recalculateMetadata();
        return true;
    }

    void recalculateCounts(List<Message> msgs) {
        this.markItemModified(7);
        this.mData.unreadCount = 0;
        this.mData.flags = 0;
        this.mData.tags = 0;
        for (Message msg : msgs) {
            this.mData.unreadCount += msg.getUnreadCount();
            this.mData.flags |= msg.getInternalFlagBitmask();
            this.mData.tags |= msg.getTagBitmask();
        }
    }

    SenderList recalculateMetadata() throws ServiceException {
        return this.recalculateMetadata(this.getMessages());
    }

    SenderList recalculateMetadata(List<Message> msgs) throws ServiceException {
        Collections.sort(msgs, new MailItem.SortDateAscending());
        this.markItemModified(526359);
        this.mEncodedSenders = null;
        this.mSenderList = new SenderList(msgs);
        this.mData.size = msgs.size();
        this.mData.unreadCount = 0;
        this.mData.flags = 0;
        this.mData.tags = 0;
        this.mExtendedData = null;
        for (Message msg : msgs) {
            super.addChild(msg);
            this.mData.unreadCount = this.mData.unreadCount + (msg.isUnread() ? 1 : 0);
            this.mData.flags |= msg.getInternalFlagBitmask();
            this.mData.tags |= msg.getTagBitmask();
            this.mExtendedData = MetadataCallback.duringConversationAdd(this.mExtendedData, msg);
        }
        ZimbraLog.mailbox.debug("resetting metadata: cid=" + this.mId + ", size was=" + this.mData.size + " is=" + this.mSenderList.size());
        this.saveData(null);
        return this.mSenderList;
    }

    List<Message> getMessages() throws ServiceException {
        return this.getMessages(SortBy.NONE);
    }

    List<Message> getMessages(SortBy sort) throws ServiceException {
        ArrayList<Message> msgs = new ArrayList<Message>(this.getMessageCount());
        List<MailItem.UnderlyingData> listData = DbMailItem.getByParent(this, sort);
        for (MailItem.UnderlyingData data : listData) {
            msgs.add(this.mMailbox.getMessage(data));
        }
        return msgs;
    }

    @Override
    boolean canAccess(short rightsNeeded) {
        return true;
    }

    @Override
    boolean canAccess(short rightsNeeded, Account authuser, boolean asAdmin) {
        return true;
    }

    @Override
    boolean isTaggable() {
        return false;
    }

    @Override
    boolean isCopyable() {
        return false;
    }

    @Override
    boolean isMovable() {
        return true;
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    boolean isIndexed() {
        return false;
    }

    @Override
    boolean canHaveChildren() {
        return true;
    }

    @Override
    boolean canParent(MailItem item) {
        return item instanceof Message;
    }

    static Conversation create(Mailbox mbox, int id, Message[] msgs) throws ServiceException {
        if (ZimbraLog.mailop.isDebugEnabled()) {
            StringBuilder msgIds = new StringBuilder();
            for (int i = 0; i < msgs.length; ++i) {
                msgIds.append(i > 0 ? "," : "").append(msgs[i].getId());
            }
            ZimbraLog.mailop.debug("Adding Conversation: id=%d, message(s): %s.", id, msgIds);
        }
        assert (id != -1 && msgs.length > 0);
        Arrays.sort(msgs, new MailItem.SortDateAscending());
        int date = 0;
        int unread = 0;
        int flags = 0;
        long tags = 0L;
        MailItem.CustomMetadata.CustomMetadataList extended = null;
        for (int i = 0; i < msgs.length; ++i) {
            Message msg = msgs[i];
            if (msg == null) {
                throw ServiceException.FAILURE("null Message in list", null);
            }
            date = Math.max(date, msg.mData.date);
            unread += msg.mData.unreadCount;
            flags |= msg.mData.flags;
            tags |= msg.mData.tags;
            extended = MetadataCallback.duringConversationAdd(extended, msg);
        }
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = (byte)4;
        data.folderId = 9;
        data.subject = msgs.length > 0 ? msgs[0].getSubject() : "";
        data.date = date;
        data.size = msgs.length;
        data.unreadCount = unread;
        data.flags = flags;
        data.tags = tags;
        data.metadata = Conversation.encodeMetadata(DEFAULT_COLOR_RGB, 1, extended, new SenderList(msgs));
        data.contentChanged(mbox);
        DbMailItem.create(mbox, data, null);
        Conversation conv = new Conversation(mbox, data);
        conv.finishCreation(null);
        DbMailItem.setParent(msgs, (MailItem)conv);
        for (int i = 0; i < msgs.length; ++i) {
            mbox.markItemModified(msgs[i], 512);
            msgs[i].mData.parentId = id;
            msgs[i].mData.metadataChanged(mbox);
        }
        return conv;
    }

    void open(String hash) throws ServiceException {
        DbMailItem.openConversation(hash, this);
    }

    void close(String hash) throws ServiceException {
        DbMailItem.closeConversation(hash, this);
    }

    @Override
    void detach() throws ServiceException {
        this.close(Mailbox.getHash(this.getNormalizedSubject()));
    }

    @Override
    void alterUnread(boolean unread) throws ServiceException {
        this.markItemModified(1);
        boolean excludeAccess = false;
        MailItem.TargetConstraint tcon = this.mMailbox.getOperationTargetConstraint();
        ArrayList<Integer> targets = new ArrayList<Integer>();
        for (Message msg : this.getMessages()) {
            if (msg.isUnread() == unread) continue;
            if (!msg.canAccess((short)2)) {
                excludeAccess = true;
                continue;
            }
            if (!msg.checkChangeID() || !MailItem.TargetConstraint.checkItem(tcon, msg)) continue;
            msg.updateUnread(unread ? 1 : -1);
            msg.mData.metadataChanged(this.mMailbox);
            targets.add(msg.getId());
        }
        if (targets.isEmpty()) {
            if (excludeAccess) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
        } else {
            DbMailItem.alterUnread(this.mMailbox, targets, unread);
        }
    }

    @Override
    void alterTag(Tag tag, boolean add) throws ServiceException {
        if (tag == null) {
            throw ServiceException.FAILURE("missing tag argument", null);
        }
        if (!add && !this.isTagged(tag)) {
            return;
        }
        if (tag.getId() == -10) {
            throw ServiceException.FAILURE("unread state must be set with alterUnread", null);
        }
        if (tag instanceof Flag && (tag.getBitmask() & (long)Flag.FLAG_SYSTEM) != 0L) {
            throw MailServiceException.CANNOT_TAG(tag, this);
        }
        this.markItemModified(tag instanceof Flag ? 4 : 2);
        MailItem.TargetConstraint tcon = this.mMailbox.getOperationTargetConstraint();
        boolean excludeAccess = false;
        List<Message> msgs = this.getMessages();
        ArrayList<Integer> targets = new ArrayList<Integer>(msgs.size());
        for (Message msg : msgs) {
            if (msg.isTagged(tag) == add) continue;
            if (!msg.canAccess((short)2)) {
                excludeAccess = true;
                continue;
            }
            if (!msg.checkChangeID() || !MailItem.TargetConstraint.checkItem(tcon, msg)) continue;
            if (add && !tag.canTag(msg)) {
                throw MailServiceException.CANNOT_TAG(tag, this);
            }
            if (tag instanceof Flag && (tag.getBitmask() & (long)Flag.FLAG_SYSTEM) != 0L) {
                throw MailServiceException.CANNOT_TAG(tag, msg);
            }
            if (tag.trackUnread() && msg.isUnread()) {
                tag.updateUnread(add ? 1 : -1);
            }
            targets.add(msg.getId());
            msg.tagChanged(tag, add);
        }
        if (targets.isEmpty()) {
            if (excludeAccess) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
        } else {
            if (ZimbraLog.mailop.isDebugEnabled()) {
                String operation = add ? "Setting" : "Unsetting";
                ZimbraLog.mailop.debug("%s %s for %s.  Affected ids: %s", operation, Conversation.getMailopContext(tag), Conversation.getMailopContext(this), StringUtil.join(",", targets));
            }
            this.recalculateCounts(msgs);
            DbMailItem.alterTag(tag, targets, add);
        }
    }

    @Override
    protected void inheritedTagChanged(Tag tag, boolean add) throws ServiceException {
        if (tag == null || add == this.isTagged(tag)) {
            return;
        }
        this.markItemModified(tag instanceof Flag ? 4 : 2);
        if (add) {
            this.tagChanged(tag, add);
        } else {
            DbMailItem.completeConversation(this.mMailbox, this.mData);
        }
    }

    protected void inheritedCustomDataChanged(Message msg, MailItem.CustomMetadata custom) throws ServiceException {
        if (custom == null) {
            return;
        }
        this.markItemModified(524288);
        if (!custom.isEmpty()) {
            this.mExtendedData = MetadataCallback.duringConversationAdd(this.mExtendedData, msg);
            this.saveMetadata();
        } else {
            this.recalculateMetadata();
        }
    }

    @Override
    boolean move(Folder target) throws ServiceException {
        if (!target.canContain((byte)5)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        this.markItemModified(0);
        List<Message> msgs = this.getMessages();
        MailItem.TargetConstraint tcon = this.mMailbox.getOperationTargetConstraint();
        boolean toTrash = target.inTrash();
        int oldUnread = 0;
        for (Message msg : msgs) {
            if (!msg.isUnread()) continue;
            ++oldUnread;
        }
        this.mData.unreadCount = oldUnread;
        boolean excludeAccess = false;
        ArrayList<Integer> markedRead = new ArrayList<Integer>();
        ArrayList<Message> moved = new ArrayList<Message>();
        ArrayList<Message> indexUpdated = new ArrayList<Message>();
        for (Message msg : msgs) {
            Folder source = msg.getFolder();
            if (source.getId() == target.getId()) continue;
            if (!source.canAccess((short)8)) {
                excludeAccess = true;
                continue;
            }
            if (target.getId() != 3 && target.getId() != 4 && !target.canAccess((short)4)) {
                excludeAccess = true;
                continue;
            }
            if (!msg.checkChangeID() || !MailItem.TargetConstraint.checkItem(tcon, msg)) continue;
            if (msg.isUnread()) {
                if (!toTrash || msg.inTrash()) {
                    source.updateUnread(-1);
                    target.updateUnread(1);
                } else {
                    msg.updateUnread(-1);
                    markedRead.add(msg.getId());
                }
            }
            if (msg.inSpam() && !target.inSpam() && msg.isIndexed() && msg.getIndexId() != null) {
                msg.indexIdChanged(msg.getMailbox().generateIndexId(msg.getId()));
                indexUpdated.add(msg);
            }
            source.updateSize(-1, -msg.getTotalSize());
            target.updateSize(1, msg.getTotalSize());
            moved.add(msg);
            msg.folderChanged(target, 0);
        }
        if (!markedRead.isEmpty()) {
            DbMailItem.alterUnread(target.getMailbox(), markedRead, false);
        }
        if (moved.isEmpty()) {
            if (excludeAccess) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
        } else {
            if (target.inSpam()) {
                this.detach();
            }
            if (ZimbraLog.mailop.isInfoEnabled()) {
                StringBuilder ids = new StringBuilder();
                for (int i = 0; i < moved.size(); ++i) {
                    if (i > 0) {
                        ids.append(',');
                    }
                    ids.append(((Message)moved.get(i)).getId());
                }
                ZimbraLog.mailop.info("Moving %s to %s.  Affected message ids: %s.", Conversation.getMailopContext(this), Conversation.getMailopContext(target), ids);
            }
            DbMailItem.setFolder(moved, target);
            if (!indexUpdated.isEmpty()) {
                DbMailItem.setIndexIds(this.mMailbox, indexUpdated);
                for (Message msg : indexUpdated) {
                    this.mMailbox.queueForIndexing(msg, false, null);
                }
            }
        }
        return !moved.isEmpty();
    }

    @Override
    void addChild(MailItem child) throws ServiceException {
        if (!(child instanceof Message)) {
            throw MailServiceException.CANNOT_PARENT();
        }
        Message msg = (Message)child;
        super.addChild(msg);
        int oldFlags = this.mData.flags;
        this.mData.flags |= msg.getInternalFlagBitmask();
        if (this.mData.flags != oldFlags) {
            this.markItemModified(4);
        }
        long oldTags = this.mData.tags;
        this.mData.tags |= msg.getTagBitmask();
        if (this.mData.tags != oldTags) {
            this.markItemModified(2);
        }
        if (msg.isUnread()) {
            this.markItemModified(1);
            this.updateUnread(child.mData.unreadCount);
        }
        this.markItemModified(526352);
        MetadataCallback.duringConversationAdd(this.mExtendedData, msg);
        this.mData.date = this.mMailbox.getOperationTimestamp();
        this.mData.contentChanged(this.mMailbox);
        if (!this.mMailbox.hasListeners(Session.Type.SOAP)) {
            this.instantiateSenderList();
            ++this.mData.size;
            try {
                if (this.mSenderList != null) {
                    this.mSenderList.add(msg);
                }
            }
            catch (SenderList.RefreshException slre) {
                this.mSenderList = null;
            }
            this.saveMetadata();
        } else {
            boolean recalculated = this.loadSenderList();
            if (!recalculated) {
                ++this.mData.size;
                try {
                    this.mSenderList.add(msg);
                    this.saveMetadata();
                }
                catch (SenderList.RefreshException slre) {
                    this.recalculateMetadata();
                }
            }
        }
    }

    @Override
    void removeChild(MailItem child) throws ServiceException {
        super.removeChild(child);
        if (this.getMessageCount() == 0) {
            this.delete();
            return;
        }
        this.markItemModified(2064);
        if (!this.mMailbox.hasListeners(Session.Type.SOAP)) {
            if (child.isUnread()) {
                this.markItemModified(1);
                this.updateUnread(-child.mData.unreadCount);
            }
            if (child.mData.tags != 0L || child.mData.flags != 0) {
                int oldFlags = this.mData.flags;
                long oldTags = this.mData.tags;
                DbMailItem.completeConversation(this.mMailbox, this.mData);
                if (this.mData.flags != oldFlags) {
                    this.markItemModified(4);
                }
                if (this.mData.tags != oldTags) {
                    this.markItemModified(2);
                }
            }
            this.mEncodedSenders = null;
            this.mSenderList = null;
            --this.mData.size;
            this.saveMetadata(null);
        } else {
            List<Message> msgs = this.getMessages();
            msgs.remove(child);
            this.recalculateMetadata(msgs);
        }
    }

    @Override
    MailItem.PendingDelete getDeletionInfo() throws ServiceException {
        MailItem.PendingDelete info = new MailItem.PendingDelete();
        info.rootId = this.mId;
        info.itemIds.add(this.getType(), this.mId);
        if (this.mData.size == 0L) {
            return info;
        }
        List<Message> msgs = this.getMessages();
        MailItem.TargetConstraint tcon = this.mMailbox.getOperationTargetConstraint();
        boolean excludeModify = false;
        boolean excludeAccess = false;
        for (Message child : msgs) {
            if (!MailItem.TargetConstraint.checkItem(tcon, child)) continue;
            if (!child.canAccess((short)8)) {
                excludeAccess = true;
                continue;
            }
            if (!child.checkChangeID()) {
                excludeModify = true;
                continue;
            }
            info.add(child.getDeletionInfo());
        }
        int totalDeleted = info.itemIds.size();
        if (totalDeleted == 1) {
            if (excludeAccess) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
            if (excludeModify) {
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
            }
        }
        if (totalDeleted != msgs.size() + 1) {
            info.incomplete = true;
        }
        return info;
    }

    @Override
    void purgeCache(MailItem.PendingDelete info, boolean purgeItem) throws ServiceException {
        if (info.incomplete) {
            this.recalculateMetadata();
        }
        super.purgeCache(info, purgeItem);
    }

    @Override
    void decodeMetadata(String metadata) {
        if (metadata != null) {
            try {
                Metadata meta = new Metadata(metadata, this);
                if (meta.containsKey("prt")) {
                    this.decodeMetadata(meta);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.mailbox.info((Object)("Unable to parse conversation metadata: id= " + this.mId + ", data='" + metadata + "'"), e);
            }
        }
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        super.decodeMetadata(meta);
        this.mEncodedSenders = meta.get("prt", null);
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        String encoded = this.mEncodedSenders;
        if (encoded == null && this.mSenderList != null) {
            encoded = this.mSenderList.toString();
        }
        return Conversation.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, encoded);
    }

    static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, SenderList senders) {
        return Conversation.encodeMetadata(new Metadata(), color, version, extended, senders.toString()).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, String encodedSenders) {
        meta.put("prt", encodedSenders);
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    @Override
    public String getSortSubject() {
        String subject = this.getNormalizedSubject();
        return subject.toUpperCase().substring(0, Math.min(1024, subject.length()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("conversation: {");
        this.appendCommonMembers(sb);
        sb.append("}");
        return sb.toString();
    }
}

