/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.MultiTreeMap;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ContactAutoComplete;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactRankings {
    private static final String CONFIG_KEY_CONTACT_RANKINGS = "CONTACT_RANKINGS";
    private static final String KEY_NAME = "n";
    private static final String KEY_FOLDER = "o";
    private static final String KEY_RANKING = "r";
    private static final String KEY_LAST_ACCESSED = "t";
    private int mTableSize;
    private String mAccountId;
    private MultiTreeMap<String, ContactAutoComplete.ContactEntry> mEntryMap;
    private TreeSet<ContactAutoComplete.ContactEntry> mEntrySet;

    public ContactRankings(String accountId) throws ServiceException {
        this.mAccountId = accountId;
        this.mEntryMap = new MultiTreeMap(new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return left.compareToIgnoreCase(right);
            }
        });
        this.mEntrySet = new TreeSet();
        this.mTableSize = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mAccountId).getIntAttr("zimbraContactRankingTableSize", 40);
        if (!LC.contact_ranking_enabled.booleanValue()) {
            return;
        }
        this.readFromDatabase();
    }

    public static void increment(String accountId, Collection<? extends Address> addrs) throws ServiceException {
        if (!LC.contact_ranking_enabled.booleanValue()) {
            return;
        }
        ContactRankings rankings = new ContactRankings(accountId);
        for (Address address : addrs) {
            if (!(address instanceof InternetAddress)) continue;
            rankings.increment(((InternetAddress)address).getAddress(), ((InternetAddress)address).getPersonal());
        }
        rankings.writeToDatabase();
    }

    public synchronized void increment(String email, String displayName) {
        long now = System.currentTimeMillis();
        ContactAutoComplete.ContactEntry entry = this.mEntryMap.getFirst(email);
        if (entry == null) {
            entry = new ContactAutoComplete.ContactEntry();
            entry.mEmail = email;
            entry.mRanking = 1;
            entry.setName(displayName);
            entry.mFolderId = -1;
            entry.mLastAccessed = now;
            this.updateContactInfo(entry);
            if (this.mEntrySet.size() >= this.mTableSize) {
                ContactAutoComplete.ContactEntry firstEntry = this.mEntrySet.first();
                if (firstEntry.mRanking <= 1) {
                    this.remove(firstEntry);
                }
            }
            if (this.mEntrySet.size() < this.mTableSize) {
                this.add(entry);
            } else {
                for (ContactAutoComplete.ContactEntry e : this.mEntrySet) {
                    int weeksOld = (int)((now - e.mLastAccessed) / 604800000L) + 1;
                    e.mRanking -= weeksOld;
                    if (e.mRanking >= 0) continue;
                    e.mRanking = 0;
                }
            }
        } else {
            long refreshInterval = 604800000L;
            try {
                refreshInterval = Provisioning.getInstance().getConfig().getContactRankingTableRefreshInterval();
            }
            catch (ServiceException se) {
                ZimbraLog.gal.warn((Object)"can't get zimbraContactRankingTableRefreshInterval", se);
            }
            if (refreshInterval == 0L) {
                return;
            }
            long age = now - entry.mLastAccessed;
            ++entry.mRanking;
            if (entry.mRanking <= 0) {
                entry.mRanking = 1;
            }
            entry.mLastAccessed = now;
            if (age > refreshInterval && (entry.mFolderId == -1 || entry.mDisplayName.length() == 0)) {
                this.updateContactInfo(entry);
            }
        }
    }

    private void updateContactInfo(ContactAutoComplete.ContactEntry entry) {
        ContactAutoComplete auto = new ContactAutoComplete(this.mAccountId);
        ContactAutoComplete.ContactEntry storedContact = null;
        try {
            auto.setIncludeRankingResults(false);
            ContactAutoComplete.AutoCompleteResult res = auto.query(entry.mEmail, null, 1);
            if (res.entries.size() == 0) {
                return;
            }
            storedContact = res.entries.iterator().next();
        }
        catch (ServiceException se) {
            ZimbraLog.gal.warn((Object)("error searching for contact " + entry), se);
        }
        if (storedContact == null) {
            return;
        }
        entry.mFolderId = storedContact.mFolderId;
        if (storedContact.mDisplayName.length() > 0 && entry.mDisplayName.length() == 0) {
            entry.mDisplayName = storedContact.mDisplayName;
        }
    }

    public synchronized Collection<ContactAutoComplete.ContactEntry> query(String str, Collection<Integer> folders) {
        TreeSet<ContactAutoComplete.ContactEntry> entries = new TreeSet<ContactAutoComplete.ContactEntry>(Collections.reverseOrder());
        int len = str.length();
        for (String k : this.mEntryMap.tailMap(str).keySet()) {
            if (k.length() < len || !k.substring(0, len).equalsIgnoreCase(str)) break;
            for (ContactAutoComplete.ContactEntry entry : (Collection)this.mEntryMap.get(k)) {
                if (entry.mFolderId != -1 && folders != null && !folders.contains(entry.mFolderId)) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    private synchronized void readFromDatabase() throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.mAccountId);
        Metadata config = mbox.getConfig(null, CONFIG_KEY_CONTACT_RANKINGS);
        if (config == null) {
            config = new Metadata();
            mbox.setConfig(null, CONFIG_KEY_CONTACT_RANKINGS, config);
        }
        for (Object k : config.mMap.keySet()) {
            Object v = config.mMap.get(k);
            if (!(v instanceof Map)) continue;
            Map m = (Map)v;
            ContactAutoComplete.ContactEntry entry = new ContactAutoComplete.ContactEntry();
            entry.mEmail = (String)k;
            entry.setName((String)m.get(KEY_NAME));
            Long num = (Long)m.get(KEY_FOLDER);
            entry.mFolderId = num.intValue();
            num = (Long)m.get(KEY_RANKING);
            entry.mRanking = num.intValue();
            num = (Long)m.get(KEY_LAST_ACCESSED);
            entry.mLastAccessed = num;
            this.add(entry);
        }
        this.dump("reading");
    }

    private synchronized void writeToDatabase() throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.mAccountId);
        Metadata config = new Metadata();
        for (ContactAutoComplete.ContactEntry entry : this.mEntrySet) {
            Metadata m = new Metadata();
            m.put(KEY_NAME, entry.mDisplayName);
            m.put(KEY_FOLDER, entry.mFolderId);
            m.put(KEY_RANKING, entry.mRanking);
            m.put(KEY_LAST_ACCESSED, entry.mLastAccessed);
            config.put(entry.mEmail, m);
        }
        mbox.setConfig(null, CONFIG_KEY_CONTACT_RANKINGS, config);
        this.dump("writing");
    }

    private synchronized void add(ContactAutoComplete.ContactEntry entry) {
        this.mEntryMap.add(entry.mEmail, entry);
        if (entry.mDisplayName.length() > 0) {
            this.mEntryMap.add(entry.mDisplayName, entry);
        }
        if (entry.mLastName.length() > 0) {
            this.mEntryMap.add(entry.mLastName, entry);
        }
        this.mEntrySet.add(entry);
    }

    private synchronized void remove(ContactAutoComplete.ContactEntry entry) {
        this.mEntryMap.remove(entry.mEmail, entry);
        if (entry.mDisplayName.length() > 0) {
            this.mEntryMap.remove(entry.mDisplayName, entry);
        }
        if (entry.mLastName.length() > 0) {
            this.mEntryMap.remove(entry.mLastName, entry);
        }
        this.mEntrySet.remove(entry);
    }

    private void dump(String action) {
        if (ZimbraLog.gal.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(action);
            buf.append("\n");
            for (ContactAutoComplete.ContactEntry entry : this.mEntrySet) {
                entry.toString(buf);
                buf.append("\n");
            }
            ZimbraLog.gal.debug(buf.toString());
        }
    }
}

