/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.gal.GalSearchControl;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.gal.GalSearchResultCallback;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.ProxiedHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.ContactRankings;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.util.ItemId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactAutoComplete {
    public static final int FOLDER_ID_GAL = 0;
    public static final int FOLDER_ID_UNKNOWN = -1;
    private String mAccountId;
    private boolean mIncludeGal;
    private boolean mIncludeRankingResults;
    private static final byte[] CONTACT_TYPES = new byte[]{6};
    private boolean mIncludeSharedFolders;
    private Collection<String> mEmailKeys;
    private Provisioning.GAL_SEARCH_TYPE mSearchType;
    private static final String[] DEFAULT_EMAIL_KEYS = new String[]{"email", "email2", "email3"};

    public ContactAutoComplete(String accountId) {
        Provisioning prov = Provisioning.getInstance();
        try {
            Account acct = prov.get(Provisioning.AccountBy.id, accountId);
            this.mIncludeSharedFolders = acct.getBooleanAttr("zimbraPrefSharedAddrBookAutoCompleteEnabled", false);
            String emailKeys = acct.getAttr("zimbraContactAutoCompleteEmailFields");
            if (emailKeys != null) {
                this.mEmailKeys = Arrays.asList(emailKeys.split(","));
            }
            this.mIncludeGal = acct.getBooleanAttr("zimbraFeatureGalAutoCompleteEnabled", false) && acct.getBooleanAttr("zimbraFeatureGalEnabled", false) && acct.getBooleanAttr("zimbraPrefGalAutoCompleteEnabled", false);
        }
        catch (ServiceException se) {
            ZimbraLog.gal.warn((Object)"error initializing ContactAutoComplete", se);
        }
        this.mAccountId = accountId;
        if (this.mEmailKeys == null) {
            this.mEmailKeys = Arrays.asList(DEFAULT_EMAIL_KEYS);
        }
        this.mIncludeRankingResults = true;
        this.mSearchType = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
    }

    public Collection<String> getEmailKeys() {
        return this.mEmailKeys;
    }

    public boolean includeGal() {
        return this.mIncludeGal;
    }

    public void setIncludeGal(boolean includeGal) {
        this.mIncludeGal = includeGal;
    }

    public void setIncludeRankingResults(boolean includeRankingResults) {
        this.mIncludeRankingResults = includeRankingResults;
    }

    public void setSearchType(Provisioning.GAL_SEARCH_TYPE type) {
        this.mSearchType = type;
    }

    public AutoCompleteResult query(String str, Collection<Integer> folders, int limit) throws ServiceException {
        ZimbraLog.gal.debug("querying " + str);
        long t0 = System.currentTimeMillis();
        AutoCompleteResult result = new AutoCompleteResult(limit);
        if (limit <= 0) {
            return result;
        }
        if (this.mIncludeRankingResults) {
            this.queryRankingTable(str, folders, limit, result);
        }
        if (result.entries.size() >= limit) {
            return result;
        }
        long t1 = System.currentTimeMillis();
        this.queryFolders(str, folders, limit, result);
        if (result.entries.size() >= limit) {
            return result;
        }
        long t2 = System.currentTimeMillis();
        if (this.mIncludeGal) {
            this.queryGal(str, limit, result);
        }
        long t3 = System.currentTimeMillis();
        ZimbraLog.gal.info("autocomplete: overall=" + (t3 - t0) + "ms, ranking=" + (t1 - t0) + "ms, folder=" + (t2 - t1) + "ms, gal=" + (t3 - t2) + "ms");
        return result;
    }

    private void queryRankingTable(String str, Collection<Integer> folders, int limit, AutoCompleteResult result) throws ServiceException {
        ContactRankings rankings = new ContactRankings(this.mAccountId);
        for (ContactEntry e : rankings.query(str, folders)) {
            result.addEntry(e);
            if (result.entries.size() != limit) continue;
            result.canBeCached = false;
            break;
        }
    }

    private void queryGal(String str, int limit, AutoCompleteResult result) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.id, this.mAccountId);
        ZimbraLog.gal.debug("querying gal");
        GalSearchParams params = new GalSearchParams(account);
        params.setQuery(str);
        params.setType(this.mSearchType);
        params.setLimit(limit - result.entries.size());
        params.setResultCallback(new AutoCompleteCallback(str, result, params));
        try {
            GalSearchControl gal = new GalSearchControl(params);
            gal.autocomplete();
        }
        catch (Exception e) {
            ZimbraLog.gal.warn((Object)"can't gal search", e);
            return;
        }
    }

    private static boolean matches(String query, String text) {
        if (query == null || text == null) {
            return false;
        }
        return text.toLowerCase().startsWith(query);
    }

    private void addMatchedContacts(String query, Map<String, ? extends Object> attrs, int folderId, ItemId id, AutoCompleteResult result) {
        ContactAutoComplete.addMatchedContacts(query, attrs, this.mEmailKeys, folderId, id, result);
    }

    public static void addMatchedContacts(String query, Map<String, ? extends Object> attrs, Collection<String> emailKeys, int folderId, ItemId id, AutoCompleteResult result) {
        String[] tokens = query.split(" ");
        if (tokens.length == 2 && tokens[1].length() == 1) {
            query = tokens[0];
        }
        String firstName = (String)attrs.get("firstName");
        String lastName = (String)attrs.get("lastName");
        String fullName = (String)attrs.get("fullName");
        String nickname = (String)attrs.get("nickname");
        if (attrs.get("dlist") == null) {
            boolean nameMatches = ContactAutoComplete.matches(query, firstName) || ContactAutoComplete.matches(query, lastName) || ContactAutoComplete.matches(query, fullName) || ContactAutoComplete.matches(query, nickname);
            for (String emailKey : emailKeys) {
                String email = (String)attrs.get(emailKey);
                if (email == null || !nameMatches && !ContactAutoComplete.matches(query, email)) continue;
                ContactEntry entry = new ContactEntry();
                entry.mEmail = email;
                if (fullName != null) {
                    entry.setName(fullName);
                } else {
                    entry.mLastName = lastName;
                    if (entry.mLastName == null) {
                        entry.mLastName = "";
                    }
                    entry.mDisplayName = firstName == null ? "" : firstName + " " + entry.mLastName;
                }
                entry.mId = id;
                entry.mFolderId = folderId;
                result.addEntry(entry);
                ZimbraLog.gal.debug("adding " + entry.getEmail());
                if (folderId != 0) continue;
                return;
            }
        } else {
            ContactEntry entry = new ContactEntry();
            entry.mDisplayName = nickname;
            entry.mDlist = (String)attrs.get("dlist");
            entry.mId = id;
            entry.mFolderId = folderId;
            result.addEntry(entry);
            ZimbraLog.gal.debug("adding " + entry.getEmail());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryFolders(String str, Collection<Integer> folders, int limit, AutoCompleteResult result) throws ServiceException {
        String[] tokens = (str = str.toLowerCase()).split(" ");
        if (tokens.length == 2 && tokens[1].length() == 1) {
            str = tokens[0];
        }
        ZimbraQueryResults qres = null;
        try {
            try {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.mAccountId);
                OperationContext octxt = new OperationContext(mbox);
                HashMap<ItemId, Integer> mountpoints = new HashMap<ItemId, Integer>();
                if (folders == null) {
                    ArrayList<Integer> allFolders = new ArrayList<Integer>();
                    for (Folder f : mbox.getFolderList(octxt, SortBy.NONE)) {
                        boolean isMountpoint = false;
                        if (f.getDefaultView() != 6) continue;
                        if (f instanceof Mountpoint) {
                            mountpoints.put(((Mountpoint)f).getTarget(), f.getId());
                            isMountpoint = true;
                        }
                        if (isMountpoint && !this.mIncludeSharedFolders) continue;
                        allFolders.add(f.getId());
                    }
                    folders = allFolders;
                } else {
                    for (int fid : folders) {
                        Folder f;
                        f = mbox.getFolderById(octxt, fid);
                        if (!(f instanceof Mountpoint)) continue;
                        mountpoints.put(((Mountpoint)f).getTarget(), fid);
                    }
                }
                String query = this.generateQuery(str, folders);
                ZimbraLog.gal.debug("querying folders: " + query);
                qres = mbox.search(octxt, query, CONTACT_TYPES, SortBy.NONE, limit);
                while (qres.hasNext()) {
                    ZimbraHit hit = qres.getNext();
                    Map<Object, Object> fields = null;
                    ItemId id = null;
                    int folderId = 0;
                    if (hit instanceof ContactHit) {
                        Contact c = ((ContactHit)hit).getContact();
                        ZimbraLog.gal.debug("hit: " + c.getId());
                        fields = c.getFields();
                        id = new ItemId(c);
                        folderId = c.getFolderId();
                    } else {
                        if (!(hit instanceof ProxiedHit)) continue;
                        fields = new HashMap();
                        Element top = ((ProxiedHit)hit).getElement();
                        id = new ItemId(top.getAttribute("id"), (String)null);
                        ZimbraLog.gal.debug("hit: " + id);
                        ItemId fiid = new ItemId(top.getAttribute("l"), (String)null);
                        folderId = (Integer)mountpoints.get(fiid);
                        for (Element elt : top.listElements("a")) {
                            try {
                                String name = elt.getAttribute("n");
                                fields.put(name, elt.getText());
                            }
                            catch (ServiceException se) {
                                ZimbraLog.gal.warn("error handling proxied query result " + hit);
                            }
                        }
                    }
                    this.addMatchedContacts(str, fields, folderId, id, result);
                    if (result.entries.size() != limit) continue;
                    ZimbraLog.gal.debug("mbox query result exceeded request limit " + limit);
                    result.canBeCached = false;
                    break;
                }
                Object var21_26 = null;
                if (qres == null) return;
            }
            catch (IOException e) {
                throw ServiceException.FAILURE(e.getMessage(), e);
            }
            catch (ParseException e) {
                throw ServiceException.FAILURE(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            if (qres == null) throw throwable;
            qres.doneWithSearchResults();
            throw throwable;
        }
        qres.doneWithSearchResults();
    }

    private String generateQuery(String query, Collection<Integer> folders) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        buf.append("(");
        for (int fid : folders) {
            if (fid < 1) continue;
            if (!first) {
                buf.append(" OR ");
            }
            first = false;
            buf.append("inid:").append(fid);
        }
        buf.append(") AND contact:(").append(query).append(")");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AutoCompleteCallback
    extends GalSearchResultCallback {
        AutoCompleteResult result;
        String str;

        public AutoCompleteCallback(String str, AutoCompleteResult result, GalSearchParams params) {
            super(params);
            this.result = result;
            this.str = str;
        }

        public void handleContactAttrs(Map<String, ? extends Object> attrs) throws ServiceException {
            ContactAutoComplete.this.addMatchedContacts(this.str, attrs, 0, null, this.result);
        }

        @Override
        public Element handleContact(Contact c) throws ServiceException {
            ZimbraLog.gal.debug("gal entry: " + c.getId());
            this.handleContactAttrs(c.getFields());
            return null;
        }

        @Override
        public void visit(GalContact c) throws ServiceException {
            ZimbraLog.gal.debug("gal entry: " + c.getId());
            this.handleContactAttrs(c.getAttrs());
        }

        @Override
        public void handleElement(Element e) throws ServiceException {
            ZimbraLog.gal.debug("gal entry: " + e.getAttribute("id"));
            this.handleContactAttrs(this.parseContactElement(e));
        }

        @Override
        public void setSortBy(String sortBy) {
        }

        @Override
        public void setQueryOffset(int offset) {
        }

        @Override
        public void setHasMoreResult(boolean more) {
            if (more) {
                ZimbraLog.gal.debug("result can't be cached by client");
                this.result.canBeCached = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContactEntry
    implements Comparable<ContactEntry> {
        String mEmail;
        String mDisplayName;
        String mLastName;
        String mDlist;
        ItemId mId;
        int mFolderId;
        int mRanking;
        long mLastAccessed;

        public String getEmail() {
            if (this.mDlist != null) {
                return this.mDlist;
            }
            StringBuilder buf = new StringBuilder();
            if (this.mDisplayName.length() > 0) {
                buf.append("\"");
                buf.append(this.mDisplayName);
                buf.append("\" ");
            }
            buf.append("<").append(this.mEmail).append(">");
            return buf.toString();
        }

        public ItemId getId() {
            return this.mId;
        }

        public int getFolderId() {
            return this.mFolderId;
        }

        public int getRanking() {
            return this.mRanking;
        }

        public boolean isDlist() {
            return this.mDlist != null;
        }

        public String getDisplayName() {
            return this.mDisplayName;
        }

        void setName(String name) {
            if (name == null) {
                name = "";
            }
            this.mDisplayName = name;
            this.mLastName = "";
            int space = name.lastIndexOf(32);
            if (space > 0) {
                this.mLastName = name.substring(space + 1);
            }
        }

        @Override
        public int compareTo(ContactEntry that) {
            int diff = this.mRanking - that.mRanking;
            if (diff != 0) {
                return diff;
            }
            return this.mEmail.compareToIgnoreCase(that.mEmail);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContactEntry) {
                return this.compareTo((ContactEntry)obj) == 0;
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        public void toString(StringBuilder buf) {
            buf.append(this.mRanking).append(" ");
            if (this.isDlist()) {
                buf.append(this.getDisplayName()).append(" (dlist)");
            } else {
                buf.append(this.getEmail());
            }
            buf.append(" (").append(this.mFolderId).append(")");
            buf.append(" ").append(new Date(this.mLastAccessed));
        }
    }

    public static class AutoCompleteResult {
        public Collection<ContactEntry> entries = new ArrayList<ContactEntry>();
        public boolean canBeCached = true;
        public int limit;
        private HashSet<String> emails = new HashSet();

        public AutoCompleteResult(int l) {
            this.limit = l;
        }

        public void addEntry(ContactEntry entry) {
            if (this.entries.size() >= this.limit) {
                return;
            }
            String email = entry.isDlist() ? entry.mDisplayName : entry.mEmail.toLowerCase();
            if (!this.emails.contains(email)) {
                this.entries.add(entry);
                this.emails.add(email);
            }
        }

        public void appendEntries(AutoCompleteResult result) {
            for (ContactEntry entry : result.entries) {
                this.addEntry(entry);
            }
        }
    }
}

