/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.mailbox.AttachmentDataSource;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.store.MailboxBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contact
extends MailItem {
    private Map<String, String> mFields;
    private List<Attachment> mAttachments;
    private static final String[] EMAIL_FIELDS = new String[]{"email", "email2", "email3", "workEmail1", "workEmail2", "workEmail3"};
    private static final String ZMVAL = "ZMVAL";
    private static final String ZMVALENCODED = "{\"ZMVAL\":";

    public Contact(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 6) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getSender() {
        try {
            return this.getFileAsString();
        }
        catch (ServiceException e) {
            return "";
        }
    }

    public String get(String fieldName) {
        return this.mFields.get(fieldName);
    }

    public Map<String, String> getFields() {
        return new HashMap<String, String>(this.mFields);
    }

    public List<Attachment> getAttachments() {
        if (this.mAttachments == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Attachment>(this.mAttachments);
    }

    public MimeMessage getMimeMessage(boolean runConverters) throws ServiceException {
        return MessageCache.getMimeMessage(this, runConverters);
    }

    public String getFileAsString() throws ServiceException {
        return Contact.getFileAsString(this.mFields);
    }

    public static String getFileAsString(Map<String, String> fields) throws ServiceException {
        String last;
        String first;
        String company;
        String fileAs = fields.get("fileAs");
        String[] fileParts = fileAs == null ? null : fileAs.split(":", 2);
        int fileAsInt = 1;
        if (fileParts != null) {
            try {
                fileAsInt = Integer.parseInt(fileParts[0]);
                if (fileAsInt < 0 || fileAsInt > 8) {
                    throw ServiceException.INVALID_REQUEST("invalid fileAs value: " + fileAs, null);
                }
            }
            catch (NumberFormatException e) {
                throw ServiceException.INVALID_REQUEST("invalid fileAs value: " + fileAs, null);
            }
        }
        if ((company = fields.get("company")) == null) {
            company = "";
        }
        if ((first = fields.get("firstName")) == null) {
            first = "";
        }
        if ((last = fields.get("lastName")) == null) {
            last = "";
        }
        StringBuilder result = new StringBuilder();
        switch (fileAsInt) {
            case 8: {
                if (fileParts.length == 2 && !fileParts[1].trim().equals("")) {
                    result.append(fileParts[1].trim());
                    break;
                }
                throw ServiceException.INVALID_REQUEST("invalid fileAs value: " + fileAs, null);
            }
            default: {
                result.append(last);
                if (first.length() > 0 && last.length() > 0) {
                    result.append(", ");
                }
                result.append(first);
                break;
            }
            case 2: {
                result.append(first);
                if (first.length() > 0 && last.length() > 0) {
                    result.append(' ');
                }
                result.append(last);
                break;
            }
            case 3: {
                result.append(company);
                break;
            }
            case 4: {
                result.append(last);
                if (first.length() > 0 && last.length() > 0) {
                    result.append(", ");
                }
                result.append(first);
                if (company.length() <= 0) break;
                result.append(" (").append(company).append(')');
                break;
            }
            case 5: {
                result.append(first);
                if (first.length() > 0 && last.length() > 0) {
                    result.append(' ');
                }
                result.append(last);
                if (company.length() <= 0) break;
                result.append(" (").append(company).append(')');
                break;
            }
            case 6: {
                result.append(company);
                if (first.length() <= 0 && last.length() <= 0) break;
                result.append(" (").append(last);
                if (first.length() > 0 && last.length() > 0) {
                    result.append(", ");
                }
                result.append(first).append(')');
                break;
            }
            case 7: {
                result.append(company);
                if (first.length() <= 0 && last.length() <= 0) break;
                result.append(" (").append(first);
                if (first.length() > 0 && last.length() > 0) {
                    result.append(' ');
                }
                result.append(last).append(')');
            }
        }
        return result.toString().trim();
    }

    public static void normalizeFileAs(Map<String, String> attrs) {
        String fileAs = attrs.get("fullName");
        if (fileAs == null || fileAs.trim().length() == 0) {
            return;
        }
        String last = attrs.get("lastName");
        last = last == null ? "" : last;
        String first = attrs.get("firstName");
        first = first == null ? "" : first;
        String company = attrs.get("company");
        company = company == null ? "" : company;
        StringBuilder sb = new StringBuilder();
        sb.append(last);
        if (last.length() > 0 && first.length() > 0) {
            sb.append(", ");
        }
        sb.append(first);
        if (sb.toString().equals(fileAs)) {
            attrs.put("fileAs", new Integer(1).toString());
            return;
        }
        sb = new StringBuilder();
        sb.append(first);
        if (last.length() > 0 && first.length() > 0) {
            sb.append(' ');
        }
        sb.append(last);
        if (sb.toString().equals(fileAs)) {
            attrs.put("fileAs", new Integer(2).toString());
            return;
        }
        if (company.equals(fileAs)) {
            attrs.put("fileAs", new Integer(3).toString());
            return;
        }
        sb = new StringBuilder();
        sb.append(last);
        if (last.length() > 0 && first.length() > 0) {
            sb.append(", ");
        }
        sb.append(first);
        if (company.length() > 0) {
            sb.append(" (").append(company).append(')');
        }
        if (sb.toString().equals(fileAs)) {
            attrs.put("fileAs", new Integer(4).toString());
            return;
        }
        sb = new StringBuilder();
        sb.append(first);
        if (last.length() > 0 && first.length() > 0) {
            sb.append(' ');
        }
        sb.append(last);
        if (company.length() > 0) {
            sb.append(" (").append(company).append(')');
        }
        if (sb.toString().equals(fileAs)) {
            attrs.put("fileAs", new Integer(5).toString());
            return;
        }
        sb = new StringBuilder();
        sb.append(company);
        if (last.length() > 0 || first.length() > 0) {
            sb.append(" (").append(last);
            if (last.length() > 0 && first.length() > 0) {
                sb.append(", ");
            }
            sb.append(first).append(')');
        }
        if (sb.toString().equals(fileAs)) {
            attrs.put("fileAs", new Integer(6).toString());
            return;
        }
        sb = new StringBuilder();
        sb.append(company);
        if (last.length() > 0 || first.length() > 0) {
            sb.append(" (").append(first);
            if (last.length() > 0 && first.length() > 0) {
                sb.append(' ');
            }
            sb.append(last).append(')');
        }
        if (sb.toString().equals(fileAs)) {
            attrs.put("fileAs", new Integer(7).toString());
            return;
        }
        attrs.put("fileAs", new Integer(8).toString() + ':' + fileAs);
    }

    public List<String> getEmailAddresses() {
        return Contact.getEmailAddresses(this.mFields);
    }

    public static final boolean isEmailField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        String lcField = fieldName.toLowerCase();
        for (String e : EMAIL_FIELDS) {
            if (!lcField.equals(e)) continue;
            return true;
        }
        return lcField.equals("dlist");
    }

    public static final List<String> getEmailAddresses(Map<String, String> fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (String field : EMAIL_FIELDS) {
            String value = fields.get(field);
            if (value == null || value.trim().equals("")) continue;
            result.add(value);
        }
        String dlist = fields.get("dlist");
        if (dlist != null) {
            String[] addrs;
            for (String s : addrs = dlist.split(",")) {
                result.add(s.trim());
            }
        }
        return result;
    }

    @Override
    boolean isTaggable() {
        return true;
    }

    @Override
    boolean isCopyable() {
        return true;
    }

    @Override
    boolean isMovable() {
        return true;
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    boolean isIndexed() {
        return true;
    }

    @Override
    boolean canHaveChildren() {
        return false;
    }

    static Contact create(int id, Folder folder, MailboxBlob mblob, ParsedContact pc, int flags, String tags, MailItem.CustomMetadata custom) throws ServiceException {
        if (folder == null || !folder.canContain((byte)6)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!folder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        Mailbox mbox = folder.getMailbox();
        mbox.updateContactCount(1);
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = (byte)6;
        data.folderId = folder.getId();
        if (!folder.inSpam() || mbox.getAccount().getBooleanAttr("zimbraJunkMessagesIndexingEnabled", false)) {
            data.indexId = mbox.generateIndexId(id);
        }
        data.imapId = id;
        data.locator = mblob == null ? null : mblob.getLocator();
        data.setBlobDigest(pc.getDigest());
        data.size = pc.getSize();
        data.date = mbox.getOperationTimestamp();
        data.flags = flags | (pc.hasAttachment() ? Flag.BITMASK_ATTACHED : 0);
        data.tags = Tag.tagsToBitmask(tags);
        data.metadata = Contact.encodeMetadata(DEFAULT_COLOR_RGB, 1, custom, pc.getFields(), pc.getAttachments());
        data.contentChanged(mbox);
        if (ZimbraLog.mailop.isInfoEnabled()) {
            String email = "null";
            if (pc.getFields() != null) {
                email = pc.getFields().get("email");
            }
            ZimbraLog.mailop.info("adding contact %s: id=%d, folderId=%d, folderName=%s.", email, data.id, folder.getId(), folder.getName());
        }
        DbMailItem.create(mbox, data, Contact.getFileAsString(pc.getFields()));
        Contact con = new Contact(mbox, data);
        con.finishCreation(null);
        if (con.mFields.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("contact must have fields", null);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexDocument> generateIndexData(boolean doConsistencyCheck) throws MailItem.TemporaryIndexingException {
        Mailbox mailbox = this.mMailbox;
        synchronized (mailbox) {
            try {
                ParsedContact pc = new ParsedContact(this);
                pc.analyze(this.mMailbox);
                if (pc.hasTemporaryAnalysisFailure()) {
                    throw new MailItem.TemporaryIndexingException();
                }
                return pc.getLuceneDocuments(this.mMailbox);
            }
            catch (MailItem.TemporaryIndexingException tie) {
                throw tie;
            }
            catch (Exception e) {
                return new ArrayList<IndexDocument>();
            }
        }
    }

    @Override
    void reanalyze(Object data) throws ServiceException {
        if (!(data instanceof ParsedContact)) {
            throw ServiceException.FAILURE("cannot reanalyze non-ParsedContact object", null);
        }
        ParsedContact pc = (ParsedContact)data;
        this.markItemModified(65572);
        this.mFields = pc.getFields();
        if (this.mFields == null || this.mFields.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("contact must have fields", null);
        }
        this.mAttachments = pc.getAttachments();
        this.mData.flags &= ~Flag.BITMASK_ATTACHED;
        if (pc.hasAttachment()) {
            this.mData.flags |= Flag.BITMASK_ATTACHED;
        }
        this.saveData(Contact.getFileAsString(this.mFields));
    }

    @Override
    MailItem copy(Folder folder, int id, int parentId) throws IOException, ServiceException {
        this.mMailbox.updateContactCount(1);
        return super.copy(folder, id, parentId);
    }

    @Override
    MailItem icopy(Folder folder, int copyId) throws IOException, ServiceException {
        this.mMailbox.updateContactCount(1);
        return super.icopy(folder, copyId);
    }

    @Override
    MailItem.PendingDelete getDeletionInfo() throws ServiceException {
        MailItem.PendingDelete info = super.getDeletionInfo();
        info.contacts = 1;
        return info;
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        Metadata metaAttrs;
        if (meta.getVersion() <= 8) {
            metaAttrs = meta;
        } else {
            super.decodeMetadata(meta);
            metaAttrs = meta.getMap("fld");
            MetadataList mlAttach = meta.getList("att", true);
            if (mlAttach != null) {
                this.mAttachments = new ArrayList<Attachment>(mlAttach.size());
                for (int i = 0; i < mlAttach.size(); ++i) {
                    Metadata attachMeta = mlAttach.getMap(i);
                    String fieldName = attachMeta.get("field");
                    String partName = attachMeta.get("part");
                    int size = (int)attachMeta.getLong("size");
                    DataHandler dh = new DataHandler(new AttachmentDataSource(this, partName));
                    Attachment attachment = new Attachment(dh, fieldName, size);
                    attachment.setPartName(partName);
                    this.mAttachments.add(attachment);
                }
            }
        }
        this.mFields = new HashMap<String, String>();
        for (Map.Entry entry : metaAttrs.asMap().entrySet()) {
            this.mFields.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return Contact.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mFields, this.mAttachments);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata custom, Map<String, String> fields, List<Attachment> attachments) {
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        return Contact.encodeMetadata(new Metadata(), color, version, extended, fields, attachments).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, Map<String, String> fields, List<Attachment> attachments) {
        meta.put("fld", new Metadata(fields));
        if (attachments != null && !attachments.isEmpty()) {
            MetadataList mlist = new MetadataList();
            for (Attachment attach : attachments) {
                mlist.add(attach.asMetadata());
            }
            meta.put("att", mlist);
        }
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("contact: {");
        this.appendCommonMembers(sb);
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            sb.append(", ").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public String getVCardUID() {
        return this.mFields.get("vcardUID");
    }

    public String getXProp(String xprop) {
        return this.getXProps().get(xprop);
    }

    public Map<String, String> getXProps() {
        HashMap<String, String> xprops = new HashMap<String, String>();
        String xpropStr = this.mFields.get("vcardXProps");
        if (xpropStr != null) {
            try {
                JSONObject xpropObj = new JSONObject(xpropStr);
                Iterator iter = xpropObj.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    xprops.put(key, xpropObj.get(key).toString());
                }
            }
            catch (JSONException e) {
                ZimbraLog.mailop.debug("can't get xprop %s", (Object)xpropStr, e);
            }
        }
        return xprops;
    }

    public static String encodeXProps(Map<String, String> xprops) {
        JSONObject jsonobj = new JSONObject();
        try {
            for (String s : xprops.keySet()) {
                jsonobj.put(s, xprops.get(s));
            }
        }
        catch (JSONException e) {
            ZimbraLog.mailop.debug((Object)"can't encode xprops to JSONObject", e);
        }
        return jsonobj.toString();
    }

    public static String encodeMultiValueAttr(String[] attrs) throws JSONException {
        JSONObject jsonobj = new JSONObject();
        for (String s : attrs) {
            jsonobj.append(ZMVAL, s);
        }
        return jsonobj.toString();
    }

    public static boolean isMultiValueAttr(String attr) {
        return attr.startsWith(ZMVALENCODED);
    }

    public static String[] parseMultiValueAttr(String attr) throws JSONException {
        JSONObject jsonobj = new JSONObject(attr);
        JSONArray array = jsonobj.getJSONArray(ZMVAL);
        String[] mv = new String[array.length()];
        for (int i = 0; i < mv.length; ++i) {
            mv[i] = array.getString(i);
        }
        return mv;
    }

    public static class Attachment
    implements DataSource {
        private DataHandler mDataHandler;
        private int mSize;
        private String mFieldName;
        private String mPartName;
        private static final String FN_SIZE = "size";
        private static final String FN_NAME = "name";
        private static final String FN_PART = "part";
        private static final String FN_CTYPE = "ctype";
        private static final String FN_FIELD = "field";

        public Attachment(byte[] content, String ctype, String field, String filename) {
            ctype = ctype == null ? "application/octet-stream" : ctype.toLowerCase();
            if (content == null) {
                content = new byte[]{};
            }
            ByteArrayDataSource ds = new ByteArrayDataSource(content, ctype);
            if (filename != null) {
                ds.setName(filename);
            } else {
                ds.setName("unknown");
            }
            this.init(new DataHandler((DataSource)ds), field, content.length);
        }

        public Attachment(DataHandler dataHandler, String field) throws IOException {
            int size = (int)ByteUtil.getDataLength(dataHandler.getInputStream());
            this.init(dataHandler, field, size);
        }

        public Attachment(DataHandler dataHandler, String field, int size) {
            this.init(dataHandler, field, size);
        }

        private void init(DataHandler dataHandler, String field, int size) {
            if (dataHandler == null) {
                throw new NullPointerException("dataHandler cannot be null");
            }
            if (StringUtil.isNullOrEmpty(field)) {
                throw new NullPointerException("field cannot be null or empty");
            }
            this.mDataHandler = dataHandler;
            this.mFieldName = field;
            this.mSize = size;
        }

        public void setPartName(String name) {
            this.mPartName = name;
        }

        public String getContentType() {
            return this.mDataHandler.getContentType();
        }

        public String getName() {
            return this.mFieldName;
        }

        public int getSize() {
            return this.mSize;
        }

        public InputStream getInputStream() throws IOException {
            if (this.mDataHandler != null) {
                return this.mDataHandler.getInputStream();
            }
            return null;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getContent() throws IOException {
            InputStream in = null;
            byte[] content = null;
            try {
                in = this.getInputStream();
                if (in != null) {
                    content = ByteUtil.getContent(in, this.mSize);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ByteUtil.closeStream(in);
                throw throwable;
            }
            ByteUtil.closeStream(in);
            return content;
        }

        public String getFilename() {
            return this.mDataHandler.getName();
        }

        public String getPartName() {
            return this.mPartName;
        }

        public DataHandler getDataHandler() {
            return this.mDataHandler;
        }

        Metadata asMetadata() {
            return new Metadata().put(FN_SIZE, this.mSize).put(FN_NAME, this.getFilename()).put(FN_PART, this.mPartName).put(FN_CTYPE, this.getContentType()).put(FN_FIELD, this.mFieldName);
        }

        public String toString() {
            return this.mFieldName + " [" + this.getContentType() + ", " + this.mSize + "B]";
        }
    }
}

