/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Task;
import com.zimbra.cs.mailbox.calendar.Alarm;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.CalendarUser;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.Recurrence;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.ZRecur;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarItem
extends MailItem {
    public static final String INDEX_FIELD_ITEM_CLASS_PUBLIC = "_calendaritemclass:public";
    public static final String INDEX_FIELD_ITEM_CLASS_PRIVATE = "_calendaritemclass:private";
    public static final long NEXT_ALARM_KEEP_CURRENT = 0L;
    public static final long NEXT_ALARM_ALL_DISMISSED = -1L;
    public static final long NEXT_ALARM_FROM_NOW = -2L;
    static Log sLog = LogFactory.getLog(CalendarItem.class);
    private String mUid;
    private long mStartTime;
    private long mEndTime;
    private AlarmData mAlarmData;
    private Recurrence.IRecurrence mRecurrence;
    private TimeZoneMap mTzMap;
    private List<Invite> mInvites;
    private ReplyList mReplyList;
    public static final String FN_CALITEM_RECURRENCE = "apptRecur";
    private static Callback sCallback = null;
    private static final long MILLIS_IN_YEAR = 31536000000L;

    protected ReplyList getReplyList() {
        return this.mReplyList;
    }

    public TimeZoneMap getTimeZoneMap() {
        return this.mTzMap;
    }

    protected CalendarItem(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 11 && this.mData.type != 15) {
            throw new IllegalArgumentException();
        }
    }

    public Recurrence.IRecurrence getRecurrence() {
        return this.mRecurrence;
    }

    public boolean isRecurring() {
        return this.mRecurrence != null;
    }

    @Override
    public String getSender() {
        ZOrganizer org;
        String sender = null;
        Invite firstInvite = this.getDefaultInviteOrNull();
        if (firstInvite != null && (org = firstInvite.getOrganizer()) != null) {
            sender = org.getIndexString();
        }
        if (sender == null) {
            sender = "";
        }
        return sender;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public AlarmData getAlarmData() {
        return this.mAlarmData;
    }

    @Override
    public void saveMetadata() throws ServiceException {
        this.reanalyze(null);
    }

    @Override
    public void markItemModified(int reason) {
        this.mMailbox.markItemModified(this, reason);
    }

    @Override
    boolean isTaggable() {
        return true;
    }

    @Override
    boolean isCopyable() {
        return false;
    }

    @Override
    boolean isMovable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    boolean isIndexed() {
        return true;
    }

    @Override
    boolean canHaveChildren() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexDocument> generateIndexData(boolean doConsistencyCheck) throws MailItem.TemporaryIndexingException {
        List<IndexDocument> docs = null;
        Mailbox mailbox = this.getMailbox();
        synchronized (mailbox) {
            docs = this.getIndexDocuments();
        }
        return docs;
    }

    protected List<IndexDocument> getIndexDocuments() throws MailItem.TemporaryIndexingException {
        ArrayList<IndexDocument> toRet = new ArrayList<IndexDocument>();
        if (this.numInvites() < 1) {
            return toRet;
        }
        Invite defaultInvite = this.getDefaultInviteOrNull();
        String defaultLocation = "";
        if (defaultInvite != null && defaultInvite.getLocation() != null) {
            defaultLocation = defaultInvite.getLocation();
        }
        String defaultName = "";
        if (defaultInvite != null && defaultInvite.getName() != null) {
            defaultName = defaultInvite.getName();
        }
        String defaultOrganizer = "";
        if (defaultInvite != null && defaultInvite.getOrganizer() != null) {
            defaultOrganizer = defaultInvite.getOrganizer().getIndexString();
        }
        for (Invite inv : this.getInvites()) {
            List<IndexDocument> docList;
            String orgToUse;
            String nameToUse;
            ArrayList<String> toAddrs;
            StringBuilder s;
            block35: {
                MimeMessage mm;
                block34: {
                    List<String> categories;
                    List<String> contacts;
                    block33: {
                        String thisInvOrg;
                        s = new StringBuilder();
                        toAddrs = new ArrayList<String>();
                        nameToUse = "";
                        if (inv.getName() != null) {
                            s.append(inv.getName()).append(' ');
                            nameToUse = inv.getName();
                        } else {
                            s.append(defaultName).append(' ');
                            nameToUse = defaultName;
                        }
                        orgToUse = null;
                        if (inv.getOrganizer() != null && (thisInvOrg = inv.getOrganizer().getIndexString()) != null && thisInvOrg.length() > 0) {
                            orgToUse = thisInvOrg;
                        }
                        if (orgToUse == null) {
                            orgToUse = defaultOrganizer;
                        }
                        for (ZAttendee at : inv.getAttendees()) {
                            try {
                                toAddrs.add(at.getFriendlyAddress().toString());
                                s.append(at.getIndexString()).append(' ');
                            }
                            catch (ServiceException e) {}
                        }
                        s.append(' ');
                        if (inv.getLocation() != null) {
                            s.append(inv.getLocation()).append(' ');
                        } else {
                            s.append(defaultLocation).append(' ');
                        }
                        try {
                            s.append(inv.getDescription()).append(' ');
                        }
                        catch (ServiceException ex) {
                            if (!ZimbraLog.index.isDebugEnabled()) break block33;
                            ZimbraLog.index.debug((Object)("Caught exception fetching description while indexing CalendarItem " + this.getId() + " skipping"), ex);
                        }
                    }
                    List<String> comments = inv.getComments();
                    if (comments != null && !comments.isEmpty()) {
                        for (String comm : comments) {
                            s.append(comm).append(' ');
                        }
                    }
                    if ((contacts = inv.getContacts()) != null && !contacts.isEmpty()) {
                        for (String contact : contacts) {
                            s.append(contact).append(' ');
                        }
                    }
                    if ((categories = inv.getCategories()) != null && !categories.isEmpty()) {
                        for (String cat : categories) {
                            s.append(cat).append(' ');
                        }
                    }
                    mm = null;
                    if (!inv.getDontIndexMimeMessage()) {
                        try {
                            mm = inv.getMimeMessage();
                        }
                        catch (ServiceException e) {
                            if (!ZimbraLog.index.isDebugEnabled()) break block34;
                            ZimbraLog.index.debug((Object)("Caught MessagingException for Invite " + inv.toString() + " while fetching MM during indexing of CalendarItem " + this.getId() + " skipping Invite"), e);
                        }
                    }
                }
                docList = new ArrayList<IndexDocument>();
                if (mm == null) {
                    Document doc = new Document();
                    doc.add(new Field("l.partname", "top", Field.Store.YES, Field.Index.UN_TOKENIZED));
                    docList.add(new IndexDocument(doc));
                } else {
                    try {
                        ParsedMessage pm = new ParsedMessage(mm, this.mMailbox.attachmentsIndexingEnabled());
                        pm.analyzeFully();
                        if (pm.hasTemporaryAnalysisFailure()) {
                            throw new MailItem.TemporaryIndexingException();
                        }
                        docList = pm.getLuceneDocuments();
                    }
                    catch (ServiceException e) {
                        if (!ZimbraLog.index.isDebugEnabled()) break block35;
                        ZimbraLog.index.debug((Object)("Caught MessagingException for Invite " + inv.toString() + " while indexing CalendarItem " + this.getId() + " skipping Invite"), e);
                    }
                }
            }
            for (IndexDocument zd : docList) {
                Document doc = (Document)zd.getWrappedDocument();
                doc.add(new Field("l.content", s.toString(), Field.Store.NO, Field.Index.TOKENIZED));
                doc.removeField("to");
                doc.removeField("from");
                doc.removeField("subject");
                for (String to : toAddrs) {
                    doc.add(new Field("to", to, Field.Store.NO, Field.Index.TOKENIZED));
                }
                doc.add(new Field("from", orgToUse, Field.Store.NO, Field.Index.TOKENIZED));
                doc.add(new Field("subject", nameToUse, Field.Store.NO, Field.Index.TOKENIZED));
                toRet.add(zd);
            }
        }
        String itemClass = this.isPublic() ? INDEX_FIELD_ITEM_CLASS_PUBLIC : INDEX_FIELD_ITEM_CLASS_PRIVATE;
        for (IndexDocument zd : toRet) {
            Document doc = (Document)zd.getWrappedDocument();
            doc.add(new Field("l.field", itemClass, Field.Store.NO, Field.Index.TOKENIZED));
        }
        return toRet;
    }

    static CalendarItem create(int id, Folder folder, int flags, long tags, String uid, ParsedMessage pm, Invite firstInvite, long nextAlarm, MailItem.CustomMetadata custom) throws ServiceException {
        long endTime;
        ParsedDateTime dtEnd;
        long startTime;
        ParsedDateTime dtStart;
        String subject;
        firstInvite.sanitize(true);
        if (!folder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        if (!firstInvite.isPublic() && !folder.canAccess((short)1024)) {
            throw ServiceException.PERM_DENIED("you do not have permission to create private calendar item in this folder");
        }
        Mailbox mbox = folder.getMailbox();
        if (pm != null && pm.hasAttachments()) {
            firstInvite.setHasAttachment(true);
            flags |= Flag.BITMASK_ATTACHED;
        } else {
            firstInvite.setHasAttachment(false);
            flags &= ~Flag.BITMASK_ATTACHED;
        }
        int type = firstInvite.isEvent() ? 11 : 15;
        String sender = null;
        ZOrganizer org = firstInvite.getOrganizer();
        if (org != null) {
            sender = org.getIndexString();
        }
        if (sender == null) {
            sender = "";
        }
        if ((subject = firstInvite.getName()) == null) {
            subject = "";
        }
        ArrayList<Invite> invites = new ArrayList<Invite>();
        invites.add(firstInvite);
        Recurrence.IRecurrence recur = firstInvite.getRecurrence();
        if (recur != null) {
            dtStart = recur.getStartTime();
            startTime = dtStart != null ? dtStart.getUtcTime() : 0L;
            dtEnd = recur.getEndTime();
            endTime = dtEnd != null ? dtEnd.getUtcTime() : 0L;
        } else {
            dtStart = firstInvite.getStartTime();
            startTime = dtStart != null ? dtStart.getUtcTime() : 0L;
            dtEnd = firstInvite.getEffectiveEndTime();
            endTime = dtEnd != null ? dtEnd.getUtcTime() : startTime;
        }
        Account account = mbox.getAccount();
        firstInvite.updateMyPartStat(account, firstInvite.getPartStat());
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = (byte)type;
        data.folderId = folder.getId();
        if (!folder.inSpam() || mbox.getAccount().getBooleanAttr("zimbraJunkMessagesIndexingEnabled", false)) {
            data.indexId = mbox.generateIndexId(id);
        }
        data.imapId = id;
        data.date = mbox.getOperationTimestamp();
        data.flags = flags & Flag.FLAGS_GENERIC;
        data.tags = tags;
        data.subject = subject;
        data.metadata = CalendarItem.encodeMetadata(DEFAULT_COLOR_RGB, 1, custom, uid, startTime, endTime, recur, invites, firstInvite.getTimeZoneMap(), new ReplyList(), null);
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("Adding CalendarItem: id=%d, Message-ID=%s, folderId=%d, folderName=%s, invite=%s.", data.id, pm != null ? pm.getMessageID() : "none", folder.getId(), folder.getName(), firstInvite.getName());
        DbMailItem.create(mbox, data, sender);
        CalendarItem item = type == 11 ? new Appointment(mbox, data) : new Task(mbox, data);
        String defaultPartStat = mbox.getOperationContext() == null ? "NE" : firstInvite.getPartStat();
        item.processPartStat(firstInvite, pm != null ? pm.getMimeMessage() : null, true, defaultPartStat);
        item.finishCreation(null);
        if (pm != null) {
            item.createBlob(pm, firstInvite);
        }
        item.mEndTime = item.recomputeRecurrenceEndTime(item.mEndTime);
        if (firstInvite.hasAlarm()) {
            long newNextAlarm;
            item.recomputeNextAlarm(nextAlarm, false);
            item.saveMetadata();
            AlarmData alarmData = item.getAlarmData();
            if (alarmData != null && (newNextAlarm = alarmData.getNextAt()) > 0L && newNextAlarm < item.mStartTime) {
                item.mStartTime = newNextAlarm;
            }
        }
        DbMailItem.addToCalendarItemTable(item);
        Callback cb = CalendarItem.getCallback();
        if (cb != null) {
            cb.created(item);
        }
        return item;
    }

    private long recomputeRecurrenceEndTime(long defaultVal) throws ServiceException {
        ParsedDateTime e;
        long endTime = defaultVal;
        if (this.mRecurrence != null && (e = this.mRecurrence.getEndTime()) != null) {
            endTime = e.getUtcTime();
        }
        return endTime;
    }

    public int fixRecurrenceEndTime() throws ServiceException {
        long endTime = this.recomputeRecurrenceEndTime(this.mEndTime);
        if (endTime != this.mEndTime) {
            this.mEndTime = endTime;
            DbMailItem.updateInCalendarItemTable(this);
            return 1;
        }
        return 0;
    }

    private boolean updateRecurrence(long nextAlarm) throws ServiceException {
        long newNextAlarm;
        long endTime;
        long startTime;
        Invite firstInv = this.getDefaultInviteOrNull();
        if (firstInv == null) {
            return false;
        }
        Recurrence.IRecurrence recur = firstInv.getRecurrence();
        if (recur instanceof Recurrence.RecurrenceRule) {
            this.mRecurrence = (Recurrence.IRecurrence)recur.clone();
            for (Invite cur : this.mInvites) {
                if (cur == firstInv) continue;
                String method = cur.getMethod();
                if (cur.isCancel()) {
                    assert (cur.hasRecurId());
                    if (!cur.hasRecurId()) continue;
                    Recurrence.CancellationRule cancelRule = new Recurrence.CancellationRule(cur.getRecurId());
                    ((Recurrence.RecurrenceRule)this.mRecurrence).addException(cancelRule);
                    continue;
                }
                if (!method.equals(ZCalendar.ICalTok.REQUEST.toString()) && !method.equals(ZCalendar.ICalTok.PUBLISH.toString())) continue;
                assert (cur.hasRecurId());
                if (cur.hasRecurId() && cur.getStartTime() != null) {
                    Recurrence.ExceptionRule exceptRule = null;
                    Recurrence.IRecurrence curRule = cur.getRecurrence();
                    exceptRule = curRule != null && curRule instanceof Recurrence.ExceptionRule ? (Recurrence.ExceptionRule)curRule.clone() : new Recurrence.ExceptionRule(cur.getRecurId(), cur.getStartTime(), cur.getEffectiveDuration(), new InviteInfo(cur));
                    ((Recurrence.RecurrenceRule)this.mRecurrence).addException(exceptRule);
                    continue;
                }
                sLog.debug("Got second invite with no RecurID: " + cur.toString());
            }
            ParsedDateTime earliestStart = null;
            for (Invite cur : this.mInvites) {
                ParsedDateTime start = cur.getStartTime();
                if (earliestStart == null) {
                    earliestStart = start;
                    continue;
                }
                if (start == null || start.compareTo(earliestStart) >= 1) continue;
                earliestStart = start;
            }
            ParsedDateTime dtStartTime = earliestStart;
            ParsedDateTime dtEndTime = this.mRecurrence.getEndTime();
            startTime = dtStartTime != null ? dtStartTime.getUtcTime() : 0L;
            endTime = dtEndTime != null ? dtEndTime.getUtcTime() : 0L;
            endTime = this.recomputeRecurrenceEndTime(this.mEndTime);
        } else {
            this.mRecurrence = null;
            startTime = 0L;
            endTime = 0L;
            for (Invite inv : this.mInvites) {
                ParsedDateTime dtEnd;
                long et;
                long st;
                if (inv.isCancel()) continue;
                ParsedDateTime dtStart = inv.getStartTime();
                long l = st = dtStart != null ? dtStart.getUtcTime() : 0L;
                if (st != 0L && (st < startTime || startTime == 0L)) {
                    startTime = st;
                }
                if ((et = (dtEnd = inv.getEffectiveEndTime()) != null ? dtEnd.getUtcTime() : 0L) == 0L || et <= endTime) continue;
                endTime = et;
            }
        }
        boolean timesChanged = false;
        if (this.mStartTime != startTime || this.mEndTime != endTime) {
            timesChanged = true;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
        }
        this.recomputeNextAlarm(nextAlarm, false);
        if (this.mAlarmData != null && (newNextAlarm = this.mAlarmData.getNextAt()) > 0L && newNextAlarm < startTime && this.mStartTime != startTime) {
            timesChanged = true;
            this.mStartTime = newNextAlarm;
        }
        if (timesChanged) {
            if (ZimbraLog.mailop.isDebugEnabled()) {
                ZimbraLog.mailop.debug("Updating recurrence for %s.  nextAlarm=%d.", CalendarItem.getMailopContext(this), nextAlarm);
            }
            DbMailItem.updateInCalendarItemTable(this);
        }
        return true;
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        super.decodeMetadata(meta);
        int mdVersion = meta.getVersion();
        this.mUid = meta.get("u", null);
        this.mInvites = new ArrayList<Invite>();
        ICalTimeZone accountTZ = ICalTimeZone.getAccountTimeZone(this.getMailbox().getAccount());
        if (mdVersion < 6) {
            this.mStartTime = 0L;
            this.mEndTime = 0L;
        } else {
            this.mTzMap = TimeZoneMap.decodeFromMetadata(meta.getMap("tzm"), accountTZ);
            this.mStartTime = meta.getLong("aps", 0L);
            this.mEndTime = meta.getLong("ape", 0L);
            long numComp = meta.getLong("nc");
            int i = 0;
            while ((long)i < numComp) {
                Metadata md = meta.getMap("inv" + i);
                this.mInvites.add(Invite.decodeMetadata(this.getMailboxId(), md, this, accountTZ));
                ++i;
            }
            Metadata metaRecur = meta.getMap(FN_CALITEM_RECURRENCE, true);
            if (metaRecur != null) {
                this.mRecurrence = Recurrence.decodeMetadata(metaRecur, this.mTzMap);
            }
            this.mReplyList = meta.containsKey("rl") ? ReplyList.decodeFromMetadata(meta.getMap("rl"), this.mTzMap) : new ReplyList();
            Metadata metaAlarmData = meta.getMap("ad", true);
            if (metaAlarmData != null) {
                this.mAlarmData = AlarmData.decodeMetadata(metaAlarmData);
            }
        }
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return CalendarItem.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mUid, this.mStartTime, this.mEndTime, this.mRecurrence, this.mInvites, this.mTzMap, this.mReplyList, this.mAlarmData);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata custom, String uid, long startTime, long endTime, Recurrence.IRecurrence recur, List<Invite> invs, TimeZoneMap tzmap, ReplyList replyList, AlarmData alarmData) {
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        return CalendarItem.encodeMetadata(new Metadata(), color, version, extended, uid, startTime, endTime, recur, invs, tzmap, replyList, alarmData).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, String uid, long startTime, long endTime, Recurrence.IRecurrence recur, List<Invite> invs, TimeZoneMap tzmap, ReplyList replyList, AlarmData alarmData) {
        meta.put("tzm", tzmap.encodeAsMetadata());
        meta.put("u", uid);
        meta.put("aps", startTime);
        meta.put("ape", endTime);
        meta.put("nc", invs.size());
        meta.put("rl", replyList.encodeAsMetadata());
        int num = 0;
        for (Invite comp : invs) {
            meta.put("inv" + num++, Invite.encodeMetadata(comp));
        }
        if (recur != null) {
            meta.put(FN_CALITEM_RECURRENCE, recur.encodeMetadata());
        }
        if (alarmData != null) {
            meta.put("ad", alarmData.encodeMetadata());
        }
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public Collection<Instance> expandInstances(long start, long end, boolean includeAlarmOnlyInstances) throws ServiceException {
        long endAdjusted = end;
        long alarmInstStart = 0L;
        if (includeAlarmOnlyInstances && this.mAlarmData != null) {
            alarmInstStart = this.mAlarmData.getNextInstanceStart();
            long nextAlarm = this.mAlarmData.getNextAt();
            if (nextAlarm >= start && nextAlarm < end && alarmInstStart >= end) {
                endAdjusted = alarmInstStart + 1L;
            }
        }
        ArrayList<Instance> instances = new ArrayList();
        if (this.mRecurrence != null) {
            long startTime = System.currentTimeMillis();
            instances = Recurrence.expandInstances(this.mRecurrence, this.getId(), start, endAdjusted);
            if (ZimbraLog.calendar.isDebugEnabled()) {
                long elapsed = System.currentTimeMillis() - startTime;
                ZimbraLog.calendar.debug("RECURRENCE EXPANSION for appt/task " + this.getId() + ": start=" + start + ", end=" + end + "; took " + elapsed + "ms");
            }
        } else if (this.mInvites != null) {
            for (Invite inv : this.mInvites) {
                long invEnd;
                if (inv.isCancel()) continue;
                ParsedDateTime dtStart = inv.getStartTime();
                long invStart = dtStart != null ? dtStart.getUtcTime() : 0L;
                ParsedDateTime dtEnd = inv.getEffectiveEndTime();
                long l = invEnd = dtEnd != null ? dtEnd.getUtcTime() : 0L;
                if ((invStart >= endAdjusted || invEnd <= start) && dtStart != null) continue;
                Instance inst = new Instance(this.getId(), new InviteInfo(inv), dtStart == null, invStart, invEnd, inv.isAllDayEvent(), dtStart != null ? dtStart.getOffset() : 0, inv.hasRecurId(), false);
                instances.add(inst);
            }
        }
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            Instance inst = (Instance)iter.next();
            if (inst.isTimeless()) continue;
            long instStart = inst.getStart();
            long instEnd = inst.getEnd();
            if (instStart == alarmInstStart || instEnd > start && instStart < end) continue;
            iter.remove();
        }
        return instances;
    }

    public String getUid() {
        return this.mUid;
    }

    public Invite getInvite(int invId, int compNum) {
        for (Invite inv : this.mInvites) {
            if (inv.getMailItemId() != invId || inv.getComponentNum() != compNum) continue;
            return inv;
        }
        return null;
    }

    public Invite[] getInvites() {
        int num = this.mInvites.size();
        if (num == 1) {
            Invite[] ret = new Invite[]{this.mInvites.get(0)};
            return ret;
        }
        ArrayList<Invite> toRet = new ArrayList<Invite>(this.mInvites.size());
        for (Invite inv : this.mInvites) {
            if (inv.hasRecurId()) continue;
            toRet.add(inv);
        }
        for (Invite inv : this.mInvites) {
            if (!inv.hasRecurId()) continue;
            toRet.add(inv);
        }
        return toRet.toArray(new Invite[0]);
    }

    public Invite[] getInvites(int invId) {
        ArrayList<Invite> toRet = new ArrayList<Invite>();
        for (Invite inv : this.mInvites) {
            if (inv.getMailItemId() != invId) continue;
            toRet.add(inv);
        }
        return toRet.toArray(new Invite[0]);
    }

    public int numInvites() {
        return this.mInvites.size();
    }

    public Invite getInvite(int index) {
        return this.mInvites.get(index);
    }

    public Invite getInvite(RecurId rid) {
        if (rid == null) {
            for (Invite inv : this.mInvites) {
                if (inv.getRecurId() != null) continue;
                return inv;
            }
        } else {
            for (Invite inv : this.mInvites) {
                if (!rid.equals(inv.getRecurId())) continue;
                return inv;
            }
        }
        return null;
    }

    public Invite getInviteForRecurId(long recurIdDtstamp) {
        Invite defInv = null;
        for (Invite inv : this.mInvites) {
            RecurId rid = inv.getRecurId();
            if (rid == null) {
                if (defInv != null) continue;
                defInv = inv;
                continue;
            }
            ParsedDateTime dt = rid.getDt();
            if (dt == null || dt.getUtcTime() != recurIdDtstamp) continue;
            return inv;
        }
        return defInv;
    }

    public Invite getInviteForRecurIdZ(String recurIdZ) {
        Invite defInv = null;
        for (Invite inv : this.mInvites) {
            RecurId rid = inv.getRecurId();
            if (recurIdZ != null) {
                if (rid == null) {
                    if (defInv != null) continue;
                    defInv = inv;
                    continue;
                }
                if (!recurIdZ.equals(rid.getDtZ())) continue;
                return inv;
            }
            if (rid != null) continue;
            return inv;
        }
        return defInv;
    }

    public Invite getDefaultInviteOrNull() {
        Invite first = null;
        for (Invite cur : this.mInvites) {
            if (!cur.hasRecurId()) {
                return cur;
            }
            if (first != null) continue;
            first = cur;
        }
        if (first == null) {
            ZimbraLog.calendar.error("Invalid state: appointment/task " + this.getId() + " in mailbox " + this.getMailbox().getId() + " has no default invite; " + (this.mInvites != null ? "invite count = " + this.mInvites.size() : "null invite list"));
        }
        return first;
    }

    public boolean isPublic() {
        boolean result = true;
        Invite[] invs = this.getInvites();
        if (invs != null && invs.length > 0) {
            for (Invite i : invs) {
                if (i.isPublic()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean allowPrivateAccess(Account authAccount, boolean asAdmin) throws ServiceException {
        return this.canAccess((short)1024, authAccount, asAdmin);
    }

    public static boolean allowPrivateAccess(Folder folder, Account authAccount, boolean asAdmin) throws ServiceException {
        return folder.canAccess((short)1024, authAccount, asAdmin);
    }

    public static boolean allowFreeBusyAccess(Folder folder, Account authAccount, boolean asAdmin) throws ServiceException {
        return folder.canAccess((short)2048, authAccount, asAdmin);
    }

    boolean processNewInvite(ParsedMessage pm, Invite invite, int folderId, boolean replaceExistingInvites) throws ServiceException {
        return this.processNewInvite(pm, invite, folderId, 0L, true, replaceExistingInvites);
    }

    boolean processNewInvite(ParsedMessage pm, Invite invite, int folderId, long nextAlarm, boolean preserveAlarms, boolean replaceExistingInvites) throws ServiceException {
        invite.setHasAttachment(pm != null ? pm.hasAttachments() : false);
        String method = invite.getMethod();
        if (method.equals(ZCalendar.ICalTok.REQUEST.toString()) || method.equals(ZCalendar.ICalTok.CANCEL.toString()) || method.equals(ZCalendar.ICalTok.PUBLISH.toString())) {
            return this.processNewInviteRequestOrCancel(pm, invite, folderId, nextAlarm, preserveAlarms, replaceExistingInvites);
        }
        if (method.equals(ZCalendar.ICalTok.REPLY.toString())) {
            return this.processNewInviteReply(invite);
        }
        if (!method.equals(ZCalendar.ICalTok.COUNTER.toString()) && !method.equals(ZCalendar.ICalTok.DECLINECOUNTER.toString())) {
            ZimbraLog.calendar.warn("Unsupported METHOD " + method);
        }
        return false;
    }

    private static boolean recurrenceIdsMatch(Invite inv1, Invite inv2) {
        RecurId r1 = inv1.getRecurId();
        RecurId r2 = inv2.getRecurId();
        if (r1 != null) {
            return r1.equals(r2);
        }
        return r2 == null;
    }

    private boolean processNewInviteRequestOrCancel(ParsedMessage pm, Invite newInvite, int folderId, long nextAlarm, boolean preserveAlarms, boolean discardExistingInvites) throws ServiceException {
        Invite defInv;
        ZOrganizer newOrganizer;
        boolean organizerChanged;
        boolean denyPrivateAccess;
        boolean isCalendarResource;
        boolean isCancel;
        block66: {
            boolean cancelAll;
            block68: {
                block67: {
                    Folder folder;
                    short rightsNeeded;
                    newInvite.sanitize(true);
                    OperationContext octxt = this.getMailbox().getOperationContext();
                    Account authAccount = octxt != null ? octxt.getAuthenticatedUser() : null;
                    boolean asAdmin = octxt != null ? octxt.isUsingAdminPrivileges() : false;
                    isCancel = newInvite.isCancel();
                    boolean skipPrivateCheck = this.shouldSkipPrivateCheck(newInvite);
                    short s = rightsNeeded = isCancel ? (short)10 : 2;
                    if (!this.canAccess(rightsNeeded, authAccount, asAdmin, skipPrivateCheck)) {
                        throw ServiceException.PERM_DENIED("you do not have sufficient permissions on this calendar item");
                    }
                    isCalendarResource = this.getMailbox().getAccount() instanceof CalendarResource;
                    boolean bl = skipPrivateCheck ? false : (denyPrivateAccess = !this.allowPrivateAccess(authAccount, asAdmin));
                    if (!(newInvite.isPublic() && this.isPublic() || folderId == this.getFolderId() || CalendarItem.allowPrivateAccess(folder = this.getMailbox().getFolderById(folderId), authAccount, asAdmin))) {
                        denyPrivateAccess = true;
                        if (!isCalendarResource) {
                            throw ServiceException.PERM_DENIED("you do not have permission to update/cancel private calendar item in target folder");
                        }
                    }
                    organizerChanged = this.organizerChangeCheck(newInvite, isCancel);
                    newOrganizer = newInvite.getOrganizer();
                    if (!isCancel) break block66;
                    if (newInvite.hasRecurId()) break block67;
                    cancelAll = true;
                    Invite series = this.getInvite(null);
                    if (series == null) break block68;
                    cancelAll = newInvite.isSameOrNewerVersion(series);
                    break block68;
                }
                cancelAll = false;
                Invite curr = this.getInvite(newInvite.getRecurId());
                if (curr != null && newInvite.isSameOrNewerVersion(curr)) {
                    cancelAll = true;
                    for (Invite inv : this.mInvites) {
                        if (inv.equals(curr) || inv.isCancel()) continue;
                        cancelAll = false;
                        break;
                    }
                }
            }
            if (cancelAll) {
                Folder trash = this.mMailbox.getFolderById(3);
                this.move(trash);
                if (this.getMaxRevisions() != 1) {
                    this.saveMetadata();
                }
                return true;
            }
        }
        boolean needRecurrenceIdUpdate = false;
        ParsedDateTime oldDtStart = null;
        ParsedDuration dtStartMovedBy = null;
        ArrayList<Invite> toUpdate = new ArrayList<Invite>();
        if (!discardExistingInvites && !isCancel && newInvite.isRecurrence() && (defInv = this.getDefaultInviteOrNull()) != null && defInv.isRecurrence()) {
            ParsedDuration delta;
            oldDtStart = defInv.getStartTime();
            ParsedDateTime newDtStart = newInvite.getStartTime();
            if (newDtStart != null && oldDtStart != null && !newDtStart.equals(oldDtStart) && (delta = newDtStart.difference(oldDtStart)).abs().compareTo(ParsedDuration.ONE_WEEK) < 0) {
                needRecurrenceIdUpdate = true;
                dtStartMovedBy = delta;
            }
        }
        if (!discardExistingInvites && preserveAlarms) {
            Invite localSeries = null;
            Invite alarmSourceInv = null;
            for (Invite inv : this.mInvites) {
                if (CalendarItem.recurrenceIdsMatch(inv, newInvite)) {
                    alarmSourceInv = inv;
                    break;
                }
                if (inv.hasRecurId()) continue;
                localSeries = inv;
            }
            if (alarmSourceInv == null) {
                alarmSourceInv = localSeries;
            }
            if (alarmSourceInv != null) {
                newInvite.clearAlarms();
                Iterator<Alarm> alarmIter = alarmSourceInv.alarmsIterator();
                while (alarmIter.hasNext()) {
                    newInvite.addAlarm(alarmIter.next());
                }
            }
        }
        boolean zcoSeriesUpdate = false;
        ZCalendar.ZProperty xzDiscardExcepts = newInvite.getXProperty(ZCalendar.ICalTok.X_ZIMBRA_DISCARD_EXCEPTIONS.toString());
        if (xzDiscardExcepts != null) {
            zcoSeriesUpdate = xzDiscardExcepts.getBoolValue();
        }
        long seriesUntil = Long.MAX_VALUE;
        if (!isCancel && !newInvite.hasRecurId()) {
            ParsedDateTime dtStart = newInvite.getStartTime();
            Recurrence.IRecurrence recur = newInvite.getRecurrence();
            if (recur != null && dtStart != null) {
                ICalTimeZone tz = dtStart.getTimeZone();
                Iterator iter = recur.addRulesIterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        ZRecur rrule;
                        ParsedDateTime until;
                        Recurrence.IRecurrence cur = (Recurrence.IRecurrence)iter.next();
                        if (cur.getType() != 5 || (until = (rrule = ((Recurrence.SimpleRepeatingRule)cur).getRule()).getUntil()) == null) continue;
                        seriesUntil = Math.min(until.getDateForRecurUntil(tz).getTime(), seriesUntil);
                    }
                }
            }
        }
        boolean addNewOne = true;
        boolean replaceExceptionBodyWithSeriesBody = false;
        boolean modifiedCalItem = false;
        Invite prev = null;
        ArrayList<Invite> toRemove = new ArrayList<Invite>();
        ArrayList<Integer> idxsToRemove = new ArrayList<Integer>();
        int numInvitesCurrent = this.mInvites.size();
        for (int i = 0; i < numInvitesCurrent; ++i) {
            ParsedDateTime ridDt;
            RecurId rid;
            ParsedDateTime instDtStart;
            Invite cur = this.mInvites.get(i);
            if (isCancel && !newInvite.hasRecurId()) {
                addNewOne = false;
                modifiedCalItem = true;
                toRemove.add(cur);
                idxsToRemove.add(0, i);
                continue;
            }
            if (!isCancel && cur.hasRecurId() && (instDtStart = cur.getStartTime()) != null && instDtStart.getUtcTime() > seriesUntil) {
                modifiedCalItem = true;
                toRemove.add(cur);
                idxsToRemove.add(0, i);
                continue;
            }
            boolean matchingRecurId = CalendarItem.recurrenceIdsMatch(cur, newInvite);
            if (discardExistingInvites || matchingRecurId) {
                if (discardExistingInvites || newInvite.isSameOrNewerVersion(cur)) {
                    newInvite.setLocalOnly(cur.isLocalOnly() && newInvite.isLocalOnly());
                    toRemove.add(cur);
                    idxsToRemove.add(0, new Integer(i));
                    this.mReplyList.removeObsoleteEntries(newInvite.getRecurId(), newInvite.getSeqNo(), newInvite.getDTStamp());
                    prev = cur;
                    modifiedCalItem = true;
                    if (!isCancel || newInvite.hasRecurId()) continue;
                    addNewOne = false;
                    continue;
                }
                modifiedCalItem = false;
                addNewOne = false;
                break;
            }
            if (isCancel) continue;
            modifiedCalItem = true;
            boolean addToUpdateList = false;
            if (organizerChanged) {
                cur.setOrganizer(newOrganizer);
                addToUpdateList = true;
            }
            if (needRecurrenceIdUpdate && (rid = cur.getRecurId()) != null && rid.getDt() != null && oldDtStart != null && (ridDt = rid.getDt()).sameTime(oldDtStart)) {
                ParsedDateTime dt = rid.getDt().add(dtStartMovedBy);
                RecurId newRid = new RecurId(dt, rid.getRange());
                cur.setRecurId(newRid);
                if (cur.isCancel()) {
                    cur.setDtStart(dt);
                    ParsedDateTime dtEnd = cur.getEndTime();
                    if (dtEnd != null) {
                        ParsedDateTime dtEndMoved = dtEnd.add(dtStartMovedBy);
                        cur.setDtEnd(dtEndMoved);
                    }
                }
                addToUpdateList = true;
            }
            if (!newInvite.hasRecurId() && cur.hasRecurId() && (zcoSeriesUpdate || cur.isLocalOnly())) {
                if (cur.isCancel()) {
                    toRemove.add(cur);
                    idxsToRemove.add(0, new Integer(i));
                    this.mReplyList.removeObsoleteEntries(newInvite.getRecurId(), newInvite.getSeqNo(), newInvite.getDTStamp());
                    addToUpdateList = false;
                } else {
                    replaceExceptionBodyWithSeriesBody = true;
                    Invite copy = newInvite.newCopy();
                    copy.setLocalOnly(true);
                    copy.setMailItemId(cur.getMailItemId());
                    copy.setComponentNum(cur.getComponentNum());
                    copy.setSeqNo(cur.getSeqNo());
                    copy.setDtStamp(cur.getDTStamp());
                    copy.setRecurId(cur.getRecurId());
                    copy.setRecurrence(null);
                    ParsedDateTime start = cur.getRecurId().getDt();
                    if (start != null) {
                        copy.setDtStart(start);
                        ParsedDuration dur = cur.getDuration();
                        if (dur != null) {
                            copy.setDtEnd(null);
                            copy.setDuration(dur);
                        } else {
                            copy.setDuration(null);
                            dur = cur.getEffectiveDuration();
                            ParsedDateTime end = null;
                            if (dur != null) {
                                end = start.add(dur);
                            }
                            copy.setDtEnd(end);
                        }
                    } else {
                        copy.setDtStart(null);
                        copy.setDtEnd(cur.getEndTime());
                        copy.setDuration(null);
                    }
                    copy.clearAlarms();
                    Iterator<Alarm> iter = cur.alarmsIterator();
                    while (iter.hasNext()) {
                        copy.addAlarm(iter.next());
                    }
                    ZAttendee me = copy.getMatchingAttendee(this.getAccount());
                    if (me != null) {
                        me.setPartStat("NE");
                    }
                    this.mInvites.set(i, copy);
                    addToUpdateList = true;
                }
            }
            if (!addToUpdateList) continue;
            toUpdate.add(cur);
        }
        boolean callProcessPartStat = false;
        if (addNewOne) {
            newInvite.setCalendarItem(this);
            if (denyPrivateAccess && prev != null && !prev.isPublic() && !isCalendarResource) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions on this calendar item");
            }
            if (prev != null && !newInvite.isOrganizer() && newInvite.sentByMe()) {
                newInvite.setPartStat(prev.getPartStat());
                newInvite.setRsvp(prev.getRsvp());
                newInvite.getCalendarItem().saveMetadata();
            } else {
                callProcessPartStat = true;
            }
            newInvite.setClassPropSetByMe(newInvite.sentByMe());
            if (prev != null && !newInvite.isOrganizer() && !newInvite.sentByMe() && !prev.isPublic() && prev.classPropSetByMe()) {
                newInvite.setClassProp(prev.getClassProp());
                newInvite.setClassPropSetByMe(true);
            }
            this.mInvites.add(newInvite);
            this.mTzMap.add(newInvite.getTimeZoneMap());
            modifiedCalItem = true;
        }
        Iterator iter = idxsToRemove.iterator();
        while (iter.hasNext()) {
            assert (modifiedCalItem);
            Integer i = (Integer)iter.next();
            this.mInvites.remove(i);
        }
        if (this.getFolderId() != folderId) {
            Folder folder = this.getMailbox().getFolderById(folderId);
            this.move(folder);
        }
        boolean hasAttachments = false;
        boolean hasRequests = false;
        for (Invite cur : this.mInvites) {
            String method = cur.getMethod();
            if (method.equals(ZCalendar.ICalTok.REQUEST.toString()) || method.equals(ZCalendar.ICalTok.PUBLISH.toString())) {
                hasRequests = true;
            }
            if (!cur.hasAttachment()) continue;
            hasAttachments = true;
        }
        if (!hasRequests) {
            if (!isCancel) {
                ZimbraLog.calendar.warn("Invalid state: deleting calendar item " + this.getId() + " in mailbox " + this.getMailboxId() + " while processing a non-cancel request");
            } else {
                ZimbraLog.calendar.warn("Invalid state: deleting calendar item " + this.getId() + " in mailbox " + this.getMailboxId() + " because it has no invite after applying cancel invite");
            }
            this.delete();
            return false;
        }
        if (nextAlarm > 0L && this.mAlarmData != null && this.mAlarmData.getNextAt() != nextAlarm) {
            modifiedCalItem = true;
        }
        if (modifiedCalItem) {
            if (!this.updateRecurrence(nextAlarm)) {
                ZimbraLog.calendar.warn("Invalid state: deleting calendar item " + this.getId() + " in mailbox " + this.getMailboxId() + " because it has no invite");
                this.delete();
                return false;
            }
            if (callProcessPartStat) {
                this.processPartStat(newInvite, pm != null ? pm.getMimeMessage() : null, false, newInvite.getPartStat());
            }
            this.mData.flags = hasAttachments ? (this.mData.flags |= Flag.BITMASK_ATTACHED) : (this.mData.flags &= ~Flag.BITMASK_ATTACHED);
            boolean hadBlobPart = false;
            Invite[] oldInvs = this.getInvites();
            if (oldInvs != null) {
                for (Invite oldInv : oldInvs) {
                    if (!oldInv.hasBlobPart()) continue;
                    hadBlobPart = true;
                    break;
                }
            }
            boolean newInvHasBlobPart = newInvite.hasBlobPart();
            if (hadBlobPart || newInvHasBlobPart) {
                if (addNewOne) {
                    this.modifyBlob(toRemove, discardExistingInvites, toUpdate, pm, newInvite, isCancel, !denyPrivateAccess, true, replaceExceptionBodyWithSeriesBody);
                } else {
                    if (!newInvHasBlobPart) {
                        toRemove.add(newInvite);
                    }
                    this.modifyBlob(toRemove, discardExistingInvites, toUpdate, null, null, isCancel, !denyPrivateAccess, true, replaceExceptionBodyWithSeriesBody);
                }
            } else {
                this.markItemModified(131072);
                try {
                    this.setContent(null, null);
                }
                catch (IOException e) {
                    throw ServiceException.FAILURE("IOException", e);
                }
            }
            Callback cb = CalendarItem.getCallback();
            if (cb != null) {
                cb.modified(this);
            }
            return true;
        }
        return false;
    }

    @Override
    void delete() throws ServiceException {
        super.delete();
        Callback cb = CalendarItem.getCallback();
        if (cb != null) {
            cb.deleted(this);
        }
    }

    public static synchronized void registerCallback(Callback cb) {
        sCallback = cb;
    }

    public static synchronized Callback getCallback() {
        return sCallback;
    }

    private boolean organizerChangeCheck(Invite newInvite, boolean denyChange) throws ServiceException {
        String origOrgAddr;
        String newOrgAddr;
        Invite originalInvite = null;
        if (!newInvite.hasRecurId()) {
            originalInvite = this.getDefaultInviteOrNull();
        } else {
            boolean found = false;
            RecurId newRid = newInvite.getRecurId();
            for (Invite inv : this.mInvites) {
                if (!inv.hasRecurId() || !newRid.equals(inv.getRecurId())) continue;
                originalInvite = inv;
                found = true;
                break;
            }
            if (!found) {
                originalInvite = this.getDefaultInviteOrNull();
            }
        }
        if (originalInvite == null) {
            if (this.mInvites.size() > 0) {
                originalInvite = this.mInvites.get(0);
            }
            if (originalInvite == null) {
                return false;
            }
        }
        boolean changed = false;
        ZOrganizer originalOrganizer = originalInvite.getOrganizer();
        if (!originalInvite.isOrganizer()) {
            if (newInvite.hasOrganizer()) {
                newOrgAddr = newInvite.getOrganizer().getAddress();
                if (originalOrganizer == null) {
                    if (denyChange) {
                        throw ServiceException.INVALID_REQUEST("Changing organizer of an appointment/task to another user is not allowed: old=(unspecified), new=" + newOrgAddr, null);
                    }
                    changed = true;
                } else {
                    origOrgAddr = originalOrganizer.getAddress();
                    if (newOrgAddr == null || !newOrgAddr.equalsIgnoreCase(origOrgAddr)) {
                        if (denyChange) {
                            throw ServiceException.INVALID_REQUEST("Changing organizer of an appointment/task is not allowed: old=" + origOrgAddr + ", new=" + newOrgAddr, null);
                        }
                        changed = true;
                    }
                }
            } else if (originalOrganizer != null) {
                if (denyChange) {
                    throw ServiceException.INVALID_REQUEST("Removing organizer of an appointment/task is not allowed", null);
                }
                changed = true;
            }
        } else if (newInvite.hasOrganizer() && !newInvite.isOrganizer()) {
            if (denyChange) {
                newOrgAddr = newInvite.getOrganizer().getAddress();
                if (originalOrganizer != null) {
                    origOrgAddr = originalOrganizer.getAddress();
                    throw ServiceException.INVALID_REQUEST("Changing organizer of an appointment/task to another user is not allowed: old=" + origOrgAddr + ", new=" + newOrgAddr, null);
                }
                throw ServiceException.INVALID_REQUEST("Changing organizer of an appointment/task to another user is not allowed: old=(unspecified), new=" + newOrgAddr, null);
            }
            changed = true;
        }
        if (changed) {
            String origOrg = originalOrganizer != null ? originalOrganizer.getAddress() : null;
            ZOrganizer newOrganizer = newInvite.getOrganizer();
            String newOrg = newOrganizer != null ? newOrganizer.getAddress() : null;
            boolean wasOrganizer = originalInvite.isOrganizer();
            boolean isOrganizer = newInvite.isOrganizer();
            ZimbraLog.calendar.info("Changed organizer: old=" + origOrg + ", new=" + newOrg + ", wasOrg=" + wasOrganizer + ", isOrg=" + isOrganizer + ", uid=\"" + newInvite.getUid() + "\", invId=" + newInvite.getMailItemId());
        }
        return changed;
    }

    private MailboxBlob storeUpdatedBlob(MimeMessage mm) throws ServiceException, IOException {
        ParsedMessage pm = new ParsedMessage(mm, this.mMailbox.attachmentsIndexingEnabled());
        byte[] data = pm.getRawData();
        if (data == null) {
            ZimbraLog.calendar.warn("Invalid state: updating blob with null data for calendar item " + this.getId() + " in mailbox " + this.getMailboxId());
        }
        return this.setContent(data, pm.getRawDigest(), pm);
    }

    @Override
    void reanalyze(Object data) throws ServiceException {
        String subject = null;
        Invite firstInvite = this.getDefaultInviteOrNull();
        if (firstInvite != null) {
            subject = firstInvite.getName();
        }
        if (subject == null) {
            subject = "";
        }
        this.mData.subject = subject;
        this.saveData(this.getSender());
    }

    private MailboxBlob createBlob(ParsedMessage invPm, Invite firstInvite) throws ServiceException {
        if (!firstInvite.hasAttachment() && (invPm == null || firstInvite.descInMeta())) {
            return null;
        }
        try {
            MimeMessage mm = new MimeMessage(JMSession.getSession());
            MimeMultipart mmp = new MimeMultipart("digest");
            mm.setContent((Multipart)mmp);
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setDataHandler(new DataHandler(new PMDataSource(invPm)));
            mmp.addBodyPart((BodyPart)mbp);
            mbp.addHeader("invId", Integer.toString(firstInvite.getMailItemId()));
            mm.saveChanges();
            return this.storeUpdatedBlob(mm);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("MessagingException " + (Object)((Object)e), e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException " + e, e);
        }
    }

    private void modifyBlob(List<Invite> toRemove, boolean removeAllExistingInvites, List<Invite> toUpdate, ParsedMessage invPm, Invite newInv, boolean isCancel, boolean allowPrivateAccess, boolean forceSave, boolean replaceExceptionBodyWithSeriesBody) throws ServiceException {
        try {
            String[] hdrs;
            MimeBodyPart mbp;
            int numParts;
            MimeMessage mm = null;
            if (this.getSize() > 0L) {
                try {
                    mm = this.getMimeMessage();
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)("Error reading blob for calendar item " + this.getId() + " in mailbox " + this.getMailboxId()), e);
                }
            }
            if (mm == null) {
                if (newInv != null && invPm != null) {
                    this.createBlob(invPm, newInv);
                } else if (forceSave) {
                    this.saveMetadata();
                }
                return;
            }
            MimeMultipart mmp = (MimeMultipart)mm.getContent();
            boolean updated = false;
            if (removeAllExistingInvites) {
                int numParts2 = mmp.getCount();
                if (numParts2 > 0) {
                    for (int i = numParts2 - 1; i >= 0; --i) {
                        mmp.removeBodyPart(i);
                    }
                    updated = true;
                }
            } else {
                for (Invite inv : toRemove) {
                    int matchedIdx;
                    do {
                        numParts = mmp.getCount();
                        matchedIdx = -1;
                        for (int i = 0; i < numParts; ++i) {
                            mbp = (MimeBodyPart)mmp.getBodyPart(i);
                            hdrs = mbp.getHeader("invId");
                            if (hdrs == null || hdrs.length == 0) {
                                matchedIdx = i;
                                break;
                            }
                            if (hdrs == null || hdrs.length <= 0 || Integer.parseInt(hdrs[0]) != inv.getMailItemId()) continue;
                            matchedIdx = i;
                            break;
                        }
                        if (matchedIdx <= -1) continue;
                        mmp.removeBodyPart(matchedIdx);
                        updated = true;
                    } while (matchedIdx > -1);
                }
            }
            for (Invite inv : toUpdate) {
                MimeMessage mmInv;
                Object objMulti;
                MimeBodyPart mbpInv = null;
                numParts = mmp.getCount();
                for (int i = 0; i < numParts; ++i) {
                    mbp = (MimeBodyPart)mmp.getBodyPart(i);
                    hdrs = mbp.getHeader("invId");
                    if (hdrs == null || hdrs.length <= 0 || Integer.parseInt(hdrs[0]) != inv.getMailItemId()) continue;
                    mbpInv = mbp;
                    break;
                }
                if (mbpInv == null) continue;
                if (replaceExceptionBodyWithSeriesBody) {
                    mmp.removeBodyPart(mbpInv);
                    mbpInv = new MimeBodyPart();
                    mbpInv.setDataHandler(new DataHandler(new PMDataSource(invPm)));
                    mmp.addBodyPart((BodyPart)mbpInv);
                    mbpInv.addHeader("invId", Integer.toString(inv.getMailItemId()));
                    mm.saveChanges();
                }
                String mbpInvCt = mbpInv.getContentType();
                Object objInv = mbpInv.getContent();
                if (!(objInv instanceof MimeMessage) || !((objMulti = (mmInv = (MimeMessage)objInv).getContent()) instanceof MimeMultipart)) continue;
                MimeMultipart multi = (MimeMultipart)objMulti;
                int numSubParts = multi.getCount();
                int icalPartNum = -1;
                for (int j = 0; j < numSubParts; ++j) {
                    MimeBodyPart part = (MimeBodyPart)multi.getBodyPart(j);
                    ContentType ct = new ContentType(part.getContentType());
                    if (!ct.match("text/calendar")) continue;
                    icalPartNum = j;
                    break;
                }
                if (icalPartNum == -1) continue;
                updated = true;
                multi.removeBodyPart(icalPartNum);
                ZCalendar.ZVCalendar cal = inv.newToICalendar(allowPrivateAccess);
                MimeBodyPart icalPart = CalendarMailSender.makeICalIntoMimePart(inv.getUid(), cal);
                multi.addBodyPart((BodyPart)icalPart, icalPartNum);
                mmInv.setContent((Multipart)multi);
                mmInv.saveChanges();
                mbpInv.setContent((Object)mmInv, mbpInvCt);
            }
            if (newInv != null) {
                MimeBodyPart mbp2 = new MimeBodyPart();
                mbp2.setDataHandler(new DataHandler(new PMDataSource(invPm)));
                mmp.addBodyPart((BodyPart)mbp2);
                mbp2.addHeader("invId", Integer.toString(newInv.getMailItemId()));
                updated = true;
            }
            if (!updated) {
                if (forceSave) {
                    this.saveMetadata();
                }
                return;
            }
            if (mmp.getCount() == 0) {
                this.markBlobForDeletion();
                this.setContent(null, null, null);
                if (forceSave) {
                    this.saveMetadata();
                }
            } else {
                mm.setContent((Multipart)mmp);
                mm.saveChanges();
                this.storeUpdatedBlob(mm);
            }
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("MessagingException", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException", e);
        }
    }

    public List<ReplyInfo> getAllReplies() {
        return this.mReplyList.getAllReplies();
    }

    public List<ReplyInfo> getReplyInfo(Invite inv, String recurIdZ) {
        return this.mReplyList.getReplyInfo(inv, recurIdZ);
    }

    public void setReplies(List<ReplyInfo> replies) throws ServiceException {
        this.mReplyList = new ReplyList(replies);
        this.saveMetadata();
    }

    public String getEffectivePartStat(Invite inv, Instance inst) throws ServiceException {
        Account acct = this.getMailbox().getAccount();
        ZAttendee at = this.mReplyList.getEffectiveAttendee(acct, inv, inst);
        if (at == null || inv.isOrganizer()) {
            return inv.getPartStat();
        }
        if (at.hasPartStat()) {
            return at.getPartStat();
        }
        return "NE";
    }

    void modifyPartStat(Account acctOrNull, RecurId recurId, String cnStr, String addressStr, String cutypeStr, String roleStr, String partStatStr, Boolean needsReply, int seqNo, long dtStamp) throws ServiceException {
        ZAttendee at;
        Invite inv;
        this.mReplyList.modifyPartStat(acctOrNull, recurId, cnStr, addressStr, cutypeStr, roleStr, partStatStr, needsReply, seqNo, dtStamp);
        if (addressStr != null && (inv = this.getInvite(recurId)) != null && (at = acctOrNull != null ? inv.getMatchingAttendee(acctOrNull) : inv.getMatchingAttendee(addressStr)) != null) {
            at.setPartStat(partStatStr);
        }
        this.saveMetadata();
    }

    public boolean processNewInviteReply(Invite reply) throws ServiceException {
        boolean asAdmin;
        boolean skipPrivateCheck = this.shouldSkipPrivateCheck(reply);
        OperationContext octxt = this.getMailbox().getOperationContext();
        Account authAccount = octxt != null ? octxt.getAuthenticatedUser() : null;
        boolean bl = asAdmin = octxt != null ? octxt.isUsingAdminPrivileges() : false;
        if (!this.canAccess((short)16, authAccount, asAdmin, skipPrivateCheck)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions to change this appointment/task's state");
        }
        boolean dirty = false;
        for (int i = 0; i < this.numInvites(); ++i) {
            Invite cur = this.getInvite(i);
            if ((cur.getRecurId() == null || !cur.getRecurId().equals(reply.getRecurId())) && (cur.getRecurId() != null || reply.getRecurId() != null)) continue;
            if (cur.getSeqNo() >= reply.getSeqNo() && cur.getDTStamp() > reply.getDTStamp()) {
                sLog.info("Invite-Reply " + reply.toString() + " is outdated, ignoring!");
                return false;
            }
            cur.updateMatchingAttendeesFromReply(reply);
            dirty = true;
            break;
        }
        List<ZAttendee> attendees = reply.getAttendees();
        for (ZAttendee at : attendees) {
            if (!this.mReplyList.maybeStoreNewReply(reply, at)) continue;
            dirty = true;
        }
        if (dirty) {
            this.saveMetadata();
            this.getMailbox().markItemModified(this, 131072);
            return true;
        }
        return false;
    }

    public InputStream getRawMessage() throws ServiceException {
        return this.getContentStream();
    }

    void appendRawCalendarData(ZCalendar.ZVCalendar cal, boolean useOutlookCompatMode, boolean ignoreErrors, boolean allowPrivateAccess) throws ServiceException {
        Invite[] invs;
        for (Invite inv : invs = this.getInvites()) {
            try {
                cal.addComponent(inv.newToVComponent(useOutlookCompatMode, allowPrivateAccess));
            }
            catch (ServiceException e) {
                if (ignoreErrors) {
                    ZimbraLog.calendar.warn((Object)("Error retrieving iCalendar data for item " + inv.getMailItemId() + ": " + e.getMessage()), e);
                    continue;
                }
                throw e;
            }
        }
    }

    public MimeMessage getMimeMessage() throws ServiceException {
        MimeMessage mm;
        InputStream is;
        block8: {
            is = null;
            mm = null;
            is = this.getRawMessage();
            if (is != null) break block8;
            MimeMessage mimeMessage = null;
            Object var6_7 = null;
            ByteUtil.closeStream(is);
            return mimeMessage;
        }
        try {
            mm = new MimeMessage(JMSession.getSession(), is);
            ByteUtil.closeStream(is);
            try {
                for (Class<? extends MimeVisitor> visitor : MimeVisitor.getConverters()) {
                    visitor.newInstance().accept(mm);
                }
            }
            catch (Exception e) {
                ZimbraLog.mailbox.warn((Object)("MIME converter failed for message " + this.getId()), e);
                is = this.getRawMessage();
                mm = new MimeMessage(JMSession.getSession(), is);
                ByteUtil.closeStream(is);
            }
            MimeMessage e = mm;
            Object var6_8 = null;
        }
        catch (MessagingException e) {
            try {
                throw ServiceException.FAILURE("MessagingException while getting MimeMessage for item " + this.mId, e);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
        }
        ByteUtil.closeStream(is);
        return e;
    }

    public MimeMessage getSubpartMessage(int subId) throws ServiceException {
        try {
            MimeBodyPart mbp = this.findBodyBySubId(subId);
            return mbp == null ? null : Mime.getMessageContent((MimePart)mbp);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException while getting MimeMessage for item " + this.mId, e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("MessagingException while getting MimeMessage for item " + this.mId, e);
        }
    }

    public Pair<MimeMessage, Integer> getSubpartMessageData(int subId) throws ServiceException {
        try {
            MimeBodyPart mbp = this.findBodyBySubId(subId);
            if (mbp == null) {
                return null;
            }
            return new Pair<MimeMessage, Integer>(Mime.getMessageContent((MimePart)mbp), mbp.getSize());
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException while getting MimeMessage for item " + this.mId, e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("MessagingException while getting MimeMessage for item " + this.mId, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MimeBodyPart findBodyBySubId(int subId) throws ServiceException {
        MimeBodyPart mimeBodyPart;
        InputStream is;
        block15: {
            MimeBodyPart mimeBodyPart2;
            block14: {
                MimeBodyPart mimeBodyPart3;
                block13: {
                    if (this.getSize() <= 0L) {
                        return null;
                    }
                    is = null;
                    MimeMessage mm = null;
                    try {
                        try {
                            is = this.getRawMessage();
                            if (is == null) {
                                mimeBodyPart3 = null;
                                Object var11_9 = null;
                                break block13;
                            }
                            mm = new MimeMessage(JMSession.getSession(), is);
                            ByteUtil.closeStream(is);
                            if (DebugConfig.forceMimeConvertersForCalendarBlobs) {
                                try {
                                    for (Class<? extends MimeVisitor> visitor : MimeVisitor.getConverters()) {
                                        visitor.newInstance().accept(mm);
                                    }
                                }
                                catch (Exception e) {
                                    ZimbraLog.mailbox.warn((Object)("MIME converter failed for message " + this.getId()), e);
                                    is = this.getRawMessage();
                                    mm = new MimeMessage(JMSession.getSession(), is);
                                    ByteUtil.closeStream(is);
                                }
                            }
                            MimeMultipart mmp = (MimeMultipart)mm.getContent();
                            int numParts = mmp.getCount();
                            for (int i = 0; i < numParts; ++i) {
                                MimeBodyPart mbp = (MimeBodyPart)mmp.getBodyPart(i);
                                String[] hdrs = mbp.getHeader("invId");
                                if (hdrs == null || hdrs.length <= 0 || Integer.parseInt(hdrs[0]) != subId) continue;
                                mimeBodyPart2 = mbp;
                                break block14;
                            }
                            mimeBodyPart = null;
                            break block15;
                        }
                        catch (IOException e) {
                            throw ServiceException.FAILURE("IOException while getting MimeMessage for item " + this.mId, e);
                        }
                        catch (MessagingException e) {
                            throw ServiceException.FAILURE("MessagingException while getting MimeMessage for item " + this.mId, e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        ByteUtil.closeStream(is);
                        throw throwable;
                    }
                }
                ByteUtil.closeStream(is);
                return mimeBodyPart3;
            }
            Object var11_10 = null;
            ByteUtil.closeStream(is);
            return mimeBodyPart2;
        }
        Object var11_11 = null;
        ByteUtil.closeStream(is);
        return mimeBodyPart;
    }

    protected abstract String processPartStat(Invite var1, MimeMessage var2, boolean var3, String var4) throws ServiceException;

    public boolean hasAlarm() {
        if (this.mInvites != null && this.mInvites.size() > 0) {
            for (Invite inv : this.mInvites) {
                if (!inv.hasAlarm()) continue;
                return true;
            }
        }
        return false;
    }

    public void updateNextAlarm(long nextAlarm) throws ServiceException {
        boolean hadAlarm = this.mAlarmData != null;
        this.recomputeNextAlarm(nextAlarm, true);
        if (this.mAlarmData != null) {
            long newNextAlarm = this.mAlarmData.getNextAt();
            if (newNextAlarm > 0L && newNextAlarm < this.mStartTime) {
                this.mStartTime = newNextAlarm;
            }
            if (ZimbraLog.mailop.isDebugEnabled()) {
                ZimbraLog.mailop.debug("Setting next alarm for %s to %d.", CalendarItem.getMailopContext(this), nextAlarm);
            }
            DbMailItem.updateInCalendarItemTable(this);
        }
        if (this.mAlarmData != null || hadAlarm) {
            this.saveMetadata();
        }
    }

    private long getNextAlarmRecurrenceExpansionLimit() {
        long fromTime = Math.max(this.getStartTime(), System.currentTimeMillis());
        long endTime = fromTime + 31536000000L;
        long itemEndTime = this.getEndTime();
        if (itemEndTime < endTime && itemEndTime >= this.getStartTime()) {
            endTime = itemEndTime;
        }
        return endTime;
    }

    private void recomputeNextAlarm(long nextAlarm, boolean skipAlarmDefChangeCheck) throws ServiceException {
        long startTime;
        if (nextAlarm == -1L || !this.hasAlarm()) {
            this.mAlarmData = null;
            return;
        }
        long now = this.getMailbox().getOperationTimestampMillis();
        long atOrAfter = nextAlarm == 0L ? (this.mAlarmData != null ? this.mAlarmData.getNextAt() : now) : (nextAlarm == -2L ? now : nextAlarm);
        if (atOrAfter <= 0L) {
            atOrAfter = now;
        }
        if ((startTime = atOrAfter) > now) {
            startTime = now;
        }
        long endTime = this.getNextAlarmRecurrenceExpansionLimit();
        Collection<Instance> instances = this.expandInstances(startTime, endTime, false);
        if (atOrAfter > 0L && !skipAlarmDefChangeCheck) {
            boolean alarmDefChanged = true;
            long savedNextInstStart = this.mAlarmData != null ? this.mAlarmData.getNextInstanceStart() : 0L;
            block0: for (Instance inst : instances) {
                long instStart = inst.getStart();
                if (inst.isTimeless() || instStart < startTime) continue;
                if (instStart > savedNextInstStart) break;
                InviteInfo invId = inst.getInviteInfo();
                Invite inv = this.getInvite(invId.getMsgId(), invId.getComponentId());
                Iterator<Alarm> alarmsIter = inv.alarmsIterator();
                long instEnd = inst.getEnd();
                while (alarmsIter.hasNext()) {
                    Alarm alarm = alarmsIter.next();
                    long currTrigger = alarm.getTriggerTime(instStart, instEnd);
                    if (currTrigger != atOrAfter) continue;
                    alarmDefChanged = false;
                    break block0;
                }
                break block0;
            }
            if (alarmDefChanged) {
                atOrAfter = now;
            }
        }
        long triggerAt = Long.MAX_VALUE;
        Instance alarmInstance = null;
        Alarm theAlarm = null;
        for (Instance inst : instances) {
            long currAt;
            InviteInfo invId;
            Invite inv;
            Pair<Long, Alarm> curr;
            long instStart = inst.getStart();
            if (instStart < startTime && !inst.isTimeless() || (curr = CalendarItem.getAlarmTriggerTime(atOrAfter, (inv = this.getInvite((invId = inst.getInviteInfo()).getMsgId(), invId.getComponentId())).alarmsIterator(), instStart, inst.getEnd())) == null || atOrAfter > (currAt = curr.getFirst().longValue()) || currAt >= triggerAt) continue;
            triggerAt = currAt;
            theAlarm = curr.getSecond();
            alarmInstance = inst;
        }
        if (alarmInstance != null) {
            InviteInfo invInfo = alarmInstance.getInviteInfo();
            if (invInfo != null) {
                this.mAlarmData = new AlarmData(triggerAt, alarmInstance.getStart(), invInfo.getMsgId(), invInfo.getComponentId(), theAlarm);
            }
        } else {
            this.mAlarmData = null;
        }
    }

    private static Pair<Long, Alarm> getAlarmTriggerTime(long nextAlarm, Iterator<Alarm> alarms, long instStart, long instEnd) {
        long triggerAt = Long.MAX_VALUE;
        Alarm theAlarm = null;
        while (alarms.hasNext()) {
            Alarm alarm = alarms.next();
            long currTrigger = alarm.getTriggerTime(instStart, instEnd);
            if (nextAlarm > currTrigger || currTrigger >= triggerAt) continue;
            triggerAt = currTrigger;
            theAlarm = alarm;
        }
        if (theAlarm != null) {
            return new Pair<Long, Object>(triggerAt, theAlarm);
        }
        return null;
    }

    public NextAlarms computeNextAlarms(Invite inv, long lastAt) throws ServiceException {
        int numAlarms = inv.getAlarms().size();
        HashMap<Integer, Long> lastAlarmsAt = new HashMap<Integer, Long>(numAlarms);
        for (int i = 0; i < numAlarms; ++i) {
            lastAlarmsAt.put(i, lastAt);
        }
        return this.computeNextAlarms(inv, lastAlarmsAt);
    }

    public NextAlarms computeNextAlarms(Invite inv, Map<Integer, Long> lastAlarmsAt) throws ServiceException {
        NextAlarms result = new NextAlarms();
        if (inv.getRecurrence() == null) {
            ParsedDateTime dtend;
            long instStart = 0L;
            long instEnd = 0L;
            ParsedDateTime dtstart = inv.getStartTime();
            if (dtstart != null) {
                instStart = dtstart.getUtcTime();
            }
            if ((dtend = inv.getEffectiveEndTime()) != null) {
                instEnd = dtend.getUtcTime();
            }
            List<Alarm> alarms = inv.getAlarms();
            int index = 0;
            for (Alarm alarm : alarms) {
                long triggerAt;
                long lastAt;
                Long lastAtLong = lastAlarmsAt.get(index);
                if (lastAtLong != null && (lastAt = lastAtLong.longValue()) < (triggerAt = alarm.getTriggerTime(instStart, instEnd))) {
                    result.add(index, triggerAt, instStart);
                }
                ++index;
            }
        } else {
            long oldest = Long.MAX_VALUE;
            for (long lastAt : lastAlarmsAt.values()) {
                oldest = Math.min(oldest, lastAt);
            }
            long endTime = this.getNextAlarmRecurrenceExpansionLimit();
            Collection<Instance> instances = this.expandInstances(oldest, endTime, false);
            List<Alarm> alarms = inv.getAlarms();
            int index = 0;
            for (Alarm alarm : alarms) {
                Long lastAtLong = lastAlarmsAt.get(index);
                if (lastAtLong != null) {
                    long lastAt = lastAtLong;
                    for (Instance inst : instances) {
                        long triggerAt;
                        long instStart;
                        if (inst.isException() || (instStart = inst.getStart()) < lastAt && !inst.isTimeless() || lastAt >= (triggerAt = alarm.getTriggerTime(instStart, inst.getEnd()))) continue;
                        result.add(index, triggerAt, instStart);
                        break;
                    }
                }
                ++index;
            }
        }
        return result;
    }

    public static boolean accountMatchesCalendarUser(Account acct, CalendarUser calUser) throws ServiceException {
        String address = calUser.getAddress();
        return AccountUtil.addressMatchesAccount(acct, address);
    }

    @Override
    boolean move(Folder target) throws ServiceException {
        if (!this.isPublic()) {
            if (!this.canAccess((short)1024)) {
                throw ServiceException.PERM_DENIED("you do not have permission to move private calendar item from the current folder");
            }
            if (target.getId() != 3 && !target.canAccess((short)1024)) {
                throw ServiceException.PERM_DENIED("you do not have permission to move private calendar item to the target folder");
            }
        }
        this.addRevision(true);
        return super.move(target);
    }

    @Override
    void delete(MailItem.DeleteScope scope, boolean writeTombstones) throws ServiceException {
        if (!this.isPublic() && !this.canAccess((short)1024)) {
            throw ServiceException.PERM_DENIED("you do not have permission to delete private calendar item from the current folder");
        }
        super.delete(scope, writeTombstones);
    }

    @Override
    MailItem copy(Folder folder, int id, int parentId) throws IOException, ServiceException {
        if (!this.isPublic()) {
            boolean privateAccessSrc = this.canAccess((short)1024);
            boolean privateAccessDest = folder.canAccess((short)1024);
            if (!privateAccessSrc) {
                throw ServiceException.PERM_DENIED("you do not have permission to copy private calendar item from the current folder");
            }
            if (!privateAccessDest) {
                throw ServiceException.PERM_DENIED("you do not have permission to copy private calendar item to the target folder");
            }
        }
        return super.copy(folder, id, parentId);
    }

    @Override
    void rename(String name, Folder target) throws ServiceException {
        if (!this.isPublic()) {
            boolean privateAccessSrc = this.canAccess((short)1024);
            boolean privateAccessDest = target.canAccess((short)1024);
            if (!privateAccessSrc) {
                throw ServiceException.PERM_DENIED("you do not have permission to rename/move private calendar item from the current folder");
            }
            if (!privateAccessDest) {
                throw ServiceException.PERM_DENIED("you do not have permission to move private calendar item to the target folder");
            }
        }
        super.rename(name, target);
    }

    @Override
    boolean canAccess(short rightsNeeded, Account authuser, boolean asAdmin) throws ServiceException {
        return this.canAccess(rightsNeeded, authuser, asAdmin, false);
    }

    private boolean canAccess(short rightsNeeded, Account authuser, boolean asAdmin, boolean skipPrivateCheck) throws ServiceException {
        int writeAccess;
        if (!(skipPrivateCheck || this.isPublic() || (rightsNeeded & (writeAccess = 10)) == 0 || super.canAccess((short)1024, authuser, asAdmin))) {
            return false;
        }
        return super.canAccess(rightsNeeded, authuser, asAdmin);
    }

    public void checkCancelPermission(Account authAccount, boolean asAdmin, Invite cancelInv) throws ServiceException {
        boolean skipPrivateCheck = this.shouldSkipPrivateCheck(cancelInv);
        if (!this.canAccess((short)10, authAccount, asAdmin, skipPrivateCheck)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions to cancel this calendar item");
        }
    }

    private boolean shouldSkipPrivateCheck(Invite newInvite) throws ServiceException {
        if (!this.isPublic() && newInvite.isPublic()) {
            RecurId rid = newInvite.getRecurId();
            if (rid == null && newInvite.isCancel()) {
                return false;
            }
            Invite current = this.getInvite(rid);
            if (current == null && rid != null) {
                current = this.getInvite(null);
            }
            if (current != null && current.isPublic()) {
                return true;
            }
        }
        return false;
    }

    public static Map<Integer, MimeMessage> decomposeBlob(byte[] digestBlob) throws ServiceException {
        HashMap<Integer, MimeMessage> map = new HashMap<Integer, MimeMessage>();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(digestBlob);
            Mime.FixedMimeMessage digestMm = new Mime.FixedMimeMessage(JMSession.getSession(), bais);
            MimeMultipart mmp = (MimeMultipart)digestMm.getContent();
            int numParts = mmp.getCount();
            for (int i = 0; i < numParts; ++i) {
                MimeBodyPart mbp = (MimeBodyPart)mmp.getBodyPart(i);
                int invId = 0;
                String[] hdrs = mbp.getHeader("invId");
                if (hdrs == null || hdrs.length <= 0) continue;
                invId = Integer.parseInt(hdrs[0]);
                MimeMessage mm = (MimeMessage)mbp.getContent();
                map.put(invId, mm);
            }
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Can't parse calendar item blob", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Can't parse calendar item blob", e);
        }
        catch (NumberFormatException e) {
            throw ServiceException.FAILURE("Can't parse calendar item blob", e);
        }
        return map;
    }

    public static boolean isAcceptableInvite(Account acct, ParsedMessage.CalendarPartInfo cpi) throws ServiceException {
        return !cpi.wasForwarded || acct.getBooleanAttr("zimbraPrefCalendarAllowForwardedInvite", true);
    }

    @Override
    int getMaxRevisions() throws ServiceException {
        return this.getAccount().getIntAttr("zimbraCalendarMaxRevisions", 1);
    }

    public void snapshotRevision() throws ServiceException {
        this.addRevision(false);
    }

    @Override
    protected boolean trackUserAgentInMetadata() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NextAlarms {
        private Map<Integer, Long> mTriggerMap = new HashMap<Integer, Long>();
        private Map<Integer, Long> mInstStartMap = new HashMap<Integer, Long>();

        public void add(int pos, long triggerAt, long instStart) {
            this.mTriggerMap.put(pos, triggerAt);
            this.mInstStartMap.put(pos, instStart);
        }

        public long getTriggerTime(int pos) {
            Long triggerAt = this.mTriggerMap.get(pos);
            if (triggerAt != null) {
                return triggerAt;
            }
            return 0L;
        }

        public long getInstStart(int pos) {
            Long start = this.mInstStartMap.get(pos);
            if (start != null) {
                return start;
            }
            return 0L;
        }

        public Iterator<Integer> posIterator() {
            return this.mTriggerMap.keySet().iterator();
        }
    }

    public static class AlarmData {
        private long mNextAt = Long.MAX_VALUE;
        private long mNextInstStart;
        private int mInvId;
        private int mCompNum;
        private Alarm mAlarm;
        private static final String FNAME_NEXT_AT = "na";
        private static final String FNAME_NEXT_INSTANCE_START = "nis";
        private static final String FNAME_INV_ID = "invId";
        private static final String FNAME_COMP_NUM = "compNum";
        private static final String FNAME_ALARM = "alarm";

        public AlarmData(long next, long nextInstStart, int invId, int compNum, Alarm alarm) {
            this.mNextAt = next;
            this.mNextInstStart = nextInstStart;
            this.mInvId = invId;
            this.mCompNum = compNum;
            this.mAlarm = alarm;
        }

        public long getNextAt() {
            return this.mNextAt;
        }

        public long getNextInstanceStart() {
            return this.mNextInstStart;
        }

        public int getInvId() {
            return this.mInvId;
        }

        public int getCompNum() {
            return this.mCompNum;
        }

        public Alarm getAlarm() {
            return this.mAlarm;
        }

        static AlarmData decodeMetadata(Metadata meta) throws ServiceException {
            long nextAt = meta.getLong(FNAME_NEXT_AT);
            long nextInstStart = meta.getLong(FNAME_NEXT_INSTANCE_START);
            int invId = (int)meta.getLong(FNAME_INV_ID);
            int compNum = (int)meta.getLong(FNAME_COMP_NUM);
            Alarm alarm = null;
            Metadata metaAlarm = meta.getMap(FNAME_ALARM, true);
            if (metaAlarm != null) {
                alarm = Alarm.decodeMetadata(metaAlarm);
            }
            return new AlarmData(nextAt, nextInstStart, invId, compNum, alarm);
        }

        Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(FNAME_NEXT_AT, this.mNextAt);
            meta.put(FNAME_NEXT_INSTANCE_START, this.mNextInstStart);
            meta.put(FNAME_INV_ID, this.mInvId);
            meta.put(FNAME_COMP_NUM, this.mCompNum);
            if (this.mAlarm != null) {
                meta.put(FNAME_ALARM, this.mAlarm.encodeMetadata());
            }
            return meta;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ReplyList {
        List<ReplyInfo> mReplies;
        private static final String FN_NUM_REPLY_INFO = "n";
        private static final String FN_REPLY_INFO = "i";

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[ReplyList]\n");
            if (this.mReplies != null) {
                for (ReplyInfo ri : this.mReplies) {
                    sb.append(ri.toString()).append("\n");
                }
            }
            sb.append("[end]\n");
            return sb.toString();
        }

        public ReplyList() {
            this.mReplies = new ArrayList<ReplyInfo>();
        }

        public ReplyList(List<ReplyInfo> list) {
            this.mReplies = list;
        }

        Metadata encodeAsMetadata() {
            Metadata meta = new Metadata();
            meta.put(FN_NUM_REPLY_INFO, this.mReplies.size());
            for (int i = 0; i < this.mReplies.size(); ++i) {
                String fn = FN_REPLY_INFO + i;
                meta.put(fn, this.mReplies.get(i).encodeAsMetadata());
            }
            return meta;
        }

        static ReplyList decodeFromMetadata(Metadata md, TimeZoneMap tzMap) throws ServiceException {
            ReplyList toRet = new ReplyList();
            int numReplies = (int)md.getLong(FN_NUM_REPLY_INFO);
            toRet.mReplies = new ArrayList<ReplyInfo>(numReplies);
            for (int i = 0; i < numReplies; ++i) {
                ReplyInfo inf = ReplyInfo.decodeFromMetadata(md.getMap(FN_REPLY_INFO + i), tzMap);
                toRet.mReplies.add(i, inf);
            }
            return toRet;
        }

        void removeObsoleteEntries(RecurId recurId, int seqNo, long dtStamp) {
            Iterator<ReplyInfo> iter = this.mReplies.iterator();
            while (iter.hasNext()) {
                ReplyInfo cur = iter.next();
                if (this.recurMatches(cur.mRecurId, recurId)) {
                    if (cur.mSeqNo >= seqNo) continue;
                    iter.remove();
                    continue;
                }
                if (recurId != null) continue;
                iter.remove();
            }
        }

        boolean maybeStoreNewReply(Invite inv, ZAttendee at) throws ServiceException {
            Iterator<ReplyInfo> iter = this.mReplies.iterator();
            while (iter.hasNext()) {
                ReplyInfo cur = iter.next();
                Account acct = null;
                String address = at.getAddress();
                if (address != null) {
                    acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, address);
                }
                if (!at.addressesMatch(cur.mAttendee) && (acct == null || !CalendarItem.accountMatchesCalendarUser(acct, cur.mAttendee)) || !this.recurMatches(inv.getRecurId(), cur.mRecurId)) continue;
                if (inv.getSeqNo() >= cur.mSeqNo && inv.getDTStamp() >= cur.mDtStamp) {
                    iter.remove();
                    ReplyInfo toAdd = new ReplyInfo(at, inv.getSeqNo(), inv.getDTStamp(), inv.getRecurId());
                    this.mReplies.add(toAdd);
                    return true;
                }
                return false;
            }
            ReplyInfo toAdd = new ReplyInfo(at, inv.getSeqNo(), inv.getDTStamp(), inv.getRecurId());
            this.mReplies.add(toAdd);
            return true;
        }

        void modifyPartStat(Account acctOrNull, RecurId recurId, String cnStr, String addressStr, String cutypeStr, String roleStr, String partStatStr, Boolean needsReply, int seqNo, long dtStamp) throws ServiceException {
            for (ReplyInfo cur : this.mReplies) {
                if ((cur.mRecurId != null || recurId != null) && (cur.mRecurId == null || !cur.mRecurId.withinRange(recurId)) || (acctOrNull == null || !AccountUtil.addressMatchesAccount(acctOrNull, cur.mAttendee.getAddress())) && (acctOrNull != null || !cur.mAttendee.addressMatches(addressStr))) continue;
                if (cur.mAttendee.hasCn()) {
                    cnStr = cur.mAttendee.getCn();
                }
                if (cur.mAttendee.hasCUType()) {
                    cutypeStr = cur.mAttendee.getCUType();
                }
                if (cur.mAttendee.hasRole()) {
                    roleStr = cur.mAttendee.getRole();
                }
                ZAttendee newAt = new ZAttendee(cur.mAttendee);
                newAt.setCn(cnStr);
                newAt.setCUType(cutypeStr);
                newAt.setRole(roleStr);
                newAt.setPartStat(partStatStr);
                newAt.setRsvp(needsReply);
                cur.mAttendee = newAt;
                cur.mSeqNo = seqNo;
                cur.mDtStamp = dtStamp;
                return;
            }
            ZAttendee at = new ZAttendee(addressStr, cnStr, null, null, null, cutypeStr, roleStr, partStatStr, needsReply, null, null, null, null);
            ReplyInfo ri = new ReplyInfo(at, seqNo, dtStamp, recurId);
            this.mReplies.add(ri);
        }

        boolean recurMatches(RecurId lhs, RecurId rhs) {
            if (lhs == null) {
                return rhs == null;
            }
            return lhs.equals(rhs);
        }

        ZAttendee getEffectiveAttendee(Account acct, Invite inv, Instance inst) throws ServiceException {
            boolean isSimple = inv.getRecurrence() == null && !inv.hasRecurId();
            ZAttendee defaultAt = null;
            for (ReplyInfo cur : this.mReplies) {
                boolean match;
                if (!AccountUtil.addressMatchesAccount(acct, cur.mAttendee.getAddress())) continue;
                boolean bl = match = cur.mRecurId == null && (inst == null || isSimple);
                if (!match && inst != null && cur.mRecurId != null) {
                    RecurId instRecurId;
                    long instStart = inst.getStart();
                    if (inst.mInvId != null && (instRecurId = inst.mInvId.getRecurrenceId()) != null) {
                        instStart = instRecurId.getDt().getUtcTime();
                    }
                    match = cur.mRecurId.withinRange(instStart);
                }
                if (match && inv.getSeqNo() <= cur.mSeqNo && inv.getDTStamp() <= cur.mDtStamp) {
                    return cur.mAttendee;
                }
                if (cur.mRecurId != null || inv.getSeqNo() > cur.mSeqNo || inv.getDTStamp() > cur.mDtStamp) continue;
                defaultAt = cur.mAttendee;
            }
            if (isSimple || inst == null) {
                return defaultAt != null ? defaultAt : inv.getMatchingAttendee(acct);
            }
            if (defaultAt != null && (!inv.hasRecurId() || inv.isLocalOnly())) {
                return defaultAt;
            }
            return inv.getMatchingAttendee(acct);
        }

        List<ReplyInfo> getAllReplies() {
            ArrayList<ReplyInfo> toRet = new ArrayList<ReplyInfo>();
            toRet.addAll(this.mReplies);
            return toRet;
        }

        List<ReplyInfo> getReplyInfo(Invite inv, String recurIdZ) {
            assert (inv != null);
            HashMap<String, ReplyInfo> repliesByAddr = new HashMap<String, ReplyInfo>();
            if (recurIdZ == null && inv.hasRecurId()) {
                recurIdZ = inv.getRecurId().getDtZ();
            }
            for (ReplyInfo reply : this.mReplies) {
                String addr;
                ReplyInfo toAdd = null;
                String replyRidZ = null;
                if (reply.getRecurId() != null) {
                    ParsedDateTime dt = reply.getRecurId().getDt();
                    ParsedDateTime dtTmp = (ParsedDateTime)dt.clone();
                    if (inv.isAllDayEvent()) {
                        dtTmp.setHasTime(false);
                    } else {
                        dtTmp.setHasTime(true);
                        dtTmp.toUTC();
                    }
                    replyRidZ = dtTmp.getDateTimePartString(false);
                }
                if (inv.hasRecurId()) {
                    if (reply.mRecurId != null && recurIdZ.equals(replyRidZ) && inv.getSeqNo() <= reply.mSeqNo) {
                        toAdd = reply;
                    }
                } else if (recurIdZ == null) {
                    if (reply.mRecurId == null && inv.getSeqNo() <= reply.mSeqNo) {
                        toAdd = reply;
                    }
                } else if ((reply.mRecurId == null || recurIdZ.equals(replyRidZ)) && inv.getSeqNo() <= reply.mSeqNo) {
                    toAdd = reply;
                }
                if (toAdd == null || toAdd.getAttendee() == null || (addr = toAdd.getAttendee().getAddress()) == null) continue;
                ReplyInfo existing = (ReplyInfo)repliesByAddr.get(addr);
                if (existing == null) {
                    repliesByAddr.put(addr, toAdd);
                    continue;
                }
                if (existing.getRecurId() == null) {
                    if (replyRidZ != null) {
                        repliesByAddr.put(addr, toAdd);
                        continue;
                    }
                    if (existing.getDtStamp() > toAdd.getDtStamp()) continue;
                    repliesByAddr.put(addr, toAdd);
                    continue;
                }
                if (replyRidZ == null || existing.getDtStamp() > toAdd.getDtStamp()) continue;
                repliesByAddr.put(addr, toAdd);
            }
            return new ArrayList<ReplyInfo>(repliesByAddr.values());
        }
    }

    public static class ReplyInfo {
        private ZAttendee mAttendee;
        private int mSeqNo;
        private long mDtStamp;
        private RecurId mRecurId;
        private static final String FN_RECURID = "r";
        private static final String FN_SEQNO = "s";
        private static final String FN_DTSTAMP = "d";
        private static final String FN_ATTENDEE = "at";

        public ReplyInfo(ZAttendee at, int seq, long dtstamp, RecurId recurId) {
            this.mAttendee = at;
            this.mSeqNo = seq;
            this.mDtStamp = dtstamp;
            this.mRecurId = recurId;
        }

        public ZAttendee getAttendee() {
            return this.mAttendee;
        }

        public int getSeq() {
            return this.mSeqNo;
        }

        public long getDtStamp() {
            return this.mDtStamp;
        }

        public RecurId getRecurId() {
            return this.mRecurId;
        }

        public Metadata encodeAsMetadata() {
            Metadata meta = new Metadata();
            if (this.mRecurId != null) {
                meta.put(FN_RECURID, this.mRecurId.encodeMetadata());
            }
            meta.put(FN_SEQNO, this.mSeqNo);
            meta.put(FN_DTSTAMP, this.mDtStamp);
            meta.put(FN_ATTENDEE, this.mAttendee.encodeAsMetadata());
            return meta;
        }

        public static ReplyInfo decodeFromMetadata(Metadata md, TimeZoneMap tzMap) throws ServiceException {
            RecurId recurId = md.containsKey(FN_RECURID) ? RecurId.decodeMetadata(md.getMap(FN_RECURID), tzMap) : null;
            int seq = (int)md.getLong(FN_SEQNO);
            long dtstamp = md.getLong(FN_DTSTAMP);
            Metadata metaAttendee = md.getMap(FN_ATTENDEE);
            ZAttendee at = metaAttendee != null ? new ZAttendee(metaAttendee) : null;
            ReplyInfo ri = new ReplyInfo(at, seq, dtstamp, recurId);
            return ri;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("seq=").append(this.mSeqNo);
            sb.append(", dtstamp=").append(this.mDtStamp);
            if (this.mRecurId != null) {
                sb.append(", recurId=\"").append(this.mRecurId).append("\"");
            }
            sb.append(", attendee=").append(this.mAttendee);
            return sb.toString();
        }
    }

    private static class PMDataSource
    implements DataSource {
        private ParsedMessage mPm;

        public PMDataSource(ParsedMessage pm) {
            this.mPm = pm;
        }

        public String getName() {
            return this.mPm != null ? this.mPm.getMessageID() : null;
        }

        public String getContentType() {
            return "message/rfc822";
        }

        public InputStream getInputStream() throws IOException {
            if (this.mPm == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(this.mPm.getRawData());
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Callback {
        public void created(CalendarItem var1) throws ServiceException;

        public void modified(CalendarItem var1) throws ServiceException;

        public void deleted(CalendarItem var1) throws ServiceException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instance
    implements Comparable<Instance> {
        private boolean mTimeless;
        private long mStart;
        private long mEnd;
        private boolean mIsException;
        private boolean mFromRdate;
        private InviteInfo mInvId;
        private int mCalItemId;
        private boolean mAllDay;
        private int mTzOffset;

        public static Instance fromInvite(int calItemId, Invite inv) {
            ParsedDateTime dtStart = inv.getStartTime();
            long start = dtStart != null ? dtStart.getUtcTime() : 0L;
            ParsedDateTime dtEnd = inv.getEffectiveEndTime();
            long end = dtEnd != null ? dtEnd.getUtcTime() : 0L;
            int tzOffset = 0;
            boolean allDay = inv.isAllDayEvent();
            if (allDay) {
                tzOffset = dtStart.getOffset();
            }
            return new Instance(calItemId, new InviteInfo(inv), dtStart == null, start, end, allDay, tzOffset, inv.hasRecurId(), false);
        }

        public Instance(int calItemId, InviteInfo invInfo, boolean timeless, long start, long end, boolean allDay, int tzOffset, boolean _exception, boolean fromRdate) {
            this.mInvId = invInfo;
            this.mCalItemId = calItemId;
            this.mTimeless = timeless;
            if (this.mTimeless) {
                this.mEnd = 0L;
                this.mStart = 0L;
                this.mAllDay = false;
                this.mTzOffset = 0;
            } else {
                this.mStart = start;
                this.mEnd = end;
                this.mAllDay = allDay;
                this.mTzOffset = this.mAllDay ? tzOffset : 0;
            }
            this.mIsException = _exception;
            this.mFromRdate = fromRdate;
        }

        @Override
        public int compareTo(Instance other) {
            long toRet = this.mCalItemId - other.mCalItemId;
            if (toRet == 0L) {
                if (this.mTimeless == other.mTimeless) {
                    toRet = this.mStart - other.mStart;
                    if (toRet == 0L && (toRet = this.mEnd - other.mEnd) == 0L) {
                        if (this.mAllDay == other.mAllDay) {
                            toRet = this.mTzOffset - other.mTzOffset;
                            if (toRet == 0L) {
                                toRet = this.mInvId != null ? (long)this.mInvId.compareTo(other.mInvId) : (other.mInvId != null ? (long)(other.mInvId.compareTo(this.mInvId) * -1) : 0L);
                            }
                        } else {
                            toRet = this.mAllDay ? -1L : 1L;
                        }
                    }
                } else {
                    toRet = this.mTimeless ? 1L : -1L;
                }
            }
            if (toRet > 0L) {
                return 1;
            }
            if (toRet < 0L) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Instance)) {
                return false;
            }
            Instance other = (Instance)o;
            boolean sameInvId = this.mInvId != null ? this.mInvId.equals(other.mInvId) : other.mInvId == null;
            return sameInvId && this.mTimeless == other.mTimeless && this.mStart == other.mStart && this.mEnd == other.mEnd && this.mAllDay == other.mAllDay && this.mTzOffset == other.mTzOffset;
        }

        public boolean sameTime(Instance other) {
            if (!this.mTimeless && !other.mTimeless) {
                return this.mStart == other.mStart && this.mEnd == other.mEnd && this.mAllDay == other.mAllDay && this.mTzOffset == other.mTzOffset;
            }
            return false;
        }

        public String toString() {
            StringBuilder toRet = new StringBuilder("INST(");
            Date dstart = new Date(this.mStart);
            Date dend = new Date(this.mEnd);
            toRet.append(this.mTimeless).append(",");
            toRet.append(dstart).append(",").append(dend).append(",").append(this.mIsException);
            toRet.append(",allDay=").append(this.mAllDay);
            toRet.append(",tzo=").append(this.mTzOffset);
            if (this.mInvId != null) {
                toRet.append(",ID=").append(this.mInvId.getMsgId()).append("-").append(this.mInvId.getComponentId());
            }
            toRet.append(")");
            return toRet.toString();
        }

        public int getCalendarItemId() {
            return this.mCalItemId;
        }

        public CalendarItem getCalendarItem() {
            return null;
        }

        public int getMailItemId() {
            return this.mInvId != null ? this.mInvId.getMsgId() : -1;
        }

        public int getComponentNum() {
            return this.mInvId != null ? this.mInvId.getComponentId() : -1;
        }

        public long getStart() {
            return this.mStart;
        }

        public long getEnd() {
            return this.mEnd;
        }

        public boolean isAllDay() {
            return this.mAllDay;
        }

        public int getTzOffset() {
            return this.mTzOffset;
        }

        public boolean isTimeless() {
            return this.mTimeless;
        }

        public boolean isException() {
            return this.mIsException;
        }

        public void setIsException(boolean isException) {
            this.mIsException = isException;
        }

        public boolean fromRdate() {
            return this.mFromRdate;
        }

        public InviteInfo getInviteInfo() {
            return this.mInvId;
        }

        public String getRecurIdZ() {
            ParsedDateTime dt;
            if (this.mTimeless) {
                return null;
            }
            if (this.mAllDay) {
                dt = ParsedDateTime.fromUTCTime(this.mStart + (long)this.mTzOffset);
                dt.setHasTime(false);
            } else {
                dt = ParsedDateTime.fromUTCTime(this.mStart);
            }
            return dt.getDateTimePartString(false);
        }

        public RecurId makeRecurId(Invite refInv) {
            RecurId rid;
            RecurId recurId = rid = this.mInvId != null ? this.mInvId.getRecurrenceId() : null;
            if (rid != null) {
                return rid;
            }
            if (refInv == null) {
                if (!this.mTimeless) {
                    return new RecurId(ParsedDateTime.fromUTCTime(this.mStart), RecurId.RANGE_NONE);
                }
                return null;
            }
            ParsedDateTime dtStart = refInv.getStartTime();
            if (dtStart == null) {
                return null;
            }
            ICalTimeZone tz = dtStart.getTimeZone();
            long startTime = this.mStart;
            ParsedDateTime dt = tz != null ? ParsedDateTime.fromUTCTime(startTime, tz) : ParsedDateTime.fromUTCTime(startTime);
            if (refInv.isAllDayEvent()) {
                dt.setHasTime(false);
            }
            return new RecurId(dt, RecurId.RANGE_NONE);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class StartTimeComparator
        implements Comparator<Instance> {
            @Override
            public int compare(Instance a, Instance b) {
                long bs;
                long as = a.getStart();
                if (as < (bs = b.getStart())) {
                    return -1;
                }
                if (as > bs) {
                    return 1;
                }
                if (a.mAllDay == b.mAllDay) {
                    return a.mTzOffset - b.mTzOffset;
                }
                if (a.mAllDay) {
                    return -1;
                }
                return 1;
            }
        }
    }

    public static class CalendarMetadata {
        public long mailboxId;
        public int itemId;
        public String uid;
        public int mod_metadata;
        public int mod_content;
        public long start_time;
        public long end_time;

        public CalendarMetadata(long mailboxId, int itemId, String uid, int mod_metadata, int mod_content, long start_time, long end_time) {
            this.mailboxId = mailboxId;
            this.itemId = itemId;
            this.uid = uid;
            this.mod_metadata = mod_metadata;
            this.mod_content = mod_content;
            this.start_time = start_time;
            this.end_time = end_time;
        }
    }
}

