/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mime.Mime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;

public class AttachmentDataSource
implements DataSource {
    private Contact mContact;
    private String mPartName;

    public AttachmentDataSource(Contact contact, String partName) {
        if (contact == null) {
            throw new NullPointerException("contact cannot be null");
        }
        if (partName == null) {
            throw new NullPointerException("partName cannot be null");
        }
        this.mContact = contact;
        this.mPartName = partName;
    }

    public String getContentType() {
        String contentType = null;
        MimePart mp = null;
        try {
            mp = this.getMimePart();
            if (mp != null) {
                contentType = mp.getContentType();
            }
        }
        catch (Exception e) {
            ZimbraLog.mailbox.error("Unable to determine content type for contact %d.", (Object)this.mContact.getId(), e);
        }
        return contentType;
    }

    private MimePart getMimePart() throws MessagingException, ServiceException {
        MimeMessage msg = this.mContact.getMimeMessage(false);
        MimePart mp = null;
        try {
            mp = Mime.getMimePart((MimePart)msg, this.mPartName);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to look up part " + this.mPartName + " for contact " + this.mContact.getId(), null);
        }
        if (mp == null) {
            ZimbraLog.mailbox.warn("Unable to find part %s for contact %d.", this.mPartName, this.mContact.getId());
        }
        return mp;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.getMimePart().getInputStream();
        }
        catch (Exception e) {
            ZimbraLog.mailbox.error("Unable to get stream to part %s for contact %d.", this.mPartName, this.mContact.getId());
            throw new IOException(e.toString());
        }
    }

    public String getName() {
        MimePart mp = null;
        String name = null;
        try {
            mp = this.getMimePart();
            if (mp != null) {
                name = mp.getFileName();
            }
        }
        catch (Exception e) {
            ZimbraLog.mailbox.error("Unable to determine the filename for contact %d, part %s.", (Object)this.mContact.getId(), (Object)this.mPartName, e);
        }
        return name;
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }
}

