/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateTimeUtil;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.CreateCalendarItemRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appointment
extends CalendarItem {
    private static final int TWENTY_FIVE_HOURS = 90000000;
    private static final int TWO_HOURS = 0x6DDD00;
    private static final int MIN_CONFLICT_LIST_SIZE = 5;

    public Appointment(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 11) {
            throw new IllegalArgumentException();
        }
    }

    public String getEffectiveFreeBusyActual(Invite inv, CalendarItem.Instance inst) throws ServiceException {
        Account acct = this.getMailbox().getAccount();
        ZAttendee at = this.getReplyList().getEffectiveAttendee(acct, inv, inst);
        if (at == null || inv.isOrganizer()) {
            return inv.getFreeBusyActual();
        }
        if (at.hasPartStat()) {
            return inv.partStatToFreeBusyActual(at.getPartStat());
        }
        return inv.getFreeBusyActual();
    }

    private static String getBusyTimesString(OperationContext octxt, Mailbox mbox, List<Conflict> list, TimeZone tz, Locale lc, boolean hasMoreConflicts) throws ServiceException {
        StringBuilder sb = new StringBuilder();
        int conflictCount = 0;
        for (Conflict avail : list) {
            if (!avail.isBusy()) continue;
            FreeBusy fb = avail.getFreeBusy();
            ArrayList<FreeBusy.FBInstance> instances = new ArrayList<FreeBusy.FBInstance>();
            for (FreeBusy.Interval interval : fb) {
                if (!Conflict.isBusy(interval.getStatus())) continue;
                for (FreeBusy.FBInstance fbinst : interval.getInstances()) {
                    if (!Conflict.isBusy(fbinst.getFreeBusy())) continue;
                    instances.add(fbinst);
                }
            }
            for (FreeBusy.FBInstance instance : instances) {
                String end;
                Date startDate = new Date(instance.getStartTime());
                Date endDate = new Date(instance.getEndTime());
                String start = CalendarMailSender.formatDateTime(startDate, tz, lc);
                sb.append(" * ").append(start);
                if (DateTimeUtil.sameDay(startDate, endDate, tz)) {
                    end = CalendarMailSender.formatTime(endDate, tz, lc);
                    sb.append(" - ").append(end);
                } else {
                    end = CalendarMailSender.formatDateTime(endDate, tz, lc);
                    sb.append("\r\n   - ").append(end);
                }
                int apptId = instance.getApptId();
                long recurIdDt = instance.getRecurIdDt();
                CalendarItem appt = mbox.getCalendarItemById(octxt, apptId);
                Invite inv = appt.getInviteForRecurId(recurIdDt);
                if (inv != null && inv.hasOrganizer()) {
                    ZOrganizer organizer = inv.getOrganizer();
                    String orgDispName = organizer.hasCn() ? organizer.getCn() + " <" + organizer.getAddress() + ">" : organizer.getAddress();
                    sb.append(L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceConflictScheduledBy, lc, orgDispName));
                }
                sb.append("\r\n");
                ++conflictCount;
            }
        }
        if (hasMoreConflicts) {
            sb.append(" * ...\r\n");
        }
        return sb.toString();
    }

    private static String getDeclinedTimesString(OperationContext octxt, Mailbox mbox, List<Conflict> conflicts, boolean allDay, TimeZone tz, Locale lc) throws ServiceException {
        StringBuilder sb = new StringBuilder();
        int conflictCount = 0;
        for (Conflict conflict : conflicts) {
            String start;
            CalendarItem.Instance instance = conflict.getInstance();
            Date startDate = new Date(instance.getStart());
            Date endDate = new Date(instance.getEnd());
            if (!allDay) {
                String end;
                start = CalendarMailSender.formatDateTime(startDate, tz, lc);
                sb.append(" * ").append(start);
                if (DateTimeUtil.sameDay(startDate, endDate, tz)) {
                    end = CalendarMailSender.formatTime(endDate, tz, lc);
                    sb.append(" - ").append(end);
                } else {
                    end = CalendarMailSender.formatDateTime(endDate, tz, lc);
                    sb.append("\r\n   - ").append(end);
                }
            } else {
                start = CalendarMailSender.formatDate(startDate, tz, lc);
                sb.append(" * ").append(start);
                long duration = endDate.getTime() - startDate.getTime();
                if (duration > 90000000L) {
                    endDate = new Date(instance.getEnd() - 0x6DDD00L);
                    String end = CalendarMailSender.formatDate(endDate, tz, lc);
                    sb.append(" - ").append(end);
                }
            }
            sb.append("\r\n");
            ++conflictCount;
        }
        return sb.toString();
    }

    private ConflictCheckResult checkAvailability(long now, Invite invite, int maxNumConflicts, int maxPctConflicts) throws ServiceException {
        Collection<Object> instances;
        long et;
        long st;
        if (invite.isRecurrence()) {
            st = this.getStartTime();
            et = this.getEndTime();
        } else {
            ParsedDateTime dtStart = invite.getStartTime();
            ParsedDateTime dtEnd = invite.getEffectiveEndTime();
            if (dtStart != null && dtEnd != null) {
                st = dtStart.getUtcTime();
                et = dtEnd.getUtcTime();
            } else {
                return null;
            }
        }
        st = Math.max(st, now);
        if (et <= st) {
            return null;
        }
        OperationContext octxt = new OperationContext(this.getAccount());
        if (invite.isRecurrence()) {
            instances = this.expandInstances(st, et, false);
        } else {
            instances = new ArrayList(1);
            instances.add(CalendarItem.Instance.fromInvite(this.getId(), invite));
        }
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        int maxByPct = maxPctConflicts * instances.size() / 100;
        int maxConflicts = Math.min(maxNumConflicts, maxByPct);
        ArrayList<Conflict> list = new ArrayList<Conflict>();
        int numConflicts = 0;
        boolean hasMoreConflicts = false;
        for (CalendarItem.Instance instance : instances) {
            if (numConflicts > Math.max(maxConflicts, 4)) {
                hasMoreConflicts = true;
                break;
            }
            long start = instance.getStart();
            long end = instance.getEnd();
            FreeBusy fb = this.getMailbox().getFreeBusy(octxt, start, end, this);
            String status = fb.getBusiest();
            if (!Conflict.isBusy(status)) continue;
            list.add(new Conflict(instance, status, fb));
            ++numConflicts;
        }
        return new ConflictCheckResult(list, numConflicts > maxConflicts, hasMoreConflicts);
    }

    @Override
    protected String processPartStat(Invite invite, MimeMessage mmInv, boolean forCreate, String defaultPartStat) throws ServiceException {
        Invite defaultInvite;
        boolean needReplyEmail;
        Boolean rsvp;
        String p;
        Account authuser;
        Mailbox mbox = this.getMailbox();
        OperationContext octxt = mbox.getOperationContext();
        CreateCalendarItemPlayer player = octxt != null ? (CreateCalendarItemPlayer)((Object)octxt.getPlayer()) : null;
        long opTime = octxt != null ? octxt.getTimestamp() : System.currentTimeMillis();
        Account account = this.getMailbox().getAccount();
        boolean onBehalfOf = false;
        Account authAcct = account;
        if (octxt != null && (authuser = octxt.getAuthenticatedUser()) != null) {
            boolean bl = onBehalfOf = !account.getId().equalsIgnoreCase(authuser.getId());
            if (onBehalfOf) {
                authAcct = authuser;
            }
        }
        boolean asAdmin = octxt != null ? octxt.isUsingAdminPrivileges() : false;
        boolean allowPrivateAccess = this.allowPrivateAccess(authAcct, asAdmin);
        String partStat = defaultPartStat;
        if (player != null && (p = player.getCalendarItemPartStat()) != null) {
            partStat = p;
        }
        boolean rsvpRequested = true;
        ZAttendee attendee = invite.getMatchingAttendee(account);
        if (attendee != null && (rsvp = attendee.getRsvp()) != null) {
            rsvpRequested = rsvp;
        }
        RedoLogProvider redoProvider = RedoLogProvider.getInstance();
        boolean bl = needReplyEmail = rsvpRequested && redoProvider.isMaster() && (player == null || redoProvider.getRedoLogManager().getInCrashRecovery()) && invite.hasOrganizer() && !invite.isCancel() && !invite.isTodo();
        if (invite.isOrganizer()) {
            partStat = "AC";
        } else if (account instanceof CalendarResource && octxt == null) {
            boolean replySent = false;
            CalendarResource resource = (CalendarResource)account;
            Account organizer = invite.getOrganizerAccount();
            Locale lc = organizer != null ? organizer.getLocale() : resource.getLocale();
            if (resource.autoAcceptDecline() || resource.autoDeclineIfBusy() || resource.autoDeclineRecurring()) {
                List<Conflict> conflicts;
                int maxPctConflicts;
                int maxNumConflicts;
                ConflictCheckResult checkResult;
                boolean replyListUpdated = false;
                if (resource.autoAcceptDecline()) {
                    partStat = "AC";
                }
                if (this.isRecurring() && resource.autoDeclineRecurring()) {
                    partStat = "DE";
                    if (needReplyEmail) {
                        String reason = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceDeclineReasonRecurring, lc, new Object[0]);
                        Invite replyInv = this.makeReplyInvite(account, authAcct, lc, onBehalfOf, allowPrivateAccess, invite, invite.getRecurId(), CalendarMailSender.VERB_DECLINE);
                        CalendarMailSender.sendResourceAutoReply(octxt, mbox, true, CalendarMailSender.VERB_DECLINE, false, reason + "\r\n", this, invite, new Invite[]{replyInv}, mmInv);
                        replySent = true;
                    }
                } else if (resource.autoDeclineIfBusy() && (checkResult = this.checkAvailability(opTime, invite, maxNumConflicts = resource.getMaxNumConflictsAllowed(), maxPctConflicts = resource.getMaxPercentConflictsAllowed())) != null && (conflicts = checkResult.getConflicts()).size() > 0) {
                    if (invite.isRecurrence() && !checkResult.tooManyConflicts()) {
                        if (resource.autoAcceptDecline()) {
                            ArrayList<Invite> replyInvites = new ArrayList<Invite>();
                            Invite acceptInv = this.makeReplyInvite(account, authAcct, lc, onBehalfOf, allowPrivateAccess, invite, invite.getRecurId(), CalendarMailSender.VERB_ACCEPT);
                            for (Conflict conflict : conflicts) {
                                CalendarItem.Instance inst = conflict.getInstance();
                                InviteInfo invInfo = inst.getInviteInfo();
                                Invite inv = this.getInvite(invInfo.getMsgId(), invInfo.getComponentId());
                                RecurId rid = inst.makeRecurId(inv);
                                this.getReplyList().modifyPartStat(resource, rid, null, resource.getName(), null, null, "DE", false, invite.getSeqNo(), opTime);
                                replyListUpdated = true;
                                Invite replyInv = this.makeReplyInvite(account, authAcct, lc, onBehalfOf, allowPrivateAccess, inv, rid, CalendarMailSender.VERB_DECLINE);
                                replyInvites.add(replyInv);
                            }
                            if (needReplyEmail) {
                                ICalTimeZone tz = this.chooseReplyTZ(invite);
                                String declinedInstances = Appointment.getDeclinedTimesString(octxt, mbox, conflicts, invite.isAllDayEvent(), tz, lc);
                                String msg = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceDeclinedInstances, lc, new Object[0]) + "\r\n\r\n" + declinedInstances;
                                CalendarMailSender.sendResourceAutoReply(octxt, mbox, true, CalendarMailSender.VERB_ACCEPT, true, msg, this, invite, new Invite[]{acceptInv}, mmInv);
                                String conflictingTimes = Appointment.getBusyTimesString(octxt, mbox, conflicts, tz, lc, false);
                                msg = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceDeclinedInstances, lc, new Object[0]) + "\r\n\r\n" + declinedInstances + "\r\n" + L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceDeclineReasonConflict, lc, new Object[0]) + "\r\n\r\n" + conflictingTimes;
                                CalendarMailSender.sendResourceAutoReply(octxt, mbox, true, CalendarMailSender.VERB_DECLINE, true, msg, this, invite, replyInvites.toArray(new Invite[0]), mmInv);
                                replySent = true;
                            }
                        }
                    } else {
                        partStat = "DE";
                        if (needReplyEmail) {
                            ICalTimeZone tz = this.chooseReplyTZ(invite);
                            String msg = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceDeclineReasonConflict, lc, new Object[0]) + "\r\n\r\n" + Appointment.getBusyTimesString(octxt, mbox, conflicts, tz, lc, checkResult.hasMoreConflicts());
                            Invite replyInv = this.makeReplyInvite(account, authAcct, lc, onBehalfOf, allowPrivateAccess, invite, invite.getRecurId(), CalendarMailSender.VERB_DECLINE);
                            CalendarMailSender.sendResourceAutoReply(octxt, mbox, true, CalendarMailSender.VERB_DECLINE, false, msg, this, invite, new Invite[]{replyInv}, mmInv);
                            replySent = true;
                        }
                    }
                }
                if (!replySent && "AC".equals(partStat) && needReplyEmail) {
                    Invite replyInv = this.makeReplyInvite(account, authAcct, lc, onBehalfOf, allowPrivateAccess, invite, invite.getRecurId(), CalendarMailSender.VERB_ACCEPT);
                    CalendarMailSender.sendResourceAutoReply(octxt, mbox, true, CalendarMailSender.VERB_ACCEPT, false, null, this, invite, new Invite[]{replyInv}, mmInv);
                }
                if ("NE".equals(partStat)) {
                    this.getReplyList().modifyPartStat(resource, invite.getRecurId(), null, resource.getName(), null, null, partStat, false, invite.getSeqNo(), opTime);
                    replyListUpdated = true;
                }
                if (forCreate && replyListUpdated) {
                    this.saveMetadata();
                }
            }
        }
        CreateCalendarItemRecorder recorder = (CreateCalendarItemRecorder)((Object)mbox.getRedoRecorder());
        recorder.setCalendarItemPartStat(partStat);
        invite.updateMyPartStat(account, partStat);
        if (forCreate && (defaultInvite = this.getDefaultInviteOrNull()) != null && !defaultInvite.equals(invite) && !partStat.equals(defaultInvite.getPartStat())) {
            defaultInvite.updateMyPartStat(account, partStat);
            this.saveMetadata();
        }
        return partStat;
    }

    private ICalTimeZone chooseReplyTZ(Invite invite) throws ServiceException {
        Account account = this.getMailbox().getAccount();
        Account organizer = invite.getOrganizerAccount();
        ICalTimeZone tz = invite.getStartTime().getTimeZone();
        if (tz == null && invite.isAllDayEvent()) {
            tz = ICalTimeZone.getAccountTimeZone(account);
            if (tz == null) {
                ICalTimeZone.getUTC();
            }
        } else if (tz == null || tz.sameAsUTC()) {
            if (organizer != null) {
                tz = ICalTimeZone.getAccountTimeZone(organizer);
            } else {
                tz = ICalTimeZone.getAccountTimeZone(account);
                if (tz == null) {
                    ICalTimeZone.getUTC();
                }
            }
        }
        return tz;
    }

    private Invite makeReplyInvite(Account account, Account authAccount, Locale lc, boolean onBehalfOf, boolean allowPrivateAccess, Invite inv, RecurId rid, CalendarMailSender.Verb verb) throws ServiceException {
        boolean hidePrivate = !inv.isPublic() && !allowPrivateAccess;
        String subject = hidePrivate ? L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectWithheld, lc, new Object[0]) : inv.getName();
        String replySubject = CalendarMailSender.getReplySubject(verb, subject, lc);
        ParsedDateTime ridDt = rid != null ? rid.getDt() : null;
        Invite replyInv = CalendarMailSender.replyToInvite(account, authAccount, onBehalfOf, allowPrivateAccess, inv, verb, replySubject, ridDt);
        return replyInv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConflictCheckResult {
        private List<Conflict> mConflicts;
        private boolean mTooManyConflicts;
        private boolean mHasMoreConflicts;

        public ConflictCheckResult(List<Conflict> conflicts, boolean tooManyConflicts, boolean hasMoreConflicts) {
            this.mConflicts = conflicts;
            this.mTooManyConflicts = tooManyConflicts;
            this.mHasMoreConflicts = hasMoreConflicts;
        }

        public List<Conflict> getConflicts() {
            return this.mConflicts;
        }

        public boolean tooManyConflicts() {
            return this.mTooManyConflicts;
        }

        public boolean hasMoreConflicts() {
            return this.mHasMoreConflicts;
        }
    }

    public static class Conflict {
        private CalendarItem.Instance mInstance;
        private FreeBusy mFreeBusy;
        private String mFreeBusyStatus;

        public Conflict(CalendarItem.Instance inst, String fbStatus, FreeBusy fb) {
            this.mInstance = inst;
            this.mFreeBusyStatus = fbStatus;
            this.mFreeBusy = fb;
        }

        public CalendarItem.Instance getInstance() {
            return this.mInstance;
        }

        public FreeBusy getFreeBusy() {
            return this.mFreeBusy;
        }

        public boolean isBusy() {
            return Conflict.isBusy(this.mFreeBusyStatus);
        }

        public static boolean isBusy(String fbStatus) {
            return "B".equals(fbStatus) || "O".equals(fbStatus);
        }
    }
}

