/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACL {
    public static final short RIGHT_READ = 1;
    public static final short RIGHT_WRITE = 2;
    public static final short RIGHT_INSERT = 4;
    public static final short RIGHT_DELETE = 8;
    public static final short RIGHT_ACTION = 16;
    public static final short RIGHT_ADMIN = 256;
    public static final short RIGHT_SUBFOLDER = 512;
    public static final short RIGHT_PRIVATE = 1024;
    public static final short RIGHT_FREEBUSY = 2048;
    private static final short SUBFOLDER_RIGHTS = 5;
    private static final short GRANTABLE_RIGHTS = 3359;
    public static final byte GRANTEE_USER = 1;
    public static final byte GRANTEE_GROUP = 2;
    public static final byte GRANTEE_AUTHUSER = 3;
    public static final byte GRANTEE_DOMAIN = 4;
    public static final byte GRANTEE_COS = 5;
    public static final byte GRANTEE_PUBLIC = 6;
    public static final byte GRANTEE_GUEST = 7;
    public static final byte GRANTEE_KEY = 8;
    public static final String GUID_AUTHUSER = "00000000-0000-0000-0000-000000000000";
    public static final String GUID_PUBLIC = "99999999-9999-9999-9999-999999999999";
    public static final Account ANONYMOUS_ACCT = new GuestAccount("public", null);
    private static final int ACCESSKEY_SIZE_BYTES = 16;
    private List<Grant> mGrants = new ArrayList<Grant>(3);
    public static final char ABBR_READ = 'r';
    public static final char ABBR_WRITE = 'w';
    public static final char ABBR_INSERT = 'i';
    public static final char ABBR_DELETE = 'd';
    public static final char ABBR_ACTION = 'x';
    public static final char ABBR_ADMIN = 'a';
    public static final char ABBR_PRIVATE = 'p';
    public static final char ABBR_FREEBUSY = 'f';
    public static final char ABBR_CREATE_FOLDER = 'c';

    static Map<String, Object> getAnonAttrs() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("uid", "public");
        attrs.put("zimbraId", GUID_PUBLIC);
        return attrs;
    }

    public ACL() {
    }

    public ACL(MetadataList mlist) {
        for (int i = 0; i < mlist.size(); ++i) {
            try {
                this.mGrants.add(new Grant(mlist.getMap(i)));
                continue;
            }
            catch (ServiceException e) {
                ZimbraLog.mailbox.warn((Object)("malformed permission grant: " + mlist), e);
            }
        }
    }

    public Short getGrantedRights(Account authuser) throws ServiceException {
        if (this.mGrants.isEmpty()) {
            return null;
        }
        short rightsGranted = 0;
        for (Grant grant : this.mGrants) {
            rightsGranted = (short)(rightsGranted | grant.getGrantedRights(authuser));
        }
        if ((rightsGranted & 5) == 5) {
            rightsGranted = (short)(rightsGranted | 0x200);
        }
        return new Short(rightsGranted);
    }

    boolean isEmpty() {
        return this.mGrants.isEmpty();
    }

    public Grant grantAccess(String zimbraId, byte type, short rights, String secret) throws ServiceException {
        if (type == 3) {
            zimbraId = GUID_AUTHUSER;
        } else if (type == 6) {
            zimbraId = GUID_PUBLIC;
        } else if (zimbraId == null) {
            throw ServiceException.INVALID_REQUEST("missing grantee id", null);
        }
        if (type == 8 && secret == null) {
            secret = ACL.generateAccessKey();
        }
        if (!this.mGrants.isEmpty()) {
            for (Grant grant : this.mGrants) {
                if (!grant.isGrantee(zimbraId)) continue;
                grant.setRights(rights);
                if (type == 7 || type == 8) {
                    grant.setPassword(secret);
                }
                return grant;
            }
        }
        Grant grant = new Grant(zimbraId, type, rights, secret);
        this.mGrants.add(grant);
        return grant;
    }

    public boolean revokeAccess(String zimbraId) {
        if (this.mGrants == null || this.mGrants.isEmpty()) {
            return false;
        }
        int count = this.mGrants.size();
        Iterator<Grant> it = this.mGrants.iterator();
        while (it.hasNext()) {
            Grant grant = it.next();
            if (!grant.isGrantee(zimbraId)) continue;
            it.remove();
        }
        return this.mGrants.size() != count;
    }

    public MetadataList encode() {
        MetadataList mlist = new MetadataList();
        for (Grant grant : this.mGrants) {
            mlist.add(grant.encode());
        }
        return mlist;
    }

    public String toString() {
        return this.encode().toString();
    }

    public ACL duplicate() {
        return new ACL(this.encode());
    }

    public List<Grant> getGrants() {
        return Collections.unmodifiableList(this.mGrants);
    }

    public static short stringToRights(String encoded) throws ServiceException {
        short rights = 0;
        if (encoded != null && encoded.length() != 0) {
            block11: for (int i = 0; i < encoded.length(); ++i) {
                switch (encoded.charAt(i)) {
                    case 'r': {
                        rights = (short)(rights | 1);
                        continue block11;
                    }
                    case 'w': {
                        rights = (short)(rights | 2);
                        continue block11;
                    }
                    case 'i': {
                        rights = (short)(rights | 4);
                        continue block11;
                    }
                    case 'd': {
                        rights = (short)(rights | 8);
                        continue block11;
                    }
                    case 'x': {
                        rights = (short)(rights | 0x10);
                        continue block11;
                    }
                    case 'a': {
                        rights = (short)(rights | 0x100);
                        continue block11;
                    }
                    case 'p': {
                        rights = (short)(rights | 0x400);
                        continue block11;
                    }
                    case 'f': {
                        rights = (short)(rights | 0x800);
                        continue block11;
                    }
                    case 'c': {
                        continue block11;
                    }
                    default: {
                        throw ServiceException.INVALID_REQUEST("unknown right: " + encoded.charAt(i), null);
                    }
                }
            }
        }
        return rights;
    }

    public static String rightsToString(short rights) {
        if (rights == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if ((rights & 1) != 0) {
            sb.append('r');
        }
        if ((rights & 2) != 0) {
            sb.append('w');
        }
        if ((rights & 4) != 0) {
            sb.append('i');
        }
        if ((rights & 8) != 0) {
            sb.append('d');
        }
        if ((rights & 0x10) != 0) {
            sb.append('x');
        }
        if ((rights & 0x100) != 0) {
            sb.append('a');
        }
        if ((rights & 0x400) != 0) {
            sb.append('p');
        }
        if ((rights & 0x800) != 0) {
            sb.append('f');
        }
        if ((rights & 0x200) != 0) {
            sb.append('c');
        }
        return sb.toString();
    }

    public static byte stringToType(String typeStr) throws ServiceException {
        if (typeStr.equalsIgnoreCase("usr")) {
            return 1;
        }
        if (typeStr.equalsIgnoreCase("grp")) {
            return 2;
        }
        if (typeStr.equalsIgnoreCase("cos")) {
            return 5;
        }
        if (typeStr.equalsIgnoreCase("dom")) {
            return 4;
        }
        if (typeStr.equalsIgnoreCase("all")) {
            return 3;
        }
        if (typeStr.equalsIgnoreCase("pub")) {
            return 6;
        }
        if (typeStr.equalsIgnoreCase("guest")) {
            return 7;
        }
        if (typeStr.equalsIgnoreCase("key")) {
            return 8;
        }
        throw ServiceException.INVALID_REQUEST("unknown grantee type: " + typeStr, null);
    }

    public static String typeToString(byte type) {
        if (type == 1) {
            return "usr";
        }
        if (type == 2) {
            return "grp";
        }
        if (type == 6) {
            return "pub";
        }
        if (type == 3) {
            return "all";
        }
        if (type == 5) {
            return "cos";
        }
        if (type == 4) {
            return "dom";
        }
        if (type == 7) {
            return "guest";
        }
        if (type == 8) {
            return "key";
        }
        return null;
    }

    public static String generateAccessKey() {
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[16];
        random.nextBytes(key);
        return new String(Hex.encodeHex((byte[])key));
    }

    public static class Grant {
        private String mGrantee;
        private String mName;
        private byte mType;
        private short mRights;
        private String mSecret;
        private static final String FN_GRANTEE = "g";
        private static final String FN_NAME = "n";
        private static final String FN_TYPE = "t";
        private static final String FN_RIGHTS = "r";
        private static final String FN_PASSWORD = "a";
        private static final String FN_ACCESSKEY = "k";

        Grant(String zimbraId, byte type, short rights) {
            this.mGrantee = zimbraId;
            this.mType = type;
            this.mRights = (short)(rights & 0xD1F);
        }

        Grant(String zimbraId, byte type, short rights, String secret) {
            this(zimbraId, type, rights);
            if (this.mType == 7 || this.mType == 8) {
                this.mSecret = secret;
            }
        }

        public Grant(Metadata meta) throws ServiceException {
            this.mType = (byte)meta.getLong(FN_TYPE);
            this.mRights = (short)(meta.getLong(FN_RIGHTS) & 0xD1FL);
            this.mName = meta.get(FN_NAME, null);
            if (this.hasGrantee()) {
                this.mGrantee = meta.get(FN_GRANTEE);
            }
            if (this.mType == 7) {
                this.mSecret = meta.get(FN_PASSWORD);
            } else if (this.mType == 8) {
                this.mSecret = meta.get(FN_ACCESSKEY);
            }
        }

        public boolean hasGrantee() {
            return this.mType != 3 && this.mType != 6;
        }

        public String getGranteeId() {
            return this.hasGrantee() ? this.mGrantee : null;
        }

        public byte getGranteeType() {
            return this.mType;
        }

        public short getGrantedRights() {
            return this.mRights;
        }

        public short getGrantedRights(Account acct) throws ServiceException {
            return this.matches(acct) ? this.mRights : (short)0;
        }

        public String getGranteeName() {
            return this.mName;
        }

        public void setGranteeName(String name) {
            this.mName = name;
        }

        public boolean matches(Account acct) throws ServiceException {
            Provisioning prov = Provisioning.getInstance();
            if (acct == null) {
                return this.mType == 6;
            }
            switch (this.mType) {
                case 6: {
                    return true;
                }
                case 3: {
                    return !acct.getId().equals(ACL.GUID_PUBLIC);
                }
                case 5: {
                    return this.mGrantee.equals(Grant.getId(prov.getCOS(acct)));
                }
                case 4: {
                    return this.mGrantee.equals(Grant.getId(prov.getDomain(acct)));
                }
                case 2: {
                    return prov.inDistributionList(acct, this.mGrantee);
                }
                case 1: {
                    return this.mGrantee.equals(acct.getId());
                }
                case 7: {
                    return this.matchesGuestAccount(acct);
                }
                case 8: {
                    return this.matchesAccessKey(acct);
                }
            }
            throw ServiceException.FAILURE("unknown ACL grantee type: " + this.mType, null);
        }

        private boolean matchesGuestAccount(Account acct) {
            if (!(acct instanceof GuestAccount)) {
                return false;
            }
            return ((GuestAccount)acct).matches(this.mGrantee, this.mSecret);
        }

        private boolean matchesAccessKey(Account acct) {
            if (!(acct instanceof GuestAccount)) {
                return false;
            }
            return ((GuestAccount)acct).matchesAccessKey(this.mGrantee, this.mSecret);
        }

        private static final String getId(NamedEntry entry) {
            return entry == null ? null : entry.getId();
        }

        public boolean isGrantee(String zimbraId) {
            if (zimbraId == null || zimbraId.equals(ACL.GUID_PUBLIC)) {
                return this.mType == 6;
            }
            if (zimbraId.equals(ACL.GUID_AUTHUSER)) {
                return this.mType == 3;
            }
            return zimbraId.equals(this.mGrantee);
        }

        void setRights(short rights) {
            this.mRights = rights;
        }

        void setPassword(String password) {
            if ((this.mType == 7 || this.mType == 8) && password != null) {
                this.mSecret = password;
            }
        }

        public String getPassword() {
            return this.mSecret;
        }

        public Metadata encode() {
            Metadata meta = new Metadata();
            meta.put(FN_GRANTEE, this.hasGrantee() ? this.mGrantee : null);
            meta.put(FN_NAME, this.mName);
            meta.put(FN_TYPE, this.mType);
            meta.put(FN_RIGHTS, this.mRights);
            if (this.mType == 8) {
                meta.put(FN_ACCESSKEY, this.mSecret);
            } else {
                meta.put(FN_PASSWORD, this.mSecret);
            }
            return meta;
        }
    }

    public static class GuestAccount
    extends Account {
        private String mDigest;
        private String mAccessKey;

        public GuestAccount(String emailAddress, String password) {
            super(emailAddress, ACL.GUID_PUBLIC, ACL.getAnonAttrs(), null, null);
            this.mDigest = AuthToken.generateDigest(emailAddress, password);
        }

        public GuestAccount(AuthToken auth) {
            super(auth.getExternalUserEmail() == null ? "" : auth.getExternalUserEmail(), ACL.GUID_PUBLIC, ACL.getAnonAttrs(), null, null);
            this.mDigest = auth.getDigest();
            this.mAccessKey = auth.getAccessKey();
        }

        public boolean matches(String emailAddress, String password) {
            if (this.getName().compareTo(emailAddress) != 0) {
                return false;
            }
            String digest = AuthToken.generateDigest(emailAddress, password);
            return this.mDigest.compareTo(digest) == 0;
        }

        public boolean matchesAccessKey(String emailAddress, String accesskey) {
            if (this.mAccessKey == null) {
                return false;
            }
            return this.mAccessKey.compareTo(accesskey) == 0;
        }

        public String getDigest() {
            return this.mDigest;
        }

        public String getAccessKey() {
            return this.mAccessKey;
        }
    }
}

