/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.localconfig;

import com.zimbra.common.localconfig.LC;

public class DebugConfig {
    public static boolean validateOutgoingICalendar;
    public static boolean disableConversation;
    public static boolean disableFilter;
    public static boolean disableMessageAnalysis;
    public static boolean disableMimePartExtraction;
    public static boolean disableIndexing;
    public static boolean disableIndexingAttachmentsSeparately;
    public static boolean disableIndexingAttachmentsTogether;
    public static boolean disableObjects;
    public static boolean calendarAllowNonDisplayAlarms;
    public static boolean calendarAllowOrganizerSpecifiedAlarms;
    public static boolean disableRedoLogFsync;
    public static boolean disableMessageStoreFsync;
    public static boolean calendarForceUTC;
    public static boolean calendarEnableInviteDeniedReplyForUnlistedAttendee;
    public static boolean checkMailboxCacheConsistency;
    public static boolean externalMailboxDirectory;
    public static boolean disableMailboxGroups;
    public static final int numMailboxGroups;
    public static final boolean mockMultiserverInstall;
    public static boolean disableGalSyncVisitor;
    public static boolean disableCalendarTZMatchByID;
    public static boolean disableCalendarTZMatchByRule;
    public static boolean forceMimeConvertersForCalendarBlobs;
    public static boolean disableFoldersTagsCache;

    protected static boolean booleanValue(String key, boolean defaultValue) {
        String val = LC.get(key);
        if (val.length() < 1) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }

    private static int intValue(String key, int defaultValue) {
        String val = LC.get(key);
        if (val.length() < 1) {
            return defaultValue;
        }
        return Integer.valueOf(val);
    }

    static {
        calendarAllowNonDisplayAlarms = DebugConfig.booleanValue("debug_calendar_allow_non_display_alarms", false);
        calendarAllowOrganizerSpecifiedAlarms = DebugConfig.booleanValue("debug_calendar_allow_organizer_specified_alarms", false);
        calendarForceUTC = DebugConfig.booleanValue("debug_calendar_force_utc", false);
        validateOutgoingICalendar = DebugConfig.booleanValue("debug_validate_outgoing_icalendar", false);
        calendarEnableInviteDeniedReplyForUnlistedAttendee = DebugConfig.booleanValue("debug_calendar_enable_invite_denied_reply_for_unlisted_attendee", false);
        disableConversation = DebugConfig.booleanValue("debug_disable_conversation", false);
        disableFilter = DebugConfig.booleanValue("debug_disable_filter", false);
        disableMessageAnalysis = DebugConfig.booleanValue("debug_disable_message_analysis", false);
        if (disableMessageAnalysis) {
            disableMimePartExtraction = true;
            disableIndexing = true;
            disableObjects = true;
        } else {
            disableMimePartExtraction = DebugConfig.booleanValue("debug_disable_mime_part_extraction", false);
            disableIndexing = DebugConfig.booleanValue("debug_disable_indexing", false);
            disableObjects = DebugConfig.booleanValue("debug_disable_objects", false);
        }
        disableIndexingAttachmentsSeparately = DebugConfig.booleanValue("debug_disable_indexing_attachments_separately", false);
        disableIndexingAttachmentsTogether = DebugConfig.booleanValue("debug_disable_indexing_attachments_together", false);
        disableRedoLogFsync = DebugConfig.booleanValue("debug_disable_redolog_fsync", false);
        disableMessageStoreFsync = DebugConfig.booleanValue("debug_disable_message_store_fsync", false);
        checkMailboxCacheConsistency = DebugConfig.booleanValue("debug_check_mailbox_cache_consistency", false);
        disableMailboxGroups = DebugConfig.booleanValue("debug_disable_mailbox_group", false);
        numMailboxGroups = disableMailboxGroups ? Integer.MAX_VALUE : Math.max(LC.zimbra_mailbox_groups.intValue(), 1);
        externalMailboxDirectory = DebugConfig.booleanValue("debug_external_mailbox_directory", false) && disableMailboxGroups;
        mockMultiserverInstall = DebugConfig.booleanValue("debug_mock_multiserver_install", false);
        disableGalSyncVisitor = DebugConfig.booleanValue("debug_disable_gal_sync_visitor", false);
        disableCalendarTZMatchByID = DebugConfig.booleanValue("debug_disable_calendar_tz_match_by_id", false);
        disableCalendarTZMatchByRule = DebugConfig.booleanValue("debug_disable_calendar_tz_match_by_rule", false);
        forceMimeConvertersForCalendarBlobs = DebugConfig.booleanValue("debug_force_mime_converters_for_calendar_blobs", false);
        disableFoldersTagsCache = DebugConfig.booleanValue("debug_disable_folders_tags_cache", false);
    }
}

