/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver.utils;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.lmtpserver.utils.LmtpClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LmtpInject {
    private static Log mLog = LogFactory.getLog(LmtpInject.class);
    private static Options mOptions = new Options();
    private String mSender;
    private String[] mRecipients;
    private List<File> mFiles;
    private String mHost;
    private int mPort;
    private LmtpClient.Protocol mProto;
    private int mCurrentFileIndex = 0;
    private int mSucceeded;
    private int mFailed;
    private int mIgnored;
    private long mStartTime;
    private long mLastProgressTime;
    private int mLastProgressCount;
    private boolean mQuietMode = false;
    private boolean mVerbose = false;
    private volatile long mFileSizeTotal = 0L;
    private int mNumThreads;
    private int mReportEvery = 100;

    private LmtpInject(int numThreads, String sender, String[] recipients, List<File> files, String host, int port, LmtpClient.Protocol proto, boolean quietMode, boolean tracingEnabled, boolean verbose) throws Exception {
        this.mNumThreads = numThreads;
        this.mSender = sender;
        this.mRecipients = recipients;
        this.mFiles = files;
        this.mHost = host;
        this.mPort = port;
        this.mProto = proto;
        this.mIgnored = 0;
        this.mFailed = 0;
        this.mSucceeded = 0;
        this.mLastProgressTime = 0L;
        this.mStartTime = 0L;
        this.mLastProgressCount = 0;
        this.mQuietMode = quietMode;
        this.mVerbose = verbose;
    }

    public synchronized void markStartTime() {
        this.mStartTime = this.mLastProgressTime = System.currentTimeMillis();
    }

    public synchronized void setReportEvery(int num) {
        this.mReportEvery = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incSuccess() {
        int count;
        int lastCount = 0;
        long lastTime = 0L;
        long startTime = 0L;
        long now = 0L;
        boolean report = false;
        LmtpInject lmtpInject = this;
        synchronized (lmtpInject) {
            count = ++this.mSucceeded;
            if (count % this.mReportEvery == 0) {
                report = true;
                startTime = this.mStartTime;
                lastCount = this.mLastProgressCount;
                lastTime = this.mLastProgressTime;
                this.mLastProgressCount = count;
                this.mLastProgressTime = now = System.currentTimeMillis();
            }
        }
        if (report && !this.mQuietMode) {
            long elapsed = now - lastTime;
            long howmany = count - lastCount;
            double rate = 0.0;
            if (elapsed > 0L) {
                rate = (double)howmany * 1000.0 / (double)elapsed;
            }
            long elapsedTotal = now - startTime;
            double rateAvg = 0.0;
            if (elapsedTotal > 0L) {
                rateAvg = (double)count * 1000.0 / (double)elapsedTotal;
            }
            System.out.printf("[progress] %d msgs in %dms @ %.2fmps; last %d msgs in %dms @ %.2fmps\n", count, elapsedTotal, rateAvg, howmany, elapsed, rate);
        }
    }

    public synchronized void incFailure() {
        ++this.mFailed;
    }

    public synchronized void incIgnored() {
        ++this.mIgnored;
    }

    public synchronized int getSuccessCount() {
        return this.mSucceeded;
    }

    public synchronized int getFailureCount() {
        return this.mFailed;
    }

    public String getSender() {
        return this.mSender;
    }

    String getHost() {
        return this.mHost;
    }

    int getPort() {
        return this.mPort;
    }

    LmtpClient.Protocol getProtocol() {
        return this.mProto;
    }

    boolean isVerbose() {
        return this.mVerbose;
    }

    boolean isQuiet() {
        return this.mQuietMode;
    }

    synchronized File getNextFile() {
        if (this.mCurrentFileIndex >= this.mFiles.size()) {
            return null;
        }
        return this.mFiles.get(this.mCurrentFileIndex++);
    }

    public String[] getRecipients() {
        return this.mRecipients;
    }

    public void addToFileSizeTotal(long size) {
        this.mFileSizeTotal += size;
    }

    private void run() throws IOException {
        int i;
        Thread[] threads = new Thread[this.mNumThreads];
        for (i = 0; i < this.mNumThreads; ++i) {
            threads[i] = new Thread(new LmtpInjectTask(this));
            threads[i].start();
        }
        for (i = 0; i < this.mNumThreads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void usage(String errmsg) {
        if (errmsg != null) {
            mLog.error(errmsg);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("zmlmtpinject -r <recip1> [recip2 ...] -s <sender> [options]", "  <file1 [file2 ...] | -d <dir>>", mOptions, "Specified paths contain rfc822 messages.  Files may be gzipped.");
        System.exit(errmsg == null ? 0 : 1);
    }

    private static CommandLine parseArgs(String[] args) {
        StringBuffer gotCL = new StringBuffer("cmdline: ");
        for (int i = 0; i < args.length; ++i) {
            gotCL.append("'").append(args[i]).append("' ");
        }
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(mOptions, args);
        }
        catch (ParseException pe) {
            LmtpInject.usage(pe.getMessage());
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int port;
        CliUtil.toolSetup();
        CommandLine cl = LmtpInject.parseArgs(args);
        if (cl.hasOption("h")) {
            LmtpInject.usage(null);
        }
        boolean quietMode = cl.hasOption("q");
        int threads = 1;
        if (cl.hasOption("t")) {
            threads = Integer.valueOf(cl.getOptionValue("t"));
        }
        String host = null;
        host = cl.hasOption("a") ? cl.getOptionValue("a") : "localhost";
        LmtpClient.Protocol proto = null;
        if (cl.hasOption("smtp")) {
            proto = LmtpClient.Protocol.SMTP;
            port = 25;
        } else {
            port = 7025;
        }
        if (cl.hasOption("p")) {
            port = Integer.valueOf(cl.getOptionValue("p"));
        }
        String[] recipients = cl.getOptionValues("r");
        String sender = cl.getOptionValue("s");
        boolean tracingEnabled = cl.hasOption("T");
        int everyN = cl.hasOption("N") ? Integer.valueOf(cl.getOptionValue("N")) : 100;
        ArrayList<File> files = new ArrayList<File>();
        if (cl.hasOption("d")) {
            File[] fileArray;
            File dir = new File(cl.getOptionValue("d"));
            if (!dir.isDirectory()) {
                System.err.format("%s is not a directory.\n", dir.getPath());
                System.exit(1);
            }
            if ((fileArray = dir.listFiles()) == null || fileArray.length == 0) {
                System.err.format("No files found in directory %s.\n", dir.getPath());
            }
            Collections.addAll(files, fileArray);
        }
        for (String arg : cl.getArgs()) {
            files.add(new File(arg));
        }
        if (!cl.hasOption("noValidation")) {
            Iterator i = files.iterator();
            while (i.hasNext()) {
                boolean valid;
                block28: {
                    Object var18_25;
                    InputStream in = null;
                    File file = (File)i.next();
                    valid = false;
                    try {
                        try {
                            in = new FileInputStream(file);
                            if (FileUtil.isGzipped(file)) {
                                in = new GZIPInputStream(in);
                            }
                            if (!EmailUtil.isRfc822Message(in = new BufferedInputStream(in))) {
                                System.err.format("%s does not contain a valid RFC 822 message.\n", file.getPath());
                            } else {
                                valid = true;
                            }
                        }
                        catch (IOException e) {
                            System.err.format("Unable to validate %s: %s.\n", file.getPath(), e.toString());
                            var18_25 = null;
                            ByteUtil.closeStream(in);
                            break block28;
                        }
                        var18_25 = null;
                    }
                    catch (Throwable throwable) {
                        var18_25 = null;
                        ByteUtil.closeStream(in);
                        throw throwable;
                    }
                    ByteUtil.closeStream(in);
                }
                if (valid) continue;
                i.remove();
            }
        }
        if (files.size() == 0) {
            System.err.println("No files to inject.");
            System.exit(1);
        }
        if (!quietMode) {
            System.out.format("Injecting %d message(s) to %d recipient(s).  Server %s, port %d, using %d thread(s).\n", files.size(), recipients.length, host, port, threads);
        }
        int totalFailed = 0;
        int totalSucceeded = 0;
        long startTime = System.currentTimeMillis();
        boolean verbose = cl.hasOption("v");
        LmtpInject injector = null;
        try {
            injector = new LmtpInject(threads, sender, recipients, files, host, port, proto, quietMode, tracingEnabled, verbose);
        }
        catch (Exception e) {
            mLog.error((Object)"Unable to initialize LmtpInject", e);
            System.exit(1);
        }
        injector.setReportEvery(everyN);
        injector.markStartTime();
        try {
            injector.run();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        int succeeded = injector.getSuccessCount();
        int failedThisTime = injector.getFailureCount();
        long elapsedMS = System.currentTimeMillis() - startTime;
        double elapsed = (double)elapsedMS / 1000.0;
        double msPerMsg = 0.0;
        double msgSizeKB = 0.0;
        if (succeeded > 0) {
            msPerMsg = elapsedMS;
            msPerMsg /= (double)succeeded;
            msgSizeKB = (double)injector.mFileSizeTotal / 1024.0;
            msgSizeKB /= (double)succeeded;
        }
        double msgPerSec = (double)succeeded / (double)elapsedMS * 1000.0;
        if (!quietMode) {
            System.out.println();
            System.out.printf("LmtpInject Finished\nsubmitted=%d failed=%d\n%.2fs, %.2fms/msg, %.2fmsg/s\naverage message size = %.2fKB\n", succeeded, failedThisTime, elapsed, msPerMsg, msgPerSec, msgSizeKB);
        }
        totalSucceeded += succeeded;
        if ((totalFailed += failedThisTime) != 0) {
            System.exit(1);
        }
    }

    static {
        mOptions.addOption("d", "directory", true, "message file directory");
        mOptions.addOption("a", "address", true, "lmtp server (default localhost)");
        mOptions.addOption("p", "port", true, "lmtp server port (default 7025)");
        OptionBuilder.withLongOpt((String)"sender");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"envelope sender (mail from)");
        mOptions.addOption(OptionBuilder.create((String)"s"));
        Option ropt = new Option("r", "recipient", true, "envelope recipients (rcpt to).  This option accepts multiple arguments, so it can't be last if a list of input files is used.");
        ropt.setArgs(-2);
        OptionBuilder.withLongOpt((String)"recipient");
        OptionBuilder.hasArgs((int)-2);
        OptionBuilder.withDescription((String)"envelope recipients (rcpt to).  This option accepts multiple arguments, so it can't be last if a list of input files is used.");
        mOptions.addOption(OptionBuilder.create((String)"r"));
        mOptions.addOption("t", "threads", true, "number of worker threads (default 1)");
        mOptions.addOption("q", "quiet", false, "don't print status");
        mOptions.addOption("T", "trace", false, "trace server/client traffic");
        mOptions.addOption("N", "every", true, "report progress after every N messages (default 100)");
        mOptions.addOption(null, "smtp", false, "use SMTP protocol instead of LMTP");
        mOptions.addOption("h", "help", false, "display usage information");
        mOptions.addOption("v", "verbose", false, "print detailed delivery status");
        mOptions.addOption(null, "noValidation", false, "don't validate file content");
    }

    private static class LmtpInjectTask
    implements Runnable {
        private LmtpInject mDriver;
        private LmtpClient mClient;

        public LmtpInjectTask(LmtpInject driver) throws IOException {
            this.mDriver = driver;
            this.mClient = new LmtpClient(driver.getHost(), driver.getPort(), this.mDriver.getProtocol());
            if (this.mDriver.isVerbose() && !this.mDriver.isQuiet()) {
                this.mClient.quiet(false);
            } else {
                this.mClient.quiet(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            File file = this.mDriver.getNextFile();
            while (true) {
                block11: {
                    Object var7_6;
                    if (file == null) {
                        this.mClient.close();
                        return;
                    }
                    InputStream in = null;
                    try {
                        try {
                            long dataLength;
                            boolean ok = false;
                            if (FileUtil.isGzipped(file)) {
                                dataLength = ByteUtil.getDataLength(new GZIPInputStream(new FileInputStream(file)));
                                in = new GZIPInputStream(new FileInputStream(file));
                            } else {
                                dataLength = file.length();
                                in = new FileInputStream(file);
                            }
                            ok = this.mClient.sendMessage(in, this.mDriver.getRecipients(), this.mDriver.getSender(), file.getName(), (Long)dataLength);
                            if (ok) {
                                this.mDriver.incSuccess();
                                this.mDriver.addToFileSizeTotal(file.length());
                            } else {
                                this.mDriver.incFailure();
                            }
                        }
                        catch (Exception e) {
                            this.mDriver.incFailure();
                            mLog.warn((Object)("Delivery failed for " + file.getPath() + ": "), e);
                            var7_6 = null;
                            ByteUtil.closeStream(in);
                            break block11;
                        }
                        var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        ByteUtil.closeStream(in);
                        throw throwable;
                    }
                    ByteUtil.closeStream(in);
                }
                file = this.mDriver.getNextFile();
            }
        }
    }
}

