/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver.utils;

import com.zimbra.common.localconfig.LC;
import com.zimbra.cs.lmtpserver.LmtpProtocolException;
import com.zimbra.cs.tcpserver.TcpServerInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;

public class LmtpClient {
    private Protocol mProtocol;
    private Socket mConnection;
    private String mGreetname;
    private TcpServerInputStream mIn;
    private BufferedOutputStream mOut;
    private boolean mNewConnection;
    private String mResponse;
    private boolean mWarnOnRejectedRecipients = true;
    private static final byte[] lineSeparator = new byte[]{13, 10};
    private boolean mQuiet;
    private boolean mTrace;

    public LmtpClient(String host, int port, Protocol proto) throws IOException {
        this.mProtocol = proto != null ? proto : Protocol.LMTP;
        this.mGreetname = LC.zimbra_server_hostname.value();
        this.mConnection = new Socket(host, port);
        this.mOut = new BufferedOutputStream(this.mConnection.getOutputStream());
        this.mIn = new TcpServerInputStream(this.mConnection.getInputStream());
        this.mNewConnection = true;
    }

    public LmtpClient(String host, int port) throws IOException {
        this(host, port, Protocol.LMTP);
    }

    public void warnOnRejectedRecipients(boolean yesno) {
        this.mWarnOnRejectedRecipients = yesno;
    }

    public void close() {
        try {
            this.sendLine("QUIT");
            this.mConnection.close();
        }
        catch (IOException ioe) {
            this.warn("IOException closing connection: " + ioe.getMessage());
        }
        this.mConnection = null;
    }

    private void sendLine(String line, boolean flush) throws IOException {
        if (this.mTrace) {
            this.trace("CLI: " + line);
        }
        this.mOut.write(line.getBytes("iso-8859-1"));
        this.mOut.write(lineSeparator);
        if (flush) {
            this.mOut.flush();
        }
    }

    private void sendLine(String line) throws IOException {
        this.sendLine(line, true);
    }

    private boolean replyOk() throws LmtpProtocolException, IOException {
        String response;
        boolean positiveReplyCode = false;
        StringBuffer sb = new StringBuffer();
        while ((response = this.mIn.readLine()) != null) {
            if (this.mTrace) {
                this.trace("SRV: " + response);
            }
            if (response.length() < 3) {
                throw new LmtpProtocolException("response too short: " + response);
            }
            if (response.length() > 3 && response.charAt(3) == '-') {
                sb.append(response);
                continue;
            }
            sb.append(response);
            if (response.charAt(0) < '1' || response.charAt(0) > '3') break;
            positiveReplyCode = true;
            break;
        }
        this.mResponse = sb.toString();
        return positiveReplyCode;
    }

    public boolean sendMessage(byte[] msg, String recipient, String sender, String logLabel) throws IOException, LmtpProtocolException {
        return this.sendMessage((InputStream)new ByteArrayInputStream(msg), new String[]{recipient}, sender, logLabel, Long.valueOf(msg.length));
    }

    public boolean sendMessage(InputStream msgStream, String recipient, String sender, String logLabel) throws IOException, LmtpProtocolException {
        return this.sendMessage(msgStream, new String[]{recipient}, sender, logLabel, null);
    }

    public boolean sendMessage(InputStream msgStream, String recipient, String sender, String logLabel, long size) throws IOException, LmtpProtocolException {
        return this.sendMessage(msgStream, new String[]{recipient}, sender, logLabel, (Long)size);
    }

    public boolean sendMessage(InputStream msgStream, String[] recipients, String sender, String logLabel, Long size) throws IOException, LmtpProtocolException {
        String line;
        long start = System.currentTimeMillis();
        if (this.mNewConnection) {
            this.mNewConnection = false;
            if (!this.replyOk()) {
                throw new LmtpProtocolException(this.mResponse);
            }
            if (Protocol.SMTP.equals((Object)this.mProtocol)) {
                this.sendLine("EHLO " + this.mGreetname);
            } else {
                this.sendLine("LHLO " + this.mGreetname);
            }
            if (!this.replyOk()) {
                throw new LmtpProtocolException(this.mResponse);
            }
        } else {
            this.sendLine("RSET");
            if (!this.replyOk()) {
                throw new LmtpProtocolException(this.mResponse);
            }
        }
        String sizeString = "";
        if (size != null) {
            sizeString = " SIZE=" + size;
        }
        this.sendLine("MAIL FROM:<" + sender + ">" + sizeString);
        if (!this.replyOk()) {
            throw new LmtpProtocolException(this.mResponse);
        }
        ArrayList<String> acceptedRecipients = new ArrayList<String>(recipients.length);
        for (String recipient : recipients) {
            this.sendLine("RCPT TO:<" + recipient + ">");
            if (this.replyOk()) {
                acceptedRecipients.add(recipient);
                continue;
            }
            if (!this.mWarnOnRejectedRecipients) continue;
            this.warn("Recipient `" + recipient + "' rejected");
        }
        this.sendLine("DATA");
        if (!this.replyOk()) {
            throw new LmtpProtocolException(this.mResponse);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(msgStream, "iso-8859-1"));
        while ((line = br.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == '.' && (line.length() <= 1 || line.charAt(1) != '.')) {
                line = "." + line;
            }
            this.sendLine(line, false);
        }
        this.sendLine("", false);
        this.sendLine(".");
        boolean allDelivered = true;
        for (String recipient : acceptedRecipients) {
            if (this.replyOk()) {
                long elapsed = System.currentTimeMillis() - start;
                if (this.mQuiet) continue;
                this.info((Object)((Object)this.mProtocol) + " delivery OK msg=" + logLabel + " rcpt=" + recipient + " elapsed=" + elapsed + "ms");
                continue;
            }
            allDelivered = false;
            this.error("Delivery failed msg=" + logLabel + " rcpt=" + recipient + " response=" + this.mResponse);
        }
        return allDelivered;
    }

    public void quiet(boolean onOff) {
        this.mQuiet = onOff;
    }

    public void trace(boolean onOff) {
        this.mTrace = onOff;
    }

    public String getResponse() {
        return this.mResponse;
    }

    private void warn(String s) {
        System.err.println("[warn] " + s);
        System.err.flush();
    }

    private void error(String s) {
        System.err.println("[error] " + s);
        System.err.flush();
    }

    private void info(String s) {
        System.out.println("[info] " + s);
        System.out.flush();
    }

    private void trace(String s) {
        System.out.println("[trace] " + s);
        System.out.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        LMTP,
        SMTP;

    }
}

