/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver.utils;

import com.zimbra.cs.lmtpserver.LmtpAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public class LmtpAddressTester {
    public static void main(String[] args) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        int i = 0;
        while ((line = in.readLine()) != null) {
            boolean validity;
            ++i;
            if (line.startsWith("#") || line.length() == 0) continue;
            int colon = line.indexOf(58);
            if (colon < 0) {
                System.err.println("missing colon:line " + i + ":" + line);
                continue;
            }
            String result = line.substring(0, colon);
            String input = line.substring(colon + 1);
            if ("+".equals(result)) {
                validity = true;
            } else if ("-".equals(result)) {
                validity = false;
            } else {
                System.err.println("missing result:line " + i + ":" + line);
                continue;
            }
            if (args.length == 0) {
                args = new String[]{"BODY", "SIZE"};
            }
            if (LmtpAddressTester.test(input, args) == validity) continue;
            System.err.println("incorrect result:line " + i + ":" + line);
        }
    }

    private static boolean test(String line, String[] allowedParams) {
        System.out.println("==>" + line + "<==");
        LmtpAddress addr = new LmtpAddress(line, allowedParams, "+");
        System.out.println("  valid=" + addr.isValid());
        if (addr.isValid()) {
            System.out.println("  local-part=/" + addr.getLocalPart() + "/");
            System.out.println("  normalized-local=/" + addr.getNormalizedLocalPart() + "/");
            System.out.println("  domain-part=/" + addr.getDomainPart() + "/");
            Map<String, String> params = addr.getParameters();
            int i = 0;
            for (Map.Entry<String, String> e : params.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                System.out.println("  [" + i + "] key=/" + key + "/ val=/" + val + "/");
                ++i;
            }
        }
        return addr.isValid();
    }
}

