/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.CopyInputStream;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.lmtpserver.LmtpAddress;
import com.zimbra.cs.lmtpserver.LmtpBackend;
import com.zimbra.cs.lmtpserver.LmtpCallback;
import com.zimbra.cs.lmtpserver.LmtpConfig;
import com.zimbra.cs.lmtpserver.LmtpEnvelope;
import com.zimbra.cs.lmtpserver.LmtpReply;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.mailbox.Notification;
import com.zimbra.cs.mailbox.QuotaWarning;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.mime.ParsedMessageOptions;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraLmtpBackend
implements LmtpBackend {
    private static List<LmtpCallback> sCallbacks = new CopyOnWriteArrayList<LmtpCallback>();
    private static LRUMap sReceivedMessageIDs = null;
    private LmtpConfig mConfig;

    public ZimbraLmtpBackend(LmtpConfig lmtpConfig) {
        this.mConfig = lmtpConfig;
    }

    public static void addCallback(LmtpCallback callback) {
        if (callback == null) {
            ZimbraLog.lmtp.error((Object)"", new IllegalStateException("LmtpCallback cannot be null"));
            return;
        }
        ZimbraLog.lmtp.info("Adding LMTP callback: %s", callback.getClass().getName());
        sCallbacks.add(callback);
    }

    @Override
    public LmtpReply getAddressStatus(LmtpAddress address) {
        String addr = address.getEmailAddress();
        try {
            Provisioning prov = Provisioning.getInstance();
            Account acct = prov.get(Provisioning.AccountBy.name, addr);
            if (acct == null) {
                ZimbraLog.lmtp.info("rejecting address " + addr + ": no account");
                return LmtpReply.NO_SUCH_USER;
            }
            String acctStatus = acct.getAccountStatus(prov);
            if (acctStatus == null) {
                ZimbraLog.lmtp.warn("rejecting address " + addr + ": no account status");
                return LmtpReply.NO_SUCH_USER;
            }
            if (acctStatus.equals("maintenance")) {
                ZimbraLog.lmtp.info("try again for address " + addr + ": account status maintenance");
                return LmtpReply.MAILBOX_DISABLED;
            }
            if (acctStatus.equals("pending")) {
                ZimbraLog.lmtp.info("rejecting address " + addr + ": account status pending");
                return LmtpReply.NO_SUCH_USER;
            }
            if (acctStatus.equals("closed")) {
                ZimbraLog.lmtp.info("rejecting address " + addr + ": account status closed");
                return LmtpReply.NO_SUCH_USER;
            }
            if (acctStatus.equals("active") || acctStatus.equals("lockout") || acctStatus.equals("locked")) {
                return LmtpReply.RECIPIENT_OK;
            }
            ZimbraLog.lmtp.info("rejecting address " + addr + ": unknown account status " + acctStatus);
            return LmtpReply.NO_SUCH_USER;
        }
        catch (ServiceException e) {
            if (e.isReceiversFault()) {
                ZimbraLog.lmtp.warn((Object)("try again for address " + addr + ": exception occurred"), e);
                return LmtpReply.MAILBOX_DISABLED;
            }
            ZimbraLog.lmtp.warn((Object)("rejecting address " + addr + ": exception occurred"), e);
            return LmtpReply.NO_SUCH_USER;
        }
    }

    @Override
    public void deliver(LmtpEnvelope env, Blob blob) {
        try {
            this.deliverMessageToLocalMailboxes(blob, null, env);
        }
        catch (ServiceException e) {
            ZimbraLog.lmtp.warn((Object)"Exception delivering mail (temporary failure)", e);
            this.setDeliveryStatuses(env.getRecipients(), LmtpReply.TEMPORARY_FAILURE);
        }
        catch (IOException e) {
            ZimbraLog.lmtp.warn((Object)"Exception delivering mail (temporary failure)", e);
            this.setDeliveryStatuses(env.getRecipients(), LmtpReply.TEMPORARY_FAILURE);
        }
    }

    @Override
    public void deliver(LmtpEnvelope env, InputStream in, int sizeHint) {
        try {
            this.deliverMessageToLocalMailboxes(in, env, sizeHint);
        }
        catch (ServiceException e) {
            ZimbraLog.lmtp.warn((Object)"Exception delivering mail (temporary failure)", e);
            this.setDeliveryStatuses(env.getRecipients(), LmtpReply.TEMPORARY_FAILURE);
        }
        catch (IOException e) {
            ZimbraLog.lmtp.warn((Object)"Exception delivering mail (temporary failure)", e);
            this.setDeliveryStatuses(env.getRecipients(), LmtpReply.TEMPORARY_FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dedupe(ParsedMessage pm, Mailbox mbox) {
        if (sReceivedMessageIDs == null || pm == null || mbox == null) {
            return false;
        }
        String msgid = pm.getMessageID();
        if (msgid == null || msgid.equals("")) {
            return false;
        }
        LRUMap lRUMap = sReceivedMessageIDs;
        synchronized (lRUMap) {
            HashSet<Long> mboxIds = (HashSet<Long>)sReceivedMessageIDs.get((Object)msgid);
            if (mboxIds == null) {
                mboxIds = new HashSet<Long>();
                sReceivedMessageIDs.put((Object)msgid, mboxIds);
            } else if (mboxIds.contains(mbox.getId())) {
                return true;
            }
            mboxIds.add(mbox.getId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDedupeCache(String msgid, Mailbox mbox) {
        if (sReceivedMessageIDs == null || msgid == null || mbox == null) {
            return;
        }
        if (msgid == null || msgid.equals("")) {
            return;
        }
        LRUMap lRUMap = sReceivedMessageIDs;
        synchronized (lRUMap) {
            Set mboxIds = (Set)sReceivedMessageIDs.get((Object)msgid);
            if (mboxIds != null) {
                mboxIds.remove(mbox.getId());
            }
        }
    }

    private void logEnvelope(LmtpEnvelope env, String msgId) {
        if (ZimbraLog.lmtp.isInfoEnabled()) {
            String size = env.getSize() == 0 ? "unspecified" : Integer.toString(env.getSize()) + " bytes";
            ZimbraLog.lmtp.info("Delivering message: size=%s, nrcpts=%d, sender=%s, msgid=%s", size, env.getRecipients().size(), env.getSender(), msgId == null ? "" : msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessageToLocalMailboxes(InputStream in, LmtpEnvelope env, int sizeHint) throws ServiceException, IOException {
        int bufLen = Provisioning.getInstance().getLocalServer().getMailDiskStreamingThreshold();
        CopyInputStream cis = new CopyInputStream(in, sizeHint, bufLen, bufLen);
        Blob blob = StoreManager.getInstance().storeIncoming(cis, sizeHint, null);
        BufferStream bs = cis.getBufferStream();
        try {
            this.deliverMessageToLocalMailboxes(blob, bs.isPartial() ? null : bs.getBuffer(), env);
            Object var9_8 = null;
            cis.release();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            cis.release();
            StoreManager.getInstance().delete(blob);
            throw throwable;
        }
        StoreManager.getInstance().delete(blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessageToLocalMailboxes(Blob blob, byte[] data, LmtpEnvelope env) throws ServiceException, IOException {
        block68: {
            List<LmtpAddress> recipients = env.getRecipients();
            String envSender = env.getSender().getEmailAddress();
            boolean shared = recipients.size() > 1;
            ArrayList<Long> targetMailboxIds = new ArrayList<Long>(recipients.size());
            HashMap<LmtpAddress, RecipientDetail> rcptMap = new HashMap<LmtpAddress, RecipientDetail>(recipients.size());
            try {
                MailboxBlob mblob;
                ParsedMessage pmAttachIndex = null;
                ParsedMessage pmNoAttachIndex = null;
                String msgId = null;
                for (LmtpAddress recipient : recipients) {
                    ParsedMessage pm;
                    String rcptEmail = recipient.getEmailAddress();
                    Account account = null;
                    Mailbox mbox = null;
                    boolean attachmentsIndexingEnabled = true;
                    try {
                        account = Provisioning.getInstance().get(Provisioning.AccountBy.name, rcptEmail);
                        if (account == null) {
                            ZimbraLog.mailbox.warn("No account found delivering mail to " + rcptEmail);
                            continue;
                        }
                        if (account.getBooleanAttr("zimbraPrefMailLocalDeliveryDisabled", false)) {
                            ZimbraLog.lmtp.debug("Local delivery disabled for account %s", rcptEmail);
                            rcptMap.put(recipient, new RecipientDetail(null, null, null, false, DeliveryAction.discard));
                            continue;
                        }
                        mbox = MailboxManager.getInstance().getMailboxByAccount(account);
                        if (mbox == null) {
                            ZimbraLog.mailbox.warn("No mailbox found delivering mail to " + rcptEmail);
                            continue;
                        }
                        attachmentsIndexingEnabled = mbox.attachmentsIndexingEnabled();
                    }
                    catch (ServiceException se) {
                        if (se.isReceiversFault()) {
                            ZimbraLog.mailbox.info((Object)("Recoverable exception getting mailbox for " + rcptEmail), se);
                            rcptMap.put(recipient, new RecipientDetail(null, null, null, false, DeliveryAction.defer));
                            continue;
                        }
                        ZimbraLog.mailbox.warn((Object)("Unrecoverable exception getting mailbox for " + rcptEmail), se);
                        continue;
                    }
                    if (account == null || mbox == null) continue;
                    ParsedMessageOptions pmo = new ParsedMessageOptions(blob, data);
                    if (attachmentsIndexingEnabled) {
                        if (pmAttachIndex == null) {
                            pmo.setAttachmentIndexing(true);
                            ZimbraLog.lmtp.debug("Creating ParsedMessage from " + (data == null ? "file" : "memory") + " with attachment indexing enabled");
                            pmAttachIndex = new ParsedMessage(pmo);
                        }
                        pm = pmAttachIndex;
                    } else {
                        if (pmNoAttachIndex == null) {
                            pmo.setAttachmentIndexing(false);
                            ZimbraLog.lmtp.debug("Creating ParsedMessage from " + (data == null ? "file" : "memory") + " with attachment indexing disabled");
                            pmNoAttachIndex = new ParsedMessage(pmo);
                        }
                        pm = pmNoAttachIndex;
                    }
                    msgId = pm.getMessageID();
                    DeliveryAction da = DeliveryAction.deliver;
                    boolean endSharedDelivery = false;
                    if (shared) {
                        if (mbox.beginSharedDelivery()) {
                            endSharedDelivery = true;
                        } else {
                            da = DeliveryAction.defer;
                        }
                    }
                    rcptMap.put(recipient, new RecipientDetail(account, mbox, pm, endSharedDelivery, da));
                    if (da != DeliveryAction.deliver) continue;
                    targetMailboxIds.add(mbox.getId());
                }
                ZimbraLog.removeAccountFromContext();
                this.logEnvelope(env, msgId);
                DeliveryContext sharedDeliveryCtxt = new DeliveryContext(shared, targetMailboxIds);
                sharedDeliveryCtxt.setIncomingBlob(blob);
                for (LmtpAddress recipient : recipients) {
                    Object var29_44;
                    String rcptEmail = recipient.getEmailAddress();
                    LmtpReply reply = LmtpReply.TEMPORARY_FAILURE;
                    RecipientDetail rd = (RecipientDetail)rcptMap.get(recipient);
                    if (rd.account != null) {
                        ZimbraLog.addAccountNameToContext(rd.account.getName());
                    }
                    if (rd.mbox != null) {
                        ZimbraLog.addMboxToContext(rd.mbox.getId());
                    }
                    boolean success = false;
                    try {
                        block67: {
                            try {
                                if (rd != null) {
                                    switch (rd.action) {
                                        case discard: {
                                            ZimbraLog.lmtp.info("accepted and discarded message for " + rcptEmail + ": local delivery is disabled");
                                            reply = LmtpReply.DELIVERY_OK;
                                            break;
                                        }
                                        case deliver: {
                                            Account account = rd.account;
                                            Mailbox mbox = rd.mbox;
                                            ParsedMessage pm = rd.pm;
                                            List<ItemId> addedMessageIds = null;
                                            if (this.dedupe(pm, mbox)) {
                                                ZimbraLog.lmtp.info("Not delivering message with duplicate Message-ID %s", pm.getMessageID());
                                            } else if (recipient.getSkipFilters()) {
                                                msgId = pm.getMessageID();
                                                int folderId = 2;
                                                if (recipient.getFolder() != null) {
                                                    try {
                                                        Folder folder = mbox.getFolderByPath(null, recipient.getFolder());
                                                        folderId = folder.getId();
                                                    }
                                                    catch (ServiceException se) {
                                                        if (se.getCode().equals("mail.NO_SUCH_FOLDER")) {
                                                            Folder folder = mbox.createFolder(null, recipient.getFolder(), (byte)0, (byte)5);
                                                            folderId = folder.getId();
                                                        }
                                                        throw se;
                                                    }
                                                }
                                                int flags = Flag.BITMASK_UNREAD;
                                                if (recipient.getFlags() != null) {
                                                    flags = Flag.flagsToBitmask(recipient.getFlags());
                                                }
                                                Message msg = mbox.addMessage(null, pm, folderId, false, flags, recipient.getTags(), rcptEmail, sharedDeliveryCtxt);
                                                addedMessageIds = new ArrayList<ItemId>(1);
                                                addedMessageIds.add(new ItemId(msg));
                                            } else if (!DebugConfig.disableFilter) {
                                                pm.getMessageID();
                                                addedMessageIds = RuleManager.applyRulesToIncomingMessage(mbox, pm, rcptEmail, sharedDeliveryCtxt, 2);
                                            } else {
                                                pm.getMessageID();
                                                Message msg = mbox.addMessage(null, pm, 2, false, Flag.BITMASK_UNREAD, null, rcptEmail, sharedDeliveryCtxt);
                                                addedMessageIds = new ArrayList<ItemId>(1);
                                                addedMessageIds.add(new ItemId(msg));
                                            }
                                            success = true;
                                            if (addedMessageIds != null && addedMessageIds.size() > 0) {
                                                for (LmtpCallback callback : sCallbacks) {
                                                    for (ItemId id : addedMessageIds) {
                                                        if (!id.belongsTo(mbox)) continue;
                                                        ZimbraLog.lmtp.debug("Executing callback %s", callback.getClass().getName());
                                                        try {
                                                            Message msg = mbox.getMessageById(null, id.getId());
                                                            callback.afterDelivery(account, mbox, envSender, rcptEmail, msg);
                                                        }
                                                        catch (Throwable t) {
                                                            if (t instanceof OutOfMemoryError) {
                                                                Zimbra.halt("LMTP callback failed", t);
                                                                continue;
                                                            }
                                                            ZimbraLog.lmtp.warn((Object)"LMTP callback threw an exception", t);
                                                        }
                                                    }
                                                }
                                            }
                                            reply = LmtpReply.DELIVERY_OK;
                                            break;
                                        }
                                        case defer: {
                                            ZimbraLog.lmtp.info("try again for message " + rcptEmail + ": mailbox skipped");
                                            reply = LmtpReply.TEMPORARY_FAILURE;
                                        }
                                    }
                                    break block67;
                                }
                                ZimbraLog.lmtp.info("rejecting message " + rcptEmail + ": account or mailbox not found");
                                reply = LmtpReply.PERMANENT_FAILURE;
                            }
                            catch (IOException ioe) {
                                reply = LmtpReply.TEMPORARY_FAILURE;
                                ZimbraLog.lmtp.warn((Object)("try again for " + rcptEmail + ": exception occurred"), ioe);
                                var29_44 = null;
                                if (rd.action == DeliveryAction.deliver && !success) {
                                    this.removeFromDedupeCache(msgId, rd.mbox);
                                }
                                recipient.setDeliveryStatus(reply);
                                if (!shared || rd == null || !rd.esd) continue;
                                rd.mbox.endSharedDelivery();
                                rd.esd = false;
                                continue;
                            }
                            catch (ServiceException se) {
                                if (se.getCode().equals("mail.QUOTA_EXCEEDED")) {
                                    ZimbraLog.lmtp.info("rejecting message " + rcptEmail + ": overquota");
                                    reply = this.mConfig.permanentFailureWhenOverQuota() ? LmtpReply.PERMANENT_FAILURE_OVER_QUOTA : LmtpReply.TEMPORARY_FAILURE_OVER_QUOTA;
                                } else if (se.isReceiversFault()) {
                                    ZimbraLog.lmtp.info((Object)("try again for message " + rcptEmail + ": exception occurred"), se);
                                    reply = LmtpReply.TEMPORARY_FAILURE;
                                } else {
                                    ZimbraLog.lmtp.info((Object)("rejecting message " + rcptEmail + ": exception occurred"), se);
                                    reply = LmtpReply.PERMANENT_FAILURE;
                                }
                                var29_44 = null;
                                if (rd.action == DeliveryAction.deliver && !success) {
                                    this.removeFromDedupeCache(msgId, rd.mbox);
                                }
                                recipient.setDeliveryStatus(reply);
                                if (!shared || rd == null || !rd.esd) continue;
                                rd.mbox.endSharedDelivery();
                                rd.esd = false;
                                continue;
                            }
                            catch (Exception e) {
                                reply = LmtpReply.TEMPORARY_FAILURE;
                                ZimbraLog.lmtp.warn((Object)("try again for message " + rcptEmail + ": exception occurred"), e);
                                var29_44 = null;
                                if (rd.action == DeliveryAction.deliver && !success) {
                                    this.removeFromDedupeCache(msgId, rd.mbox);
                                }
                                recipient.setDeliveryStatus(reply);
                                if (!shared || rd == null || !rd.esd) continue;
                                rd.mbox.endSharedDelivery();
                                rd.esd = false;
                                continue;
                            }
                        }
                        var29_44 = null;
                        if (rd.action == DeliveryAction.deliver && !success) {
                            this.removeFromDedupeCache(msgId, rd.mbox);
                        }
                        recipient.setDeliveryStatus(reply);
                        if (!shared || rd == null || !rd.esd) continue;
                        rd.mbox.endSharedDelivery();
                        rd.esd = false;
                    }
                    catch (Throwable throwable) {
                        var29_44 = null;
                        if (rd.action == DeliveryAction.deliver && !success) {
                            this.removeFromDedupeCache(msgId, rd.mbox);
                        }
                        recipient.setDeliveryStatus(reply);
                        if (shared && rd != null && rd.esd) {
                            rd.mbox.endSharedDelivery();
                            rd.esd = false;
                        }
                        throw throwable;
                    }
                }
                ParsedMessage mimeSource = pmAttachIndex;
                if (mimeSource == null) {
                    mimeSource = pmNoAttachIndex;
                }
                if ((mblob = sharedDeliveryCtxt.getMailboxBlob()) != null && mimeSource != null && mimeSource.isStreamedFromDisk()) {
                    try {
                        BlobInputStream bis = mimeSource.getBlobInputStream();
                        Blob storedBlob = mblob.getLocalBlob();
                        bis.fileMoved(storedBlob.getFile());
                        MessageCache.cacheMessage(mblob.getDigest(), mimeSource.getOriginalMessage(), mimeSource.getMimeMessage());
                    }
                    catch (IOException e) {
                        ZimbraLog.lmtp.warn((Object)("Unable to cache message for " + mblob), e);
                    }
                }
                Object var31_46 = null;
                if (!shared) break block68;
            }
            catch (Throwable throwable) {
                Object var31_47 = null;
                if (shared) {
                    for (RecipientDetail rd : rcptMap.values()) {
                        if (!rd.esd || rd.mbox == null) continue;
                        rd.mbox.endSharedDelivery();
                    }
                }
                if (blob != null) {
                    StoreManager.getInstance().delete(blob);
                }
                throw throwable;
            }
            for (RecipientDetail rd : rcptMap.values()) {
                if (!rd.esd || rd.mbox == null) continue;
                rd.mbox.endSharedDelivery();
            }
        }
        if (blob != null) {
            StoreManager.getInstance().delete(blob);
        }
    }

    private void setDeliveryStatuses(List<LmtpAddress> recipients, LmtpReply reply) {
        for (LmtpAddress recipient : recipients) {
            recipient.setDeliveryStatus(reply);
        }
    }

    static {
        try {
            int cacheSize = Provisioning.getInstance().getConfig().getIntAttr("zimbraMessageIdDedupeCacheSize", 0);
            if (cacheSize > 0) {
                sReceivedMessageIDs = new LRUMap(cacheSize);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.lmtp.error((Object)"could not read zimbraMessageIdDedupeCacheSize; no deduping will be performed", e);
        }
        ZimbraLmtpBackend.addCallback(Notification.getInstance());
        ZimbraLmtpBackend.addCallback(QuotaWarning.getInstance());
    }

    private static class RecipientDetail {
        public Account account;
        public Mailbox mbox;
        public ParsedMessage pm;
        public boolean esd;
        public DeliveryAction action;

        public RecipientDetail(Account a, Mailbox m, ParsedMessage p, boolean endSharedDelivery, DeliveryAction da) {
            this.account = a;
            this.mbox = m;
            this.pm = p;
            this.esd = endSharedDelivery;
            this.action = da;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeliveryAction {
        discard,
        defer,
        deliver;

    }
}

