/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.lmtpserver.LmtpHandler;
import com.zimbra.cs.lmtpserver.LmtpMessageInputStream;
import com.zimbra.cs.lmtpserver.LmtpServer;
import com.zimbra.cs.lmtpserver.LmtpWriter;
import com.zimbra.cs.tcpserver.TcpServerInputStream;
import java.io.IOException;
import java.net.Socket;

public class TcpLmtpHandler
extends LmtpHandler {
    private TcpServerInputStream mInputStream;

    TcpLmtpHandler(LmtpServer server) {
        super(server);
    }

    protected boolean setupConnection(Socket connection) throws IOException {
        this.reset();
        connection.setSoTimeout(this.mConfig.getMaxIdleSeconds() * 1000);
        this.mInputStream = new TcpServerInputStream(connection.getInputStream());
        this.mWriter = new LmtpWriter(connection.getOutputStream());
        return this.setupConnection(connection.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void dropConnection() {
        ZimbraLog.addIpToContext(this.mRemoteAddress);
        try {
            block7: {
                try {
                    if (this.mInputStream != null) {
                        this.mInputStream.close();
                        this.mInputStream = null;
                    }
                    if (this.mWriter == null) break block7;
                    this.mWriter.close();
                    this.mWriter = null;
                }
                catch (IOException e) {
                    if (ZimbraLog.lmtp.isDebugEnabled()) {
                        ZimbraLog.lmtp.info((Object)"I/O error while closing connection", e);
                    } else {
                        ZimbraLog.lmtp.info("I/O error while closing connection: " + e);
                    }
                    Object var3_2 = null;
                    ZimbraLog.clearContext();
                    return;
                }
            }
            Object var3_1 = null;
            ZimbraLog.clearContext();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLog.clearContext();
            throw throwable;
        }
    }

    protected boolean processCommand() throws IOException {
        return this.processCommand(this.mInputStream.readLine());
    }

    protected void continueDATA() throws IOException {
        LmtpMessageInputStream min = new LmtpMessageInputStream(this.mInputStream, this.getAdditionalHeaders());
        this.processMessageData(min);
    }
}

