/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.lmtpserver.LmtpConfig;
import com.zimbra.cs.lmtpserver.MinaLmtpDecoder;
import com.zimbra.cs.lmtpserver.MinaLmtpHandler;
import com.zimbra.cs.mina.MinaCodecFactory;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaServer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;

public class MinaLmtpServer
extends MinaServer {
    public static boolean isEnabled() {
        return Boolean.getBoolean("ZimbraNioLmtpEnabled") || LC.nio_lmtp_enabled.booleanValue();
    }

    public MinaLmtpServer(LmtpConfig config, ExecutorService pool) throws IOException, ServiceException {
        super(config, pool);
    }

    public MinaHandler createHandler(IoSession session) {
        return new MinaLmtpHandler(this, session);
    }

    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaCodecFactory(this){

            public ProtocolDecoder getDecoder() {
                return new MinaLmtpDecoder(MinaLmtpServer.this.getStats());
            }
        };
    }

    public Log getLog() {
        return ZimbraLog.lmtp;
    }
}

