/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.lmtpserver.LmtpEnvelope;
import com.zimbra.cs.lmtpserver.LmtpHandler;
import com.zimbra.cs.lmtpserver.LmtpWriter;
import com.zimbra.cs.lmtpserver.MinaLmtpServer;
import com.zimbra.cs.mina.LineBuffer;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaIoSessionOutputStream;
import com.zimbra.cs.mina.MinaOutputStream;
import com.zimbra.cs.store.BlobBuilder;
import com.zimbra.cs.store.StoreManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

public class MinaLmtpHandler
extends LmtpHandler
implements MinaHandler {
    private final IoSession mSession;
    private BlobBuilder data;
    private MinaOutputStream mOutputStream;
    private static final long WRITE_TIMEOUT = 5000L;

    public MinaLmtpHandler(MinaLmtpServer server, IoSession session) {
        super(server);
        this.mSession = session;
        this.mEnvelope = new LmtpEnvelope();
        this.mOutputStream = new MinaIoSessionOutputStream(this.mSession);
        this.mWriter = new LmtpWriter(this.mOutputStream);
        this.mSession.setIdleTime(IdleStatus.BOTH_IDLE, this.mConfig.getMaxIdleSeconds());
    }

    public void messageReceived(Object msg) throws IOException {
        if (this.data != null) {
            this.receiveData((LineBuffer)msg);
            if (this.data.isFinished()) {
                this.processMessageData(this.data.getBlob());
                this.data.dispose();
                this.data = null;
            }
        } else {
            this.processCommand((String)msg);
        }
    }

    private void receiveData(LineBuffer lb) throws IOException {
        if (lb.matches(".\r\n")) {
            try {
                this.data.finish();
            }
            catch (ServiceException e) {
                throw (IOException)new IOException("Unable to write blob").initCause(e);
            }
        } else {
            ByteBuffer bb = lb.buf();
            if (lb.startsWith("..")) {
                bb.position(bb.position() + 1);
            }
            this.data.append(bb);
        }
    }

    public void connectionOpened() {
        this.setupConnection(((InetSocketAddress)this.mSession.getRemoteAddress()).getAddress());
    }

    public void connectionClosed() {
        this.cleanup();
    }

    public void connectionIdle() {
        this.notifyIdleConnection();
        this.dropConnection();
    }

    protected void continueDATA() throws IOException {
        try {
            this.data = StoreManager.getInstance().getBlobBuilder();
        }
        catch (ServiceException e) {
            throw (IOException)new IOException("Unable to create blob builder").initCause(e);
        }
        this.data.append(this.getAdditionalHeaders().getBytes());
    }

    protected void dropConnection() {
        this.dropConnection(5000L);
    }

    public void dropConnection(long timeout) {
        if (!this.mSession.isConnected()) {
            return;
        }
        try {
            this.mOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (timeout >= 0L && !this.mOutputStream.join(timeout)) {
            ZimbraLog.lmtp.warn("Force closing session because write timed out: " + this.mSession);
        }
        this.cleanup();
    }

    private void cleanup() {
        this.mSession.close();
        if (this.data != null) {
            this.data.dispose();
            this.data = null;
        }
    }

    protected boolean setupConnection(Socket connection) {
        throw new UnsupportedOperationException();
    }

    protected boolean processCommand() {
        throw new UnsupportedOperationException();
    }
}

