/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.cs.mina.LineBuffer;
import com.zimbra.cs.mina.MinaStats;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class MinaLmtpDecoder
extends ProtocolDecoderAdapter {
    private final MinaStats stats;
    private final LineBuffer cmd = new LineBuffer(132);
    private LineBuffer data;

    MinaLmtpDecoder(MinaStats stats) {
        this.stats = stats;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) {
        java.nio.ByteBuffer bb = in.buf();
        while (bb.hasRemaining()) {
            if (this.data != null) {
                if (!this.data.parse(bb)) continue;
                if (this.stats != null) {
                    this.stats.receivedBytes.addAndGet(this.data.size());
                }
                out.write((Object)this.data);
                if (this.data.matches(".\r\n")) {
                    this.data = null;
                    continue;
                }
                this.data = new LineBuffer(this.data.size());
                continue;
            }
            if (!this.cmd.parse(bb)) continue;
            String line = this.cmd.toString().trim();
            out.write((Object)line);
            if (this.stats != null) {
                this.stats.receivedBytes.addAndGet(this.cmd.size());
            }
            this.cmd.reset();
            if (!"DATA".equalsIgnoreCase(MinaLmtpDecoder.getCommand(line))) continue;
            this.data = new LineBuffer();
        }
    }

    private static String getCommand(String line) {
        int i = line.indexOf(32);
        return i > 0 ? line.substring(0, i) : line;
    }
}

