/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.NetUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.lmtpserver.LmtpConfig;
import com.zimbra.cs.lmtpserver.MinaLmtpServer;
import com.zimbra.cs.lmtpserver.TcpLmtpHandler;
import com.zimbra.cs.mina.MinaThreadFactory;
import com.zimbra.cs.server.Server;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.tcpserver.TcpServer;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LmtpServer
extends TcpServer {
    private static Server lmtpServer;
    private static final String HANDLER_THREAD_NAME = "LmtpHandler";

    public LmtpServer(LmtpConfig config) throws ServiceException {
        super("LmtpServer", config);
    }

    protected ProtocolHandler newProtocolHandler() {
        return new TcpLmtpHandler(this);
    }

    public static void bindServerSocket(String addr, int port) throws IOException {
        NetUtil.bindServerSocket(addr, port, false, MinaLmtpServer.isEnabled(), null);
    }

    public static void startupLmtpServer() throws ServiceException {
        if (lmtpServer != null) {
            return;
        }
        LmtpConfig config = new LmtpConfig(Provisioning.getInstance());
        ExecutorService pool = Executors.newFixedThreadPool(config.getNumThreads(), new MinaThreadFactory(HANDLER_THREAD_NAME));
        if (MinaLmtpServer.isEnabled()) {
            try {
                lmtpServer = new MinaLmtpServer(config, pool);
            }
            catch (IOException e) {
                Zimbra.halt("failed to create MinaLmtpServer", e);
            }
        } else {
            lmtpServer = new LmtpServer(config);
        }
        try {
            lmtpServer.start();
        }
        catch (IOException e) {
            Zimbra.halt("failed to start LmtpServer", e);
        }
    }

    public static void shutdownLmtpServer() {
        if (lmtpServer != null) {
            lmtpServer.shutdown(10);
            lmtpServer = null;
        }
    }

    public static LmtpServer getInstance() {
        return (LmtpServer)lmtpServer;
    }

    public LmtpConfig getLmtpConfig() {
        return (LmtpConfig)this.getConfig();
    }
}

