/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.cs.lmtpserver.LmtpConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LmtpReply {
    OK(250, "2.0.0", "OK"),
    SENDER_OK(250, "2.0.0", "Sender OK"),
    RECIPIENT_OK(250, "2.1.5", "Recipient OK"),
    DELIVERY_OK(250, "2.1.5", "Delivery OK"),
    OK_TO_SEND_DATA(354, null, "End data with <CR><LF>.<CR><LF>"),
    USE_RCPT_INSTEAD(252, "2.3.3", "Use RCPT to deliver messages"),
    BYE(221, null, new DetailCB(){

        protected String detail() {
            return LmtpConfig.getServerName() + " closing connection";
        }
    }),
    GREETING(220, null, new DetailCB(){

        protected String detail() {
            return LmtpConfig.getServerName() + " Zimbra" + LmtpConfig.getServerVersion() + " LMTP ready";
        }
    }),
    SERVICE_DISABLED(421, "4.3.2", "Service not available, closing transmission channel"),
    MAILBOX_DISABLED(450, "4.2.1", "Mailbox disabled, not accepting messages"),
    TEMPORARY_FAILURE(451, "4.0.0", "Temporary message delivery failure try again"),
    TEMPORARY_FAILURE_OVER_QUOTA(452, "4.2.2", "Over quota"),
    TIMEOUT(421, null, new DetailCB(){

        protected String detail() {
            return LmtpConfig.getServerName() + " Timeout exceeded";
        }
    }),
    NESTED_MAIL_COMMAND(503, "5.5.1", "Nested MAIL command"),
    NO_RECIPIENTS(503, "5.5.1", "No recipients"),
    MISSING_MAIL_TO(503, "5.5.1", "Need MAIL command"),
    SYNTAX_ERROR(500, "5.5.2", "Syntax error"),
    INVALID_RECIPIENT_ADDRESS(500, "5.5.2", "Syntax error in recipient address"),
    INVALID_SENDER_ADDRESS(501, "5.5.4", "Syntax error in sender address"),
    INVALID_BODY_PARAMETER(501, "5.5.4", "Syntax error in BODY parameter"),
    INVALID_SIZE_PARAMETER(501, "5.5.4", "Syntax error in SIZE parameter"),
    NO_SUCH_USER(550, "5.1.1", "No such user here"),
    PERMANENT_FAILURE_OVER_QUOTA(552, "5.2.2", "Over quota"),
    PERMANENT_FAILURE(554, "5.0.0", "Permanent message delivery failure");

    private int mCode;
    private String mEnhancedCode;
    private String mDetail;
    private DetailCB mDetailCallback;

    private LmtpReply(int code, String enhancedCode, String detail) {
        this.mCode = code;
        this.mEnhancedCode = enhancedCode;
        this.mDetail = detail;
    }

    private LmtpReply(int code, String enhancedCode, DetailCB detail) {
        this.mCode = code;
        this.mEnhancedCode = enhancedCode;
        this.mDetailCallback = detail;
    }

    public String toString() {
        String detail = this.mDetailCallback != null ? this.mDetailCallback.detail() : this.mDetail;
        if (this.mEnhancedCode == null) {
            return this.mCode + " " + detail;
        }
        return this.mCode + " " + this.mEnhancedCode + " " + detail;
    }

    public boolean success() {
        return this.mCode > 199 && this.mCode < 400;
    }

    private static abstract class DetailCB {
        private DetailCB() {
        }

        protected abstract String detail();
    }
}

