/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.LinkedList;

public class LmtpMessageInputStream
extends InputStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private PushbackInputStream mIn;
    private int mMessageSize = 0;
    private boolean mDone = false;
    private LinkedList<Integer> mPrefix;
    private boolean mGotCR = true;
    private boolean mGotLF = true;

    public LmtpMessageInputStream(InputStream in, String prefix) {
        this.mIn = new PushbackInputStream(in);
        if (prefix != null) {
            byte[] bytes;
            this.mPrefix = new LinkedList();
            for (byte b : bytes = prefix.getBytes()) {
                this.mPrefix.add(Integer.valueOf(b));
            }
            this.mMessageSize = bytes.length;
        }
    }

    public int getMessageSize() {
        return this.mMessageSize;
    }

    public int available() throws IOException {
        if (this.mDone) {
            return 0;
        }
        return this.mIn.available();
    }

    public int read() throws IOException {
        int c;
        if (this.mDone) {
            return -1;
        }
        if (this.mPrefix != null) {
            if (this.mPrefix.size() > 0) {
                return this.mPrefix.remove();
            }
            this.mPrefix = null;
        }
        if ((c = this.mIn.read()) == -1) {
            this.mDone = true;
            throw new IOException("End of stream encountered when looking for <CR><LF>.<CR><LF>");
        }
        if (c == 13) {
            this.mGotCR = true;
            this.mGotLF = false;
            ++this.mMessageSize;
            return c;
        }
        if (c == 10) {
            if (this.mGotCR) {
                this.mGotLF = true;
            }
            ++this.mMessageSize;
            return c;
        }
        if (!this.mGotCR || !this.mGotLF) {
            this.mGotCR = false;
            this.mGotLF = false;
            ++this.mMessageSize;
            return c;
        }
        if (c != 46) {
            this.mGotCR = false;
            this.mGotLF = false;
            ++this.mMessageSize;
            return c;
        }
        c = this.mIn.read();
        if (c == -1) {
            this.mDone = true;
            throw new IOException("End of stream encountered after '.' when looking for '<CR><LF>'");
        }
        if (c != 13) {
            this.mGotCR = false;
            this.mGotLF = false;
            ++this.mMessageSize;
            return c;
        }
        c = this.mIn.read();
        if (c == -1) {
            this.mDone = true;
            throw new IOException("End of stream encountered after '<CR><LF>.<CR>' when looking for '<LF>'");
        }
        if (c != 10) {
            this.mIn.unread(c);
            this.mGotCR = true;
            this.mGotLF = false;
            ++this.mMessageSize;
            return 13;
        }
        this.mDone = true;
        return -1;
    }
}

