/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.lmtpserver.LmtpAddress;
import com.zimbra.cs.lmtpserver.LmtpBodyType;
import com.zimbra.cs.lmtpserver.LmtpConfig;
import com.zimbra.cs.lmtpserver.LmtpEnvelope;
import com.zimbra.cs.lmtpserver.LmtpMessageInputStream;
import com.zimbra.cs.lmtpserver.LmtpReply;
import com.zimbra.cs.lmtpserver.LmtpServer;
import com.zimbra.cs.lmtpserver.LmtpWriter;
import com.zimbra.cs.lmtpserver.MinaLmtpServer;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.util.Config;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeUtility;

public abstract class LmtpHandler
extends ProtocolHandler {
    protected LmtpConfig mConfig;
    protected LmtpWriter mWriter;
    protected String mRemoteAddress;
    protected String mRemoteHostname;
    private String mLhloArg;
    protected LmtpEnvelope mEnvelope;
    private String mCurrentCommandLine;

    LmtpHandler(MinaLmtpServer server) {
        super(null);
        this.mConfig = (LmtpConfig)server.getConfig();
    }

    LmtpHandler(LmtpServer server) {
        super(server);
        this.mConfig = (LmtpConfig)server.getConfig();
    }

    protected boolean setupConnection(InetAddress remoteAddr) {
        this.mRemoteAddress = remoteAddr.getHostAddress();
        this.mRemoteHostname = remoteAddr.getHostName();
        if (this.mRemoteHostname == null || this.mRemoteHostname.length() == 0) {
            this.mRemoteHostname = this.mRemoteAddress;
        }
        ZimbraLog.addIpToContext(this.mRemoteAddress);
        ZimbraLog.lmtp.debug("connected");
        if (!Config.userServicesEnabled()) {
            this.sendReply(LmtpReply.SERVICE_DISABLED);
            this.dropConnection();
            return false;
        }
        this.sendReply(LmtpReply.GREETING);
        return true;
    }

    protected void notifyIdleConnection() {
        this.sendReply(LmtpReply.TIMEOUT);
    }

    protected boolean authenticate() {
        return true;
    }

    protected boolean processCommand(String cmd) throws IOException {
        this.mCurrentCommandLine = cmd;
        String arg = null;
        if (cmd == null) {
            ZimbraLog.lmtp.info("disconnected without quit");
            this.dropConnection();
            return false;
        }
        if (!Config.userServicesEnabled()) {
            this.sendReply(LmtpReply.SERVICE_DISABLED);
            this.dropConnection();
            return false;
        }
        this.setIdle(false);
        int i = cmd.indexOf(32);
        if (i > 0) {
            arg = cmd.substring(i + 1);
            cmd = cmd.substring(0, i);
        }
        ZimbraLog.lmtp.debug("command=%s arg=%s", cmd, arg);
        if (cmd.length() < 4) {
            this.doSyntaxError("command too short");
            return true;
        }
        char ch = cmd.charAt(0);
        switch (ch) {
            case 'L': 
            case 'l': {
                if (!"LHLO".equalsIgnoreCase(cmd)) break;
                this.doLHLO(arg);
                return true;
            }
            case 'M': 
            case 'm': {
                String fromColon;
                if (!"MAIL".equalsIgnoreCase(cmd)) break;
                int fromColonLength = 5;
                if (arg.length() < 5 || !"FROM:".equalsIgnoreCase(fromColon = arg.substring(0, 5))) break;
                arg = arg.substring(5);
                this.doMAIL(arg);
                return true;
            }
            case 'R': 
            case 'r': {
                String toColon;
                if ("RSET".equalsIgnoreCase(cmd)) {
                    this.doRSET(arg);
                    return true;
                }
                if (!"RCPT".equalsIgnoreCase(cmd)) break;
                int toColonLength = 3;
                if (arg.length() < 3 || !"TO:".equalsIgnoreCase(toColon = arg.substring(0, 3))) break;
                arg = arg.substring(3);
                this.doRCPT(arg);
                return true;
            }
            case 'D': 
            case 'd': {
                if (!"DATA".equalsIgnoreCase(cmd)) break;
                this.doDATA(arg);
                return true;
            }
            case 'N': 
            case 'n': {
                if (!"NOOP".equalsIgnoreCase(cmd)) break;
                this.doNOOP();
                return true;
            }
            case 'Q': 
            case 'q': {
                if (!"QUIT".equalsIgnoreCase(cmd)) break;
                this.doQUIT();
                return false;
            }
            case 'V': 
            case 'v': {
                if (!"VRFY".equalsIgnoreCase(cmd)) break;
                this.doVRFY(arg);
                return true;
            }
        }
        this.doSyntaxError("unknown command");
        return true;
    }

    private void sendReply(LmtpReply reply) {
        String cl;
        String string = cl = this.mCurrentCommandLine != null ? this.mCurrentCommandLine : "<none>";
        if (ZimbraLog.lmtp.isDebugEnabled()) {
            ZimbraLog.lmtp.debug("%s (%s)", reply.toString(), cl);
        } else if (!reply.success()) {
            ZimbraLog.lmtp.info("%s (%s)", reply.toString(), cl);
        }
        this.mWriter.println(reply.toString());
        this.mWriter.flush();
    }

    private void doSyntaxError(String why) {
        this.sendReply(LmtpReply.SYNTAX_ERROR);
    }

    private void doNOOP() {
        this.sendReply(LmtpReply.OK);
    }

    private void doQUIT() {
        this.sendReply(LmtpReply.BYE);
        ZimbraLog.lmtp.debug("quit from client");
        this.dropConnection();
    }

    private void doRSET(String arg) {
        if (arg != null) {
            this.doSyntaxError("parameter supplied to rset");
            return;
        }
        this.reset();
        this.sendReply(LmtpReply.OK);
    }

    private void doVRFY(String arg) {
        if (arg == null || arg.length() == 0) {
            this.doSyntaxError("no parameter to vrfy");
            return;
        }
        this.sendReply(LmtpReply.USE_RCPT_INSTEAD);
    }

    private void doLHLO(String arg) {
        this.mLhloArg = arg;
        if (arg == null || arg.length() == 0) {
            this.doSyntaxError("no parameter to lhlo");
            return;
        }
        this.mWriter.println("250-" + this.mConfig.getName());
        this.mWriter.println("250-8BITMIME");
        this.mWriter.println("250-ENHANCEDSTATUSCODES");
        this.mWriter.println("250-SIZE ");
        this.mWriter.println("250 PIPELINING");
        this.mWriter.flush();
        this.reset();
    }

    private void doMAIL(String arg) {
        if (arg == null || arg.length() == 0) {
            this.doSyntaxError("no parameter to mail from");
            return;
        }
        if (this.mEnvelope.hasSender()) {
            this.sendReply(LmtpReply.NESTED_MAIL_COMMAND);
            return;
        }
        LmtpAddress addr = new LmtpAddress(arg, new String[]{"BODY", "SIZE"}, null);
        if (!addr.isValid()) {
            this.sendReply(LmtpReply.INVALID_SENDER_ADDRESS);
            return;
        }
        LmtpBodyType type = null;
        String body = addr.getParameter("BODY");
        if (body != null && (type = LmtpBodyType.getInstance(body)) == null) {
            this.sendReply(LmtpReply.INVALID_BODY_PARAMETER);
            return;
        }
        int size = 0;
        String sz = addr.getParameter("SIZE");
        if (sz != null) {
            try {
                size = Integer.parseInt(sz);
            }
            catch (NumberFormatException nfe) {
                this.sendReply(LmtpReply.INVALID_SIZE_PARAMETER);
                return;
            }
        }
        this.mEnvelope.setSender(addr);
        this.mEnvelope.setBodyType(type);
        this.mEnvelope.setSize(size);
        this.sendReply(LmtpReply.SENDER_OK);
    }

    private void doRCPT(String arg) {
        if (arg == null || arg.length() == 0) {
            this.doSyntaxError("no parameter to rcpt to");
            return;
        }
        if (!this.mEnvelope.hasSender()) {
            this.sendReply(LmtpReply.MISSING_MAIL_TO);
            return;
        }
        LmtpAddress addr = new LmtpAddress(arg, null, this.mConfig.getRecipientDelimiter());
        if (!addr.isValid()) {
            this.sendReply(LmtpReply.INVALID_RECIPIENT_ADDRESS);
            return;
        }
        LmtpReply reply = this.mConfig.getLmtpBackend().getAddressStatus(addr);
        if (reply.success()) {
            this.mEnvelope.addRecipient(addr);
        }
        this.sendReply(reply);
    }

    protected void reset() {
        this.mEnvelope = new LmtpEnvelope();
        this.mCurrentCommandLine = null;
    }

    private void doDATA(String arg) throws IOException {
        if (!this.mEnvelope.hasRecipients()) {
            this.sendReply(LmtpReply.NO_RECIPIENTS);
            return;
        }
        this.sendReply(LmtpReply.OK_TO_SEND_DATA);
        this.continueDATA();
    }

    protected abstract void continueDATA() throws IOException;

    protected void processMessageData(Blob blob) throws IOException {
        this.mConfig.getLmtpBackend().deliver(this.mEnvelope, blob);
        this.finishMessageData(blob.getRawSize());
    }

    protected void processMessageData(LmtpMessageInputStream in) throws IOException {
        this.mConfig.getLmtpBackend().deliver(this.mEnvelope, in, this.mEnvelope.getSize());
        this.finishMessageData(in.getMessageSize());
    }

    private void finishMessageData(long size) throws IOException {
        int numRecipients = this.mEnvelope.getRecipients().size();
        ZimbraPerf.COUNTER_LMTP_RCVD_MSGS.increment();
        ZimbraPerf.COUNTER_LMTP_RCVD_BYTES.increment(size);
        ZimbraPerf.COUNTER_LMTP_RCVD_RCPT.increment(numRecipients);
        int numDelivered = 0;
        for (LmtpAddress recipient : this.mEnvelope.getRecipients()) {
            LmtpReply reply = recipient.getDeliveryStatus();
            this.sendReply(reply);
            if (!reply.success()) continue;
            ++numDelivered;
        }
        ZimbraPerf.COUNTER_LMTP_DLVD_MSGS.increment(numDelivered);
        ZimbraPerf.COUNTER_LMTP_DLVD_BYTES.increment((long)numDelivered * size);
        this.reset();
    }

    protected String getAdditionalHeaders() {
        String sender;
        StringBuilder headers = new StringBuilder();
        if (this.mEnvelope.hasSender() && !StringUtil.isNullOrEmpty(sender = this.mEnvelope.getSender().getEmailAddress())) {
            headers.append(String.format("Return-Path: %s\r\n", sender));
        }
        String localHostname = "unknown";
        try {
            localHostname = Provisioning.getInstance().getLocalServer().getName();
        }
        catch (ServiceException e) {
            ZimbraLog.lmtp.warn((Object)"Unable to determine local hostname", e);
        }
        String timestamp = new MailDateFormat().format(new Date());
        String name = "Received: ";
        String value = String.format("from %s (LHLO %s) (%s) by %s with LMTP; %s", this.mRemoteHostname, this.mLhloArg, this.mRemoteAddress, localHostname, timestamp);
        headers.append(name);
        headers.append(MimeUtility.fold((int)name.length(), (String)value));
        headers.append("\r\n");
        return headers.toString();
    }
}

