/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.lmtpserver.LmtpBackend;
import com.zimbra.cs.lmtpserver.ZimbraLmtpBackend;
import com.zimbra.cs.server.ServerConfig;
import com.zimbra.cs.util.BuildInfo;

public class LmtpConfig
extends ServerConfig {
    private String mRecipientDelimiter;
    private LmtpBackend mBackend;
    private static final int DEFAULT_MAX_IDLE_SECONDS = 300;

    public LmtpConfig() {
    }

    public LmtpConfig(Provisioning provisioning) throws ServiceException {
        this.setName(LmtpConfig.getServerName());
        Server server = provisioning.getLocalServer();
        this.setMaxIdleSeconds(300);
        this.setNumThreads(server.getIntAttr("zimbraLmtpNumThreads", -1));
        this.setBindPort(server.getIntAttr("zimbraLmtpBindPort", -1));
        this.setBindAddress(server.getAttr("zimbraLmtpBindAddress"));
        this.setRecipientDelimiter(provisioning.getConfig().getAttr("zimbraMtaRecipientDelimiter"));
        this.setLmtpBackend(new ZimbraLmtpBackend(this));
        this.validate();
    }

    public void validate() throws ServiceException {
        if (this.getNumThreads() < 0) {
            this.failure("invalid value " + this.getNumThreads() + " for " + "zimbraLmtpNumThreads");
        }
        if (this.getBindPort() < 0) {
            this.failure("invalid value " + this.getBindPort() + " for " + "zimbraLmtpBindPort");
        }
        if (this.getLmtpBackend() == null) {
            this.failure("missing lmtp backend");
        }
        super.validate();
    }

    public static String getServerName() {
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            String name = server.getAttr("zimbraLmtpAdvertisedName");
            if (name != null && name.length() > 0) {
                return name;
            }
            name = LC.zimbra_server_hostname.value();
            if (name != null) {
                return name;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return "";
    }

    public static String getServerVersion() {
        String version = "";
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            if (server.getBooleanAttr("zimbraLmtpExposeVersionOnBanner", false)) {
                version = " " + BuildInfo.VERSION;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return version;
    }

    public String getRecipientDelimiter() {
        return this.mRecipientDelimiter;
    }

    public void setRecipientDelimiter(String delimiter) {
        this.mRecipientDelimiter = delimiter;
    }

    public LmtpBackend getLmtpBackend() {
        return this.mBackend;
    }

    public void setLmtpBackend(LmtpBackend backend) {
        this.mBackend = backend;
    }

    public boolean permanentFailureWhenOverQuota() {
        boolean isPermanent = false;
        try {
            isPermanent = Provisioning.getInstance().getLocalServer().getBooleanAttr("zimbraLmtpPermanentFailureWhenOverQuota", false);
        }
        catch (ServiceException e) {
            ZimbraLog.lmtp.warn("Unable to determine value of %s.  Defaulting to false.", "zimbraLmtpPermanentFailureWhenOverQuota");
        }
        return isPermanent;
    }
}

