/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.cs.lmtpserver.LmtpReply;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LmtpAddress {
    private boolean mIsValid;
    private String mLocalPart;
    private String mNormalizedLocalPart;
    private String mDomainPart;
    private Map<String, String> mParameters;
    private LmtpReply mDeliveryReply;
    private String mEmailAddress;
    private String[] mAllowedParameters;
    private boolean mSkipFilters = false;
    private String mFolder = null;
    private String mFlags = null;
    private String mTags = null;
    private int offset;
    private int length;
    private char[] array;
    private static final boolean debug = false;

    public LmtpAddress(String arg, String[] allowedParameters, String rcptDelim) {
        this.mAllowedParameters = allowedParameters;
        this.mParameters = new HashMap<String, String>();
        this.mIsValid = this.parse(arg);
        this.mDeliveryReply = LmtpReply.TEMPORARY_FAILURE;
        if (!this.mIsValid) {
            return;
        }
        int delimIndex = -1;
        this.mNormalizedLocalPart = this.mLocalPart != null && rcptDelim != null && (delimIndex = this.mLocalPart.indexOf(rcptDelim)) > 0 ? this.mLocalPart.substring(0, delimIndex) : this.mLocalPart;
        int l1 = this.mLocalPart != null ? this.mLocalPart.length() : 0;
        int l2 = this.mDomainPart != null ? this.mDomainPart.length() : 0;
        StringBuilder sb = new StringBuilder(l1 + l2 + 1);
        if (this.mNormalizedLocalPart != null) {
            sb.append(this.mNormalizedLocalPart);
        }
        if (this.mDomainPart != null) {
            sb.append("@").append(this.mDomainPart);
        }
        this.mEmailAddress = sb.toString();
    }

    public void setSkipFilters(boolean skip) {
        this.mSkipFilters = skip;
    }

    public boolean getSkipFilters() {
        return this.mSkipFilters;
    }

    public void setFolder(String folder) {
        this.mFolder = folder;
    }

    public String getFolder() {
        return this.mFolder;
    }

    public void setFlags(String flags) {
        this.mFlags = flags;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public void setTags(String tags) {
        this.mTags = tags;
    }

    public String getTags() {
        return this.mTags;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public String getLocalPart() {
        return this.mLocalPart;
    }

    public String getNormalizedLocalPart() {
        return this.mNormalizedLocalPart;
    }

    public String getDomainPart() {
        return this.mDomainPart;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public Map<String, String> getParameters() {
        return this.mParameters;
    }

    public String getParameter(String key) {
        if (this.mParameters.isEmpty()) {
            return null;
        }
        return this.mParameters.get(key.toUpperCase());
    }

    public LmtpReply getDeliveryStatus() {
        return this.mDeliveryReply;
    }

    public void setDeliveryStatus(LmtpReply reply) {
        this.mDeliveryReply = reply;
    }

    private static void say(String s) {
        System.out.println("  [debug] " + s);
    }

    private boolean eos() {
        return this.offset >= this.length;
    }

    private int next() {
        if (this.offset < this.length) {
            return this.array[this.offset++];
        }
        return -1;
    }

    private int peek() {
        if (this.offset < this.length) {
            return this.array[this.offset];
        }
        return -1;
    }

    private void skip() {
        ++this.offset;
    }

    private void init(String p) {
        this.array = p.toCharArray();
        this.length = this.array.length;
        this.offset = 0;
    }

    private boolean parse(String p) {
        if (p == null || p.length() < 2) {
            return false;
        }
        this.init(p);
        this.skipSpaces();
        int ch = this.next();
        if (ch == -1 || ch != 60) {
            return false;
        }
        if (!this.skipSourceRoutes()) {
            return false;
        }
        if (!this.parseLocalPart()) {
            return false;
        }
        ch = this.peek();
        if (ch == 64 && !this.parseDomainPart()) {
            return false;
        }
        ch = this.next();
        if (ch != 62) {
            return false;
        }
        if (this.eos()) {
            return true;
        }
        ch = this.peek();
        if (ch != 32) {
            return false;
        }
        this.skipSpaces();
        while (!this.eos()) {
            if (!this.parseParameter()) {
                return false;
            }
            this.skipSpaces();
        }
        return true;
    }

    private void skipSpaces() {
        while (this.peek() == 32) {
            this.skip();
        }
    }

    private boolean skipSourceRoutes() {
        int ch = this.peek();
        if (ch != 64) {
            return true;
        }
        this.skip();
        while (ch == 64) {
            ch = this.peek();
            if (ch == 91 ? !this.skipAddress() : !this.skipHostname()) {
                return false;
            }
            ch = this.next();
            if (ch == 44) {
                ch = this.next();
                continue;
            }
            if (ch == 58) {
                ch = this.peek();
                if (ch != 64) break;
                this.skip();
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isLetter(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private boolean skipAddress() {
        int ch = this.next();
        if (ch != 91) {
            return false;
        }
        while (this.isDigit(ch = this.next()) || ch == 46) {
        }
        return ch == 93;
    }

    private boolean skipHostname() {
        int ch;
        while (this.isDigit(ch = this.peek()) || this.isLetter(ch) || ch == 46 || ch == 45) {
            this.skip();
        }
        return true;
    }

    private boolean parseLocalPart() {
        int ch = this.peek();
        if (ch == 34) {
            return this.parseQuotedLocalPart();
        }
        return this.parsePlainLocalPart();
    }

    private boolean parseQuotedLocalPart() {
        int soffset = this.offset;
        int ch = this.next();
        if (ch != 34) {
            return false;
        }
        while (!this.eos()) {
            ch = this.next();
            if (ch == 92) {
                ch = this.next();
                if (ch != -1) continue;
                return false;
            }
            if (ch != 34) continue;
            this.mLocalPart = new String(this.array, soffset, this.offset - soffset);
            return true;
        }
        return false;
    }

    private boolean parsePlainLocalPart() {
        int soffset = this.offset;
        while (!this.eos()) {
            int ch = this.peek();
            if (ch < 33 || ch > 126) {
                return false;
            }
            if ("<()[]\\,;:\"".indexOf(ch) > -1) {
                return false;
            }
            if (ch == 64 || ch == 62) {
                this.mLocalPart = new String(this.array, soffset, this.offset - soffset);
                return true;
            }
            this.skip();
        }
        this.mLocalPart = new String(this.array, soffset, this.offset - soffset);
        return true;
    }

    private boolean parseDomainPart() {
        int ch = this.next();
        if (ch != 64) {
            return false;
        }
        int soffset = this.offset;
        ch = this.peek();
        if (ch == 91 ? !this.skipAddress() : !this.skipHostname()) {
            return false;
        }
        this.mDomainPart = new String(this.array, soffset, this.offset - soffset);
        return true;
    }

    private boolean parseParameter() {
        int ch;
        String key = null;
        int koffset = this.offset;
        while (!this.eos()) {
            int ch2 = this.next();
            if (ch2 != 61) continue;
            key = new String(this.array, koffset, this.offset - koffset - 1);
            if (this.allowedParameter(key)) break;
            return false;
        }
        if (key == null) {
            return false;
        }
        int voffset = this.offset;
        while ((ch = this.peek()) != -1 && ch != 32) {
            this.skip();
        }
        String value = new String(this.array, voffset, this.offset - voffset);
        this.mParameters.put(key.toUpperCase(), value);
        return true;
    }

    private boolean allowedParameter(String key) {
        if (this.mAllowedParameters == null) {
            return false;
        }
        for (int i = 0; i < this.mAllowedParameters.length; ++i) {
            if (!key.equalsIgnoreCase(this.mAllowedParameters[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mEmailAddress;
    }
}

