/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.lmtpserver;

import com.zimbra.common.mime.InternetAddress;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.lmtpserver.LmtpAddress;
import com.zimbra.cs.lmtpserver.LmtpEnvelope;
import com.zimbra.cs.lmtpserver.LmtpReply;
import com.zimbra.cs.lmtpserver.LmtpServer;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.stats.ZimbraPerf;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DeliveryServlet
extends ZimbraServlet {
    private static final long serialVersionUID = 1L;
    public static final String DELIVERY_PATH = "/service/deliver";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO_PREFIX = "to";
    public static final String PARAM_FOLDER_PREFIX = "folder";
    public static final String PARAM_FLAGS_PREFIX = "flags";
    public static final String PARAM_TAGS_PREFIX = "tags";
    public static final String RESPONSE_REPLY_PREFIX = "X-Zimbra-LMTP-Reply-";
    public static final String RESPONSE_DELIVERED = "X-Zimbra-LMTP-Delivered";
    public static final String RESPONSE_PROCESSED = "X-Zimbra-LMTP-Processed";
    public static final int MAX_RECIPIENTS = 50;

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    private LmtpAddress toLmtpAddress(String addrParam) {
        InternetAddress ia = new InternetAddress(addrParam);
        String address = ia.getAddress();
        if (address == null) {
            return null;
        }
        return new LmtpAddress("<" + address + ">", null, null);
    }

    private int deliver(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LmtpReply lmtpReply;
        String to;
        int numDelivered = 0;
        int contentLength = req.getContentLength();
        String from = req.getParameter(PARAM_FROM);
        if (from == null) {
            return numDelivered;
        }
        LmtpEnvelope envelope = new LmtpEnvelope();
        LmtpAddress sender = this.toLmtpAddress(from);
        if (sender == null || !sender.isValid()) {
            return numDelivered;
        }
        envelope.setSender(sender);
        LmtpServer lmtpServer = LmtpServer.getInstance();
        if (lmtpServer == null) {
            return numDelivered;
        }
        LinkedList<String> toList = new LinkedList<String>();
        while (toList.size() < 50 && (to = req.getParameter(PARAM_TO_PREFIX + toList.size())) != null) {
            toList.add(to);
        }
        String[] tos = toList.toArray(new String[0]);
        resp.addHeader(RESPONSE_PROCESSED, new Integer(tos.length).toString());
        if (contentLength > -1) {
            ZimbraPerf.COUNTER_LMTP_RCVD_MSGS.increment();
            ZimbraPerf.COUNTER_LMTP_RCVD_BYTES.increment(contentLength);
            ZimbraPerf.COUNTER_LMTP_RCVD_RCPT.increment(tos.length);
        }
        String[] status = new String[tos.length];
        HashMap<LmtpAddress, Integer> responseIndex = new HashMap<LmtpAddress, Integer>();
        for (int i = 0; i < tos.length; ++i) {
            LmtpAddress recipient = this.toLmtpAddress(tos[i]);
            if (recipient == null || !recipient.isValid()) {
                status[i] = LmtpReply.INVALID_RECIPIENT_ADDRESS.toString();
                continue;
            }
            responseIndex.put(recipient, i);
            lmtpReply = lmtpServer.getLmtpConfig().getLmtpBackend().getAddressStatus(recipient);
            if (!lmtpReply.success()) {
                status[i] = lmtpReply.toString();
                continue;
            }
            recipient.setSkipFilters(true);
            String folder = req.getParameter(PARAM_FOLDER_PREFIX + i);
            recipient.setFolder(folder);
            String flags = req.getParameter(PARAM_FLAGS_PREFIX + i);
            recipient.setFlags(flags);
            String tags = req.getParameter(PARAM_TAGS_PREFIX + i);
            recipient.setTags(tags);
            envelope.addRecipient(recipient);
        }
        if (!envelope.getRecipients().isEmpty()) {
            lmtpServer.getLmtpConfig().getLmtpBackend().deliver(envelope, (InputStream)req.getInputStream(), 0);
        }
        for (LmtpAddress recipient : envelope.getRecipients()) {
            lmtpReply = recipient.getDeliveryStatus();
            if (lmtpReply.success()) {
                ++numDelivered;
            }
            int index = (Integer)responseIndex.get(recipient);
            status[index] = lmtpReply.toString();
        }
        for (int i = 0; i < tos.length; ++i) {
            ZimbraLog.lmtp.info("lmtp over http delivery for " + tos[i] + ": " + status[i]);
            resp.addHeader(RESPONSE_REPLY_PREFIX + i, status[i]);
        }
        if (contentLength > -1) {
            ZimbraPerf.COUNTER_LMTP_DLVD_MSGS.increment(numDelivered);
            ZimbraPerf.COUNTER_LMTP_DLVD_BYTES.increment(numDelivered * contentLength);
        }
        return numDelivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ZimbraLog.clearContext();
        this.addRemoteIpToLoggingContext(req);
        int numDelivered = 0;
        try {
            numDelivered = this.deliver(req, resp);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ZimbraLog.clearContext();
            resp.addHeader(RESPONSE_DELIVERED, new Integer(numDelivered).toString());
            throw throwable;
        }
        ZimbraLog.clearContext();
        resp.addHeader(RESPONSE_DELIVERED, new Integer(numDelivered).toString());
    }

    public static void main(String[] args) {
        InternetAddress addr = new InternetAddress(args[0]);
        System.out.println("addr=" + addr.getAddress());
        System.out.println("pers=" + addr.getPersonal());
    }
}

