/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index.queryparser;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.ZimbraQuery;
import com.zimbra.cs.index.queryparser.JavaCharStream;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.index.queryparser.Token;
import com.zimbra.cs.index.queryparser.TokenMgrError;
import com.zimbra.cs.index.queryparser.ZimbraQueryParserConstants;
import com.zimbra.cs.index.queryparser.ZimbraQueryParserTokenManager;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.util.ItemId;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;

public final class ZimbraQueryParser
implements ZimbraQueryParserConstants {
    private static HashMap<String, Integer> sFolderStrMap = new HashMap();
    private int mDefaultField;
    private static HashMap<String, GetQueryCallback> sIsStrMap;
    private Analyzer mAnalyzer = null;
    private Mailbox mMailbox = null;
    private TimeZone mTimeZone = null;
    private Locale mLocale = null;
    private String mSortByStr = null;
    public ZimbraQueryParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public ZimbraQuery.BaseQuery GetFieldQuery(int modifier, int target, String targetImg, String tok) throws ParseException, ServiceException, MailServiceException {
        return ZimbraQuery.FieldQuery.Create(this.mMailbox, this.mAnalyzer, modifier, target, targetImg, tok);
    }

    public static final ParseException parseException(String s, String code, Token t) throws ParseException {
        ParseException pe = new ParseException(s, code);
        pe.currentToken = t;
        return pe;
    }

    public ZimbraQuery.BaseQuery GetQuery(int modifier, int target, String tok, Token t) throws ParseException, ServiceException, MailServiceException {
        switch (target) {
            case 33: {
                if (!tok.equalsIgnoreCase("attachment")) {
                    return new ZimbraQuery.HasQuery(this.mMailbox, this.mAnalyzer, modifier, tok);
                }
                tok = "any";
            }
            case 36: {
                return new ZimbraQuery.AttachmentQuery(this.mMailbox, this.mAnalyzer, modifier, tok);
            }
            case 35: {
                return new ZimbraQuery.TypeQuery(this.mMailbox, this.mAnalyzer, modifier, tok);
            }
            case 67: {
                return ZimbraQuery.ItemQuery.Create(this.mMailbox, this.mAnalyzer, modifier, tok);
            }
            case 31: 
            case 32: {
                String iidStr;
                ItemId iid = null;
                int subfolderSplit = tok.indexOf(47);
                String subfolderPath = null;
                if (subfolderSplit > 0) {
                    iidStr = tok.substring(0, subfolderSplit);
                    subfolderPath = tok.substring(subfolderSplit + 1);
                } else {
                    iidStr = tok;
                }
                iid = new ItemId(iidStr, (String)null);
                try {
                    return ZimbraQuery.InQuery.Create(this.mMailbox, this.mAnalyzer, modifier, iid, subfolderPath, target == 32);
                }
                catch (ServiceException e) {
                    ZimbraLog.index.debug("Ignoring INID/UNDERID clause b/c of ServiceException: " + e);
                    return ZimbraQuery.InQuery.Create(this.mMailbox, this.mAnalyzer, modifier, ZimbraQuery.InQuery.IN_NO_FOLDER, false);
                }
            }
            case 29: 
            case 30: {
                Integer folderId = sFolderStrMap.get(tok.toLowerCase());
                if (folderId != null) {
                    return ZimbraQuery.InQuery.Create(this.mMailbox, this.mAnalyzer, modifier, folderId, target == 30);
                }
                return ZimbraQuery.InQuery.Create(this.mMailbox, this.mAnalyzer, modifier, tok, target == 30);
            }
            case 50: {
                return new ZimbraQuery.TagQuery(this.mMailbox, this.mAnalyzer, modifier, tok, true);
            }
            case 37: {
                GetQueryCallback cback = sIsStrMap.get(tok.toLowerCase());
                if (cback != null) {
                    return cback.execute(this.mMailbox, this.mAnalyzer, modifier);
                }
                throw ZimbraQueryParser.parseException("Unknown text after is: in query string", "UNKNOWN_TEXT_AFTER_IS", t);
            }
            case 54: {
                return ZimbraQuery.ConvQuery.create(this.mMailbox, this.mAnalyzer, modifier, tok);
            }
            case 55: {
                return ZimbraQuery.ConvCountQuery.create(this.mMailbox, this.mAnalyzer, modifier, target, tok);
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                ZimbraQuery.DateQuery q = new ZimbraQuery.DateQuery(this.mAnalyzer, target);
                q.parseDate(modifier, tok, t, this.mTimeZone, this.mLocale);
                return q;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                if (tok == null || tok.length() < 1) {
                    throw ZimbraQueryParser.parseException("Missing required text after a TO/FROM/CC", "MISSING_TEXT_AFTER_TOFROMCC", t);
                }
                return ZimbraQuery.AddrQuery.createFromTarget(this.mMailbox, this.mAnalyzer, modifier, target, tok);
            }
            case 23: {
                if (tok == null || tok.length() < 1) {
                    throw ZimbraQueryParser.parseException("Missing required text after a TO/FROM/CC", "MISSING_TEXT_AFTER_TOFROMCC", t);
                }
                return ZimbraQuery.SenderQuery.create(this.mMailbox, this.mAnalyzer, modifier, target, tok);
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                if (tok == null || tok.length() < 1) {
                    throw ZimbraQueryParser.parseException("Missing required text after a TO/FROM/CC", "MISSING_TEXT_AFTER_TOFROMCC", t);
                }
                if (tok.charAt(0) == '@') {
                    return new ZimbraQuery.DomainQuery(this.mMailbox, this.mAnalyzer, modifier, target, tok);
                }
                return new ZimbraQuery.TextQuery(this.mMailbox, this.mAnalyzer, modifier, target, tok);
            }
            case 53: {
                return new ZimbraQuery.ModseqQuery(this.mMailbox, this.mAnalyzer, modifier, target, tok);
            }
            case 45: 
            case 46: 
            case 49: {
                return new ZimbraQuery.SizeQuery(this.mAnalyzer, modifier, target, tok);
            }
            case 17: {
                return ZimbraQuery.SubjectQuery.create(this.mMailbox, this.mAnalyzer, modifier, target, tok);
            }
        }
        return new ZimbraQuery.TextQuery(this.mMailbox, this.mAnalyzer, modifier, target, tok);
    }

    public String getSortByStr() {
        return this.mSortByStr;
    }

    public void init(Analyzer analyzer, Mailbox mbx, TimeZone tz, Locale locale, int defaultField) {
        this.mAnalyzer = analyzer;
        this.mMailbox = mbx;
        this.mTimeZone = tz;
        this.mLocale = locale;
        this.mDefaultField = defaultField;
    }

    public ArrayList Parse() throws ServiceException, ParseException {
        try {
            return this.DoParse();
        }
        catch (TokenMgrError e) {
            Token t = new Token();
            t.image = "";
            t.beginColumn = e.colNo;
            t.endColumn = e.colNo;
            throw ZimbraQueryParser.parseException(e.getMessage(), "LEXICAL_ERROR", t);
        }
    }

    public static final void AddClause(ArrayList clauses, ZimbraQuery.BaseQuery q) {
        if (null != q) {
            if (clauses.size() > 0) {
                ZimbraQuery.BaseQuery prev = (ZimbraQuery.BaseQuery)clauses.get(clauses.size() - 1);
                assert (prev.getNext() == null);
                prev.setNext(q);
            }
            clauses.add(q);
        }
    }

    public final ZimbraQuery.BaseQuery Conjunction() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                return new ZimbraQuery.ConjQuery(this.mAnalyzer, 4);
            }
            case 5: {
                this.jj_consume_token(5);
                return new ZimbraQuery.ConjQuery(this.mAnalyzer, 5);
            }
        }
        this.jj_la1[0] = this.jj_gen;
        return new ZimbraQuery.ConjQuery(this.mAnalyzer, 4);
    }

    public final int Modifier() throws ParseException {
        Object mod = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                return 9;
            }
            case 10: {
                this.jj_consume_token(10);
                return 10;
            }
            case 6: {
                this.jj_consume_token(6);
                return 10;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        return 0;
    }

    public final int DateModifier() throws ParseException {
        Object mod = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                return 6;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        return 0;
    }

    public final void SortBy() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: 
            case 69: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: {
                        this.jj_consume_token(68);
                        break;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                t = this.jj_consume_token(13);
                this.mSortByStr = t.image;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    public final ZimbraQuery.BaseQuery Rhs_Text(int target) throws ParseException, ServiceException {
        ArrayList clauses = new ArrayList();
        int modifier = 0;
        ZimbraQuery.BaseQuery clause = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                modifier = this.Modifier();
                clause = this.Rhs_Text(target);
                clause.setModifier(modifier);
                ZimbraQueryParser.AddClause(clauses, clause);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            break block11;
                        }
                    }
                    clause = this.Conjunction();
                    ZimbraQueryParser.AddClause(clauses, clause);
                    modifier = this.Modifier();
                    clause = this.Rhs_Text(target);
                    clause.setModifier(modifier);
                    ZimbraQueryParser.AddClause(clauses, clause);
                }
                this.jj_consume_token(8);
                return new ZimbraQuery.SubQuery(this.mAnalyzer, 0, clauses);
            }
            case 12: 
            case 13: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        t = this.jj_consume_token(13);
                        break;
                    }
                    case 12: {
                        t = this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.GetQuery(modifier, target, t.image, t);
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ZimbraQuery.BaseQuery Rhs_Item(int target) throws ParseException, ServiceException {
        ArrayList clauses = new ArrayList();
        int modifier = 0;
        ZimbraQuery.BaseQuery clause = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                modifier = this.Modifier();
                clause = this.Rhs_Item(target);
                clause.setModifier(modifier);
                ZimbraQueryParser.AddClause(clauses, clause);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 75: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block12;
                        }
                    }
                    clause = this.Conjunction();
                    ZimbraQueryParser.AddClause(clauses, clause);
                    modifier = this.Modifier();
                    clause = this.Rhs_Item(target);
                    clause.setModifier(modifier);
                    ZimbraQueryParser.AddClause(clauses, clause);
                }
                this.jj_consume_token(8);
                return new ZimbraQuery.SubQuery(this.mAnalyzer, 0, clauses);
            }
            case 12: 
            case 13: 
            case 75: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        t = this.jj_consume_token(13);
                        break;
                    }
                    case 12: {
                        t = this.jj_consume_token(12);
                        break;
                    }
                    case 75: {
                        t = this.jj_consume_token(75);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.GetQuery(modifier, target, t.image, t);
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ZimbraQuery.BaseQuery Rhs_Field(int target, String img) throws ParseException, ServiceException {
        ArrayList clauses = new ArrayList();
        int modifier = 0;
        ZimbraQuery.BaseQuery clause = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                modifier = this.Modifier();
                clause = this.Rhs_Field(target, img);
                clause.setModifier(modifier);
                ZimbraQueryParser.AddClause(clauses, clause);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block11;
                        }
                    }
                    clause = this.Conjunction();
                    ZimbraQueryParser.AddClause(clauses, clause);
                    modifier = this.Modifier();
                    clause = this.Rhs_Field(target, img);
                    clause.setModifier(modifier);
                    ZimbraQueryParser.AddClause(clauses, clause);
                }
                this.jj_consume_token(8);
                return new ZimbraQuery.SubQuery(this.mAnalyzer, 0, clauses);
            }
            case 12: 
            case 13: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        t = this.jj_consume_token(13);
                        break;
                    }
                    case 12: {
                        t = this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.GetFieldQuery(modifier, target, img, t.image);
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ZimbraQuery.BaseQuery Rhs_Date(int target) throws ParseException, ServiceException {
        ArrayList clauses = new ArrayList();
        int modifier = 0;
        ZimbraQuery.BaseQuery clause = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                modifier = this.DateModifier();
                clause = this.Rhs_Date(target);
                if (modifier == 6) {
                    clause.setModifier(10);
                }
                ZimbraQueryParser.AddClause(clauses, clause);
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block20;
                        }
                    }
                    clause = this.Conjunction();
                    ZimbraQueryParser.AddClause(clauses, clause);
                    modifier = this.DateModifier();
                    clause = this.Rhs_Date(target);
                    if (modifier == 6) {
                        clause.setModifier(10);
                    }
                    ZimbraQueryParser.AddClause(clauses, clause);
                }
                this.jj_consume_token(8);
                return new ZimbraQuery.SubQuery(this.mAnalyzer, 0, clauses);
            }
            case 9: 
            case 10: {
                Token t;
                Token u;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        u = this.jj_consume_token(10);
                        break;
                    }
                    case 9: {
                        u = this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        t = this.jj_consume_token(13);
                        break;
                    }
                    case 12: {
                        t = this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.GetQuery(0, target, u.image + t.image, t);
            }
            case 12: 
            case 13: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        t = this.jj_consume_token(13);
                        break;
                    }
                    case 12: {
                        t = this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.GetQuery(0, target, t.image, t);
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ZimbraQuery.BaseQuery Clause() throws ParseException, ServiceException {
        Token t = null;
        ZimbraQuery.BaseQuery q = null;
        ArrayList subExp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                subExp = this.Query();
                this.jj_consume_token(8);
                return new ZimbraQuery.SubQuery(this.mAnalyzer, 0, subExp);
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 45: 
                    case 46: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: {
                                t = this.jj_consume_token(18);
                                break;
                            }
                            case 20: {
                                t = this.jj_consume_token(20);
                                break;
                            }
                            case 19: {
                                t = this.jj_consume_token(19);
                                break;
                            }
                            case 23: {
                                t = this.jj_consume_token(23);
                                break;
                            }
                            case 22: {
                                t = this.jj_consume_token(22);
                                break;
                            }
                            case 24: {
                                t = this.jj_consume_token(24);
                                break;
                            }
                            case 21: {
                                t = this.jj_consume_token(21);
                                break;
                            }
                            case 25: {
                                t = this.jj_consume_token(25);
                                break;
                            }
                            case 26: {
                                t = this.jj_consume_token(26);
                                break;
                            }
                            case 27: {
                                t = this.jj_consume_token(27);
                                break;
                            }
                            case 28: {
                                t = this.jj_consume_token(28);
                                break;
                            }
                            case 16: {
                                t = this.jj_consume_token(16);
                                break;
                            }
                            case 51: {
                                t = this.jj_consume_token(51);
                                break;
                            }
                            case 17: {
                                t = this.jj_consume_token(17);
                                break;
                            }
                            case 29: {
                                t = this.jj_consume_token(29);
                                break;
                            }
                            case 31: {
                                t = this.jj_consume_token(31);
                                break;
                            }
                            case 30: {
                                t = this.jj_consume_token(30);
                                break;
                            }
                            case 32: {
                                t = this.jj_consume_token(32);
                                break;
                            }
                            case 35: {
                                t = this.jj_consume_token(35);
                                break;
                            }
                            case 36: {
                                t = this.jj_consume_token(36);
                                break;
                            }
                            case 33: {
                                t = this.jj_consume_token(33);
                                break;
                            }
                            case 34: {
                                t = this.jj_consume_token(34);
                                break;
                            }
                            case 62: {
                                t = this.jj_consume_token(62);
                                break;
                            }
                            case 63: {
                                t = this.jj_consume_token(63);
                                break;
                            }
                            case 64: {
                                t = this.jj_consume_token(64);
                                break;
                            }
                            case 65: {
                                t = this.jj_consume_token(65);
                                break;
                            }
                            case 66: {
                                t = this.jj_consume_token(66);
                                break;
                            }
                            case 52: {
                                t = this.jj_consume_token(52);
                                break;
                            }
                            case 37: {
                                t = this.jj_consume_token(37);
                                break;
                            }
                            case 50: {
                                t = this.jj_consume_token(50);
                                break;
                            }
                            case 54: {
                                t = this.jj_consume_token(54);
                                break;
                            }
                            case 55: {
                                t = this.jj_consume_token(55);
                                break;
                            }
                            case 56: {
                                t = this.jj_consume_token(56);
                                break;
                            }
                            case 57: {
                                t = this.jj_consume_token(57);
                                break;
                            }
                            case 45: {
                                t = this.jj_consume_token(45);
                                break;
                            }
                            case 46: {
                                t = this.jj_consume_token(46);
                                break;
                            }
                            case 49: {
                                t = this.jj_consume_token(49);
                                break;
                            }
                            case 53: {
                                t = this.jj_consume_token(53);
                                break;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        q = this.Rhs_Text(t.kind);
                        break;
                    }
                    case 70: {
                        t = this.jj_consume_token(70);
                        q = this.Rhs_Field(t.kind, t.image);
                        break;
                    }
                    case 67: {
                        t = this.jj_consume_token(67);
                        q = this.Rhs_Item(t.kind);
                        break;
                    }
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 38: {
                                t = this.jj_consume_token(38);
                                break;
                            }
                            case 39: {
                                t = this.jj_consume_token(39);
                                break;
                            }
                            case 41: {
                                t = this.jj_consume_token(41);
                                break;
                            }
                            case 40: {
                                t = this.jj_consume_token(40);
                                break;
                            }
                            case 42: {
                                t = this.jj_consume_token(42);
                                break;
                            }
                            case 43: {
                                t = this.jj_consume_token(43);
                                break;
                            }
                            case 44: {
                                t = this.jj_consume_token(44);
                                break;
                            }
                            case 58: {
                                t = this.jj_consume_token(58);
                                break;
                            }
                            case 59: {
                                t = this.jj_consume_token(59);
                                break;
                            }
                            case 60: {
                                t = this.jj_consume_token(60);
                                break;
                            }
                            case 61: {
                                t = this.jj_consume_token(61);
                                break;
                            }
                            default: {
                                this.jj_la1[20] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        q = this.Rhs_Date(t.kind);
                        break;
                    }
                    case 12: 
                    case 13: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 13: {
                                t = this.jj_consume_token(13);
                                break;
                            }
                            case 12: {
                                t = this.jj_consume_token(12);
                                break;
                            }
                            default: {
                                this.jj_la1[21] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        return this.GetQuery(0, this.mDefaultField, t.image, t);
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return q;
            }
        }
        this.jj_la1[23] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ArrayList Query() throws ParseException, ServiceException {
        ZimbraQuery.BaseQuery clause = null;
        ArrayList clauses = new ArrayList();
        this.SortBy();
        int modifier = this.Modifier();
        clause = this.Clause();
        this.SortBy();
        if (clause != null) {
            clause.setModifier(modifier);
            ZimbraQueryParser.AddClause(clauses, clause);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 70: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            clause = this.Conjunction();
            ZimbraQueryParser.AddClause(clauses, clause);
            modifier = this.Modifier();
            clause = this.Clause();
            if (clause != null) {
                clause.setModifier(modifier);
                ZimbraQueryParser.AddClause(clauses, clause);
            }
            this.SortBy();
        }
        return clauses;
    }

    public final ArrayList DoParse() throws ParseException, ServiceException {
        ArrayList clauses = this.Query();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: 
            case 76: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: {
                        this.jj_consume_token(76);
                        break block0;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break block0;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        return clauses;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{48, 1600, 64, 0, 0, 14064, 12288, 12416, 14064, 12288, 12416, 14064, 12288, 12416, 14064, 1536, 12288, 12288, 13952, -65536, 0, 12288, -53248, -53120, -51472, 1, 1};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1006739393, 1006641088, 0, -98305, -98305, -98305, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 48, 48, 0, 0, 0, 2048, 2048, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 79, 79, 79, 4096, 4096};
    }

    public ZimbraQueryParser(InputStream stream) {
        this(stream, null);
    }

    public ZimbraQueryParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ZimbraQueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ZimbraQueryParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ZimbraQueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ZimbraQueryParser(ZimbraQueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ZimbraQueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[77];
        for (i = 0; i < 77; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 77; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        sFolderStrMap.put("inbox", new Integer(2));
        sFolderStrMap.put("trash", new Integer(3));
        sFolderStrMap.put("junk", new Integer(4));
        sFolderStrMap.put("sent", new Integer(5));
        sFolderStrMap.put("drafts", new Integer(6));
        sFolderStrMap.put("contacts", new Integer(7));
        sIsStrMap = new HashMap();
        sIsStrMap.put("read", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.ReadQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("unread", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.ReadQuery(mbx, analyze, modifier, false);
            }
        });
        sIsStrMap.put("flagged", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.FlaggedQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("unflagged", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.FlaggedQuery(mbx, analyze, modifier, false);
            }
        });
        sIsStrMap.put("draft", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.DraftQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("received", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.SentQuery(mbx, analyze, modifier, false);
            }
        });
        sIsStrMap.put("replied", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.RepliedQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("unreplied", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.RepliedQuery(mbx, analyze, modifier, false);
            }
        });
        sIsStrMap.put("forwarded", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.ForwardedQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("unforwarded", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.ForwardedQuery(mbx, analyze, modifier, false);
            }
        });
        sIsStrMap.put("invite", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.IsInviteQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("anywhere", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.InQuery.Create(mbx, analyze, modifier, ZimbraQuery.InQuery.IN_ANY_FOLDER, false);
            }
        });
        sIsStrMap.put("local", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.InQuery.Create(mbx, analyze, modifier, ZimbraQuery.InQuery.IN_LOCAL_FOLDER, false);
            }
        });
        sIsStrMap.put("remote", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.InQuery.Create(mbx, analyze, modifier, ZimbraQuery.InQuery.IN_REMOTE_FOLDER, true);
            }
        });
        sIsStrMap.put("solo", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.ConvCountQuery.create(mbx, analyze, modifier, 55, "1");
            }
        });
        sIsStrMap.put("sent", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.SentQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("tome", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.MeQuery.create(mbx, analyze, modifier, 2);
            }
        });
        sIsStrMap.put("fromme", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return new ZimbraQuery.SentQuery(mbx, analyze, modifier, true);
            }
        });
        sIsStrMap.put("ccme", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.MeQuery.create(mbx, analyze, modifier, 4);
            }
        });
        sIsStrMap.put("tofromme", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.MeQuery.create(mbx, analyze, modifier, 3);
            }
        });
        sIsStrMap.put("toccme", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.MeQuery.create(mbx, analyze, modifier, 6);
            }
        });
        sIsStrMap.put("fromccme", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.MeQuery.create(mbx, analyze, modifier, 5);
            }
        });
        sIsStrMap.put("tofromccme", new GetQueryCallback(){

            public ZimbraQuery.BaseQuery execute(Mailbox mbx, Analyzer analyze, int modifier) throws ServiceException {
                return ZimbraQuery.MeQuery.create(mbx, analyze, modifier, 7);
            }
        });
        ZimbraQueryParser.jj_la1_0();
        ZimbraQueryParser.jj_la1_1();
        ZimbraQueryParser.jj_la1_2();
    }

    private static abstract class GetQueryCallback {
        private GetQueryCallback() {
        }

        public abstract ZimbraQuery.BaseQuery execute(Mailbox var1, Analyzer var2, int var3) throws ServiceException;
    }
}

