/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index.queryparser;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.ZimbraQuery;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.index.queryparser.ZimbraQueryParser;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.qa.unittest.TestUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.lucene.analysis.Analyzer;

public class TestQueryParser
extends TestCase {
    long mMailboxId;
    Mailbox mMbox;
    MailboxIndex mMi;

    protected void setUp() throws Exception {
        super.setUp();
        Mailbox mbox = TestUtil.getMailbox("user1");
        this.mMailboxId = mbox.getId();
    }

    public void testQueryParser() throws ServiceException, ParseException {
        this.mMbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId);
        this.mMi = this.mMbox.getMailboxIndex();
        this.mMi.initAnalyzer(this.mMbox);
        this.runQuery("subject:\"foo bar\" and content:\"baz gub\"");
        this.runQuery("date:-4d");
        this.runQuery("date:\"-4d\"");
        this.runQuery("subject:\"foo\"");
        this.runQuery("(a or b)");
        this.runQuery("(a or b) and in:inbox");
        this.runQuery("(a or b) and before:1/1/2009 and -subject:\"quoted string\"");
        this.runQuery("\"This is a \\\"phrase\\\" query\"");
    }

    private void runQuery(String queryStr) throws ServiceException, ParseException {
        this.runQuery(queryStr, null, null, "content:");
    }

    private void runQuery(String queryStr, TimeZone tz, Locale l, String defaultField) throws ServiceException, ParseException {
        System.out.println("Parsing: " + queryStr);
        ZimbraQueryParser parser = new ZimbraQueryParser(new StringReader(queryStr));
        Analyzer analyzer = this.mMi.getAnalyzer();
        parser.init(analyzer, this.mMbox, tz, l, ZimbraQuery.lookupQueryTypeFromString(defaultField));
        ArrayList clauses = parser.Parse();
        System.out.println("Output: ");
        for (Object o : clauses) {
            System.out.println("\t" + o);
        }
    }

    public static void runTests() {
        TestSuite suite = new TestSuite(TestQueryParser.class);
        TestResult results = new TestResult();
        suite.run(results);
        if (!results.wasSuccessful()) {
            System.out.println("\n**************************");
            System.out.println("TEST FAILURES:");
            System.out.println("**************************");
        }
        if (results.failureCount() > 0) {
            Enumeration failures = results.failures();
            while (failures.hasMoreElements()) {
                TestFailure error = (TestFailure)failures.nextElement();
                System.out.println("--> Test Failure: " + error.trace() + error.thrownException());
                System.out.print("\n");
            }
        }
        if (results.errorCount() > 0) {
            Enumeration errors = results.errors();
            while (errors.hasMoreElements()) {
                TestFailure failure = (TestFailure)errors.nextElement();
                System.out.println("--> Test Error: " + failure.trace() + failure.thrownException() + " at ");
                failure.thrownException().printStackTrace();
                System.out.print("\n");
            }
        }
        if (results.wasSuccessful()) {
            System.out.println("\n**************************");
            System.out.println("Tests SUCCESSFUL!");
            System.out.println("**************************");
        }
    }

    public static void main(String[] args) {
        CliUtil.toolSetup("DEBUG");
        ZimbraLog.account.info("INFO TEST!");
        ZimbraLog.account.debug("DEBUG TEST!");
        TestQueryParser.runTests();
        System.exit(1);
    }
}

