/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.DbSearch;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.index.CalendarItemHit;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.DocumentHit;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.NoteHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TaskHit;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.document.Document;

abstract class ZimbraQueryResultsImpl
implements ZimbraQueryResults {
    private static final int MAX_LRU_ENTRIES = 2048;
    private static final int INITIAL_TABLE_SIZE = 100;
    private HashMap<Integer, ConversationHit> mConversationHits;
    private HashMap<Integer, MessageHit> mMessageHits;
    private HashMap<String, MessagePartHit> mPartHits;
    private HashMap<Integer, ContactHit> mContactHits;
    private HashMap<Integer, NoteHit> mNoteHits;
    private HashMap<Integer, CalendarItemHit> mCalItemHits;
    private byte[] mTypes;
    private SortBy mSearchOrder;
    private Mailbox.SearchResultMode mMode;

    public abstract void doneWithSearchResults() throws ServiceException;

    public abstract ZimbraHit skipToHit(int var1) throws ServiceException;

    public boolean hasNext() throws ServiceException {
        return this.peekNext() != null;
    }

    protected MessageHit getCachedMessageHit(int messageId) {
        return null;
    }

    ZimbraQueryResultsImpl(byte[] types, SortBy searchOrder, Mailbox.SearchResultMode mode) {
        this.mTypes = types;
        this.mMode = mode;
        this.mSearchOrder = searchOrder;
        this.mConversationHits = new LRUHashMap<Integer, ConversationHit>(2048, 100);
        this.mMessageHits = new LRUHashMap<Integer, MessageHit>(2048, 100);
        this.mPartHits = new LRUHashMap<String, MessagePartHit>(2048, 100);
        this.mContactHits = new LRUHashMap<Integer, ContactHit>(2048, 100);
        this.mNoteHits = new LRUHashMap<Integer, NoteHit>(2048, 100);
        this.mCalItemHits = new LRUHashMap<Integer, CalendarItemHit>(2048, 100);
    }

    public ZimbraHit getFirstHit() throws ServiceException {
        this.resetIterator();
        return this.getNext();
    }

    public SortBy getSortBy() {
        return this.mSearchOrder;
    }

    byte[] getTypes() {
        return this.mTypes;
    }

    public Mailbox.SearchResultMode getSearchMode() {
        return this.mMode;
    }

    protected ConversationHit getConversationHit(Mailbox mbx, int convId, float score) {
        ConversationHit ch = this.mConversationHits.get(convId);
        if (ch == null) {
            ch = new ConversationHit(this, mbx, convId, score);
            this.mConversationHits.put(convId, ch);
        } else {
            ch.updateScore(score);
        }
        return ch;
    }

    protected ContactHit getContactHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        ContactHit hit = this.mContactHits.get(mailItemId);
        if (hit == null) {
            hit = new ContactHit(this, mbx, mailItemId, d, score, ud);
            this.mContactHits.put(mailItemId, hit);
        } else {
            hit.updateScore(score);
        }
        return hit;
    }

    protected NoteHit getNoteHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        NoteHit hit = this.mNoteHits.get(mailItemId);
        if (hit == null) {
            hit = new NoteHit(this, mbx, mailItemId, d, score, ud);
            this.mNoteHits.put(mailItemId, hit);
        } else {
            hit.updateScore(score);
        }
        return hit;
    }

    protected CalendarItemHit getAppointmentHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        CalendarItemHit hit = this.mCalItemHits.get(mailItemId);
        if (hit == null) {
            hit = d != null ? new CalendarItemHit(this, mbx, mailItemId, d, score, ud) : new CalendarItemHit(this, mbx, mailItemId, score, ud);
            this.mCalItemHits.put(mailItemId, hit);
        } else {
            hit.updateScore(score);
        }
        return hit;
    }

    protected CalendarItemHit getTaskHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        CalendarItemHit hit = this.mCalItemHits.get(mailItemId);
        if (hit == null) {
            hit = TaskHit.create(this, mbx, mailItemId, d, score, ud);
            this.mCalItemHits.put(mailItemId, hit);
        } else {
            hit.updateScore(score);
        }
        return hit;
    }

    protected MessageHit getMessageHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData underlyingData) throws ServiceException {
        MessageHit hit = this.mMessageHits.get(mailItemId);
        if (hit == null) {
            hit = d != null ? new MessageHit(this, mbx, mailItemId, d, score, underlyingData) : new MessageHit(this, mbx, mailItemId, score, underlyingData);
            this.mMessageHits.put(mailItemId, hit);
        } else {
            hit.updateScore(score);
        }
        return hit;
    }

    protected MessagePartHit getMessagePartHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData underlyingData) throws ServiceException {
        String partKey = Integer.toString(mailItemId) + "-" + d.get("l.partname");
        MessagePartHit hit = this.mPartHits.get(partKey);
        if (hit == null) {
            hit = new MessagePartHit(this, mbx, mailItemId, d, score, underlyingData);
            this.mPartHits.put(partKey, hit);
        } else {
            hit.updateScore(score);
        }
        return hit;
    }

    static final boolean shouldAddDuplicateHits(byte type) {
        return type == 16 || type == 5;
    }

    ZimbraHit getZimbraHit(Mailbox mbox, float score, DbSearch.SearchResult sr, Document doc, DbSearch.SearchResult.ExtraData extra) throws ServiceException {
        MailItem.UnderlyingData ud = null;
        ImapMessage i4msg = null;
        int modseq = -1;
        int parentId = 0;
        switch (extra) {
            case MAIL_ITEM: {
                ud = (MailItem.UnderlyingData)sr.extraData;
                break;
            }
            case IMAP_MSG: {
                i4msg = (ImapMessage)sr.extraData;
                break;
            }
            case MODSEQ: {
                modseq = sr.extraData != null ? (Integer)sr.extraData : -1;
                break;
            }
            case PARENT: {
                parentId = sr.extraData != null ? (Integer)sr.extraData : 0;
            }
        }
        ZimbraHit toRet = null;
        switch (sr.type) {
            case 5: 
            case 16: {
                if (doc != null) {
                    toRet = this.getMessagePartHit(mbox, sr.id, doc, score, ud);
                    toRet.cacheSortField(this.getSortBy(), sr.sortkey);
                    break;
                }
                toRet = this.getMessageHit(mbox, sr.id, null, score, ud);
                toRet.cacheSortField(this.getSortBy(), sr.sortkey);
                break;
            }
            case 6: {
                toRet = this.getContactHit(mbox, sr.id, null, score, ud);
                break;
            }
            case 9: {
                toRet = this.getNoteHit(mbox, sr.id, null, score, ud);
                break;
            }
            case 11: {
                toRet = this.getAppointmentHit(mbox, sr.id, null, score, ud);
                break;
            }
            case 15: {
                toRet = this.getTaskHit(mbox, sr.id, null, score, ud);
                break;
            }
            case 8: 
            case 14: {
                toRet = this.getDocumentHit(mbox, sr.id, doc, score, ud);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (i4msg != null) {
            toRet.cacheImapMessage(i4msg);
        }
        if (modseq > 0) {
            toRet.cacheModifiedSequence(modseq);
        }
        if (parentId != 0) {
            toRet.cacheParentId(parentId);
        }
        return toRet;
    }

    protected DocumentHit getDocumentHit(Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData underlyingData) throws ServiceException {
        DocumentHit hit = d != null ? new DocumentHit(this, mbx, score, mailItemId, underlyingData, d) : new DocumentHit(this, mbx, score, mailItemId, underlyingData);
        return hit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LRUHashMap<T, U>
    extends LinkedHashMap<T, U> {
        private final int mMaxSize;

        LRUHashMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.mMaxSize = maxSize;
        }

        LRUHashMap(int maxSize, int tableSize) {
            super(tableSize, 0.75f, true);
            this.mMaxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.mMaxSize;
        }
    }
}

