/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.index.CombiningQueryOperation;
import com.zimbra.cs.index.DBQueryOperation;
import com.zimbra.cs.index.EmptyQueryResults;
import com.zimbra.cs.index.FilteredQueryResults;
import com.zimbra.cs.index.HitIdGrouper;
import com.zimbra.cs.index.IntersectionQueryOperation;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.NoResultsQueryOperation;
import com.zimbra.cs.index.NoTermQueryOperation;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.RemoteQueryOperation;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TextQueryOperation;
import com.zimbra.cs.index.UnionQueryOperation;
import com.zimbra.cs.index.WildcardExpansionQueryInfo;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.index.queryparser.Token;
import com.zimbra.cs.index.queryparser.ZimbraQueryParser;
import com.zimbra.cs.index.queryparser.ZimbraQueryParserConstants;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.util.ItemId;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZimbraQuery {
    public static final int ADDR_BITMASK_FROM = 1;
    public static final int ADDR_BITMASK_TO = 2;
    public static final int ADDR_BITMASK_CC = 4;
    private static final int SUBQUERY_TOKEN = 9999;
    private AbstractList mClauses;
    private ParseTree.Node mParseTree = null;
    private QueryOperation mOp;
    private Mailbox mMbox;
    private ZimbraQueryResults mResults;
    private SearchParams mParams;
    private int mChunkSize;
    private static String[] unquotedTokenImage;
    private static HashMap<String, Integer> sTokenImageMap;
    private SortBy mSortByOverride = null;

    public static int lookupQueryTypeFromString(String str) throws ServiceException {
        Integer toRet = sTokenImageMap.get(str);
        if (toRet == null) {
            throw MailServiceException.QUERY_PARSE_ERROR(str, null, str, -1, "UNKNOWN_QUERY_TYPE");
        }
        return toRet;
    }

    private static String QueryTypeString(int qType) {
        switch (qType) {
            case 21: {
                return "l.contactData";
            }
            case 16: {
                return "l.content";
            }
            case 18: {
                return "msg_id";
            }
            case 20: {
                return "env_from";
            }
            case 19: {
                return "env_to";
            }
            case 23: {
                return "from";
            }
            case 22: {
                return "to";
            }
            case 24: {
                return "cc";
            }
            case 17: {
                return "subject";
            }
            case 29: {
                return "IN";
            }
            case 33: {
                return "HAS";
            }
            case 34: {
                return "filename";
            }
            case 35: {
                return "type";
            }
            case 36: {
                return "attachment";
            }
            case 37: {
                return "IS";
            }
            case 38: {
                return "DATE";
            }
            case 43: {
                return "AFTER";
            }
            case 44: {
                return "BEFORE";
            }
            case 60: {
                return "APPT-START";
            }
            case 61: {
                return "APPT-END";
            }
            case 45: {
                return "SIZE";
            }
            case 46: {
                return "BIGGER";
            }
            case 49: {
                return "SMALLER";
            }
            case 50: {
                return "TAG";
            }
            case 52: {
                return "MY";
            }
            case 51: {
                return "MESSAGE";
            }
            case 54: {
                return "CONV";
            }
            case 55: {
                return "CONV-COUNT";
            }
            case 56: {
                return "CONV_MINM";
            }
            case 57: {
                return "CONV_MAXM";
            }
            case 58: {
                return "CONV-START";
            }
            case 59: {
                return "CONV-END";
            }
            case 62: {
                return "AUTHOR";
            }
            case 63: {
                return "TITLE";
            }
            case 64: {
                return "KEYWORDS";
            }
            case 65: {
                return "COMPANY";
            }
            case 66: {
                return "METADATA";
            }
            case 67: {
                return "ITEMID";
            }
            case 70: {
                return "l.field";
            }
        }
        return "UNKNOWN:(" + qType + ")";
    }

    private void handleSortByOverride(String str) throws ServiceException {
        SortBy sortBy = SortBy.lookup(str);
        if (sortBy == null) {
            throw ServiceException.FAILURE("Unkown sortBy: specified in search string: " + str, null);
        }
        this.mSortByOverride = sortBy;
    }

    int countSearchTextOperations() {
        if (this.mOp == null) {
            return 0;
        }
        CountTextOperations count = new CountTextOperations();
        this.mOp.depthFirstRecurse(count);
        return count.num;
    }

    private static int countSearchTextOperations(QueryOperation op) {
        if (op == null) {
            return 0;
        }
        CountTextOperations count = new CountTextOperations();
        op.depthFirstRecurse(count);
        return count.num;
    }

    int countNontrivialCombiningOperations() {
        if (this.mOp == null) {
            return 0;
        }
        CountCombiningOperations count = new CountCombiningOperations();
        this.mOp.depthFirstRecurse(count);
        return count.num;
    }

    public static boolean unitTests(Mailbox mbox) throws ServiceException {
        try {
            long GRAN = 1000L;
            String JAN1Str = "01/01/2007";
            long JAN1 = 1167638400000L;
            long JAN2 = 1167724800000L;
            ZimbraQuery.testDate(mbox, "date:01/01/2007", 1167638400000L, true, 1167724800000L, false);
            ZimbraQuery.testDate(mbox, "date:<01/01/2007", -1L, false, 1167638400000L, false);
            ZimbraQuery.testDate(mbox, "before:01/01/2007", -1L, false, 1167638400000L, false);
            ZimbraQuery.testDate(mbox, "date:<=01/01/2007", -1L, false, 1167724800000L, false);
            ZimbraQuery.testDate(mbox, "date:>01/01/2007", 1167724800000L, true, -1L, false);
            ZimbraQuery.testDate(mbox, "after:01/01/2007", 1167724800000L, true, -1L, false);
            ZimbraQuery.testDate(mbox, "date:>=01/01/2007", 1167638400000L, true, -1L, false);
            ZimbraQuery.testDate(mbox, "date:1167638400000", 1167638400000L, true, 1167638401000L, false);
            ZimbraQuery.testDate(mbox, "date:<1167638400000", -1L, false, 1167638400000L, false);
            ZimbraQuery.testDate(mbox, "before:1167638400000", -1L, false, 1167638400000L, false);
            ZimbraQuery.testDate(mbox, "date:<=1167638400000", -1L, false, 1167638401000L, false);
            ZimbraQuery.testDate(mbox, "date:>1167638400000", 1167638401000L, true, -1L, false);
            ZimbraQuery.testDate(mbox, "after:1167638400000", 1167638401000L, true, -1L, false);
            ZimbraQuery.testDate(mbox, "date:>=1167638400000", 1167638400000L, true, -1L, false);
            return true;
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void testDate(Mailbox mbox, String qs, long lowest, boolean lowestEq, long highest, boolean highestEq) throws ServiceException, ParseException {
        AbstractList<BaseQuery> c = ZimbraQuery.unitTestParse(mbox, qs);
        for (BaseQuery t : c) {
            if (!(t instanceof DateQuery)) continue;
            DateQuery dq = (DateQuery)t;
            if (dq.mLowestTime != lowest) {
                throw ServiceException.FAILURE("Invalid lowest time (found " + dq.mLowestTime + " expected " + lowest + "), query is \"" + qs + "\"", null);
            }
            if (dq.mLowerEq != lowestEq) {
                throw ServiceException.FAILURE("Invalid lower EQ (expected " + lowestEq + "), query is \"" + qs + "\"", null);
            }
            if (dq.mHighestTime != highest) {
                throw ServiceException.FAILURE("Invalid highest time (found " + dq.mHighestTime + " expected " + highest + "), query is \"" + qs + "\"", null);
            }
            if (dq.mHigherEq == highestEq) continue;
            throw ServiceException.FAILURE("Invalid higher EQ (expected " + highestEq + "), query is \"" + qs + "\"", null);
        }
    }

    private static AbstractList<BaseQuery> unitTestParse(Mailbox mbox, String qs) throws ServiceException, ParseException {
        Analyzer analyzer = null;
        MailboxIndex mi = mbox.getMailboxIndex();
        if (mi != null) {
            mi.initAnalyzer(mbox);
            analyzer = mi.getAnalyzer();
        } else {
            analyzer = ZimbraAnalyzer.getDefaultAnalyzer();
        }
        ZimbraQueryParser parser = new ZimbraQueryParser(new StringReader(qs));
        parser.init(analyzer, mbox, null, null, ZimbraQuery.lookupQueryTypeFromString("content:"));
        return parser.Parse();
    }

    public ZimbraQuery(OperationContext octxt, SoapProtocol proto, Mailbox mbox, SearchParams params) throws ParseException, ServiceException {
        this.mParams = params;
        this.mMbox = mbox;
        long chunkSize = (long)this.mParams.getOffset() + (long)this.mParams.getLimit();
        this.mChunkSize = chunkSize > 1000L ? 1000 : (int)chunkSize;
        Analyzer analyzer = null;
        MailboxIndex mi = mbox.getMailboxIndex();
        try {
            ZimbraQueryParser parser = new ZimbraQueryParser(new StringReader(this.mParams.getQueryStr()));
            if (mi != null) {
                mi.initAnalyzer(mbox);
                analyzer = mi.getAnalyzer();
            } else {
                analyzer = ZimbraAnalyzer.getDefaultAnalyzer();
            }
            parser.init(analyzer, this.mMbox, params.getTimeZone(), params.getLocale(), ZimbraQuery.lookupQueryTypeFromString(params.getDefaultField()));
            this.mClauses = parser.Parse();
            String sortByStr = parser.getSortByStr();
            if (sortByStr != null) {
                this.handleSortByOverride(sortByStr);
            }
        }
        catch (OutOfMemoryError oome) {
            throw oome;
        }
        catch (Error error) {
            throw ServiceException.FAILURE("ZimbraQueryParser threw Error: " + error, error);
        }
        if (ZimbraLog.index_search.isDebugEnabled()) {
            String str = this.toString() + " search([";
            for (int i = 0; i < this.mParams.getTypes().length; ++i) {
                if (i > 0) {
                    str = str + ",";
                }
                str = str + this.mParams.getTypes()[i];
            }
            str = str + "]," + this.mParams.getSortBy() + ")";
            ZimbraLog.index_search.debug(str);
        }
        ParseTree.Node pt = ParseTree.build(this.mClauses);
        pt = pt.simplify();
        pt.pushNotsDown();
        this.mParseTree = pt;
        this.mOp = null;
        if (this.mSortByOverride != null) {
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("Overriding SortBy parameter to execute (" + params.getSortBy().toString() + ") w/ specification from QueryString: " + this.mSortByOverride.toString());
            }
            params.setSortBy(this.mSortByOverride);
        }
        if (this.mClauses.size() > 0) {
            this.mOp = this.mParseTree.getQueryOperation();
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("OP=" + this.mOp.toString());
            }
            this.mOp = this.mOp.expandLocalRemotePart(mbox);
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("AFTEREXP=" + this.mOp.toString());
            }
            this.mOp = this.mOp.optimize(this.mMbox);
            if (this.mOp == null) {
                this.mOp = new NoResultsQueryOperation();
            }
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("OPTIMIZED=" + this.mOp.toString());
            }
        }
        if (this.mOp != null) {
            UnionQueryOperation union;
            QueryTargetSet targets = this.mOp.getQueryTargets();
            assert (this.mOp instanceof UnionQueryOperation || targets.countExplicitTargets() <= 1);
            UnionQueryOperation remoteOps = new UnionQueryOperation();
            UnionQueryOperation localOps = new UnionQueryOperation();
            if (this.mOp instanceof UnionQueryOperation) {
                union = (UnionQueryOperation)this.mOp;
                for (QueryOperation op : union.mQueryOperations) {
                    QueryTargetSet targets2 = op.getQueryTargets();
                    assert (targets2.countExplicitTargets() <= 1);
                    if (targets2.hasExternalTargets()) {
                        remoteOps.add(op);
                        continue;
                    }
                    localOps.add(op);
                }
            } else {
                QueryTargetSet targets3 = this.mOp.getQueryTargets();
                assert (targets3.countExplicitTargets() <= 1);
                if (targets3.hasExternalTargets()) {
                    remoteOps.add(this.mOp);
                } else {
                    localOps.add(this.mOp);
                }
            }
            if (!remoteOps.mQueryOperations.isEmpty()) {
                for (int i = remoteOps.mQueryOperations.size() - 1; i >= 0; --i) {
                    QueryOperation op = (QueryOperation)remoteOps.mQueryOperations.get(i);
                    QueryTargetSet targets4 = op.getQueryTargets();
                    assert (targets4.countExplicitTargets() <= 1);
                    if (!targets4.hasExternalTargets()) continue;
                    remoteOps.mQueryOperations.remove(i);
                    boolean foundOne = false;
                    for (QueryOperation tryIt : remoteOps.mQueryOperations) {
                        if (!(tryIt instanceof RemoteQueryOperation) || !((RemoteQueryOperation)tryIt).tryAddOredOperation(op)) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    RemoteQueryOperation remoteOp = new RemoteQueryOperation();
                    remoteOp.tryAddOredOperation(op);
                    remoteOps.mQueryOperations.add(i, remoteOp);
                }
                for (QueryOperation toSetup : remoteOps.mQueryOperations) {
                    assert (toSetup instanceof RemoteQueryOperation);
                    try {
                        RemoteQueryOperation remote = (RemoteQueryOperation)toSetup;
                        remote.setup(proto, octxt.getAuthToken(), params);
                    }
                    catch (Exception e) {
                        ZimbraLog.index_search.info("Ignoring " + e + " during RemoteQuery generation for " + remoteOps.toString());
                    }
                }
            }
            if (!localOps.mQueryOperations.isEmpty()) {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("LOCAL_IN=" + localOps.toString());
                }
                Account authAcct = null;
                authAcct = octxt != null ? octxt.getAuthenticatedUser() : mbox.getAccount();
                boolean includeTrash = false;
                boolean includeSpam = false;
                if (authAcct != null) {
                    includeTrash = authAcct.getBooleanAttr("zimbraPrefIncludeTrashInSearch", false);
                    includeSpam = authAcct.getBooleanAttr("zimbraPrefIncludeSpamInSearch", false);
                }
                if (!includeTrash || !includeSpam) {
                    ArrayList<QueryOperation> toAdd = new ArrayList<QueryOperation>();
                    Iterator iter = localOps.mQueryOperations.iterator();
                    while (iter.hasNext()) {
                        QueryOperation newOp;
                        QueryOperation cur = (QueryOperation)iter.next();
                        if (cur.hasSpamTrashSetting() || (newOp = cur.ensureSpamTrashSetting(mbox, includeTrash, includeSpam)) == cur) continue;
                        iter.remove();
                        toAdd.add(newOp);
                    }
                    localOps.mQueryOperations.addAll(toAdd);
                }
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("LOCAL_AFTERTS=" + localOps.toString());
                }
                boolean allowPrivateAccess = true;
                if (octxt != null) {
                    allowPrivateAccess = AccessManager.getInstance().allowPrivateAccess(octxt.getAuthenticatedUser(), mbox.getAccount(), octxt.isUsingAdminPrivileges());
                }
                UnionQueryOperation clonedLocal = null;
                HashSet<Folder> hasFolderRightPrivateSet = new HashSet<Folder>();
                boolean hasCalendarType = false;
                if (params.getTypes() != null) {
                    for (byte b : params.getTypes()) {
                        if (b != 11 && b != 15) continue;
                        hasCalendarType = true;
                        break;
                    }
                }
                if (hasCalendarType && !allowPrivateAccess && ZimbraQuery.countSearchTextOperations(localOps) > 0) {
                    Set<Folder> allVisibleFolders = mbox.getVisibleFolders(octxt);
                    if (allVisibleFolders == null) {
                        allVisibleFolders = new HashSet<Folder>();
                        allVisibleFolders.addAll(mbox.getFolderList(octxt, SortBy.NONE));
                    }
                    for (Folder f : allVisibleFolders) {
                        if (f.getType() != 1 || !CalendarItem.allowPrivateAccess(f, authAcct, false)) continue;
                        hasFolderRightPrivateSet.add(f);
                    }
                    if (!hasFolderRightPrivateSet.isEmpty()) {
                        clonedLocal = (UnionQueryOperation)localOps.clone();
                    }
                }
                Set<Folder> visibleFolders = mbox.getVisibleFolders(octxt);
                localOps = ZimbraQuery.handleLocalPermissionChecks(localOps, this.mMbox, octxt, this.mMbox.getMailboxIndex(), this.mParams, visibleFolders, allowPrivateAccess);
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("LOCAL_AFTER_PERM_CHECKS=" + localOps.toString());
                }
                if (!hasFolderRightPrivateSet.isEmpty()) {
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("CLONED_LOCAL_BEFORE_PERM=" + clonedLocal.toString());
                    }
                    clonedLocal = ZimbraQuery.handleLocalPermissionChecks(clonedLocal, this.mMbox, octxt, this.mMbox.getMailboxIndex(), this.mParams, hasFolderRightPrivateSet, true);
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("CLONED_LOCAL_AFTER_PERM=" + clonedLocal.toString());
                    }
                    assert (clonedLocal.mQueryOperations.size() == 1);
                    QueryOperation optimizedClonedLocal = clonedLocal.optimize(mbox);
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("CLONED_LOCAL_AFTER_OPTIMIZE=" + optimizedClonedLocal.toString());
                    }
                    UnionQueryOperation withPrivateExcluded = localOps;
                    localOps = new UnionQueryOperation();
                    localOps.add(withPrivateExcluded);
                    localOps.add(optimizedClonedLocal);
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("LOCAL_WITH_CLONED=" + localOps.toString());
                    }
                }
            }
            union = new UnionQueryOperation();
            union.add(localOps);
            union.add(remoteOps);
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("BEFORE_FINAL_OPT=" + union.toString());
            }
            this.mOp = union.optimize(mbox);
            assert (union.mQueryOperations.size() > 0);
        }
        if (ZimbraLog.index_search.isDebugEnabled()) {
            ZimbraLog.index_search.debug("END_ZIMBRAQUERY_CONSTRUCTOR=" + this.mOp.toString());
        }
    }

    public void doneWithQuery() throws ServiceException {
        if (this.mResults != null) {
            this.mResults.doneWithSearchResults();
        }
        if (this.mOp != null) {
            this.mOp.doneWithSearchResults();
        }
    }

    public final ZimbraQueryResults execute() throws ServiceException, IOException {
        MailboxIndex mbidx = this.mMbox.getMailboxIndex();
        if (this.mOp != null) {
            QueryTargetSet targets = this.mOp.getQueryTargets();
            assert (this.mOp instanceof UnionQueryOperation || targets.countExplicitTargets() <= 1);
            assert (targets.size() > 1 || !targets.hasExternalTargets() || this.mOp instanceof RemoteQueryOperation);
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("OPERATION:" + this.mOp.toString());
            }
            assert (this.mResults == null);
            this.mResults = this.mOp.run(this.mMbox, mbidx, this.mParams, this.mChunkSize);
            this.mResults = HitIdGrouper.Create(this.mResults, this.mParams.getSortBy());
            if (!this.mParams.getIncludeTagDeleted() && this.mParams.getMode() != Mailbox.SearchResultMode.IDS || this.mParams.getAllowableTaskStatuses() != null) {
                FilteredQueryResults filtered = new FilteredQueryResults(this.mResults);
                if (!this.mParams.getIncludeTagDeleted()) {
                    filtered.setFilterTagDeleted(true);
                }
                if (this.mParams.getAllowableTaskStatuses() != null) {
                    filtered.setAllowedTaskStatuses(this.mParams.getAllowableTaskStatuses());
                }
                this.mResults = filtered;
            }
            return this.mResults;
        }
        ZimbraLog.index_search.debug("Operation optimized to nothing.  Returning no results");
        return new EmptyQueryResults(this.mParams.getTypes(), this.mParams.getSortBy(), this.mParams.getMode());
    }

    private static UnionQueryOperation handleLocalPermissionChecks(UnionQueryOperation union, Mailbox mbox, OperationContext octxt, MailboxIndex mbidx, SearchParams params, Set<Folder> visibleFolders, boolean allowPrivateAccess) throws ServiceException {
        for (int i = union.mQueryOperations.size() - 1; i >= 0; --i) {
            QueryOperation op = (QueryOperation)union.mQueryOperations.get(i);
            QueryTargetSet targets = op.getQueryTargets();
            assert (targets.countExplicitTargets() <= 1);
            assert (!targets.hasExternalTargets());
            if (targets.hasExternalTargets()) continue;
            if (!allowPrivateAccess) {
                op.depthFirstRecurse(new excludePrivateCalendarItems());
            }
            if (visibleFolders == null) continue;
            if (visibleFolders.size() == 0) {
                union.mQueryOperations.remove(i);
                ZimbraLog.index_search.debug("Query changed to NULL_QUERY_OPERATION, no visible folders");
                union.mQueryOperations.add(i, new NoResultsQueryOperation());
                continue;
            }
            union.mQueryOperations.remove(i);
            IntersectionQueryOperation intersect = new IntersectionQueryOperation();
            intersect.addQueryOp(op);
            UnionQueryOperation newUnion = new UnionQueryOperation();
            intersect.addQueryOp(newUnion);
            for (Folder f : visibleFolders) {
                DBQueryOperation newOp = DBQueryOperation.Create();
                newUnion.add(newOp);
                newOp.addInClause(f, true);
            }
            union.mQueryOperations.add(i, intersect);
        }
        return union;
    }

    public String toString() {
        String ret = "ZQ:\n";
        if (this.mClauses.size() > 0) {
            BaseQuery head;
            for (BaseQuery q = head = (BaseQuery)this.mClauses.get(0); q != null; q = q.getNext()) {
                ret = ret + q.toString(1) + "\n";
            }
        }
        return ret;
    }

    public String toQueryString() {
        if (this.mOp == null) {
            return "";
        }
        return this.mOp.toQueryString();
    }

    static {
        sTokenImageMap = new HashMap();
        unquotedTokenImage = new String[ZimbraQueryParserConstants.tokenImage.length];
        for (int i = 0; i < ZimbraQueryParserConstants.tokenImage.length; ++i) {
            String str = ZimbraQueryParserConstants.tokenImage[i].substring(1, ZimbraQueryParserConstants.tokenImage[i].length() - 1);
            ZimbraQuery.unquotedTokenImage[i] = "FIELD".equals(str) ? "#" : str;
            sTokenImageMap.put(str, i);
        }
    }

    private static final class excludePrivateCalendarItems
    implements QueryOperation.RecurseCallback {
        private excludePrivateCalendarItems() {
        }

        public void recurseCallback(QueryOperation op) {
            if (op instanceof TextQueryOperation) {
                ((TextQueryOperation)op).addAndedClause(new TermQuery(new Term("l.field", "_calendaritemclass:private")), false);
            }
        }
    }

    private static final class CountCombiningOperations
    implements QueryOperation.RecurseCallback {
        int num = 0;

        private CountCombiningOperations() {
        }

        public void recurseCallback(QueryOperation op) {
            if (op instanceof CombiningQueryOperation && ((CombiningQueryOperation)op).getNumSubOps() > 1) {
                ++this.num;
            }
        }
    }

    private static final class CountTextOperations
    implements QueryOperation.RecurseCallback {
        int num = 0;

        private CountTextOperations() {
        }

        public void recurseCallback(QueryOperation op) {
            if (op instanceof TextQueryOperation) {
                ++this.num;
            }
        }
    }

    private static class ParseTree {
        private static final int STATE_AND = 1;
        private static final int STATE_OR = 2;
        private static final boolean SPEW = false;

        private ParseTree() {
        }

        static Node build(AbstractList clauses) {
            OperatorNode top = new OperatorNode(2);
            OperatorNode cur = new OperatorNode(1);
            top.add(cur);
            for (BaseQuery q : clauses) {
                if (q instanceof ConjQuery) {
                    if (!((ConjQuery)q).isOr()) continue;
                    cur = new OperatorNode(1);
                    top.add(cur);
                    continue;
                }
                if (q instanceof SubQuery) {
                    SubQuery sq = (SubQuery)q;
                    Node subTree = ParseTree.build(sq.getSubClauses());
                    subTree.setTruth(!sq.isNegated());
                    cur.add(subTree);
                    continue;
                }
                cur.add(new ThingNode(q));
            }
            return top;
        }

        static class ThingNode
        extends Node {
            BaseQuery mThing;
            int mPermuteBase;
            int mNumCanExecute;

            public ThingNode(BaseQuery thing) {
                this.mThing = thing;
                this.mTruthFlag = thing.mTruth;
            }

            public void invertTruth() {
                this.mTruthFlag = !this.mTruthFlag;
            }

            public void pushNotsDown() {
            }

            public Node simplify() {
                return this;
            }

            public String toString() {
                StringBuffer toRet = new StringBuffer(this.mTruthFlag ? "" : " NOT ");
                toRet.append(this.mThing.toString());
                return toRet.toString();
            }

            public QueryOperation getQueryOperation() {
                return this.mThing.getQueryOperation(this.mTruthFlag);
            }
        }

        static class OperatorNode
        extends Node {
            int mKind;
            boolean mTruthFlag = true;
            public ArrayList<Node> mNodes = new ArrayList();

            public OperatorNode(int kind) {
                this.mKind = kind;
            }

            protected OperatorNode() {
            }

            public void setTruth(boolean truth) {
                this.mTruthFlag = truth;
            }

            public void invertTruth() {
                this.mTruthFlag = !this.mTruthFlag;
            }

            public void pushNotsDown() {
                if (!this.mTruthFlag) {
                    this.mTruthFlag = !this.mTruthFlag;
                    this.mKind = this.mKind == 1 ? 2 : 1;
                    for (Node n : this.mNodes) {
                        n.invertTruth();
                    }
                }
                assert (this.mTruthFlag);
                for (Node n : this.mNodes) {
                    n.pushNotsDown();
                }
            }

            public Node simplify() {
                boolean simplifyAgain;
                do {
                    simplifyAgain = false;
                    ArrayList<Node> newNodes = new ArrayList<Node>();
                    for (Node n : this.mNodes) {
                        newNodes.add(n.simplify());
                    }
                    this.mNodes = newNodes;
                    newNodes = new ArrayList();
                    for (Node n : this.mNodes) {
                        boolean addIt = true;
                        if (n instanceof OperatorNode) {
                            OperatorNode opn = (OperatorNode)n;
                            if (opn.mKind == this.mKind && opn.mTruthFlag) {
                                addIt = false;
                                simplifyAgain = true;
                                Iterator<Node> opIter = opn.mNodes.iterator();
                                while (opIter.hasNext()) {
                                    newNodes.add(opIter.next());
                                }
                            }
                        }
                        if (!addIt) continue;
                        newNodes.add(n);
                    }
                    this.mNodes = newNodes;
                } while (simplifyAgain);
                if (this.mNodes.size() == 0) {
                    return null;
                }
                if (this.mNodes.size() == 1) {
                    Node n = this.mNodes.get(0);
                    if (!this.mTruthFlag) {
                        n.invertTruth();
                    }
                    return n;
                }
                return this;
            }

            public void add(Node subNode) {
                this.mNodes.add(subNode);
            }

            public String toString() {
                StringBuffer toRet = new StringBuffer(this.mTruthFlag ? "" : " NOT ");
                toRet.append(this.mKind == 1 ? " AND[" : " OR(");
                for (Node n : this.mNodes) {
                    toRet.append(n.toString());
                    toRet.append(", ");
                }
                toRet.append(this.mKind == 1 ? "] " : ") ");
                return toRet.toString();
            }

            public QueryOperation getQueryOperation() {
                assert (this.mTruthFlag);
                if (this.mKind == 1) {
                    IntersectionQueryOperation intersect = new IntersectionQueryOperation();
                    for (Node n : this.mNodes) {
                        QueryOperation op = n.getQueryOperation();
                        assert (op != null);
                        intersect.addQueryOp(op);
                    }
                    return intersect;
                }
                UnionQueryOperation union = new UnionQueryOperation();
                for (Node n : this.mNodes) {
                    QueryOperation op = n.getQueryOperation();
                    assert (op != null);
                    union.add(op);
                }
                return union;
            }
        }

        static abstract class Node {
            boolean mTruthFlag = true;

            protected Node() {
            }

            public void setTruth(boolean truth) {
                this.mTruthFlag = truth;
            }

            public void invertTruth() {
                this.mTruthFlag = !this.mTruthFlag;
            }

            public abstract void pushNotsDown();

            public abstract Node simplify();

            public abstract QueryOperation getQueryOperation();
        }
    }

    public static class SubjectQuery
    extends BaseQuery {
        private String mStr;
        private boolean mLt;
        private boolean mEq;

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation op = DBQueryOperation.Create();
            truth = this.calcTruth(truth);
            if (this.mLt) {
                op.addRelativeSubject(null, false, this.mStr, this.mEq, truth);
            } else {
                op.addRelativeSubject(this.mStr, this.mEq, null, false, truth);
            }
            return op;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "Subject(";
        }

        private SubjectQuery(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String text) throws ServiceException {
            super(modifier, qType);
            this.mLt = text.charAt(0) == '<';
            this.mEq = false;
            this.mStr = text.substring(1);
            if (this.mStr.charAt(0) == '=') {
                this.mEq = true;
                this.mStr = this.mStr.substring(1);
            }
        }

        public static BaseQuery create(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String text) throws ServiceException {
            if (text.length() > 1 && (text.startsWith("<") || text.startsWith(">"))) {
                return new SubjectQuery(mbox, analyzer, modifier, qType, text);
            }
            return new TextQuery(mbox, analyzer, modifier, qType, text);
        }
    }

    public static class ConvCountQuery
    extends BaseQuery {
        private int mLowestCount;
        private boolean mLowerEq;
        private int mHighestCount;
        private boolean mHigherEq;

        private ConvCountQuery(Mailbox mbox, Analyzer analyzer, int modifier, int qType, int lowestCount, boolean lowerEq, int highestCount, boolean higherEq) {
            super(modifier, qType);
            this.mLowestCount = lowestCount;
            this.mLowerEq = lowerEq;
            this.mHighestCount = highestCount;
            this.mHigherEq = higherEq;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "ConvCount(" + (this.mLowerEq ? ">=" : ">") + this.mLowestCount + " " + (this.mHigherEq ? "<=" : "<") + this.mHighestCount + ")";
        }

        protected QueryOperation getQueryOperation(boolean truthiness) {
            DBQueryOperation op = DBQueryOperation.Create();
            truthiness = this.calcTruth(truthiness);
            op.addConvCountClause(this.mLowestCount, this.mLowerEq, this.mHighestCount, this.mHigherEq, truthiness);
            return op;
        }

        public static BaseQuery create(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String str) throws ServiceException {
            if (str.charAt(0) == '<') {
                boolean eq = false;
                if (str.charAt(1) == '=') {
                    eq = true;
                    str = str.substring(2);
                } else {
                    str = str.substring(1);
                }
                int num = Integer.parseInt(str);
                return new ConvCountQuery(mbox, analyzer, modifier, qType, -1, false, num, eq);
            }
            if (str.charAt(0) == '>') {
                boolean eq = false;
                if (str.charAt(1) == '=') {
                    eq = true;
                    str = str.substring(2);
                } else {
                    str = str.substring(1);
                }
                int num = Integer.parseInt(str);
                return new ConvCountQuery(mbox, analyzer, modifier, qType, num, eq, -1, false);
            }
            int num = Integer.parseInt(str);
            return new ConvCountQuery(mbox, analyzer, modifier, qType, num, true, num, true);
        }
    }

    public static class SenderQuery
    extends BaseQuery {
        private String mStr;
        private boolean mLt;
        private boolean mEq;

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation op = DBQueryOperation.Create();
            truth = this.calcTruth(truth);
            if (this.mLt) {
                op.addRelativeSender(null, false, this.mStr, this.mEq, truth);
            } else {
                op.addRelativeSender(this.mStr, this.mEq, null, false, truth);
            }
            return op;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "Sender(";
        }

        private SenderQuery(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String text) throws ServiceException {
            super(modifier, qType);
            this.mLt = text.charAt(0) == '<';
            this.mEq = false;
            this.mStr = text.substring(1);
            if (this.mStr.charAt(0) == '=') {
                this.mEq = true;
                this.mStr = this.mStr.substring(1);
            }
        }

        public static BaseQuery create(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String text) throws ServiceException {
            if (text.length() > 1 && (text.startsWith("<") || text.startsWith(">"))) {
                return new SenderQuery(mbox, analyzer, modifier, qType, text);
            }
            return new TextQuery(mbox, analyzer, modifier, qType, text);
        }
    }

    public static class TypeQuery
    extends AttachmentQuery {
        public TypeQuery(Mailbox mbox, Analyzer analyzer, int modifier, String what) {
            super(mbox, modifier, "type", what);
        }
    }

    public static class TextQuery
    extends BaseQuery {
        private ArrayList<String> mTokens;
        private LinkedList<String> mOredTokens;
        private String mWildcardTerm;
        private String mOrigText;
        private List<QueryInfo> mQueryInfo = new ArrayList<QueryInfo>();
        private Mailbox mMailbox;
        private static final int MAX_WILDCARD_TERMS = LC.zimbra_index_wildcard_max_terms_expanded.intValue();

        public TextQuery(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String text) throws ServiceException {
            super(modifier, qType);
            if (mbox == null) {
                throw new IllegalArgumentException("Must not pass a null mailbox into TextQuery constructor");
            }
            this.mMailbox = mbox;
            this.mOredTokens = new LinkedList();
            this.mTokens = new ArrayList(1);
            this.mWildcardTerm = null;
            if (text.charAt(text.length() - 1) != '*' || qType != 22 && qType != 24 && qType != 23) {
                TokenStream source = analyzer.tokenStream(ZimbraQuery.QueryTypeString(qType), new StringReader(text));
                while (true) {
                    org.apache.lucene.analysis.Token t;
                    try {
                        t = source.next();
                    }
                    catch (IOException e) {
                        t = null;
                    }
                    if (t == null) break;
                    this.mTokens.add(t.termText());
                }
                try {
                    source.close();
                }
                catch (IOException e) {}
            } else {
                this.mTokens.add(text);
            }
            if (qType == 21 && this.mTokens.size() <= 1 && text.length() > 0 && text.charAt(text.length() - 1) != '*' && !text.equals(".")) {
                text = text + '*';
            }
            this.mOrigText = text;
            if (text.length() > 0 && text.charAt(text.length() - 1) == '*') {
                String wcToken = this.mTokens.size() > 0 ? this.mTokens.remove(this.mTokens.size() - 1) : text;
                if (wcToken.charAt(wcToken.length() - 1) == '*') {
                    wcToken = wcToken.substring(0, wcToken.length() - 1);
                }
                if (wcToken.length() > 0) {
                    this.mWildcardTerm = wcToken;
                    MailboxIndex mbidx = mbox.getMailboxIndex();
                    ArrayList<String> expandedTokens = new ArrayList<String>(100);
                    boolean expandedAllTokens = false;
                    if (mbidx != null) {
                        expandedAllTokens = mbidx.expandWildcardToken(expandedTokens, ZimbraQuery.QueryTypeString(qType), wcToken, MAX_WILDCARD_TERMS);
                    }
                    this.mQueryInfo.add(new WildcardExpansionQueryInfo(wcToken + "*", expandedTokens.size(), expandedAllTokens));
                    if (expandedTokens.size() == 0 || !expandedAllTokens) {
                        this.mTokens.add(wcToken);
                    } else {
                        for (String token : expandedTokens) {
                            this.mOredTokens.add(token);
                        }
                    }
                }
            }
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            if (this.mTokens.size() <= 0 && this.mOredTokens.size() <= 0) {
                return new NoTermQueryOperation();
            }
            if (this.mMailbox.getMailboxIndex() == null) {
                return new NoTermQueryOperation();
            }
            TextQueryOperation lop = this.mMailbox.getMailboxIndex().createTextQueryOperation();
            for (QueryInfo inf : this.mQueryInfo) {
                lop.addQueryInfo(inf);
            }
            String fieldName = ZimbraQuery.QueryTypeString(this.getQueryType());
            if (this.mTokens.size() == 0) {
                lop.setQueryString(this.getQueryOperatorString() + this.mOrigText);
            } else if (this.mTokens.size() == 1) {
                TermQuery q = null;
                String queryTerm = this.mTokens.get(0);
                q = new TermQuery(new Term(fieldName, queryTerm));
                lop.addClause(this.getQueryOperatorString() + this.mOrigText, q, this.calcTruth(truth));
            } else if (this.mTokens.size() > 1) {
                PhraseQuery p = new PhraseQuery();
                p.setSlop(0);
                for (int i = 0; i < this.mTokens.size(); ++i) {
                    p.add(new Term(fieldName, this.mTokens.get(i)));
                }
                String qos = this.getQueryOperatorString();
                lop.addClause(qos + this.mOrigText, p, this.calcTruth(truth));
            }
            if (this.mOredTokens.size() > 0) {
                BooleanQuery orQuery = new BooleanQuery();
                for (String token : this.mOredTokens) {
                    orQuery.add(new TermQuery(new Term(fieldName, token)), BooleanClause.Occur.SHOULD);
                }
                lop.addClause("", orQuery, this.calcTruth(truth));
            }
            return lop;
        }

        public String toString(int expLevel) {
            String ret = super.toString(expLevel) + ",";
            for (int i = 0; i < this.mTokens.size(); ++i) {
                ret = ret + "," + this.mTokens.get(i).toString();
            }
            if (this.mWildcardTerm != null) {
                ret = ret + " WILDCARD=" + this.mWildcardTerm + " [" + this.mOredTokens.size() + " terms]";
            }
            return ret + ")";
        }
    }

    public static class FieldQuery {
        public static TextQuery Create(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String targetImg, String text) throws ServiceException {
            int open = targetImg.indexOf(91);
            if (open >= 0) {
                String fieldName = null;
                int close = targetImg.indexOf(93);
                if (close >= 0 && close > open) {
                    fieldName = targetImg.substring(open + 1, close);
                    System.out.println("Field is: \"" + fieldName + "\"");
                }
                text = fieldName + ":" + text;
            } else if (targetImg.charAt(0) == '#') {
                String fieldName = targetImg.substring(1);
                text = fieldName + text;
            }
            return new TextQuery(mbox, analyzer, modifier, qType, text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemQuery
    extends BaseQuery {
        private boolean mIsAllQuery;
        private boolean mIsNoneQuery;
        private List<ItemId> mItemIds;
        private Mailbox mMailbox;

        public static BaseQuery Create(Mailbox mbox, Analyzer analyzer, int modifier, String str) throws ServiceException {
            boolean allQuery = false;
            boolean noneQuery = false;
            ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
            if (str.equalsIgnoreCase("all")) {
                allQuery = true;
            } else if (str.equalsIgnoreCase("none")) {
                noneQuery = true;
            } else {
                String[] items = str.split(",");
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].length() <= 0) continue;
                    ItemId iid = new ItemId(items[i], mbox.getAccountId());
                    itemIds.add(iid);
                }
                if (itemIds.size() == 0) {
                    noneQuery = true;
                }
            }
            return new ItemQuery(mbox, analyzer, modifier, allQuery, noneQuery, itemIds);
        }

        ItemQuery(Mailbox mbox, Analyzer analyzer, int modifier, boolean all, boolean none, List<ItemId> ids) {
            super(modifier, 67);
            this.mIsAllQuery = all;
            this.mIsNoneQuery = none;
            this.mItemIds = ids;
            this.mMailbox = mbox;
        }

        @Override
        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation dbOp = DBQueryOperation.Create();
            if (!((truth = this.calcTruth(truth)) && this.mIsAllQuery || !truth && this.mIsNoneQuery)) {
                if (truth && this.mIsNoneQuery || !truth && this.mIsAllQuery) {
                    return new NoResultsQueryOperation();
                }
                for (ItemId iid : this.mItemIds) {
                    dbOp.addItemIdClause(this.mMailbox, iid, truth);
                }
            }
            return dbOp;
        }

        @Override
        public String toString(int expLevel) {
            StringBuffer toRet = new StringBuffer(super.toString(expLevel));
            if (this.mIsAllQuery) {
                toRet.append(",all");
            } else if (this.mIsNoneQuery) {
                toRet.append(",none");
            } else {
                for (ItemId cur : this.mItemIds) {
                    toRet.append("," + cur.toString());
                }
            }
            return toRet.toString();
        }
    }

    public static class TagQuery
    extends BaseQuery {
        private Tag mTag = null;

        public TagQuery(Mailbox mailbox, Analyzer analyzer, int modifier, String name, boolean truth) throws ServiceException {
            super(modifier, 50);
            this.mTag = mailbox.getTagByName(name);
            this.mTruth = truth;
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation dbOp = DBQueryOperation.Create();
            dbOp.addTagClause(this.mTag, this.calcTruth(truth));
            return dbOp;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "," + this.mTag + ")";
        }
    }

    public static class MeQuery
    extends SubQuery {
        protected MeQuery(Analyzer analyzer, int modifier, AbstractList exp) {
            super(analyzer, modifier, exp);
        }

        public static BaseQuery create(Mailbox mbox, Analyzer analyzer, int modifier, int operatorBitmask) throws ServiceException {
            String[] aliases;
            ArrayList<BaseQuery> clauses = new ArrayList<BaseQuery>();
            Account acct = mbox.getAccount();
            boolean atFirst = true;
            if ((operatorBitmask & 1) != 0) {
                clauses.add(new SentQuery(mbox, analyzer, modifier, true));
                atFirst = false;
            }
            if ((operatorBitmask & 2) != 0) {
                if (atFirst) {
                    atFirst = false;
                } else {
                    clauses.add(new ConjQuery(analyzer, 5));
                }
                clauses.add(new TextQuery(mbox, analyzer, modifier, 22, acct.getName()));
            }
            if ((operatorBitmask & 4) != 0) {
                if (atFirst) {
                    atFirst = false;
                } else {
                    clauses.add(new ConjQuery(analyzer, 5));
                }
                clauses.add(new TextQuery(mbox, analyzer, modifier, 24, acct.getName()));
            }
            for (String alias : aliases = acct.getMailAlias()) {
                if ((operatorBitmask & 2) != 0) {
                    if (atFirst) {
                        atFirst = false;
                    } else {
                        clauses.add(new ConjQuery(analyzer, 5));
                    }
                    clauses.add(new TextQuery(mbox, analyzer, modifier, 22, alias));
                }
                if ((operatorBitmask & 4) == 0) continue;
                if (atFirst) {
                    atFirst = false;
                } else {
                    clauses.add(new ConjQuery(analyzer, 5));
                }
                clauses.add(new TextQuery(mbox, analyzer, modifier, 24, alias));
            }
            return new MeQuery(analyzer, modifier, clauses);
        }
    }

    public static class AddrQuery
    extends SubQuery {
        protected AddrQuery(Analyzer analyzer, int modifier, AbstractList exp) {
            super(analyzer, modifier, exp);
        }

        public static BaseQuery createFromTarget(Mailbox mbox, Analyzer analyzer, int modifier, int target, String text) throws ServiceException {
            int bitmask = 0;
            switch (target) {
                case 25: {
                    bitmask = 3;
                    break;
                }
                case 26: {
                    bitmask = 6;
                    break;
                }
                case 27: {
                    bitmask = 5;
                    break;
                }
                case 28: {
                    bitmask = 7;
                }
            }
            return AddrQuery.createFromBitmask(mbox, analyzer, modifier, text, bitmask);
        }

        public static BaseQuery createFromBitmask(Mailbox mbox, Analyzer analyzer, int modifier, String text, int operatorBitmask) throws ServiceException {
            ArrayList<BaseQuery> clauses = new ArrayList<BaseQuery>();
            boolean atFirst = true;
            if ((operatorBitmask & 1) != 0) {
                clauses.add(new TextQuery(mbox, analyzer, modifier, 23, text));
                atFirst = false;
            }
            if ((operatorBitmask & 2) != 0) {
                if (atFirst) {
                    atFirst = false;
                } else {
                    clauses.add(new ConjQuery(analyzer, 5));
                }
                clauses.add(new TextQuery(mbox, analyzer, modifier, 22, text));
            }
            if ((operatorBitmask & 4) != 0) {
                if (atFirst) {
                    atFirst = false;
                } else {
                    clauses.add(new ConjQuery(analyzer, 5));
                }
                clauses.add(new TextQuery(mbox, analyzer, modifier, 24, text));
            }
            return new AddrQuery(analyzer, modifier, clauses);
        }
    }

    public static class SubQuery
    extends BaseQuery {
        private AbstractList mSubClauses;

        public SubQuery(Analyzer analyzer, int modifier, AbstractList exp) {
            super(modifier, 9999);
            this.mSubClauses = exp;
        }

        protected BaseQuery getSubClauseHead() {
            return (BaseQuery)this.mSubClauses.get(0);
        }

        AbstractList getSubClauses() {
            return this.mSubClauses;
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            assert (false);
            return null;
        }

        public String toString(int expLevel) {
            String ret = this.indent(expLevel) + this.modToString() + "( ";
            for (BaseQuery sub = (BaseQuery)this.mSubClauses.get(0); sub != null; sub = sub.getNext()) {
                ret = ret + sub.toString(expLevel + 1) + " ";
            }
            ret = ret + this.indent(expLevel) + " )";
            return ret;
        }
    }

    public static class ModseqQuery
    extends BaseQuery {
        private int mValue;
        private Operator mOp;

        public ModseqQuery(Mailbox mbox, Analyzer analyzer, int modifier, int target, String changeId) throws ParseException {
            super(modifier, target);
            if (changeId.charAt(0) == '<') {
                if (changeId.charAt(1) == '=') {
                    this.mOp = Operator.LTEQ;
                    changeId = changeId.substring(2);
                } else {
                    this.mOp = Operator.LT;
                    changeId = changeId.substring(1);
                }
            } else if (changeId.charAt(0) == '>') {
                if (changeId.charAt(1) == '=') {
                    this.mOp = Operator.GTEQ;
                    changeId = changeId.substring(2);
                } else {
                    this.mOp = Operator.GT;
                    changeId = changeId.substring(1);
                }
            } else {
                this.mOp = Operator.EQ;
            }
            this.mValue = Integer.parseInt(changeId);
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation op = DBQueryOperation.Create();
            truth = this.calcTruth(truth);
            long highest = -1L;
            long lowest = -1L;
            boolean lowestEq = false;
            boolean highestEq = false;
            switch (this.mOp) {
                case EQ: {
                    highest = this.mValue;
                    lowest = this.mValue;
                    highestEq = true;
                    lowestEq = true;
                    break;
                }
                case GT: {
                    lowest = this.mValue;
                    break;
                }
                case GTEQ: {
                    lowest = this.mValue;
                    lowestEq = true;
                    break;
                }
                case LT: {
                    highest = this.mValue;
                    break;
                }
                case LTEQ: {
                    highest = this.mValue;
                    highestEq = true;
                }
            }
            op.addModSeqClause(lowest, lowestEq, highest, highestEq, truth);
            return op;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "," + (Object)((Object)this.mOp) + " " + this.mValue + ")";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Operator {
            EQ,
            GT,
            GTEQ,
            LT,
            LTEQ;

        }
    }

    public static class SizeQuery
    extends BaseQuery {
        private String mSizeStr;
        private long mSize;

        public SizeQuery(Analyzer analyzer, int modifier, int target, String size) throws ParseException {
            super(modifier, target);
            boolean hasEQ = false;
            this.mSizeStr = size;
            char ch = this.mSizeStr.charAt(0);
            if (ch == '>') {
                this.setQueryType(46);
                this.mSizeStr = this.mSizeStr.substring(1);
            } else if (ch == '<') {
                this.setQueryType(49);
                this.mSizeStr = this.mSizeStr.substring(1);
            }
            ch = this.mSizeStr.charAt(0);
            if (ch == '=') {
                this.mSizeStr = this.mSizeStr.substring(1);
                hasEQ = true;
            }
            char typeChar = '\u0000';
            typeChar = Character.toLowerCase(this.mSizeStr.charAt(this.mSizeStr.length() - 1));
            if (typeChar == 'b') {
                this.mSizeStr = this.mSizeStr.substring(0, this.mSizeStr.length() - 1);
                typeChar = Character.toLowerCase(this.mSizeStr.charAt(this.mSizeStr.length() - 1));
            }
            int multiplier = 1;
            switch (typeChar) {
                case 'k': {
                    multiplier = 1024;
                    break;
                }
                case 'm': {
                    multiplier = 0x100000;
                }
            }
            if (multiplier > 1) {
                this.mSizeStr = this.mSizeStr.substring(0, this.mSizeStr.length() - 1);
            }
            this.mSize = Integer.parseInt(this.mSizeStr) * multiplier;
            if (hasEQ) {
                if (this.getQueryType() == 46) {
                    --this.mSize;
                } else if (this.getQueryType() == 49) {
                    ++this.mSize;
                }
            }
            this.mSizeStr = ZimbraAnalyzer.SizeTokenFilter.encodeSize(this.mSize);
            if (this.mSizeStr == null) {
                this.mSizeStr = "";
            }
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation op = DBQueryOperation.Create();
            truth = this.calcTruth(truth);
            long highest = -1L;
            long lowest = -1L;
            switch (this.getQueryType()) {
                case 46: {
                    highest = -1L;
                    lowest = this.mSize;
                    break;
                }
                case 49: {
                    highest = this.mSize;
                    lowest = -1L;
                    break;
                }
                case 45: {
                    highest = this.mSize + 1L;
                    lowest = this.mSize - 1L;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            op.addSizeClause(lowest, highest, truth);
            return op;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "," + this.mSize + ")";
        }
    }

    public static class SentQuery
    extends TagQuery {
        public SentQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Sent", truth);
        }

        public String toString(int expLevel) {
            if (this.mTruth) {
                return super.toString(expLevel) + ",SENT)";
            }
            return super.toString(expLevel) + ",RECEIVED)";
        }
    }

    public static class IsInviteQuery
    extends TagQuery {
        public IsInviteQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Invite", truth);
        }

        public String toString(int expLevel) {
            if (this.mTruth) {
                return super.toString(expLevel) + ",INVITE)";
            }
            return super.toString(expLevel) + ",NOT_INVITE)";
        }
    }

    public static class RepliedQuery
    extends TagQuery {
        public RepliedQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Answered", truth);
        }

        public String toString(int expLevel) {
            if (this.mTruth) {
                return super.toString(expLevel) + ",REPLIED)";
            }
            return super.toString(expLevel) + ",UNREPLIED)";
        }
    }

    public static class ReadQuery
    extends TagQuery {
        public ReadQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Unread", !truth);
        }

        public String toString(int expLevel) {
            if (!this.mTruth) {
                return super.toString(expLevel) + ",READ)";
            }
            return super.toString(expLevel) + ",UNREAD)";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LuceneTableQuery
    extends BaseQuery {
        private Mailbox mMailbox;
        private String mLuceneField;
        private String mValue;

        protected static void addMapping(HashMap<String, String> map, String[] array, String value) {
            for (int i = array.length - 1; i >= 0; --i) {
                map.put(array[i], value);
            }
        }

        protected static String lookup(HashMap map, String key) {
            String toRet = (String)map.get(key);
            if (toRet == null) {
                return key;
            }
            return toRet;
        }

        public LuceneTableQuery(Mailbox mbox, int modifier, int target, String luceneField, String value) {
            super(modifier, target);
            this.mMailbox = mbox;
            this.mLuceneField = luceneField;
            this.mValue = value;
        }

        @Override
        protected QueryOperation getQueryOperation(boolean truth) {
            TextQueryOperation op = this.mMailbox.getMailboxIndex().createTextQueryOperation();
            TermQuery q = null;
            if (this.mValue != null) {
                q = new TermQuery(new Term(this.mLuceneField, this.mValue));
            }
            op.addClause(this.getQueryOperatorString() + this.mValue, q, this.calcTruth(truth));
            return op;
        }

        @Override
        public String toString(int expLevel) {
            return super.toString(expLevel) + "," + this.mLuceneField + ":" + this.mValue + ")";
        }
    }

    public static class InQuery
    extends BaseQuery {
        public static final Integer IN_ANY_FOLDER = new Integer(-2);
        public static final Integer IN_LOCAL_FOLDER = new Integer(-3);
        public static final Integer IN_REMOTE_FOLDER = new Integer(-4);
        public static final Integer IN_NO_FOLDER = new Integer(-5);
        private Folder mFolder;
        private ItemId mRemoteId = null;
        private String mSubfolderPath = null;
        private Integer mSpecialTarget = null;
        private boolean mIncludeSubfolders = false;

        public static BaseQuery Create(Mailbox mailbox, Analyzer analyzer, int modifier, Integer folderId, boolean includeSubfolders) throws ServiceException {
            if (folderId < 0) {
                InQuery toRet = new InQuery(mailbox, null, null, null, folderId, includeSubfolders, analyzer, modifier);
                return toRet;
            }
            Folder folder = mailbox.getFolderById(null, folderId);
            InQuery toRet = new InQuery(mailbox, folder, null, null, null, includeSubfolders, analyzer, modifier);
            return toRet;
        }

        public static BaseQuery Create(Mailbox mailbox, Analyzer analyzer, int modifier, String folderName, boolean includeSubfolders) throws ServiceException {
            Pair<Folder, String> result = mailbox.getFolderByPathLongestMatch(null, 1, folderName);
            return InQuery.recursiveResolve(mailbox, analyzer, modifier, result.getFirst(), result.getSecond(), includeSubfolders);
        }

        public static BaseQuery Create(Mailbox mailbox, Analyzer analyzer, int modifier, ItemId iid, String subfolderPath, boolean includeSubfolders) throws ServiceException {
            Pair<Folder, String> result;
            if (!iid.belongsTo(mailbox)) {
                InQuery toRet = new InQuery(mailbox, null, iid, subfolderPath, null, includeSubfolders, analyzer, modifier);
                return toRet;
            }
            if (subfolderPath != null && subfolderPath.length() > 0) {
                result = mailbox.getFolderByPathLongestMatch(null, iid.getId(), subfolderPath);
            } else {
                Folder f = mailbox.getFolderById(null, iid.getId());
                result = new Pair<Folder, Object>(f, null);
            }
            return InQuery.recursiveResolve(mailbox, analyzer, modifier, result.getFirst(), result.getSecond(), includeSubfolders);
        }

        private static BaseQuery recursiveResolve(Mailbox mailbox, Analyzer analyzer, int modifier, Folder baseFolder, String subfolderPath, boolean includeSubfolders) throws ServiceException {
            if (!(baseFolder instanceof Mountpoint)) {
                if (subfolderPath != null) {
                    throw MailServiceException.NO_SUCH_FOLDER(baseFolder.getPath() + "/" + subfolderPath);
                }
                InQuery toRet = new InQuery(mailbox, baseFolder, null, null, null, includeSubfolders, analyzer, modifier);
                return toRet;
            }
            Mountpoint mpt = (Mountpoint)baseFolder;
            if (mpt.isLocal()) {
                if (subfolderPath == null || subfolderPath.length() == 0) {
                    InQuery toRet = new InQuery(mailbox, baseFolder, null, null, null, includeSubfolders, analyzer, modifier);
                    return toRet;
                }
                Folder newBase = mailbox.getFolderById(null, mpt.getRemoteId());
                return InQuery.recursiveResolve(mailbox, analyzer, modifier, newBase, subfolderPath, includeSubfolders);
            }
            InQuery toRet = new InQuery(mailbox, null, mpt.getTarget(), subfolderPath, null, includeSubfolders, analyzer, modifier);
            return toRet;
        }

        private InQuery(Mailbox mailbox, Folder folder, ItemId remoteId, String subfolderPath, Integer specialTarget, boolean includeSubfolders, Analyzer analyzer, int modifier) {
            super(modifier, 29);
            this.mFolder = folder;
            this.mRemoteId = remoteId;
            this.mSubfolderPath = subfolderPath;
            this.mSpecialTarget = specialTarget;
            this.mIncludeSubfolders = includeSubfolders;
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            if (this.mSpecialTarget != null) {
                if (this.mSpecialTarget == IN_NO_FOLDER) {
                    return new NoResultsQueryOperation();
                }
                if (this.mSpecialTarget == IN_ANY_FOLDER) {
                    DBQueryOperation dbOp = DBQueryOperation.Create();
                    dbOp.addAnyFolderClause(this.calcTruth(truth));
                    return dbOp;
                }
                if (this.calcTruth(truth)) {
                    if (this.mSpecialTarget == IN_REMOTE_FOLDER) {
                        DBQueryOperation dbop = new DBQueryOperation();
                        dbop.addIsRemoteClause();
                        return dbop;
                    }
                    assert (this.mSpecialTarget == IN_LOCAL_FOLDER);
                    DBQueryOperation dbop = new DBQueryOperation();
                    dbop.addIsLocalClause();
                    return dbop;
                }
                if (this.mSpecialTarget == IN_REMOTE_FOLDER) {
                    DBQueryOperation dbop = new DBQueryOperation();
                    dbop.addIsLocalClause();
                    return dbop;
                }
                assert (this.mSpecialTarget == IN_LOCAL_FOLDER);
                DBQueryOperation dbop = new DBQueryOperation();
                dbop.addIsRemoteClause();
                return dbop;
            }
            DBQueryOperation dbOp = DBQueryOperation.Create();
            if (this.mFolder != null) {
                if (this.mIncludeSubfolders) {
                    List<Folder> subFolders = this.mFolder.getSubfolderHierarchy();
                    if (this.calcTruth(truth)) {
                        UnionQueryOperation union = new UnionQueryOperation();
                        for (Folder f : subFolders) {
                            DBQueryOperation dbop = new DBQueryOperation();
                            union.add(dbop);
                            if (f instanceof Mountpoint) {
                                Mountpoint mpt = (Mountpoint)f;
                                if (mpt.isLocal()) continue;
                                dbop.addInRemoteFolderClause(mpt.getTarget(), "", this.mIncludeSubfolders, this.calcTruth(truth));
                                continue;
                            }
                            dbop.addInClause(f, this.calcTruth(truth));
                        }
                        return union;
                    }
                    IntersectionQueryOperation iop = new IntersectionQueryOperation();
                    for (Folder f : subFolders) {
                        DBQueryOperation dbop = new DBQueryOperation();
                        iop.addQueryOp(dbop);
                        if (f instanceof Mountpoint) {
                            Mountpoint mpt = (Mountpoint)f;
                            if (mpt.isLocal()) continue;
                            dbop.addInRemoteFolderClause(mpt.getTarget(), "", this.mIncludeSubfolders, this.calcTruth(truth));
                            continue;
                        }
                        dbop.addInClause(f, this.calcTruth(truth));
                    }
                    return iop;
                }
                dbOp.addInClause(this.mFolder, this.calcTruth(truth));
            } else if (this.mRemoteId != null) {
                dbOp.addInRemoteFolderClause(this.mRemoteId, this.mSubfolderPath, this.mIncludeSubfolders, this.calcTruth(truth));
            } else assert (false);
            return dbOp;
        }

        public String toString(int expLevel) {
            if (this.mSpecialTarget != null) {
                String toRet = !this.mIncludeSubfolders ? super.toString(expLevel) + ",IN:" : super.toString(expLevel) + ",UNDER:";
                if (this.mSpecialTarget == IN_ANY_FOLDER) {
                    toRet = toRet + "ANY_FOLDER";
                } else if (this.mSpecialTarget == IN_LOCAL_FOLDER) {
                    toRet = toRet + "LOCAL";
                } else if (this.mSpecialTarget == IN_REMOTE_FOLDER) {
                    toRet = toRet + "REMOTE";
                }
                return toRet;
            }
            return super.toString(expLevel) + "," + (this.mIncludeSubfolders ? "UNDER" : "IN") + ":" + (this.mRemoteId != null ? this.mRemoteId.toString() : (this.mFolder != null ? this.mFolder.getName() : "ANY_FOLDER")) + (this.mSubfolderPath != null ? "/" + this.mSubfolderPath : "") + ")";
        }
    }

    public static class HasQuery
    extends LuceneTableQuery {
        protected static HashMap<String, String> mMap = new HashMap();

        public HasQuery(Mailbox mbox, Analyzer analyzer, int modifier, String what) {
            super(mbox, modifier, 33, "has", HasQuery.lookup(mMap, what));
        }

        static {
            HasQuery.addMapping(mMap, new String[]{"attachment", "att"}, "any");
            HasQuery.addMapping(mMap, new String[]{"phone"}, "phone");
            HasQuery.addMapping(mMap, new String[]{"u.po"}, "u.po");
            HasQuery.addMapping(mMap, new String[]{"ssn"}, "ssn");
            HasQuery.addMapping(mMap, new String[]{"url"}, "url");
        }
    }

    public static class ForwardedQuery
    extends TagQuery {
        public ForwardedQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Forwarded", truth);
        }

        public String toString(int expLevel) {
            if (this.mTruth) {
                return super.toString(expLevel) + ",FORWARDED)";
            }
            return super.toString(expLevel) + ",UNFORWARDED)";
        }
    }

    public static class FlaggedQuery
    extends TagQuery {
        public FlaggedQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Flagged", truth);
        }

        public String toString(int expLevel) {
            if (this.mTruth) {
                return super.toString(expLevel) + ",FLAGGED)";
            }
            return super.toString(expLevel) + ",UNFLAGGED)";
        }
    }

    public static class DraftQuery
    extends TagQuery {
        public DraftQuery(Mailbox mailbox, Analyzer analyzer, int modifier, boolean truth) throws ServiceException {
            super(mailbox, analyzer, modifier, "\\Draft", truth);
        }

        public String toString(int expLevel) {
            if (this.mTruth) {
                return super.toString(expLevel) + ",DRAFT)";
            }
            return super.toString(expLevel) + ",UNDRAFT)";
        }
    }

    public static class DomainQuery
    extends BaseQuery {
        private String mTarget;
        private Mailbox mMailbox;

        public DomainQuery(Mailbox mbox, Analyzer analyzer, int modifier, int qType, String target) {
            super(modifier, qType);
            this.mTarget = target;
            this.mMailbox = mbox;
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            TextQueryOperation op = this.mMailbox.getMailboxIndex().createTextQueryOperation();
            TermQuery q = new TermQuery(new Term(ZimbraQuery.QueryTypeString(this.getQueryType()), this.mTarget));
            op.addClause(this.getQueryOperatorString() + this.mTarget, q, this.calcTruth(truth));
            return op;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "-DOMAIN," + this.mTarget + ")";
        }
    }

    public static class DateQuery
    extends BaseQuery {
        private Date mDate = null;
        private Date mEndDate = null;
        private long mLowestTime;
        private boolean mLowerEq;
        private long mHighestTime;
        private boolean mHigherEq;
        protected static final String NUMERICDATE_PATTERN = "^([0-9]+)$";
        protected static final Pattern sNumericDatePattern = Pattern.compile("^([0-9]+)$");
        protected static final String RELDATE_PATTERN = "([+-])([0-9]+)([mhdwy][a-z]*)?";
        protected static final Pattern sRelDatePattern = Pattern.compile("([+-])([0-9]+)([mhdwy][a-z]*)?");

        public DateQuery(Analyzer analyzer, int qType) {
            super(0, qType);
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation op = DBQueryOperation.Create();
            truth = this.calcTruth(truth);
            if (this.getQueryType() == 60) {
                op.addCalStartDateClause(this.mLowestTime, this.mLowerEq, this.mHighestTime, this.mHigherEq, truth);
            } else if (this.getQueryType() == 61) {
                op.addCalEndDateClause(this.mLowestTime, this.mLowerEq, this.mHighestTime, this.mHigherEq, truth);
            } else {
                op.addDateClause(this.mLowestTime, this.mLowerEq, this.mHighestTime, this.mHigherEq, truth);
            }
            return op;
        }

        public static final ParseException parseException(String s, String code, Token t) throws ParseException {
            ParseException pe = new ParseException(s, code);
            pe.currentToken = t;
            return pe;
        }

        public void parseDate(int modifier, String s, Token tok, TimeZone tz, Locale locale) throws ParseException {
            this.mDate = null;
            this.mEndDate = null;
            this.mLowestTime = -1L;
            this.mHighestTime = -1L;
            boolean hasExplicitComparasins = false;
            boolean explicitLT = false;
            boolean explicitGT = false;
            boolean explicitEq = false;
            if (s.length() <= 0) {
                throw DateQuery.parseException("Invalid string in date query: \"\"", "INVALID_DATE", tok);
            }
            if (s.charAt(s.length() - 1) == ',') {
                s = s.substring(0, s.length() - 1);
            }
            if (s.length() <= 0) {
                throw DateQuery.parseException("Invalid string in date query after trimming trailing comma: \"\"", "INVALID_DATE", tok);
            }
            char ch = s.charAt(0);
            if (ch == '<' || ch == '>') {
                if (this.getQueryType() == 44 || this.getQueryType() == 43) {
                    throw DateQuery.parseException(">, <, >= and <= may not be specified with BEFORE or AFTER searches", "INVALID_DATE", tok);
                }
                hasExplicitComparasins = true;
                if (s.length() <= 1) {
                    throw DateQuery.parseException("Invalid string in date query: \"" + s + "\"", "INVALID_DATE", tok);
                }
                char ch2 = s.charAt(1);
                if (ch2 == '=' && s.length() <= 2) {
                    throw DateQuery.parseException("Invalid string in date query: \"" + s + "\"", "INVALID_DATE", tok);
                }
                if (ch == '<') {
                    explicitLT = true;
                } else if (ch == '>') {
                    explicitGT = true;
                }
                if (ch2 == '=') {
                    s = s.substring(2);
                    explicitEq = true;
                } else {
                    s = s.substring(1);
                }
            }
            if (s.length() <= 0) {
                throw DateQuery.parseException("Invalid string in date query: \"" + s + "\"", "INVALID_DATE", tok);
            }
            int origType = this.getQueryType();
            if (s.equalsIgnoreCase("today")) {
                s = "-0d";
            }
            if (s.equalsIgnoreCase("yesterday")) {
                s = "-1d";
            }
            int field = 0;
            switch (origType) {
                case 38: 
                case 39: 
                case 43: 
                case 44: 
                case 60: 
                case 61: {
                    field = 5;
                    break;
                }
                case 40: {
                    field = 3;
                    break;
                }
                case 41: {
                    field = 2;
                    break;
                }
                case 42: {
                    field = 1;
                }
            }
            String mod = null;
            Matcher m = sNumericDatePattern.matcher(s);
            if (m.lookingAt()) {
                long dateLong = Long.parseLong(s);
                this.mDate = new Date(dateLong);
                this.mEndDate = new Date(dateLong + 1000L);
            } else {
                m = sRelDatePattern.matcher(s);
                if (m.lookingAt()) {
                    mod = s.substring(m.start(1), m.end(1));
                    String reltime = s.substring(m.start(2), m.end(2));
                    if (m.start(3) != -1) {
                        String what = s.substring(m.start(3), m.end(3));
                        switch (what.charAt(0)) {
                            case 'm': {
                                field = 2;
                                if (what.length() <= 1 || what.charAt(1) != 'i') break;
                                field = 12;
                                break;
                            }
                            case 'h': {
                                field = 11;
                                break;
                            }
                            case 'd': {
                                field = 5;
                                break;
                            }
                            case 'w': {
                                field = 3;
                                break;
                            }
                            case 'y': {
                                field = 1;
                            }
                        }
                    }
                    GregorianCalendar cal = new GregorianCalendar();
                    if (tz != null) {
                        cal.setTimeZone(tz);
                    }
                    cal.setTime(new Date());
                    switch (field) {
                        case 1: {
                            cal.set(2, 0);
                        }
                        case 2: {
                            cal.set(5, 1);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            break;
                        }
                        case 3: {
                            cal.set(7, cal.getFirstDayOfWeek());
                        }
                        case 5: {
                            cal.set(11, 0);
                        }
                        case 10: 
                        case 11: {
                            cal.set(12, 0);
                        }
                        case 12: {
                            cal.set(13, 0);
                        }
                    }
                    int num = Integer.parseInt(reltime);
                    if (mod.equals("-")) {
                        num *= -1;
                    }
                    cal.add(field, num);
                    this.mDate = cal.getTime();
                    cal.add(field, 1);
                    this.mEndDate = cal.getTime();
                } else {
                    char first = s.charAt(0);
                    if (first == '-' || first == '+') {
                        s = s.substring(1);
                    }
                    DateFormat df = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3);
                    df.setLenient(false);
                    if (tz != null) {
                        df.setTimeZone(tz);
                    }
                    try {
                        this.mDate = df.parse(s);
                    }
                    catch (java.text.ParseException ex) {
                        throw DateQuery.parseException(ex.getLocalizedMessage(), "INVALID_DATE", tok);
                    }
                    Calendar cal = Calendar.getInstance();
                    if (tz != null) {
                        cal.setTimeZone(tz);
                    }
                    cal.setTime(this.mDate);
                    cal.add(field, 1);
                    this.mEndDate = cal.getTime();
                }
            }
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("Parsed date range to: (" + this.mDate.toString() + "-" + this.mEndDate.toString() + ")");
            }
            if (!hasExplicitComparasins) {
                switch (this.getQueryType()) {
                    case 44: {
                        explicitLT = true;
                        explicitEq = false;
                        break;
                    }
                    case 43: {
                        explicitGT = true;
                        explicitEq = false;
                        break;
                    }
                    case 38: 
                    case 41: 
                    case 42: 
                    case 60: 
                    case 61: {
                        explicitEq = true;
                    }
                }
            }
            if (explicitLT) {
                if (explicitEq) {
                    this.mLowestTime = -1L;
                    this.mLowerEq = false;
                    this.mHighestTime = this.mEndDate.getTime();
                    this.mHigherEq = false;
                } else {
                    this.mLowestTime = -1L;
                    this.mLowerEq = false;
                    this.mHighestTime = this.mDate.getTime();
                    this.mHigherEq = false;
                }
            } else if (explicitGT) {
                if (explicitEq) {
                    this.mLowestTime = this.mDate.getTime();
                    this.mLowerEq = true;
                    this.mHighestTime = -1L;
                    this.mHigherEq = false;
                } else {
                    this.mLowestTime = this.mEndDate.getTime();
                    this.mLowerEq = true;
                    this.mHighestTime = -1L;
                    this.mHigherEq = false;
                }
            } else {
                this.mLowestTime = this.mDate.getTime();
                this.mLowerEq = true;
                this.mHighestTime = this.mEndDate.getTime();
                this.mHigherEq = false;
            }
        }

        public String toString(int expLevel) {
            String str;
            switch (this.getQueryType()) {
                case 44: {
                    str = "BEFORE";
                    break;
                }
                case 43: {
                    str = "AFTER";
                    break;
                }
                case 38: {
                    str = "DATE";
                    break;
                }
                case 60: {
                    str = "APPT-START";
                    break;
                }
                case 61: {
                    str = "APPT-END";
                    break;
                }
                default: {
                    str = "ERROR";
                }
            }
            return super.toString(expLevel) + "," + str + "," + this.mDate.toString() + ")";
        }
    }

    public static class ConvQuery
    extends BaseQuery {
        private ItemId mConvId;
        private Mailbox mMailbox;

        private ConvQuery(Mailbox mbox, Analyzer analyzer, int modifier, ItemId convId) throws ServiceException {
            super(modifier, 54);
            this.mMailbox = mbox;
            this.mConvId = convId;
            if (this.mConvId.getId() < 0) {
                throw ServiceException.FAILURE("Illegal Negative ConvID: " + convId.toString() + ", use ItemQuery for virtual convs", null);
            }
        }

        public static BaseQuery create(Mailbox mbox, Analyzer analyzer, int modifier, String target) throws ServiceException {
            ItemId convId = new ItemId(target, mbox.getAccountId());
            if (convId.getId() < 0) {
                convId = new ItemId(convId.getAccountId(), -1 * convId.getId());
                ArrayList<ItemId> iidList = new ArrayList<ItemId>(1);
                iidList.add(convId);
                return new ItemQuery(mbox, analyzer, modifier, false, false, iidList);
            }
            return new ConvQuery(mbox, analyzer, modifier, convId);
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            DBQueryOperation op = DBQueryOperation.Create();
            op.addConvId(this.mMailbox, this.mConvId, this.calcTruth(truth));
            return op;
        }

        public String toString(int expLevel) {
            return super.toString(expLevel) + "," + this.mConvId + ")";
        }
    }

    public static class ConjQuery
    extends BaseQuery {
        private static final int AND = 4;
        private static final int OR = 5;
        int mOp;

        public ConjQuery(Analyzer analyzer, int qType) {
            super(0, qType);
        }

        final boolean isOr() {
            return this.getQueryType() == 5;
        }

        public String toString(int expLevel) {
            switch (this.getQueryType()) {
                case 4: {
                    return this.indent(expLevel) + "_AND_";
                }
                case 5: {
                    return this.indent(expLevel) + "_OR_";
                }
            }
            assert (false);
            return "";
        }

        protected QueryOperation getQueryOperation(boolean truth) {
            assert (false);
            return null;
        }
    }

    public static class AttachmentQuery
    extends LuceneTableQuery {
        protected static HashMap<String, String> mMap = new HashMap();

        public AttachmentQuery(Mailbox mbox, Analyzer analyzer, int modifier, String what) {
            super(mbox, modifier, 35, "attachment", AttachmentQuery.lookup(mMap, what));
        }

        protected AttachmentQuery(Mailbox mbox, int modifier, String luceneField, String what) {
            super(mbox, modifier, 35, luceneField, AttachmentQuery.lookup(mMap, what));
        }

        static {
            AttachmentQuery.addMapping(mMap, new String[]{"any"}, "any");
            AttachmentQuery.addMapping(mMap, new String[]{"application", "application/*"}, "application");
            AttachmentQuery.addMapping(mMap, new String[]{"bmp", "image/bmp"}, "image/bmp");
            AttachmentQuery.addMapping(mMap, new String[]{"gif", "image/gif"}, "image/gif");
            AttachmentQuery.addMapping(mMap, new String[]{"image", "image/*"}, "image");
            AttachmentQuery.addMapping(mMap, new String[]{"jpeg", "image/jpeg"}, "image/jpeg");
            AttachmentQuery.addMapping(mMap, new String[]{"excel", "application/vnd.ms-excel", "xls"}, "application/vnd.ms-excel");
            AttachmentQuery.addMapping(mMap, new String[]{"ppt", "application/vnd.ms-powerpoint"}, "application/vnd.ms-powerpoint");
            AttachmentQuery.addMapping(mMap, new String[]{"ms-tnef", "application/ms-tnef"}, "application/ms-tnef");
            AttachmentQuery.addMapping(mMap, new String[]{"word", "application/msword", "msword"}, "application/msword");
            AttachmentQuery.addMapping(mMap, new String[]{"none"}, "none");
            AttachmentQuery.addMapping(mMap, new String[]{"pdf", "application/pdf"}, "application/pdf");
            AttachmentQuery.addMapping(mMap, new String[]{"text", "text/*"}, "text");
        }
    }

    public static abstract class BaseQuery {
        protected boolean mTruth = true;
        private BaseQuery mNext = null;
        private int mModifierType;
        private int mQueryType;

        protected BaseQuery(int modifierType, int queryType) {
            this.mModifierType = modifierType;
            this.mQueryType = queryType;
        }

        protected final void setQueryType(int queryType) {
            this.mQueryType = queryType;
        }

        protected final int getQueryType() {
            return this.mQueryType;
        }

        public final BaseQuery getNext() {
            return this.mNext;
        }

        String getQueryOperatorString() {
            return unquotedTokenImage[this.mQueryType];
        }

        public final void setModifier(int mod) {
            this.mModifierType = mod;
        }

        public final void setNext(BaseQuery next) {
            this.mNext = next;
        }

        public String toString() {
            return this.toString(0);
        }

        public String toString(int expLevel) {
            return this.indent(expLevel) + this.modToString() + "Q(" + ZimbraQuery.QueryTypeString(this.getQueryType());
        }

        protected abstract QueryOperation getQueryOperation(boolean var1);

        protected final String indent(int level) {
            String ret = "";
            for (int i = 0; i < level; ++i) {
                ret = ret + "    ";
            }
            return ret;
        }

        boolean isNegated() {
            return this.mModifierType == 10;
        }

        protected final String modToString() {
            String modString = "";
            switch (this.mModifierType) {
                case 9: {
                    modString = "+";
                    break;
                }
                case 10: {
                    modString = "-";
                }
            }
            return modString;
        }

        protected final boolean calcTruth(boolean truth) {
            if (this.isNegated()) {
                return !truth;
            }
            return truth;
        }
    }
}

