/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.util.ItemId;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZimbraHit {
    protected Mailbox mMailbox;
    protected ZimbraQueryResultsImpl mResults;
    protected long mCachedDate = -1L;
    protected long mCachedSize = -1L;
    protected String mCachedName = null;
    protected String mCachedSubj = null;
    private float mScore = 1.0f;
    protected ImapMessage mCachedImapMessage = null;
    protected int mCachedModseq = -1;
    protected int mCachedParentId = 0;

    public ZimbraHit(ZimbraQueryResultsImpl results, Mailbox mbx, float score) {
        this.mMailbox = mbx;
        this.mResults = results;
        this.mScore = score;
    }

    public String getAcctIdStr() {
        if (this.mMailbox == null) {
            return "NULL_ACCOUNTID";
        }
        return this.mMailbox.getAccountId();
    }

    public String toString() {
        StringBuffer toRet = new StringBuffer("MB");
        toRet.append(this.getMailbox().getId());
        toRet.append(" ");
        try {
            toRet.append(this.getItemId());
            toRet.append("-\"");
            toRet.append(this.getName());
            toRet.append("\"-\"");
            toRet.append(this.getSubject());
            toRet.append("\"-\"");
            toRet.append(new Date(this.getDate()).toString());
            toRet.append("\"");
            toRet.append("\"-(");
            toRet.append(this.getDate());
            toRet.append(")");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return toRet.toString();
    }

    public Object getSortField(SortBy sortOrder) throws ServiceException {
        switch (sortOrder.getType()) {
            case NONE: {
                return "";
            }
            case DATE_ASCENDING: 
            case DATE_DESCENDING: {
                return this.getDate();
            }
            case SUBJ_ASCENDING: 
            case SUBJ_DESCENDING: {
                return this.getSubject().toUpperCase();
            }
            case NAME_ASCENDING: 
            case NAME_DESCENDING: 
            case NAME_LOCALIZED_ASCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                return this.getName().toUpperCase();
            }
            case SIZE_ASCENDING: 
            case SIZE_DESCENDING: {
                return this.getSize();
            }
            case SCORE_DESCENDING: {
                return Float.valueOf(this.getScore());
            }
            case TASK_DUE_ASCENDING: 
            case TASK_DUE_DESCENDING: 
            case TASK_STATUS_ASCENDING: 
            case TASK_STATUS_DESCENDING: 
            case TASK_PERCENT_COMPLETE_ASCENDING: 
            case TASK_PERCENT_COMPLETE_DESCENDING: {
                throw new IllegalArgumentException("Wrong hit type for hit " + this.toString() + " with sort order: " + sortOrder);
            }
        }
        throw new IllegalArgumentException("Unknown sort order: " + sortOrder);
    }

    public final float getScore() {
        return this.mScore;
    }

    public abstract int getItemId() throws ServiceException;

    public ItemId getParsedItemID() throws ServiceException {
        return new ItemId(this.mMailbox, this.getItemId());
    }

    final Mailbox getMailbox() {
        return this.mMailbox;
    }

    final ZimbraQueryResultsImpl getResults() {
        return this.mResults;
    }

    abstract long getDate() throws ServiceException;

    abstract long getSize() throws ServiceException;

    abstract int getConversationId() throws ServiceException;

    int compareBySortField(SortBy sortOrder, ZimbraHit other) throws ServiceException {
        long retVal = 0L;
        boolean dumpComp = false;
        switch (sortOrder.getType()) {
            case NONE: {
                throw new IllegalArgumentException("Illegal to use sort comparison on unsorted results");
            }
            case DATE_ASCENDING: {
                retVal = other.getDate() - this.getDate();
                break;
            }
            case DATE_DESCENDING: {
                retVal = this.getDate() - other.getDate();
                break;
            }
            case SUBJ_ASCENDING: {
                retVal = -1 * this.getSubject().toUpperCase().compareTo(other.getSubject().toUpperCase());
                break;
            }
            case SUBJ_DESCENDING: {
                retVal = this.getSubject().toUpperCase().compareTo(other.getSubject().toUpperCase());
                break;
            }
            case NAME_ASCENDING: 
            case NAME_LOCALIZED_ASCENDING: {
                retVal = -1 * this.getName().toUpperCase().compareTo(other.getName().toUpperCase());
                break;
            }
            case NAME_DESCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                retVal = this.getName().toUpperCase().compareTo(other.getName().toUpperCase());
                break;
            }
            case SIZE_ASCENDING: {
                retVal = other.getSize() - this.getSize();
                break;
            }
            case SIZE_DESCENDING: {
                retVal = other.getSize() - this.getSize();
                break;
            }
            case SCORE_DESCENDING: {
                retVal = (long)(10000.0f * (this.getScore() - other.getScore()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown sort order: " + sortOrder);
            }
        }
        if (retVal == 0L) {
            return 0;
        }
        if (retVal > 0L) {
            return -1;
        }
        return 1;
    }

    public abstract MailItem getMailItem() throws ServiceException;

    abstract void setItem(MailItem var1) throws ServiceException;

    abstract boolean itemIsLoaded() throws ServiceException;

    abstract String getSubject() throws ServiceException;

    abstract String getName() throws ServiceException;

    boolean isLocal() {
        return true;
    }

    public ImapMessage getImapMessage() throws ServiceException {
        if (this.mCachedImapMessage != null) {
            return this.mCachedImapMessage;
        }
        MailItem item = this.getMailItem();
        if (item == null) {
            return null;
        }
        this.mCachedImapMessage = new ImapMessage(item);
        return this.mCachedImapMessage;
    }

    public int getModifiedSequence() throws ServiceException {
        if (this.mCachedModseq > 0) {
            return this.mCachedModseq;
        }
        MailItem item = this.getMailItem();
        if (item == null) {
            return -1;
        }
        return item.getModifiedSequence();
    }

    public int getParentId() throws ServiceException {
        if (this.mCachedParentId != 0) {
            return this.mCachedParentId;
        }
        MailItem item = this.getMailItem();
        if (item == null) {
            return -1;
        }
        return item.getParentId();
    }

    protected final void updateScore(float score) {
        if (score > this.mScore) {
            this.mScore = score;
        }
    }

    final void cacheSortField(SortBy sortType, Object sortKey) {
        switch (sortType.getType()) {
            case DATE_ASCENDING: 
            case DATE_DESCENDING: {
                this.mCachedDate = (Long)sortKey;
                break;
            }
            case NAME_ASCENDING: 
            case NAME_DESCENDING: 
            case NAME_LOCALIZED_ASCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                this.mCachedName = (String)sortKey;
                break;
            }
            case SUBJ_ASCENDING: 
            case SUBJ_DESCENDING: {
                this.mCachedSubj = (String)sortKey;
                break;
            }
            case SIZE_ASCENDING: 
            case SIZE_DESCENDING: {
                this.mCachedSize = (Long)sortKey;
            }
        }
    }

    final void cacheImapMessage(ImapMessage i4msg) {
        this.mCachedImapMessage = i4msg;
    }

    final void cacheModifiedSequence(int modseq) {
        this.mCachedModseq = modseq;
    }

    final void cacheParentId(int parentId) {
        this.mCachedParentId = parentId;
    }

    static Comparator<ZimbraHit> getSortAndIdComparator(SortBy sortOrder) {
        return new ZimbraHitSortAndIdComparator(sortOrder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZimbraHitSortAndIdComparator
    implements Comparator<ZimbraHit> {
        SortBy mSortOrder;

        ZimbraHitSortAndIdComparator(SortBy sortOrder) {
            this.mSortOrder = sortOrder;
        }

        @Override
        public int compare(ZimbraHit lhs, ZimbraHit rhs) {
            try {
                int retVal = lhs.compareBySortField(this.mSortOrder, rhs);
                if (retVal == 0) {
                    int rhsId;
                    int lhsId = lhs.getItemId();
                    if (lhsId <= 0) {
                        lhsId = lhs.getConversationId();
                    }
                    if ((rhsId = rhs.getItemId()) <= 0) {
                        rhsId = rhs.getConversationId();
                    }
                    retVal = !this.mSortOrder.isDescending() ? lhsId - rhsId : rhsId - lhsId;
                }
                return retVal;
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

