/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class ZimbraAnalyzer
extends StandardAnalyzer {
    private static ZimbraAnalyzer sInstance = new ZimbraAnalyzer();
    private static HashMap<String, Analyzer> sAnalyzerMap = new HashMap();

    public static Analyzer getAnalyzer(String name) {
        Analyzer toRet = sAnalyzerMap.get(name);
        if (toRet == null) {
            return ZimbraAnalyzer.getDefaultAnalyzer();
        }
        return toRet;
    }

    public static Analyzer getDefaultAnalyzer() {
        return sInstance;
    }

    public static void registerAnalyzer(String name, Analyzer analyzer) throws ServiceException {
        if (sAnalyzerMap.containsKey(name)) {
            throw ServiceException.FAILURE("Cannot register analyzer: " + name + " because there is one already registered with that name.", null);
        }
        sAnalyzerMap.put(name, analyzer);
    }

    public static void unregisterAnalyzer(String name) {
        sAnalyzerMap.remove(name);
    }

    public static String getAllTokensConcatenated(String fieldName, String text) {
        StringReader reader = new StringReader(text);
        return ZimbraAnalyzer.getAllTokensConcatenated(fieldName, reader);
    }

    public static String getAllTokensConcatenated(String fieldName, Reader reader) {
        StringBuffer toReturn = new StringBuffer();
        TokenStream stream = sInstance.tokenStream(fieldName, reader);
        try {
            Token cur = stream.next();
            while (cur != null) {
                toReturn.append(cur.termText());
                toReturn.append(" ");
                cur = stream.next();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn.toString();
    }

    protected ZimbraAnalyzer() {
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (fieldName.equals("msg_id")) {
            return new DontTokenizer(reader);
        }
        if (fieldName.equals("l.field")) {
            return new FieldTokenStream(reader);
        }
        if (fieldName.equals("attachment") || fieldName.equals("type")) {
            return new MimeTypeTokenFilter(this.CommaSeparatedTokenStream(reader));
        }
        if (fieldName.equals("l.size")) {
            return new SizeTokenFilter(new NumberTokenStream(reader));
        }
        if (fieldName.equals("from") || fieldName.equals("to") || fieldName.equals("cc") || fieldName.equals("env_from") || fieldName.equals("env_to")) {
            return new AddressTokenFilter(new AddrCharTokenizer(reader));
        }
        if (fieldName.equals("filename")) {
            return new FilenameTokenizer(reader);
        }
        return super.tokenStream(fieldName, reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.tokenStream(fieldName, reader);
    }

    private TokenStream CommaSeparatedTokenStream(Reader reader) {
        return new CharTokenizer(reader){

            protected boolean isTokenChar(char c) {
                return c != ',';
            }

            protected char normalize(char c) {
                return Character.toLowerCase(c);
            }
        };
    }

    public static void main(String[] args) {
        MultiTokenFilter.sPrintNewTokens = true;
        ZimbraAnalyzer la = new ZimbraAnalyzer();
        String str = "DONOTREPLY@zimbra.com tim@foo.com \"Tester Address\" <test.address@mail.nnnn.com>, image/jpeg, text/plain, text/foo/bar, tim (tim@foo.com),bugzilla-daemon@eric.example.zimbra.com, zug zug [zug@gug.com], Foo.gub, \"My Mom\" <mmm@nnnn.com>,asd foo bar aaa/bbb ccc/ddd/eee fff@ggg.com hhh@iiii";
        System.out.print("AddressTokenFilter:\n-------------------------");
        StringReader reader = new StringReader(str);
        TokenStream filter1 = la.tokenStream("from", reader);
        Token tok = null;
        do {
            try {
                tok = filter1.next();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tok == null) continue;
            System.out.println("    " + tok.toString());
        } while (tok != null);
        String src = "\"Tim Brown\" <first@domain.com>";
        String concat = ZimbraAnalyzer.getAllTokensConcatenated("from", src);
        System.out.println("SRC=" + src + " OUT=\"" + concat + "\"");
        src = "dharma@fdharma.com";
        concat = ZimbraAnalyzer.getAllTokensConcatenated("from", src);
        System.out.println("SRC=" + src + " OUT=\"" + concat + "\"");
        System.out.print("\nATTACHMENTS: MimeTypeTokenFilter:\n-------------------------");
        reader = new StringReader(str);
        filter1 = la.tokenStream("attachment", reader);
        tok = null;
        do {
            try {
                tok = filter1.next();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tok == null) continue;
            System.out.println("    " + tok.termText());
        } while (tok != null);
        System.out.print("\nTYPE: MimeTypeTokenFilter:\n-------------------------");
        reader = new StringReader(str);
        filter1 = la.tokenStream("type", reader);
        tok = null;
        do {
            try {
                tok = filter1.next();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tok == null) continue;
            System.out.println("    " + tok.termText());
        } while (tok != null);
        str = "123 26 1000000 100000000 1,000,000,000 1,000,000,000,000,000";
        System.out.println("\nMimeTypeTokenFilter:\n-------------------------");
        reader = new StringReader(str);
        filter1 = la.tokenStream("l.size", reader);
        tok = null;
        do {
            try {
                tok = filter1.next();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tok == null) continue;
            System.out.println("    " + tok.termText());
        } while (tok != null);
        str = "test1:val1 val2 val3    val4-test\t  val5\r\n#test2:2val1 2val2:_123 2val3\ntest3:zzz\n#calendarItemClass:public";
        System.out.println("\nFieldTokenStream:\n-------------------------");
        reader = new StringReader(str);
        filter1 = la.tokenStream("l.field", reader);
        tok = null;
        do {
            try {
                tok = filter1.next();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tok == null) continue;
            System.out.println("    " + tok.termText());
        } while (tok != null);
        src = "This is my-filename.test.pdf";
        concat = ZimbraAnalyzer.getAllTokensConcatenated("filename", src);
        System.out.println("SRC=" + src + " OUT=\"" + concat + "\"");
    }

    public static class TestTokenStream
    extends TokenStream {
        int curPos;
        String[] mStringList;

        TestTokenStream(String[] stringlist) {
            this.mStringList = stringlist;
            this.curPos = 0;
        }

        public Token next() {
            ++this.curPos;
            if (this.curPos > this.mStringList.length) {
                return null;
            }
            return new Token(this.mStringList[this.curPos - 1], 0, this.mStringList[this.curPos].length());
        }
    }

    public static class MimeTypeTokenFilter
    extends MultiTokenFilter {
        MimeTypeTokenFilter(TokenFilter in) {
            super(in);
            this.init();
        }

        MimeTypeTokenFilter(TokenStream in) {
            super(in);
            this.init();
        }

        void init() {
            this.mMaxSplits = 1;
            this.mNoLastToken = true;
        }

        protected int getNextSplit(String s) {
            return s.indexOf("/");
        }
    }

    private static class AddrCharTokenizer
    extends CharTokenizer {
        public AddrCharTokenizer(Reader reader) {
            super(reader);
        }

        protected boolean isTokenChar(char c) {
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '<': 
                case '>': 
                case '[': 
                case ']': {
                    return false;
                }
            }
            return true;
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }
    }

    public static class FilenameTokenizer
    extends CharTokenizer {
        public FilenameTokenizer(Reader reader) {
            super(reader);
        }

        protected boolean isTokenChar(char c) {
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case '.': {
                    return false;
                }
            }
            return true;
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }
    }

    public static class AddressTokenFilter
    extends MultiTokenFilter {
        LinkedList<Token> mSplitStrings = null;

        AddressTokenFilter(TokenFilter in) {
            super(in);
            this.mIncludeSeparatorChar = true;
            this.mMaxSplits = 4;
        }

        AddressTokenFilter(TokenStream in) {
            super(in);
            this.mIncludeSeparatorChar = true;
            this.mMaxSplits = 4;
        }

        protected int getNextSplit(String s) {
            return s.indexOf("@");
        }

        public Token nextSplit() {
            if (this.mSplitStrings == null) {
                String[] rhsParts;
                this.mSplitStrings = new LinkedList();
                String termText = this.mCurToken.termText();
                String lhs = termText.substring(0, this.mNextSplitPos);
                String rhs = termText.substring(this.mNextSplitPos);
                String[] lhsParts = lhs.split("\\.");
                if (lhsParts.length > 1) {
                    for (String s : lhsParts) {
                        this.mSplitStrings.addLast(new Token(s, this.mCurToken.startOffset(), this.mCurToken.endOffset(), this.mCurToken.type()));
                    }
                }
                if ((rhsParts = rhs.split("\\.")).length > 1) {
                    this.mSplitStrings.addLast(new Token(rhsParts[rhsParts.length - 2], this.mCurToken.startOffset(), this.mCurToken.endOffset(), this.mCurToken.type()));
                }
                this.mSplitStrings.addLast(new Token(lhs, this.mCurToken.startOffset(), this.mCurToken.startOffset() + this.mNextSplitPos, this.mCurToken.type()));
                this.mSplitStrings.addLast(new Token(rhs, this.mCurToken.startOffset() + this.mNextSplitPos, this.mCurToken.endOffset(), this.mCurToken.type()));
                if (rhs.length() > 1) {
                    this.mSplitStrings.addLast(new Token(rhs.substring(1), this.mCurToken.startOffset() + this.mNextSplitPos, this.mCurToken.endOffset(), this.mCurToken.type()));
                }
            }
            ++this.mNumSplits;
            Token toRet = this.mSplitStrings.removeFirst();
            if (this.mSplitStrings.isEmpty()) {
                this.mSplitStrings = null;
                this.mCurToken = null;
            }
            return toRet;
        }
    }

    public static abstract class MultiTokenFilter
    extends TokenFilter {
        protected int mMaxSplits = 1;
        protected boolean mIncludeSeparatorChar = false;
        protected boolean mNoLastToken = false;
        Token mCurToken = null;
        protected int mNextSplitPos;
        protected int mNumSplits;
        public static boolean sPrintNewTokens = false;

        MultiTokenFilter(TokenStream in) {
            super(in);
        }

        MultiTokenFilter(TokenFilter in) {
            super(in);
        }

        protected abstract int getNextSplit(String var1);

        public Token nextInternal() throws IOException {
            if (this.mCurToken == null) {
                Token newTok = this.input.next();
                if (newTok == null) {
                    return null;
                }
                if (sPrintNewTokens) {
                    System.out.println("\nnew token: " + newTok.toString());
                }
                String termText = newTok.termText();
                this.mNextSplitPos = this.getNextSplit(termText);
                if (this.mNextSplitPos <= 0) {
                    return newTok;
                }
                this.mNumSplits = 0;
                this.mCurToken = new Token(termText, newTok.startOffset(), newTok.endOffset(), newTok.type());
                return newTok;
            }
            return this.nextSplit();
        }

        public Token nextSplit() {
            if (this.mNextSplitPos > 0 && this.mNumSplits < this.mMaxSplits) {
                ++this.mNumSplits;
                String termText = this.mCurToken.termText();
                String stringToRet = termText.substring(0, this.mNextSplitPos);
                Token tokenToReturn = new Token(stringToRet, this.mCurToken.startOffset(), this.mCurToken.startOffset() + this.mNextSplitPos, this.mCurToken.type());
                if (!this.mIncludeSeparatorChar) {
                    ++this.mNextSplitPos;
                }
                String secondPart = termText.substring(this.mNextSplitPos);
                if (this.mNumSplits < this.mMaxSplits) {
                    this.mNextSplitPos = this.getNextSplit(secondPart);
                }
                this.mCurToken = this.mNoLastToken ? null : new Token(secondPart, this.mCurToken.startOffset() + this.mNextSplitPos, this.mCurToken.endOffset(), this.mCurToken.type());
                return tokenToReturn;
            }
            Token toRet = this.mCurToken;
            this.mCurToken = null;
            return toRet;
        }

        public Token next() throws IOException {
            Token t;
            while ((t = this.nextInternal()) != null && t.termText().length() <= 1) {
            }
            return t;
        }
    }

    public static class SizeTokenFilter
    extends TokenFilter {
        SizeTokenFilter(TokenStream in) {
            super(in);
        }

        SizeTokenFilter(TokenFilter in) {
            super(in);
        }

        public static String encodeSize(String size) {
            return size;
        }

        public static String encodeSize(long lsize) {
            return Long.toString(lsize);
        }

        public static long decodeSize(String size) {
            return Long.parseLong(size);
        }

        public Token next() throws IOException {
            Token t = this.input.next();
            if (t == null) {
                return null;
            }
            String sizeFieldStr = SizeTokenFilter.encodeSize(t.termText());
            if (sizeFieldStr == null) {
                return this.next();
            }
            return new Token(sizeFieldStr.toString(), t.startOffset(), t.endOffset(), t.type());
        }
    }

    protected static class NumberTokenStream
    extends Tokenizer {
        protected Reader mReader;
        protected int mEndPos = 0;

        NumberTokenStream(Reader reader) {
            super(reader);
        }

        public Token next() throws IOException {
            int startPos = this.mEndPos;
            StringBuffer buf = new StringBuffer(10);
            while (true) {
                int c = this.input.read();
                ++this.mEndPos;
                switch (c) {
                    case -1: {
                        if (buf.length() == 0) {
                            return null;
                        }
                    }
                    case 9: 
                    case 32: {
                        if (buf.length() == 0) break;
                        String toRet = buf.toString();
                        return new Token(toRet, startPos, this.mEndPos - 1);
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        buf.append((char)c);
                        break;
                    }
                }
            }
        }
    }

    protected static class FieldTokenStream
    extends Tokenizer {
        int mOffset = 0;
        String mFieldName = null;
        List<Token> mValues = new ArrayList<Token>();
        protected static final char FIELD_SEPARATOR = ':';
        protected static final char EOL = '\n';
        StandardTokenizer mSt = null;

        public FieldTokenStream(Reader r) {
            super(r);
        }

        protected String stripFieldName(String fieldName) {
            return fieldName;
        }

        public Token next() throws IOException {
            while (this.mValues.size() == 0 || this.mFieldName == null || this.mFieldName.length() == 0) {
                if (this.bufferNextLine()) continue;
                if (this.mValues.size() != 0) break;
                return null;
            }
            return this.mValues.remove(0);
        }

        protected boolean isWhitespace(char ch) {
            switch (ch) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '[': 
                case ']': {
                    return true;
                }
            }
            return false;
        }

        protected void addCharToValue(StringBuilder val, char ch) {
            if (!Character.isISOControl(ch)) {
                val.append(Character.toLowerCase(ch));
            }
        }

        protected void addCharToFieldName(StringBuilder val, char ch) {
            if (ch == ':') {
                return;
            }
            if (!Character.isISOControl(ch)) {
                val.append(Character.toLowerCase(ch));
            }
        }

        protected void addToken(String curWord, int wordStart, int wordEnd) {
            if (this.mFieldName.length() > 0 && curWord.length() > 0) {
                String token = this.mFieldName + ":" + curWord;
                this.mValues.add(new Token(token, wordStart, wordEnd));
            }
        }

        protected boolean bufferNextLine() {
            int c = 0;
            this.mFieldName = null;
            this.mValues.clear();
            try {
                StringBuilder fieldName = new StringBuilder();
                while (this.mFieldName == null && (c = this.input.read()) >= 0) {
                    ++this.mOffset;
                    char ch = (char)c;
                    if (ch == ':') {
                        this.mFieldName = this.stripFieldName(fieldName.toString());
                    } else if (ch == '\n') {
                        return true;
                    }
                    this.addCharToFieldName(fieldName, ch);
                }
                if (c < 0) {
                    return false;
                }
                assert (this.mFieldName != null);
                StringBuilder curWord = new StringBuilder();
                int wordStart = this.mOffset;
                while (true) {
                    c = this.input.read();
                    ++this.mOffset;
                    if (c < 0) {
                        if (curWord.length() > 0) {
                            this.addToken(curWord.toString(), wordStart, this.mOffset);
                        }
                        return false;
                    }
                    char ch = (char)c;
                    if (this.isWhitespace(ch) || curWord.length() > 0 && ch == '-') {
                        if (curWord.length() <= 0) continue;
                        this.addToken(curWord.toString(), wordStart, this.mOffset);
                        curWord = new StringBuilder();
                        continue;
                    }
                    if (ch == '\n') {
                        if (curWord.length() > 0) {
                            this.addToken(curWord.toString(), wordStart, this.mOffset);
                        }
                        return true;
                    }
                    this.addCharToValue(curWord, ch);
                }
            }
            catch (IOException e) {
                this.mFieldName = null;
                this.mValues.clear();
                return false;
            }
        }
    }

    protected static class DontTokenizer
    extends CharTokenizer {
        DontTokenizer(Reader input) {
            super(input);
        }

        protected boolean isTokenChar(char c) {
            return true;
        }
    }
}

