/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.cs.stats.ZimbraPerf;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class Z23FSDirectory
extends FSDirectory {
    AtomicLong mBytesWritten = new AtomicLong();
    AtomicLong mBytesRead = new AtomicLong();

    long getBytesWritten() {
        return this.mBytesWritten.get();
    }

    void resetBytesWritten() {
        this.mBytesWritten.set(0L);
    }

    long getBytesRead() {
        return this.mBytesRead.get();
    }

    void resetBytesRead() {
        this.mBytesRead.set(0L);
    }

    public IndexOutput createOutput(String name) throws IOException {
        File file = new File(this.getFile(), name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    public IndexInput openInput(String name) throws IOException {
        return new FSIndexInput(new File(this.getFile(), name));
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return new FSIndexInput(new File(this.getFile(), name), bufferSize);
    }

    protected class FSIndexInput
    extends FSDirectory.FSIndexInput {
        public FSIndexInput(File path) throws IOException {
            super(path);
        }

        public FSIndexInput(File path, int bufferSize) throws IOException {
            super(path, bufferSize);
        }

        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            ZimbraPerf.COUNTER_IDX_BYTES_READ.increment(len);
            Z23FSDirectory.this.mBytesRead.addAndGet(len);
            super.readInternal(b, offset, len);
        }
    }

    protected class FSIndexOutput
    extends FSDirectory.FSIndexOutput {
        public FSIndexOutput(File path) throws IOException {
            super(path);
        }

        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            ZimbraPerf.COUNTER_IDX_BYTES_WRITTEN.increment(size);
            Z23FSDirectory.this.mBytesWritten.addAndGet(size);
            super.flushBuffer(b, offset, size);
        }
    }
}

