/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.cs.stats.ZimbraPerf;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class Z21FSDirectory
extends FSDirectory {
    AtomicLong mBytesWritten = new AtomicLong();
    AtomicLong mBytesRead = new AtomicLong();

    long getBytesWritten() {
        return this.mBytesWritten.get();
    }

    void resetBytesWritten() {
        this.mBytesWritten.set(0L);
    }

    long getBytesRead() {
        return this.mBytesRead.get();
    }

    void resetBytesRead() {
        this.mBytesRead.set(0L);
    }

    public IndexOutput createOutput(String name) throws IOException {
        File file = new File(this.getFile(), name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    public IndexInput openInput(String name) throws IOException {
        return new FSIndexInput(new File(this.getFile(), name));
    }

    class FSIndexInput
    extends BufferedIndexInput {
        private final Descriptor file;
        boolean isClone;

        public FSIndexInput(File path) throws IOException {
            this.file = new Descriptor(path, "r");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            ZimbraPerf.COUNTER_IDX_BYTES_READ.increment(len);
            Z21FSDirectory.this.mBytesRead.addAndGet(len);
            Descriptor descriptor = this.file;
            synchronized (descriptor) {
                int i;
                long position = this.getFilePointer();
                if (position != this.file.position) {
                    this.file.seek(position);
                    this.file.position = position;
                }
                int total = 0;
                do {
                    if ((i = this.file.read(b, offset + total, len - total)) == -1) {
                        throw new IOException("read past EOF");
                    }
                    this.file.position += (long)i;
                } while ((total += i) < len);
            }
        }

        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        protected void seekInternal(long position) {
        }

        public long length() {
            return this.file.length;
        }

        public Object clone() {
            FSIndexInput clone = (FSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }

        private class Descriptor
        extends RandomAccessFile {
            private boolean isOpen;
            long position;
            final long length;

            public Descriptor(File file, String mode) throws IOException {
                super(file, mode);
                this.isOpen = true;
                this.length = this.length();
            }

            public void close() throws IOException {
                if (this.isOpen) {
                    this.isOpen = false;
                    super.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    super.finalize();
                    throw throwable;
                }
                super.finalize();
            }
        }
    }

    class FSIndexOutput
    extends BufferedIndexOutput {
        RandomAccessFile file = null;
        private boolean isOpen;

        public FSIndexOutput(File path) throws IOException {
            this.file = new RandomAccessFile(path, "rw");
            this.isOpen = true;
        }

        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
        }

        public void flushBuffer(byte[] b, int size) throws IOException {
            ZimbraPerf.COUNTER_IDX_BYTES_WRITTEN.increment(size);
            Z21FSDirectory.this.mBytesWritten.addAndGet(size);
            this.file.write(b, 0, size);
        }

        public void close() throws IOException {
            if (this.isOpen) {
                super.close();
                this.file.close();
                this.isOpen = false;
            }
        }

        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.file.seek(pos);
        }

        public long length() throws IOException {
            return this.file.length();
        }
    }
}

