/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.index.CombiningQueryOperation;
import com.zimbra.cs.index.IntersectionQueryOperation;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.NoTermQueryOperation;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.QueryTarget;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnionQueryOperation
extends CombiningQueryOperation {
    private static Log mLog = LogFactory.getLog(UnionQueryOperation.class);
    private boolean atStart = true;
    private ZimbraHit mCachedNextHit = null;

    UnionQueryOperation() {
    }

    @Override
    QueryTargetSet getQueryTargets() {
        QueryTargetSet toRet = new QueryTargetSet();
        for (QueryOperation op : this.mQueryOperations) {
            toRet = (QueryTargetSet)SetUtil.union(toRet, op.getQueryTargets());
        }
        return toRet;
    }

    @Override
    public void resetIterator() throws ServiceException {
        if (!this.atStart) {
            for (QueryOperation q : this.mQueryOperations) {
                q.resetIterator();
            }
            this.mCachedNextHit = null;
            this.internalGetNext();
        }
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        this.atStart = false;
        ZimbraHit toRet = this.mCachedNextHit;
        if (this.mCachedNextHit != null) {
            this.mCachedNextHit = null;
            this.internalGetNext();
        }
        return toRet;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        return this.mCachedNextHit;
    }

    private void internalGetNext() throws ServiceException {
        if (this.mCachedNextHit == null) {
            if (this.getResultsSet().getSortBy() == SortBy.NONE) {
                for (QueryOperation op : this.mQueryOperations) {
                    this.mCachedNextHit = op.getNext();
                    if (this.mCachedNextHit == null) continue;
                    return;
                }
            } else {
                int currentBestHitOffset = -1;
                ZimbraHit currentBestHit = null;
                for (int i = 0; i < this.mQueryOperations.size(); ++i) {
                    QueryOperation op = (QueryOperation)this.mQueryOperations.get(i);
                    if (!op.hasNext()) continue;
                    if (currentBestHitOffset == -1) {
                        currentBestHitOffset = i;
                        currentBestHit = op.peekNext();
                        continue;
                    }
                    ZimbraHit opNext = op.peekNext();
                    int result = opNext.compareBySortField(this.getResultsSet().getSortBy(), currentBestHit);
                    if (result >= 0) continue;
                    currentBestHitOffset = i;
                    currentBestHit = opNext;
                }
                if (currentBestHitOffset > -1) {
                    this.mCachedNextHit = ((QueryOperation)this.mQueryOperations.get(currentBestHitOffset)).getNext();
                    assert (this.mCachedNextHit == currentBestHit);
                }
            }
        }
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        for (QueryOperation q : this.mQueryOperations) {
            q.doneWithSearchResults();
        }
    }

    @Override
    public boolean hasSpamTrashSetting() {
        boolean hasAll = true;
        Iterator iter = this.mQueryOperations.iterator();
        while (hasAll && iter.hasNext()) {
            QueryOperation op = (QueryOperation)iter.next();
            hasAll = op.hasSpamTrashSetting();
        }
        return hasAll;
    }

    @Override
    void forceHasSpamTrashSetting() {
        for (QueryOperation op : this.mQueryOperations) {
            op.forceHasSpamTrashSetting();
        }
    }

    QueryTarget getQueryTarget(QueryTarget targetOfParent) {
        return targetOfParent;
    }

    @Override
    boolean hasNoResults() {
        return false;
    }

    @Override
    boolean hasAllResults() {
        return false;
    }

    @Override
    QueryOperation expandLocalRemotePart(Mailbox mbox) throws ServiceException {
        ArrayList<QueryOperation> newList = new ArrayList<QueryOperation>();
        for (QueryOperation op : this.mQueryOperations) {
            newList.add(op.expandLocalRemotePart(mbox));
        }
        this.mQueryOperations = newList;
        return this;
    }

    @Override
    QueryOperation ensureSpamTrashSetting(Mailbox mbox, boolean includeTrash, boolean includeSpam) throws ServiceException {
        ArrayList<QueryOperation> newList = new ArrayList<QueryOperation>();
        for (QueryOperation op : this.mQueryOperations) {
            if (!op.hasSpamTrashSetting()) {
                newList.add(op.ensureSpamTrashSetting(mbox, includeTrash, includeSpam));
                continue;
            }
            newList.add(op);
        }
        assert (newList.size() == this.mQueryOperations.size());
        this.mQueryOperations = newList;
        return this;
    }

    public void add(QueryOperation op) {
        this.mQueryOperations.add(op);
    }

    void pruneIncompatibleTargets(QueryTargetSet targets) {
        for (int i = this.mQueryOperations.size() - 1; i >= 0; --i) {
            QueryOperation op = (QueryOperation)this.mQueryOperations.get(i);
            if (op instanceof UnionQueryOperation) {
                assert (false);
                ((UnionQueryOperation)op).pruneIncompatibleTargets(targets);
                continue;
            }
            if (op instanceof IntersectionQueryOperation) {
                ((IntersectionQueryOperation)op).pruneIncompatibleTargets(targets);
                continue;
            }
            QueryTargetSet qts = op.getQueryTargets();
            assert (qts.size() <= 1);
            if (qts.size() != 0 && (qts.isSubset(targets) || qts.contains(QueryTarget.UNSPECIFIED))) continue;
            this.mQueryOperations.remove(i);
        }
    }

    @Override
    public QueryOperation optimize(Mailbox mbox) throws ServiceException {
        block0: while (true) {
            Iterator iter = this.mQueryOperations.iterator();
            while (iter.hasNext()) {
                QueryOperation q = (QueryOperation)iter.next();
                QueryOperation newQ = q.optimize(mbox);
                if (newQ == q) continue;
                iter.remove();
                if (newQ == null) continue block0;
                this.mQueryOperations.add(newQ);
                continue block0;
            }
            break;
        }
        if (this.mQueryOperations.size() == 0) {
            return new NoTermQueryOperation();
        }
        while (true) {
            block3: for (int i = 0; i < this.mQueryOperations.size(); ++i) {
                QueryOperation lhs = (QueryOperation)this.mQueryOperations.get(i);
                if (lhs instanceof UnionQueryOperation) {
                    this.combineOps(lhs, true);
                    this.mQueryOperations.remove(i);
                    continue;
                }
                for (int j = i + 1; j < this.mQueryOperations.size(); ++j) {
                    QueryOperation rhs = (QueryOperation)this.mQueryOperations.get(j);
                    QueryOperation joined = lhs.combineOps(rhs, true);
                    if (joined == null) continue;
                    this.mQueryOperations.remove(j);
                    this.mQueryOperations.remove(i);
                    this.mQueryOperations.add(joined);
                    continue block3;
                }
            }
            break;
        }
        if (this.mQueryOperations.size() == 1) {
            return (QueryOperation)this.mQueryOperations.get(0);
        }
        return this;
    }

    @Override
    String toQueryString() {
        StringBuilder ret = new StringBuilder("(");
        boolean atFirst = true;
        for (QueryOperation op : this.mQueryOperations) {
            if (!atFirst) {
                ret.append(" OR ");
            }
            ret.append(op.toQueryString());
            atFirst = false;
        }
        ret.append(')');
        return ret.toString();
    }

    public String toString() {
        StringBuilder retval = new StringBuilder("UNION{");
        boolean atFirst = true;
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            if (atFirst) {
                atFirst = false;
            } else {
                retval.append(" OR ");
            }
            retval.append(((QueryOperation)this.mQueryOperations.get(i)).toString());
        }
        retval.append("}");
        return retval.toString();
    }

    @Override
    public Object clone() {
        UnionQueryOperation toRet = null;
        toRet = (UnionQueryOperation)super.clone();
        assert (this.mCachedNextHit == null);
        toRet.mQueryOperations = new ArrayList(this.mQueryOperations.size());
        for (QueryOperation q : this.mQueryOperations) {
            toRet.mQueryOperations.add((QueryOperation)q.clone());
        }
        return toRet;
    }

    @Override
    protected QueryOperation combineOps(QueryOperation other, boolean union) {
        if (union && other instanceof UnionQueryOperation) {
            this.mQueryOperations.addAll(((UnionQueryOperation)other).mQueryOperations);
            return this;
        }
        return null;
    }

    @Override
    protected void prepare(Mailbox mbx, ZimbraQueryResultsImpl res, MailboxIndex mbidx, SearchParams params, int chunkSize) throws ServiceException, IOException {
        this.mParams = params;
        this.setupResults(mbx, res);
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            QueryOperation qop = (QueryOperation)this.mQueryOperations.get(i);
            if (mLog.isDebugEnabled()) {
                mLog.debug("Executing: " + qop.toString());
            }
            qop.prepare(mbx, res, mbidx, this.mParams, chunkSize + 1);
        }
        this.internalGetNext();
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        ArrayList<QueryInfo> toRet = new ArrayList<QueryInfo>();
        for (QueryOperation op : this.mQueryOperations) {
            toRet.addAll(op.getResultInfo());
        }
        return toRet;
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        int total = 0;
        for (QueryOperation qop : this.mQueryOperations) {
            total += qop.estimateResultSize();
        }
        return total;
    }

    @Override
    protected void depthFirstRecurse(QueryOperation.RecurseCallback cb) {
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            QueryOperation op = (QueryOperation)this.mQueryOperations.get(i);
            op.depthFirstRecurse(cb);
        }
        cb.recurseCallback(this);
    }
}

