/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.DBQueryOperation;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.QueryTarget;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TextQueryOperation
extends QueryOperation {
    protected int mCurHitNo = 0;
    protected boolean mHaveRunSearch = false;
    protected String mQueryString = "";
    protected BooleanQuery mQuery;
    protected List<Term> mFilterTerms;
    protected DBQueryOperation mDBOp = null;
    protected List<QueryInfo> mQueryInfo = new ArrayList<QueryInfo>();
    private boolean mHasSpamTrashSetting = false;

    TextQueryOperation() {
    }

    protected abstract boolean shouldExecuteDbFirst();

    protected abstract TextResultsChunk getNextResultsChunk(int var1) throws ServiceException;

    protected abstract int countHits();

    protected void resetDocNum() {
        this.mCurHitNo = 0;
    }

    void addClause(String queryStr, Query q, boolean truth) {
        this.mQueryString = this.mQueryString + " " + (truth ? "" : "-") + queryStr;
        assert (!this.mHaveRunSearch);
        if (truth) {
            this.mQuery.add(new BooleanClause(q, BooleanClause.Occur.MUST));
        } else {
            BooleanQuery top = new BooleanQuery();
            top.add(new BooleanClause(new TermQuery(new Term("l.partname", "top")), BooleanClause.Occur.SHOULD));
            top.add(new BooleanClause(new TermQuery(new Term("l.partname", "CONTACT")), BooleanClause.Occur.SHOULD));
            top.add(new BooleanClause(new TermQuery(new Term("l.partname", "NOTE")), BooleanClause.Occur.SHOULD));
            this.mQuery.add(new BooleanClause(top, BooleanClause.Occur.MUST));
            this.mQuery.add(new BooleanClause(q, BooleanClause.Occur.MUST_NOT));
        }
    }

    void addAndedClause(Query q, boolean truth) {
        this.mHaveRunSearch = false;
        this.mCurHitNo = 0;
        BooleanQuery top = new BooleanQuery();
        BooleanClause lhs = new BooleanClause(this.mQuery, BooleanClause.Occur.MUST);
        BooleanClause rhs = new BooleanClause(q, truth ? BooleanClause.Occur.MUST : BooleanClause.Occur.MUST_NOT);
        top.add(lhs);
        top.add(rhs);
        this.mQuery = top;
    }

    void addFilterClause(Term t) {
        this.mHaveRunSearch = false;
        this.mCurHitNo = 0;
        if (this.mFilterTerms == null) {
            this.mFilterTerms = new ArrayList<Term>();
        }
        this.mFilterTerms.add(t);
    }

    void clearFilterClause() {
        this.mFilterTerms = null;
    }

    void setQueryString(String queryStr) {
        assert (this.mQueryString.length() == 0);
        this.mQueryString = queryStr;
    }

    protected BooleanQuery getCurrentQuery() {
        assert (!this.mHaveRunSearch);
        return this.mQuery;
    }

    protected void resetQuery(BooleanQuery q) {
        this.mHaveRunSearch = false;
        this.mQuery = q;
        this.mCurHitNo = 0;
    }

    @Override
    String toQueryString() {
        StringBuilder ret = new StringBuilder("(");
        ret.append(this.mQueryString);
        return ret.append(")").toString();
    }

    protected abstract Object clone(DBQueryOperation var1) throws CloneNotSupportedException;

    @Override
    void forceHasSpamTrashSetting() {
        this.mHasSpamTrashSetting = true;
    }

    List<QueryInfo> getQueryInfo() {
        return this.mQueryInfo;
    }

    void addQueryInfo(QueryInfo inf) {
        this.mQueryInfo.add(inf);
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        if (this.mDBOp == null) {
            return 0;
        }
        return this.mDBOp.estimateResultSize();
    }

    @Override
    protected void prepare(Mailbox mbx, ZimbraQueryResultsImpl res, MailboxIndex mbidx, SearchParams params, int chunkSize) throws ServiceException, IOException {
        this.mParams = params;
        assert (!this.mHaveRunSearch);
        if (this.mDBOp == null) {
            this.mDBOp = DBQueryOperation.Create();
            this.mDBOp.addTextOp(this);
            this.mDBOp.prepare(mbx, res, mbidx, params, chunkSize);
        } else {
            this.setupResults(mbx, res);
            this.prepareThisOperation(res, mbidx);
        }
    }

    protected abstract void prepareThisOperation(ZimbraQueryResultsImpl var1, MailboxIndex var2);

    @Override
    boolean hasSpamTrashSetting() {
        return this.mHasSpamTrashSetting;
    }

    @Override
    boolean hasNoResults() {
        return false;
    }

    @Override
    boolean hasAllResults() {
        return false;
    }

    @Override
    QueryOperation expandLocalRemotePart(Mailbox mbox) throws ServiceException {
        return this;
    }

    @Override
    QueryOperation ensureSpamTrashSetting(Mailbox mbox, boolean includeTrash, boolean includeSpam) throws ServiceException {
        DBQueryOperation dbOp = DBQueryOperation.Create();
        dbOp.addTextOp(this);
        return dbOp.ensureSpamTrashSetting(mbox, includeTrash, includeSpam);
    }

    @Override
    QueryTargetSet getQueryTargets() {
        QueryTargetSet toRet = new QueryTargetSet(1);
        toRet.add(QueryTarget.UNSPECIFIED);
        return toRet;
    }

    protected void setDBOperation(DBQueryOperation op) {
        this.mDBOp = op;
    }

    @Override
    public void resetIterator() throws ServiceException {
        if (this.mDBOp != null) {
            this.mDBOp.resetIterator();
        }
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        if (this.mDBOp != null) {
            return this.mDBOp.getNext();
        }
        return null;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        if (this.mDBOp != null) {
            return this.mDBOp.peekNext();
        }
        return null;
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        ArrayList<QueryInfo> toRet = new ArrayList<QueryInfo>();
        toRet.addAll(this.mQueryInfo);
        if (this.mDBOp != null) {
            toRet.addAll(this.mDBOp.mQueryInfo);
        }
        return toRet;
    }

    @Override
    QueryOperation optimize(Mailbox mbox) throws ServiceException {
        return this;
    }

    protected void depthFirstRecurseInternal(QueryOperation.RecurseCallback cb) {
        cb.recurseCallback(this);
    }

    @Override
    protected void depthFirstRecurse(QueryOperation.RecurseCallback cb) {
        if (this.mDBOp != null) {
            this.mDBOp.depthFirstRecurse(cb);
        } else {
            this.depthFirstRecurseInternal(cb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextResultsChunk {
        private HashMap<String, ScoredLuceneHit> mHits = new LinkedHashMap<String, ScoredLuceneHit>();

        protected TextResultsChunk() {
        }

        Set<String> getIndexIds() {
            LinkedHashSet<String> toRet = new LinkedHashSet<String>(this.mHits.keySet().size());
            for (String curId : this.mHits.keySet()) {
                toRet.add(curId);
            }
            return toRet;
        }

        protected int size() {
            return this.mHits.size();
        }

        void addHit(String indexId, Document doc, float score) {
            ScoredLuceneHit sh = this.mHits.get(indexId);
            if (sh == null) {
                sh = new ScoredLuceneHit(score);
                this.mHits.put(indexId, sh);
            }
            sh.mDocs.add(doc);
        }

        ScoredLuceneHit getScoredHit(String indexId) {
            return this.mHits.get(indexId);
        }

        static class ScoredLuceneHit {
            public List<Document> mDocs = new ArrayList<Document>();
            public float mScore;

            ScoredLuceneHit(float score) {
                this.mScore = score;
            }
        }
    }
}

