/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.ResultValidator;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQuery;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestSearch
extends TestCase {
    public static final ResultValidator.QueryResult[] NO_EXPECTED_CHECK = new ResultValidator.QueryResult[0];
    public long mMailboxId;

    public void testSearch() throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId);
        try {
            byte[] types = new byte[]{5};
            mbox.search(new OperationContext(mbox), "abc", types, SortBy.DATE_ASCENDING, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSearch.fail((String)("Caught exception running initial text search: " + e));
        }
        TestSearch.assertTrue((boolean)ZimbraQuery.unitTests(mbox));
        long startTime = System.currentTimeMillis();
        this.runTestQuery(this.mMailboxId, "is:unread is:remote", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING);
        this.runTestQuery(this.mMailboxId, "in:inbox", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING);
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "appt-start:<1/1/2006 recurring", false, TestSearch.getTypes((byte)11, (byte)5), SortBy.DATE_DESCENDING, NO_EXPECTED_CHECK, new ResultValidator.ExpectedHitValidator(new ResultValidator.ExpectedMessageHit("Recurring Meeting Test"), new ResultValidator.ExpectedCalendarItemHit("040000008200E00074C5B7101A82E00800000000F0BC424F5761C5010000000000000000100000002C10E79C9140CF41B7E18816DF121033"))));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "appt-start:>1/1/2006 recurring", false, TestSearch.getTypes((byte)11, (byte)5), SortBy.DATE_DESCENDING, NO_EXPECTED_CHECK, new ResultValidator.ExpectedHitValidator(new ResultValidator.ExpectedMessageHit("Recurring Meeting Test"))));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "(linux or has:ssn) and before:1/1/2009 and -subject:\"zipped document\"", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Frequent system freezes after kernel bug"), new ResultValidator.QueryResult("Linux Desktop Info")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "(linux or has:ssn) and before:1/1/2009 and -subject:\"zipped document\"", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Frequent system freezes after kernel bug"), new ResultValidator.QueryResult("Linux Desktop Info")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "(linux or has:ssn) and before:1/1/2009 and -subject:\"zipped document\"", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Frequent system freezes after kernel bug"), new ResultValidator.QueryResult("Linux Desktop Info")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "from:ross and not roland", true, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("meeting")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:(01/01/2001 02/02/2002)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:-1d date:(01/01/2001 02/02/2002)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "in:(trash -junk)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:(-1d or -2d)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:\"-4d\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:-4d", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:\"+1d\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:+2w", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "not date:(1/1/2004 or 2/1/2004)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "content:foo", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "content:\"foo bar\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "from:foo@bar.com", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "from:\"foo bar\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "to:foo@bar.com", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "to:\"foo bar\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "cc:foo@bar.com", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "cc:\"foo bar\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "subject:this_is_my_subject subject:\"this is_my_subject\"", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "in:inbox", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "has:attachment has:phone has:url", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "filename:foo filename:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "type:attachment type:text type:application type:word type:msword type:excel type:xls type:ppt type:pdf type:ms-tnef type:image type:jpeg type:gif type:bmp type:none type:any", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "is:(read unread flagged unflagged \"sent\" received replied unreplied forwarded unforwarded)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "date:+1d", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "size:(1 20 300 1k <1k 10k >10k 100kb 34mb)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "larger:(1 20 300 100kb 34mb)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "smaller:(1 20 300 100kb 34mb)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "author:foo author:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "title:foo title:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "keywords:foo keywords:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "company:foo company:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "foo sort:score and bar", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "in:inbox ((after:1/1/2006 and welcome) or from:ross)", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Welcome to the Zimbra Collaboration Suite source!"), new ResultValidator.QueryResult("Here are my ski pictures!"), new ResultValidator.QueryResult(""), new ResultValidator.QueryResult("Linux Desktop Info"), new ResultValidator.QueryResult("meeting")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "contributing to xmlbeans ", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Contributing to XMLBeans"), new ResultValidator.QueryResult("XmlBeans.jar size"), new ResultValidator.QueryResult("XmlBeans project logo")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "before:1/1/2004 and source", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Contributing to XMLBeans"), new ResultValidator.QueryResult("XmlBeans.jar size"), new ResultValidator.QueryResult("Failed to build with \"network downloads disabled\" error message."), new ResultValidator.QueryResult("Failed to build with \"network downloads disabled\" error message."), new ResultValidator.QueryResult("XMLBeans V1 binding style arch writeup"), new ResultValidator.QueryResult("Official release yet?"), new ResultValidator.QueryResult("cvs commit: xml-xmlbeans/v2/src/jam/org/apache/xmlbeans/impl/jam/internal/javadoc JDClassLoaderFactory.java"), new ResultValidator.QueryResult("XMLBeans/Java Web Start Issues"), new ResultValidator.QueryResult("XMLBeans/Java Web Start Issues"), new ResultValidator.QueryResult("builtin type conversions"), new ResultValidator.QueryResult("ArrayStoreException when using RMI"), new ResultValidator.QueryResult("Source Build Problem"), new ResultValidator.QueryResult("Finalizers"), new ResultValidator.QueryResult("Mapping XML type QName to Java Class name?"), new ResultValidator.QueryResult("xmlbeans javadocs?"), new ResultValidator.QueryResult("licenses for jaxb-api.jar and jax-qname.jar...?"), new ResultValidator.QueryResult("code to contribute: JAM"), new ResultValidator.QueryResult("STAX"), new ResultValidator.QueryResult("STAX"), new ResultValidator.QueryResult("code to contribute: JAM"), new ResultValidator.QueryResult("Getting the distribution onto a download site somewhere ..."), new ResultValidator.QueryResult("Getting an XMLBeans distribution onto a download site somewhere"), new ResultValidator.QueryResult("About me"), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("Source Code"), new ResultValidator.QueryResult("Source Code"), new ResultValidator.QueryResult("Source Code")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "subject:linux", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Linux Desktop Info")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "subject:\"code has\"", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ..."), new ResultValidator.QueryResult("XmlBeans source code has been checked in ...")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "(linux or has:ssn) and before:1/1/2009 and -subject:\"zipped document\"", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Frequent system freezes after kernel bug"), new ResultValidator.QueryResult("Linux Desktop Info")}, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "larger:1M", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "foo or not foo", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "(foo or not foo) and larger:1M", false, new ResultValidator.QueryResult[]{new ResultValidator.QueryResult("Here are my ski pictures!"), new ResultValidator.QueryResult("AdminGuide...")}, SortBy.DATE_DESCENDING));
        ResultValidator val = new ResultValidator(){
            int cmpId = 2;

            public void validate(ZimbraHit hit) throws ServiceException {
                MessageHit mh = (MessageHit)hit;
                int msgFolderId = mh.getFolderId();
                Assert.assertTrue((String)("Folder-Checking " + mh.toString() + " for INBOX"), (this.cmpId == msgFolderId ? 1 : 0) != 0);
            }
        };
        this.runTestQuery(this.mMailboxId, "in:inbox", false, TestSearch.getMessageTypes(false), SortBy.DATE_DESCENDING, NO_EXPECTED_CHECK, val);
        final Date compDate = new GregorianCalendar(2004, 1, 1).getTime();
        ResultValidator val2 = new ResultValidator(){

            public void validate(ZimbraHit hit) throws ServiceException {
                MessageHit mh = (MessageHit)hit;
                Date date = new Date(mh.getDateHeader());
                Assert.assertTrue((String)("Date " + date + " out of range for " + mh.toString()), (boolean)date.before(compDate));
            }
        };
        this.runTestQuery(this.mMailboxId, "before:1/1/2004", false, TestSearch.getMessageTypes(false), SortBy.DATE_DESCENDING, NO_EXPECTED_CHECK, val2);
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "metadata:foo metadata:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "sort:score metadata:foo metadata:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "metadata:foo sort:score and not metadata:foo sort:score and metadata:(\"foo\" \"foo bar\" gub)", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "metadata:foo sort:score metadata:(\"foo\" \"foo bar\" gub) sort:score", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "item:({1,2,3} or {4,5,6})", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        TestSearch.assertTrue((boolean)this.runTestQuery(this.mMailboxId, "item:({1,2,3}) is:unread", false, NO_EXPECTED_CHECK, SortBy.DATE_DESCENDING));
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        System.out.println("UnitTests completed in: " + time + "ms");
    }

    public static void makeTestQuery(long mailboxId, String qstr, boolean conv) {
        try {
            ResultValidator.QueryResult[] ret = TestSearch.runQuery(mailboxId, qstr, conv, TestSearch.getMessageTypes(conv), SortBy.DATE_DESCENDING, null);
            String qstr2 = qstr.replaceAll("\"", "\\\\\"");
            System.out.println("assertTrue(runTestQuery(mM, \"" + qstr2 + "\", false, new QueryResult[]\n{");
            if (ret.length > 0) {
                System.out.println("\t\tnew QueryResult(0, \"" + ret[0].toString().replaceAll("\"", "\\\\\"") + "\")");
            }
            for (int i = 1; i < ret.length; ++i) {
                System.out.println("\t\t,new QueryResult(0, \"" + ret[i].toString().replaceAll("\"", "\\\\\"") + "\")");
            }
            System.out.println("}\n));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notest11() throws ServiceException {
        Mailbox mbx = MailboxManager.getInstance().getMailboxById(1L);
        String tagName = new String("foo");
        final Tag compTag = mbx.getTagByName(tagName);
        ResultValidator val = new ResultValidator(){

            public void validate(ZimbraHit hit) throws ServiceException {
                MessageHit mh = (MessageHit)hit;
                String mhStr = "";
                String compTagStr = "";
                try {
                    mhStr = mh.toString();
                    compTagStr = compTag.toString();
                }
                catch (NullPointerException e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
                Assert.assertTrue((String)("Tag-Checking " + mhStr + " for " + compTagStr), (boolean)mh.isTagged(compTag));
            }
        };
        this.runTestQuery(this.mMailboxId, "tag:" + tagName, false, TestSearch.getMessageTypes(false), SortBy.DATE_DESCENDING, NO_EXPECTED_CHECK, val);
    }

    static final byte[] getTypes(Byte ... in) {
        HashSet<Byte> types = new HashSet<Byte>();
        for (Byte b : in) {
            types.add(b);
        }
        byte[] toRet = new byte[types.size()];
        int i = 0;
        for (Byte b : types) {
            toRet[i++] = b;
        }
        return toRet;
    }

    static final byte[] getMessageTypes(boolean conv) {
        byte[] types = new byte[]{conv ? (byte)4 : 5};
        return types;
    }

    boolean runTestQuery(long mailboxId, String qstr, boolean conv, ResultValidator.QueryResult[] expected, SortBy sort) {
        byte[] types = TestSearch.getMessageTypes(conv);
        return this.runTestQuery(mailboxId, qstr, conv, types, SortBy.DATE_DESCENDING, expected, null);
    }

    boolean runTestQuery(long mailboxId, String qstr, boolean conv, byte[] types, SortBy sort, ResultValidator.QueryResult[] expected, ResultValidator validator) {
        try {
            if (expected != null && expected != NO_EXPECTED_CHECK && validator != null) {
                throw new IllegalArgumentException("Only one of subject validator or expected may be passed!");
            }
            if (expected != null && expected != NO_EXPECTED_CHECK) {
                validator = new ResultValidator.ExpectedHitValidator(expected);
            }
            TestSearch.runQuery(mailboxId, qstr, conv, types, sort, validator);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Caught an IOException running test query " + qstr + " for mailbox " + mailboxId));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            TestSearch.fail((String)("Caught a service exception running test query " + qstr));
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestSearch.fail((String)("Caught a parse exception running test query " + qstr));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResultValidator.QueryResult[] runQuery(long mailboxId, String qstr, boolean conv, byte[] types, SortBy sort, ResultValidator validator) throws IOException, MailServiceException, ParseException, ServiceException {
        ArrayList<ResultValidator.QueryResult> ret = new ArrayList<ResultValidator.QueryResult>();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mailboxId);
        SearchParams params = new SearchParams();
        params.setQueryStr(qstr);
        params.setTypes(types);
        params.setSortBy(SortBy.DATE_DESCENDING);
        params.setOffset(0);
        params.setLimit(100);
        params.setPrefetch(true);
        params.setMode(Mailbox.SearchResultMode.NORMAL);
        System.out.println("Running query: " + qstr);
        ZimbraQuery zq = new ZimbraQuery(null, SoapProtocol.Soap12, mbox, params);
        ZimbraQueryResults res = zq.execute();
        try {
            int numMessages = 0;
            ZimbraHit hit = res.getFirstHit();
            while (hit != null) {
                ++numMessages;
                hit = res.getNext();
            }
            System.out.println("Query: \"" + qstr + "\" matched " + numMessages + " documents");
            int HITS_PER_PAGE = 20;
            int totalShown = 0;
            ZimbraHit hit2 = res.skipToHit(0);
            while (hit2 != null) {
                for (int i = 0; hit2 != null && i < 20; ++i) {
                    if (conv) {
                        ConversationHit ch = (ConversationHit)hit2;
                        Date date = new Date(ch.getHitDate());
                        System.out.println(ch.toString() + " " + date + " " + ch.getSubject() + "  (" + ch.getNumMessageHits() + ")");
                        ++totalShown;
                        ret.add(new ResultValidator.QueryResult(ch.getSubject()));
                        if (validator != null) {
                            try {
                                validator.validate(hit2);
                            }
                            catch (ServiceException e) {
                                StringBuilder toRet = new StringBuilder("\nReceived Hits:\n");
                                for (ResultValidator.QueryResult q : ret) {
                                    toRet.append('\t').append(q.toString()).append('\n');
                                }
                                throw ServiceException.FAILURE(toRet.append(e.getMessage()).toString(), null);
                            }
                        }
                    } else if (hit2 instanceof MessageHit) {
                        MessageHit mh = (MessageHit)hit2;
                        ++totalShown;
                        ret.add(new ResultValidator.QueryResult(mh.getSubject()));
                        if (null != validator) {
                            try {
                                validator.validate(hit2);
                            }
                            catch (ServiceException e) {
                                StringBuilder toRet = new StringBuilder("\nReceived Hits:\n");
                                for (ResultValidator.QueryResult q : ret) {
                                    toRet.append('\t').append(q.toString()).append('\n');
                                }
                                throw ServiceException.FAILURE(toRet.append(e.getMessage()).toString(), null);
                            }
                        }
                    } else {
                        ++totalShown;
                        ret.add(new ResultValidator.QueryResult(hit2.getClass().getName()));
                    }
                    hit2 = res.getNext();
                }
            }
            if (validator != null && !validator.numReceived(ret.size())) {
                String errStr = "Unexpected number of return values (expected " + validator.numExpected() + ", returned " + ret.size() + ")";
                int ilen = Math.max(ret.size(), validator.numExpected());
                for (int i = 0; i < ilen; ++i) {
                    errStr = i < ret.size() ? errStr + "\n\t\t" + i + ") ret=" + ((ResultValidator.QueryResult)ret.get(i)).toString() : errStr + "\n\t\t" + i + ") ret=NO_MORE";
                    errStr = i < validator.numExpected() ? errStr + "\n\t\t" + i + ") exp=" + validator.getExpected(i).toString() + "\n" : errStr + "\n\t\t" + i + ") exp=NO_MORE\n";
                }
                TestSearch.fail((String)("\n\tQuery=\"" + qstr + "\" -- " + errStr));
            }
            Object var23_30 = null;
        }
        catch (Throwable throwable) {
            Object var23_31 = null;
            res.doneWithSearchResults();
            throw throwable;
        }
        res.doneWithSearchResults();
        ResultValidator.QueryResult[] retArray = new ResultValidator.QueryResult[ret.size()];
        return ret.toArray(retArray);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static void runTests() {
        TestSuite suite = new TestSuite(TestSearch.class);
        TestResult results = new TestResult();
        suite.run(results);
        if (!results.wasSuccessful()) {
            System.out.println("\n**************************");
            System.out.println("TEST FAILURES:");
            System.out.println("**************************");
        }
        if (results.failureCount() > 0) {
            Enumeration failures = results.failures();
            while (failures.hasMoreElements()) {
                TestFailure error = (TestFailure)failures.nextElement();
                System.out.println("--> Test Failure: " + error.trace() + error.thrownException());
                System.out.print("\n");
            }
        }
        if (results.errorCount() > 0) {
            Enumeration errors = results.errors();
            while (errors.hasMoreElements()) {
                TestFailure failure = (TestFailure)errors.nextElement();
                System.out.println("--> Test Error: " + failure.trace() + failure.thrownException() + " at ");
                failure.thrownException().printStackTrace();
                System.out.print("\n");
            }
        }
        if (results.wasSuccessful()) {
            System.out.println("\n**************************");
            System.out.println("Tests SUCCESSFUL!");
            System.out.println("**************************");
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        Mailbox mbox = TestUtil.getMailbox("user1");
        this.mMailboxId = mbox.getId();
    }

    public static void main(String[] args) {
        MailboxIndex.startup();
        RedoLogProvider redoLog = RedoLogProvider.getInstance();
        try {
            redoLog.startup();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        CliUtil.toolSetup("DEBUG");
        ZimbraLog.account.info("INFO TEST!");
        ZimbraLog.account.debug("DEBUG TEST!");
        try {
            String command;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            if (args.length > 0 && (command = args[0]).equals("make")) {
                while (true) {
                    System.out.print("Type Query>");
                    String query = in.readLine();
                    TestSearch.makeTestQuery(1L, query, false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TestSearch.runTests();
        MailboxIndex.shutdown();
        System.exit(1);
    }
}

