/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.CalendarItemHit;
import com.zimbra.cs.index.ProxiedHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Task;
import com.zimbra.cs.mailbox.calendar.Invite;
import org.apache.lucene.document.Document;

public class TaskHit
extends CalendarItemHit {
    public static TaskHit create(ZimbraQueryResultsImpl results, Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        Task calItem = null;
        byte type = 15;
        if (ud != null) {
            calItem = (Task)mbx.getItemFromUnderlyingData(ud);
            type = ud.type;
        }
        return new TaskHit(results, mbx, mailItemId, d, score, calItem, type);
    }

    public TaskHit(ZimbraQueryResultsImpl results, Mailbox mbx, int mailItemId, Document d, float score, CalendarItem calItem, byte type) throws ServiceException {
        super(results, mbx, mailItemId, d, score, calItem, type);
    }

    public long getDueTime() throws ServiceException {
        Task task = (Task)this.getCalendarItem();
        return task.getEndTime();
    }

    public int getCompletionPercentage() throws ServiceException {
        String compPerc;
        Task task = (Task)this.getCalendarItem();
        Invite inv = task.getDefaultInviteOrNull();
        if (inv != null && (compPerc = inv.getPercentComplete()) != null) {
            try {
                int toRet = Integer.parseInt(compPerc);
                return toRet;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public Status getStatus() throws ServiceException {
        Task task = (Task)this.getCalendarItem();
        Invite inv = task.getDefaultInviteOrNull();
        if (inv != null) {
            String status = inv.getStatus();
            try {
                Status s = Status.valueOf(status.toUpperCase());
                return s;
            }
            catch (IllegalArgumentException e) {
                ZimbraLog.index.debug("Unknown Task Status value: " + status.toUpperCase());
            }
        }
        return Status.DEFERRED;
    }

    public Object getSortField(SortBy sortOrder) throws ServiceException {
        switch (sortOrder.getType()) {
            case TASK_DUE_ASCENDING: 
            case TASK_DUE_DESCENDING: {
                return this.getDueTime();
            }
            case TASK_STATUS_ASCENDING: 
            case TASK_STATUS_DESCENDING: {
                return this.getStatus();
            }
            case TASK_PERCENT_COMPLETE_ASCENDING: 
            case TASK_PERCENT_COMPLETE_DESCENDING: {
                return this.getCompletionPercentage();
            }
        }
        return super.getSortField(sortOrder);
    }

    int compareBySortField(SortBy sortOrder, ZimbraHit other) throws ServiceException {
        switch (sortOrder.getType()) {
            case TASK_DUE_ASCENDING: {
                return TaskHit.compareByDueDate(true, this, other);
            }
            case TASK_DUE_DESCENDING: {
                return TaskHit.compareByDueDate(false, this, other);
            }
            case TASK_STATUS_ASCENDING: {
                return TaskHit.compareByStatus(true, this, other);
            }
            case TASK_STATUS_DESCENDING: {
                return TaskHit.compareByStatus(false, this, other);
            }
            case TASK_PERCENT_COMPLETE_ASCENDING: {
                return TaskHit.compareByCompletionPercent(true, this, other);
            }
            case TASK_PERCENT_COMPLETE_DESCENDING: {
                return TaskHit.compareByCompletionPercent(false, this, other);
            }
        }
        return super.compareBySortField(sortOrder, other);
    }

    private static long getDueTime(ZimbraHit zh) throws ServiceException {
        if (zh instanceof ProxiedHit) {
            return ((ProxiedHit)zh).getElement().getAttributeLong("dueDate");
        }
        return ((TaskHit)zh).getDueTime();
    }

    private static Status getStatus(ZimbraHit zh) throws ServiceException {
        if (zh instanceof ProxiedHit) {
            String s = ((ProxiedHit)zh).getElement().getAttribute("status");
            return Status.valueOf(s);
        }
        return ((TaskHit)zh).getStatus();
    }

    static int getCompletionPercentage(ZimbraHit zh) throws ServiceException {
        if (zh instanceof ProxiedHit) {
            return (int)((ProxiedHit)zh).getElement().getAttributeLong("percentComplete");
        }
        return ((TaskHit)zh).getCompletionPercentage();
    }

    static final int compareByDueDate(boolean ascending, ZimbraHit lhs, ZimbraHit rhs) {
        int retVal = 0;
        try {
            long left = TaskHit.getDueTime(lhs);
            long right = TaskHit.getDueTime(rhs);
            long result = right - left;
            retVal = result > 0L ? 1 : (result < 0L ? -1 : 0);
        }
        catch (ServiceException e) {
            ZimbraLog.index.info("Caught ServiceException trying to compare TaskHit %s to TaskHit %s", (Object)lhs, (Object)rhs, e);
        }
        if (ascending) {
            return -1 * retVal;
        }
        return retVal;
    }

    static final int compareByStatus(boolean ascending, ZimbraHit lhs, ZimbraHit rhs) {
        int retVal = 0;
        try {
            Status left = TaskHit.getStatus(lhs);
            Status right = TaskHit.getStatus(rhs);
            int result = right.getSortVal() - left.getSortVal();
            retVal = result > 0 ? 1 : (result < 0 ? -1 : 0);
        }
        catch (ServiceException e) {
            ZimbraLog.index.info("Caught ServiceException trying to compare TaskHit %s to TaskHit %s", (Object)lhs, (Object)rhs, e);
        }
        if (ascending) {
            return -1 * retVal;
        }
        return retVal;
    }

    static final int compareByCompletionPercent(boolean ascending, ZimbraHit lhs, ZimbraHit rhs) {
        int retVal = 0;
        try {
            int left = TaskHit.getCompletionPercentage(lhs);
            int right = TaskHit.getCompletionPercentage(rhs);
            int result = right - left;
            retVal = result > 0 ? 1 : (result < 0 ? -1 : 0);
        }
        catch (ServiceException e) {
            ZimbraLog.index.info("Caught ServiceException trying to compare TaskHit %s to TaskHit %s", (Object)lhs, (Object)rhs, e);
        }
        if (ascending) {
            return -1 * retVal;
        }
        return retVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        NEED(0),
        INPR(1),
        WAITING(2),
        DEFERRED(3),
        COMP(4);

        private int mSortVal;

        private Status(int sortVal) {
            this.mSortVal = sortVal;
        }

        public int getSortVal() {
            return this.mSortVal;
        }
    }
}

