/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.soap.Element;
import com.zimbra.cs.index.QueryInfo;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellSuggestQueryInfo
implements QueryInfo {
    private String mMisSpelled;
    private List<Suggestion> mSuggestions;

    SpellSuggestQueryInfo(String misSpelled, List<Suggestion> suggestions) {
        this.mMisSpelled = misSpelled;
        this.mSuggestions = suggestions;
    }

    @Override
    public Element toXml(Element parent) {
        Element ms = parent.addElement("spell");
        ms.addAttribute("word", this.mMisSpelled);
        for (Suggestion s : this.mSuggestions) {
            Element elt = ms.addElement("sug");
            elt.addAttribute("dist", s.mEditDist);
            elt.addAttribute("numDocs", s.mDocs);
            elt.addAttribute("value", s.mStr);
        }
        return ms;
    }

    public String toString() {
        String toRet = "SUGGEST(" + this.mMisSpelled + " [";
        for (Suggestion s : this.mSuggestions) {
            toRet = toRet + "(" + s.mStr + "," + s.mEditDist + ", " + s.mDocs + ")   ";
        }
        return toRet + "]";
    }

    static class Suggestion {
        public String mStr;
        public int mDocs;
        public int mEditDist;

        Suggestion() {
        }
    }
}

