/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import java.util.HashMap;

public class SortBy {
    static HashMap<String, SortBy> sNameMap = new HashMap();
    public static final SortBy DATE_ASCENDING = new SortBy(Type.DATE_ASCENDING, "dateAsc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy DATE_DESCENDING = new SortBy(Type.DATE_DESCENDING, "dateDesc", SortCriterion.DATE, SortDirection.DESCENDING);
    public static final SortBy SUBJ_ASCENDING = new SortBy(Type.SUBJ_ASCENDING, "subjAsc", SortCriterion.SUBJECT, SortDirection.ASCENDING);
    public static final SortBy SUBJ_DESCENDING = new SortBy(Type.SUBJ_DESCENDING, "subjDesc", SortCriterion.SUBJECT, SortDirection.DESCENDING);
    public static final SortBy NAME_ASCENDING = new SortBy(Type.NAME_ASCENDING, "nameAsc", SortCriterion.SENDER, SortDirection.ASCENDING);
    public static final SortBy NAME_DESCENDING = new SortBy(Type.NAME_DESCENDING, "nameDesc", SortCriterion.SENDER, SortDirection.DESCENDING);
    public static final SortBy SIZE_ASCENDING = new SortBy(Type.SIZE_ASCENDING, "sizeAsc", SortCriterion.SIZE, SortDirection.ASCENDING);
    public static final SortBy SIZE_DESCENDING = new SortBy(Type.SIZE_DESCENDING, "sizeDesc", SortCriterion.SIZE, SortDirection.DESCENDING);
    public static final SortBy SCORE_DESCENDING = new SortBy(Type.SCORE_DESCENDING, "score", SortCriterion.DATE, SortDirection.DESCENDING);
    public static final SortBy NAME_NATURAL_ORDER_ASCENDING = new SortBy(Type.NAME_NATURAL_ORDER_ASCENDING, null, SortCriterion.NAME_NATURAL_ORDER, SortDirection.ASCENDING);
    public static final SortBy NAME_NATURAL_ORDER_DESCENDING = new SortBy(Type.NAME_NATURAL_ORDER_DESCENDING, null, SortCriterion.NAME_NATURAL_ORDER, SortDirection.DESCENDING);
    public static final SortBy TASK_DUE_ASCENDING = new SortBy(Type.TASK_DUE_ASCENDING, "taskDueAsc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy TASK_DUE_DESCENDING = new SortBy(Type.TASK_DUE_DESCENDING, "taskDueDesc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy TASK_STATUS_ASCENDING = new SortBy(Type.TASK_STATUS_ASCENDING, "taskStatusAsc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy TASK_STATUS_DESCENDING = new SortBy(Type.TASK_STATUS_DESCENDING, "taskStatusDesc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy TASK_PERCENT_COMPLETE_ASCENDING = new SortBy(Type.TASK_PERCENT_COMPLETE_ASCENDING, "taskPercCompletedAsc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy TASK_PERCENT_COMPLETE_DESCENDING = new SortBy(Type.TASK_PERCENT_COMPLETE_DESCENDING, "taskPercCompletedDesc", SortCriterion.DATE, SortDirection.ASCENDING);
    public static final SortBy NONE = new SortBy(Type.NONE, "none", SortCriterion.NONE, SortDirection.ASCENDING);
    private String mName;
    private SortCriterion mCriterion;
    private SortDirection mDirection;
    private Type mType;

    SortBy(Type t, String str, SortCriterion criterion, SortDirection direction) {
        this.mType = t;
        this.mName = str;
        if (this.mName != null) {
            sNameMap.put(this.mName.toLowerCase(), this);
        }
        this.mCriterion = criterion;
        this.mDirection = direction;
    }

    public String toString() {
        return this.mName == null ? super.toString() : this.mName;
    }

    public Type getType() {
        return this.mType;
    }

    public SortCriterion getCriterion() {
        return this.mCriterion;
    }

    public SortDirection getDirection() {
        return this.mDirection;
    }

    public boolean isDescending() {
        return this.mDirection == SortDirection.DESCENDING;
    }

    public static SortBy lookup(String str) {
        if (str != null) {
            return sNameMap.get(str.toLowerCase());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortDirection {
        DESCENDING,
        ASCENDING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortCriterion {
        DATE,
        SENDER,
        SUBJECT,
        ID,
        NONE,
        NAME,
        NAME_NATURAL_ORDER,
        SIZE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DATE_ASCENDING,
        DATE_DESCENDING,
        SUBJ_ASCENDING,
        SUBJ_DESCENDING,
        NAME_ASCENDING,
        NAME_DESCENDING,
        SIZE_ASCENDING,
        SIZE_DESCENDING,
        SCORE_DESCENDING,
        NAME_NATURAL_ORDER_ASCENDING,
        NAME_NATURAL_ORDER_DESCENDING,
        TASK_DUE_ASCENDING,
        TASK_DUE_DESCENDING,
        TASK_STATUS_ASCENDING,
        TASK_STATUS_DESCENDING,
        TASK_PERCENT_COMPLETE_ASCENDING,
        TASK_PERCENT_COMPLETE_DESCENDING,
        NAME_LOCALIZED_ASCENDING,
        NAME_LOCALIZED_DESCENDING,
        NONE;

    }
}

