/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TaskHit;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchParams
implements Cloneable {
    private static final int MAX_OFFSET = 10000000;
    private static final int MAX_LIMIT = 10000000;
    private static final String LOCALE_PATTERN = "([a-zA-Z]{2})(?:[-_]([a-zA-Z]{2})([-_](.+))?)?";
    private static final Pattern sLocalePattern = Pattern.compile("([a-zA-Z]{2})(?:[-_]([a-zA-Z]{2})([-_](.+))?)?");
    private ZimbraSoapContext mRequestContext;
    private int mHopCount = 0;
    private String mDefaultField = "content:";
    private String mQueryStr;
    private int mOffset;
    private int mLimit;
    private ExpandResults mInlineRule = null;
    private boolean mMarkRead = false;
    private int mMaxInlinedLength;
    private boolean mWantHtml = false;
    private boolean mNeuterImages = false;
    private Set<String> mInlinedHeaders = null;
    private boolean mRecipients = false;
    private long mCalItemExpandStart = -1L;
    private long mCalItemExpandEnd = -1L;
    private boolean mIncludeTagDeleted = false;
    private Set<TaskHit.Status> mAllowableTaskStatuses = null;
    private TimeZone mTimeZone = null;
    private Locale mLocale = null;
    private boolean mHasCursor = false;
    private ItemId mPrevMailItemId;
    private String mPrevSortValueStr;
    private long mPrevSortValueLong;
    private int mPrevOffset;
    private String mEndSortValueStr;
    private long mEndSortValueLong;
    private String mGroupByStr;
    private String mSortByStr;
    private SortBy mSortBy;
    private byte[] types;
    private boolean mPrefetch = true;
    private Mailbox.SearchResultMode mMode = Mailbox.SearchResultMode.NORMAL;
    private boolean mEstimateSize = false;

    public ZimbraSoapContext getRequestContext() {
        return this.mRequestContext;
    }

    public int getHopCount() {
        return this.mHopCount;
    }

    public long getCalItemExpandStart() {
        return this.mCalItemExpandStart;
    }

    public long getCalItemExpandEnd() {
        return this.mCalItemExpandEnd;
    }

    public String getQueryStr() {
        return this.mQueryStr;
    }

    public String getTypesStr() {
        return this.mGroupByStr;
    }

    public byte[] getTypes() {
        return this.types;
    }

    public String getSortByStr() {
        return this.mSortByStr;
    }

    public SortBy getSortBy() {
        return this.mSortBy;
    }

    public ExpandResults getInlineRule() {
        return this.mInlineRule;
    }

    public boolean getMarkRead() {
        return this.mMarkRead;
    }

    public int getMaxInlinedLength() {
        return this.mMaxInlinedLength;
    }

    public boolean getWantHtml() {
        return this.mWantHtml;
    }

    public boolean getNeuterImages() {
        return this.mNeuterImages;
    }

    public Set<String> getInlinedHeaders() {
        return this.mInlinedHeaders;
    }

    public ToXML.OutputParticipants getWantRecipients() {
        return this.mRecipients ? ToXML.OutputParticipants.PUT_RECIPIENTS : ToXML.OutputParticipants.PUT_SENDERS;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public boolean getPrefetch() {
        return this.mPrefetch;
    }

    public Mailbox.SearchResultMode getMode() {
        return this.mMode;
    }

    public boolean getEstimateSize() {
        return this.mEstimateSize;
    }

    public String getDefaultField() {
        return this.mDefaultField;
    }

    public final boolean getIncludeTagDeleted() {
        return this.mIncludeTagDeleted;
    }

    public Set<TaskHit.Status> getAllowableTaskStatuses() {
        return this.mAllowableTaskStatuses;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public ItemId getPrevMailItemId() {
        return this.mPrevMailItemId;
    }

    public String getPrevSortValueStr() {
        return this.mPrevSortValueStr;
    }

    public long getPrevSortValueLong() {
        return this.mPrevSortValueLong;
    }

    public int getPrevOffset() {
        return this.mPrevOffset;
    }

    public boolean hasEndSortValue() {
        return this.mEndSortValueStr != null;
    }

    public String getEndSortValueStr() {
        return this.mEndSortValueStr;
    }

    public long getEndSortValueLong() {
        return this.mEndSortValueLong;
    }

    public void setHopCount(int hopCount) {
        this.mHopCount = hopCount;
    }

    public void setQueryStr(String queryStr) {
        this.mQueryStr = queryStr;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
        if (this.mOffset > 10000000) {
            this.mOffset = 10000000;
        }
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
        if (this.mLimit > 10000000) {
            this.mLimit = 10000000;
        }
    }

    public void setDefaultField(String field) {
        if (field.charAt(field.length() - 1) != ':') {
            field = field + ':';
        }
        this.mDefaultField = field;
    }

    public final void setIncludeTagDeleted(boolean includeTagDeleted) {
        this.mIncludeTagDeleted = includeTagDeleted;
    }

    public void setAllowableTaskStatuses(Set<TaskHit.Status> statuses) {
        this.mAllowableTaskStatuses = statuses;
    }

    public void setCalItemExpandStart(long calItemExpandStart) {
        this.mCalItemExpandStart = calItemExpandStart;
    }

    public void setCalItemExpandEnd(long calItemExpandEnd) {
        this.mCalItemExpandEnd = calItemExpandEnd;
    }

    public void setChunkSize(int chunkSize) {
        this.setLimit(chunkSize + this.mOffset);
    }

    public void setTypesStr(String groupByStr) throws ServiceException {
        this.mGroupByStr = groupByStr;
        byte[] typesToSet = MailboxIndex.parseTypesString(this.getTypesStr());
        this.setTypesInternal(typesToSet);
    }

    public void setTypes(byte[] _types) {
        boolean atFirst = true;
        StringBuilder s = new StringBuilder();
        for (byte b : _types) {
            if (!atFirst) {
                s.append(',');
            }
            s.append(MailItem.getNameForType(b));
            atFirst = false;
        }
        this.mGroupByStr = s.toString();
        this.setTypesInternal(_types);
    }

    private void setTypesInternal(byte[] _types) {
        this.types = _types;
        this.checkForLocalizedContactSearch();
    }

    private void checkForLocalizedContactSearch() {
    }

    public void setSortBy(SortBy sortBy) {
        this.mSortBy = sortBy;
        this.mSortByStr = this.mSortBy.toString();
        this.checkForLocalizedContactSearch();
    }

    public void setSortByStr(String sortByStr) {
        this.mSortByStr = sortByStr;
        SortBy sb = SortBy.lookup(sortByStr);
        if (sb == null) {
            sb = SortBy.DATE_DESCENDING;
        }
        this.setSortBy(sb);
    }

    public void setInlineRule(ExpandResults fetch) {
        this.mInlineRule = fetch;
    }

    public void setMarkRead(boolean read) {
        this.mMarkRead = read;
    }

    public void setMaxInlinedLength(int maxSize) {
        this.mMaxInlinedLength = maxSize;
    }

    public void setWantHtml(boolean html) {
        this.mWantHtml = html;
    }

    public void setNeuterImages(boolean neuter) {
        this.mNeuterImages = neuter;
    }

    public void addInlinedHeader(String name) {
        if (this.mInlinedHeaders == null) {
            this.mInlinedHeaders = new HashSet<String>();
        }
        this.mInlinedHeaders.add(name);
    }

    public void setWantRecipients(boolean recips) {
        this.mRecipients = recips;
    }

    public void setTimeZone(TimeZone tz) {
        this.mTimeZone = tz;
    }

    public void setLocale(Locale loc) {
        this.mLocale = loc;
        this.checkForLocalizedContactSearch();
    }

    public boolean hasCursor() {
        return this.mHasCursor;
    }

    public void setCursor(ItemId prevMailItemId, String prevSort, int prevOffset, String endSort) {
        this.mHasCursor = true;
        this.mPrevMailItemId = prevMailItemId;
        this.mPrevSortValueStr = prevSort;
        try {
            this.mPrevSortValueLong = Long.parseLong(prevSort);
        }
        catch (NumberFormatException e) {
            this.mPrevSortValueLong = 0L;
        }
        this.mPrevOffset = prevOffset;
        this.mEndSortValueStr = endSort;
        this.mEndSortValueLong = -1L;
        if (this.mEndSortValueStr != null) {
            try {
                this.mEndSortValueLong = Long.parseLong(this.mEndSortValueStr);
            }
            catch (NumberFormatException e) {
                this.mEndSortValueLong = Long.MAX_VALUE;
            }
        }
    }

    public void clearCursor() {
        this.mHasCursor = false;
        this.mPrevOffset = 0;
        this.mPrevMailItemId = null;
        this.mPrevSortValueStr = null;
        this.mPrevSortValueLong = 0L;
        this.mEndSortValueStr = null;
        this.mEndSortValueLong = -1L;
    }

    public void setPrefetch(boolean truthiness) {
        this.mPrefetch = truthiness;
    }

    public void setMode(Mailbox.SearchResultMode mode) {
        this.mMode = mode;
    }

    public void setEstimateSize(boolean estimateSize) {
        this.mEstimateSize = estimateSize;
    }

    public void encodeParams(Element searchElt) {
        if (this.mAllowableTaskStatuses != null) {
            StringBuilder taskStatusStr = new StringBuilder();
            for (TaskHit.Status s : this.mAllowableTaskStatuses) {
                if (taskStatusStr.length() > 0) {
                    taskStatusStr.append(",");
                }
                taskStatusStr.append(s.name());
            }
            searchElt.addAttribute("allowableTaskStatus", taskStatusStr.toString());
        }
        searchElt.addAttribute("includeTagDeleted", this.getIncludeTagDeleted());
        searchElt.addAttribute("calExpandInstStart", this.getCalItemExpandStart());
        searchElt.addAttribute("calExpandInstEnd", this.getCalItemExpandEnd());
        searchElt.addAttribute("query", this.getQueryStr(), Element.Disposition.CONTENT);
        searchElt.addAttribute("types", this.getTypesStr());
        searchElt.addAttribute("sortBy", this.getSortByStr());
        if (this.getInlineRule() != null) {
            searchElt.addAttribute("fetch", this.getInlineRule().toString());
        }
        searchElt.addAttribute("read", this.getMarkRead());
        searchElt.addAttribute("max", this.getMaxInlinedLength());
        searchElt.addAttribute("html", this.getWantHtml());
        searchElt.addAttribute("neuter", this.getNeuterImages());
        if (this.getInlinedHeaders() != null) {
            for (String name : this.getInlinedHeaders()) {
                searchElt.addElement("header").addAttribute("n", name);
            }
        }
        searchElt.addAttribute("recip", this.mRecipients);
        if (this.getLocale() != null) {
            searchElt.addElement("locale").setText(this.getLocale().toString());
        }
        searchElt.addAttribute("prefetch", this.getPrefetch());
        searchElt.addAttribute("resultMode", this.getMode().name());
        searchElt.addAttribute("estimateSize", this.getEstimateSize());
        searchElt.addAttribute("field", this.getDefaultField());
        searchElt.addAttribute("limit", this.mLimit);
        searchElt.addAttribute("offset", this.mOffset);
    }

    public static SearchParams parse(Element request, ZimbraSoapContext zsc, String defaultQueryStr) throws ServiceException {
        Element locElt;
        SearchParams params = new SearchParams();
        params.mRequestContext = zsc;
        params.setHopCount(zsc.getHopCount());
        params.setIncludeTagDeleted(request.getAttributeBool("includeTagDeleted", false));
        String allowableTasks = request.getAttribute("allowableTaskStatus", null);
        if (allowableTasks != null) {
            params.mAllowableTaskStatuses = new HashSet<TaskHit.Status>();
            String[] split = allowableTasks.split(",");
            if (split != null) {
                for (String s : split) {
                    try {
                        TaskHit.Status status = TaskHit.Status.valueOf(s.toUpperCase());
                        params.mAllowableTaskStatuses.add(status);
                    }
                    catch (IllegalArgumentException e) {
                        ZimbraLog.index.debug("Skipping unknown task completion status: " + s);
                    }
                }
            }
        }
        params.setCalItemExpandStart(request.getAttributeLong("calExpandInstStart", -1L));
        params.setCalItemExpandEnd(request.getAttributeLong("calExpandInstEnd", -1L));
        String query = request.getAttribute("query", defaultQueryStr);
        if (query == null) {
            throw ServiceException.INVALID_REQUEST("no query submitted and no default query found", null);
        }
        params.setQueryStr(query);
        params.setTypesStr(request.getAttribute("types", request.getAttribute("groupBy", "conversation")));
        params.setSortByStr(request.getAttribute("sortBy", SortBy.DATE_DESCENDING.toString()));
        params.setInlineRule(ExpandResults.valueOf(request.getAttribute("fetch", null), zsc));
        if (params.getInlineRule() != ExpandResults.NONE) {
            params.setMarkRead(request.getAttributeBool("read", false));
            params.setMaxInlinedLength((int)request.getAttributeLong("max", -1L));
            params.setWantHtml(request.getAttributeBool("html", false));
            params.setNeuterImages(request.getAttributeBool("neuter", true));
            for (Element elt : request.listElements("header")) {
                params.addInlinedHeader(elt.getAttribute("n"));
            }
        }
        params.setWantRecipients(request.getAttributeBool("recip", false));
        Element tzElt = request.getOptionalElement("tz");
        if (tzElt != null) {
            params.setTimeZone(SearchParams.parseTimeZonePart(tzElt));
        }
        if ((locElt = request.getOptionalElement("locale")) != null) {
            params.setLocale(SearchParams.parseLocale(locElt));
        }
        params.setPrefetch(request.getAttributeBool("prefetch", true));
        params.setMode(Mailbox.SearchResultMode.get(request.getAttribute("resultMode", null)));
        String field = request.getAttribute("field", null);
        if (field != null) {
            params.setDefaultField(field);
        }
        params.setLimit(SearchParams.parseLimit(request));
        params.setOffset(SearchParams.parseOffset(request));
        Element cursor = request.getOptionalElement("cursor");
        boolean useCursorToNarrowDbQuery = true;
        switch (params.getSortBy().getType()) {
            case TASK_DUE_ASCENDING: 
            case TASK_DUE_DESCENDING: 
            case TASK_PERCENT_COMPLETE_ASCENDING: 
            case TASK_PERCENT_COMPLETE_DESCENDING: 
            case TASK_STATUS_ASCENDING: 
            case TASK_STATUS_DESCENDING: 
            case NAME_LOCALIZED_ASCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                useCursorToNarrowDbQuery = false;
            }
        }
        for (byte b : params.getTypes()) {
            if (b != 4) continue;
            useCursorToNarrowDbQuery = false;
        }
        if (cursor != null) {
            String cursorStr = cursor.getAttribute("id");
            ItemId prevMailItemId = null;
            if (cursorStr != null) {
                prevMailItemId = new ItemId(cursorStr, zsc);
            }
            int prevOffset = 0;
            String sortVal = cursor.getAttribute("sortVal");
            String endSortVal = cursor.getAttribute("endSortVal", null);
            params.setCursor(prevMailItemId, sortVal, prevOffset, endSortVal);
            String addedPart = null;
            if (useCursorToNarrowDbQuery) {
                switch (params.getSortBy().getType()) {
                    case NONE: {
                        throw new IllegalArgumentException("Invalid request: cannot use cursor with SortBy=NONE");
                    }
                    case DATE_ASCENDING: {
                        addedPart = "date:" + SearchParams.quote(">=", sortVal) + (endSortVal != null ? " date:" + SearchParams.quote("<", endSortVal) : "");
                        break;
                    }
                    case DATE_DESCENDING: {
                        addedPart = "date:" + SearchParams.quote("<=", sortVal) + (endSortVal != null ? " date:" + SearchParams.quote(">", endSortVal) : "");
                        break;
                    }
                    case SUBJ_ASCENDING: {
                        addedPart = "subject:" + SearchParams.quote(">=", sortVal) + (endSortVal != null ? " subject:" + SearchParams.quote("<", endSortVal) : "");
                        break;
                    }
                    case SUBJ_DESCENDING: {
                        addedPart = "subject:" + SearchParams.quote("<=", sortVal) + (endSortVal != null ? " subject:" + SearchParams.quote(">", endSortVal) : "");
                        break;
                    }
                    case SIZE_ASCENDING: {
                        sortVal = "" + (Long.parseLong(sortVal) - 1L);
                        addedPart = "size:" + SearchParams.quote(">", sortVal) + (endSortVal != null ? " size:" + SearchParams.quote("<", endSortVal) : "");
                        break;
                    }
                    case SIZE_DESCENDING: {
                        sortVal = "" + (Long.parseLong(sortVal) + 1L);
                        addedPart = "size:" + SearchParams.quote("<", sortVal) + (endSortVal != null ? " size:" + SearchParams.quote(">", endSortVal) : "");
                        break;
                    }
                    case NAME_ASCENDING: {
                        addedPart = "from:" + SearchParams.quote(">=", sortVal) + (endSortVal != null ? " from:" + SearchParams.quote("<", endSortVal) : "");
                        break;
                    }
                    case NAME_DESCENDING: {
                        addedPart = "from:" + SearchParams.quote("<=", sortVal) + (endSortVal != null ? " from:" + SearchParams.quote(">", endSortVal) : "");
                    }
                }
            }
            if (addedPart != null) {
                params.setQueryStr("(" + params.getQueryStr() + ")" + addedPart);
            }
        }
        return params;
    }

    private static TimeZone parseTimeZonePart(Element tzElt) throws ServiceException {
        String id = tzElt.getAttribute("id");
        ICalTimeZone knownTZ = WellKnownTimeZones.getTimeZoneById(id);
        if (knownTZ != null) {
            return knownTZ;
        }
        String test = tzElt.getAttribute("stdoff", null);
        if (test == null) {
            throw ServiceException.INVALID_REQUEST("Unknown TZ: \"" + id + "\" and no " + "stdoff" + " specified", null);
        }
        return CalendarUtils.parseTzElement(tzElt);
    }

    private static Locale parseLocale(Element localeElt) {
        String locStr = localeElt.getText();
        return SearchParams.lookupLocaleFromString(locStr);
    }

    private static Locale lookupLocaleFromString(String locStr) {
        Matcher m;
        if (locStr != null && locStr.length() > 0 && (m = sLocalePattern.matcher(locStr)).lookingAt()) {
            String lang = null;
            String country = null;
            String variant = null;
            if (m.start(1) != -1) {
                lang = locStr.substring(m.start(1), m.end(1));
            }
            if (lang == null || lang.length() <= 0) {
                return null;
            }
            if (m.start(2) != -1) {
                country = locStr.substring(m.start(2), m.end(2));
            }
            if (m.start(4) != -1) {
                variant = locStr.substring(m.start(4), m.end(4));
            }
            if (variant != null && country != null && variant.length() > 0 && country.length() > 0) {
                return new Locale(lang, country, variant);
            }
            if (country != null && country.length() > 0) {
                return new Locale(lang, country);
            }
            return new Locale(lang);
        }
        return null;
    }

    public static void main(String[] args) {
        Locale l = SearchParams.lookupLocaleFromString("da");
        System.out.println(" got locale: " + l);
        l = SearchParams.lookupLocaleFromString("da_DK");
        System.out.println(" got locale: " + l);
        l = SearchParams.lookupLocaleFromString("en");
        System.out.println(" got locale: " + l);
        l = SearchParams.lookupLocaleFromString("en_US-MAC");
        System.out.println(" got locale: " + l);
    }

    private static final String quote(String s1, String s2) {
        String in = s1 + s2;
        in = in.replace("\"", "\\\"");
        return "\"" + in + "\"";
    }

    private static int parseLimit(Element request) throws ServiceException {
        int limit = (int)request.getAttributeLong("limit", -1L);
        if (limit <= 0) {
            limit = 30;
        }
        if (limit > 1000) {
            limit = 1000;
        }
        return limit;
    }

    private static int parseOffset(Element request) throws ServiceException {
        return (int)request.getAttributeLong("offset", 0L);
    }

    public Object clone() {
        SearchParams o = new SearchParams();
        o.mRequestContext = this.mRequestContext;
        o.mHopCount = this.mHopCount;
        o.mDefaultField = this.mDefaultField;
        o.mQueryStr = this.mQueryStr;
        o.mOffset = this.mOffset;
        o.mLimit = this.mLimit;
        o.mInlineRule = this.mInlineRule;
        o.mMarkRead = this.mMarkRead;
        o.mMaxInlinedLength = this.mMaxInlinedLength;
        o.mWantHtml = this.mWantHtml;
        o.mNeuterImages = this.mNeuterImages;
        o.mInlinedHeaders = this.mInlinedHeaders;
        o.mRecipients = this.mRecipients;
        o.mCalItemExpandStart = this.mCalItemExpandStart;
        o.mCalItemExpandEnd = this.mCalItemExpandEnd;
        o.mIncludeTagDeleted = this.mIncludeTagDeleted;
        o.mTimeZone = this.mTimeZone;
        o.mLocale = this.mLocale;
        o.mHasCursor = this.mHasCursor;
        o.mPrevMailItemId = this.mPrevMailItemId;
        o.mPrevSortValueStr = this.mPrevSortValueStr;
        o.mPrevSortValueLong = this.mPrevSortValueLong;
        o.mPrevOffset = this.mPrevOffset;
        o.mEndSortValueStr = this.mEndSortValueStr;
        o.mEndSortValueLong = this.mEndSortValueLong;
        o.mGroupByStr = this.mGroupByStr;
        o.mSortByStr = this.mSortByStr;
        o.mSortBy = this.mSortBy;
        o.types = this.types;
        o.mPrefetch = this.mPrefetch;
        o.mMode = this.mMode;
        o.mEstimateSize = this.mEstimateSize;
        if (this.mAllowableTaskStatuses != null) {
            o.mAllowableTaskStatuses = new HashSet<TaskHit.Status>();
            o.mAllowableTaskStatuses.addAll(this.mAllowableTaskStatuses);
        }
        return o;
    }

    public static final class ExpandResults {
        public static ExpandResults NONE = new ExpandResults("none");
        public static ExpandResults FIRST = new ExpandResults("first");
        public static ExpandResults HITS = new ExpandResults("hits");
        public static ExpandResults ALL = new ExpandResults("all");
        private final String mRep;
        private ItemId mItemId;

        private ExpandResults(String rep) {
            this.mRep = rep;
        }

        private ExpandResults setId(ItemId iid) {
            this.mItemId = iid;
            return this;
        }

        public boolean matches(MailItem item) {
            return this.mItemId != null && item != null && this.matches(new ItemId(item));
        }

        public boolean matches(ItemId iid) {
            return iid != null && iid.equals(this.mItemId);
        }

        public static ExpandResults valueOf(String value, ZimbraSoapContext zsc) throws ServiceException {
            if (value == null) {
                return NONE;
            }
            if ((value = value.trim().toLowerCase()).equals("none") || value.equals("0") || value.equals("false")) {
                return NONE;
            }
            if (value.equals("first") || value.equals("1")) {
                return FIRST;
            }
            if (value.equals("hits")) {
                return HITS;
            }
            if (value.equals("all")) {
                return ALL;
            }
            ItemId iid = null;
            try {
                iid = new ItemId(value, zsc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iid != null) {
                return new ExpandResults(value).setId(iid);
            }
            throw ServiceException.INVALID_REQUEST("invalid 'fetch' value: " + value, null);
        }

        public String toString() {
            return this.mRep;
        }
    }
}

