/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.MailItem;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultsPager {
    private ZimbraQueryResults mResults;
    private boolean mFixedOffset;
    private boolean mIgnoreOffsetHack = false;
    private AbstractList<ZimbraHit> mBufferedHits = null;
    private SearchParams mParams;
    private boolean mForward = true;

    public SortBy getSortOrder() {
        return this.mParams.getSortBy();
    }

    public static ResultsPager create(ZimbraQueryResults results, SearchParams params) throws ServiceException {
        ResultsPager toRet;
        params.setSortBy(results.getSortBy());
        boolean dontUseCursor = false;
        boolean skipOffsetHack = false;
        switch (params.getSortBy().getType()) {
            case TASK_DUE_ASCENDING: 
            case TASK_DUE_DESCENDING: 
            case TASK_PERCENT_COMPLETE_ASCENDING: 
            case TASK_PERCENT_COMPLETE_DESCENDING: 
            case TASK_STATUS_ASCENDING: 
            case TASK_STATUS_DESCENDING: {
                dontUseCursor = true;
                break;
            }
            case NAME_LOCALIZED_ASCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                dontUseCursor = true;
                skipOffsetHack = true;
            }
        }
        if (dontUseCursor || !params.hasCursor()) {
            toRet = new ResultsPager(results, params, false, true, skipOffsetHack);
        } else {
            boolean forward = true;
            if (params.getOffset() < params.getPrevOffset()) {
                forward = false;
            }
            toRet = new ResultsPager(results, params, true, forward, false);
        }
        return toRet;
    }

    private ResultsPager(ZimbraQueryResults results, SearchParams params, boolean useCursor, boolean forward, boolean skipOffset) throws ServiceException {
        this.mResults = results;
        this.mParams = params;
        this.mFixedOffset = !useCursor;
        this.mIgnoreOffsetHack = skipOffset;
        this.mForward = forward;
        assert (forward || !this.mFixedOffset);
        this.reset();
    }

    public void reset() throws ServiceException {
        if (this.mFixedOffset) {
            int offsetToUse = this.mParams.getOffset();
            if (this.mIgnoreOffsetHack) {
                offsetToUse = 0;
            }
            if (offsetToUse > 0) {
                this.mResults.skipToHit(offsetToUse - 1);
            } else {
                this.mResults.resetIterator();
            }
        } else if (this.mForward) {
            this.mBufferedHits = new ArrayList<ZimbraHit>(1);
            ZimbraHit current = this.forwardFindFirst();
            if (current != null) {
                this.mBufferedHits.add(current);
            }
        } else {
            this.mBufferedHits = this.backward();
        }
    }

    public boolean hasNext() throws ServiceException {
        if (this.mBufferedHits != null && !this.mBufferedHits.isEmpty()) {
            return true;
        }
        return this.mResults.hasNext();
    }

    public ZimbraHit getNextHit() throws ServiceException {
        if (this.mBufferedHits != null && !this.mBufferedHits.isEmpty()) {
            return this.mBufferedHits.remove(0);
        }
        return this.mResults.getNext();
    }

    private ZimbraHit forwardFindFirst() throws ServiceException {
        int offset = 0;
        ZimbraHit prevHit = this.getDummyPrevHit();
        ZimbraHit hit = this.mResults.getFirstHit();
        while (hit != null) {
            ++offset;
            if (hit.getItemId() == this.mParams.getPrevMailItemId().getId()) {
                return this.mResults.getNext();
            }
            int comp = hit.compareBySortField(this.mParams.getSortBy(), prevHit);
            if (comp == 0) {
                if (this.mParams.getPrevMailItemId().getId() == 0) {
                    return hit;
                }
                if (this.mParams.getSortBy().isDescending() ? hit.getItemId() < this.mParams.getPrevMailItemId().getId() : hit.getItemId() > this.mParams.getPrevMailItemId().getId()) {
                    return hit;
                }
                hit = this.mResults.getNext();
                continue;
            }
            if (comp < 0) {
                hit = this.mResults.getNext();
                continue;
            }
            return hit;
        }
        return null;
    }

    private AbstractList<ZimbraHit> backward() throws ServiceException {
        LinkedList<ZimbraHit> ll = new LinkedList<ZimbraHit>();
        int offset = 0;
        ZimbraHit hit = this.mResults.getFirstHit();
        ZimbraHit prevHit = this.getDummyPrevHit();
        ZimbraHit dummyEndHit = null;
        if (this.mParams.hasEndSortValue()) {
            dummyEndHit = this.getDummyEndHit();
        }
        while (hit != null) {
            ++offset;
            ll.addLast(hit);
            if (hit.getItemId() == this.mParams.getPrevMailItemId().getId() || hit.compareBySortField(this.mParams.getSortBy(), prevHit) > 0 || this.mParams.hasEndSortValue() && hit.compareBySortField(this.mParams.getSortBy(), dummyEndHit) <= 0) break;
            hit = this.mResults.getNext();
        }
        return ll;
    }

    private ZimbraHit getDummyPrevHit() {
        long dateVal = 0L;
        String strVal = "";
        strVal = this.mParams.getPrevSortValueStr();
        dateVal = this.mParams.getPrevSortValueLong();
        return new DummyHit(strVal, strVal, dateVal, this.mParams.getPrevMailItemId().getId());
    }

    private ZimbraHit getDummyEndHit() {
        long dateVal = 0L;
        String strVal = "";
        strVal = this.mParams.getEndSortValueStr();
        dateVal = this.mParams.getEndSortValueLong();
        return new DummyHit(strVal, strVal, dateVal, 0);
    }

    static class DummyHit
    extends ZimbraHit {
        private int mItemId;
        private long mDate;
        private String mName;
        private String mSubject;

        DummyHit(String name, String subject, long date, int itemId) {
            super(null, null, 0.0f);
            this.mName = name;
            this.mSubject = subject;
            this.mDate = date;
            this.mItemId = itemId;
        }

        public String toString() {
            return "DummyHit(" + this.mName + "," + this.mSubject + "," + this.mDate + "," + this.mItemId + ")";
        }

        public long getDate() {
            return this.mDate;
        }

        public long getSize() {
            return 0L;
        }

        public int getConversationId() {
            return 0;
        }

        public int getItemId() {
            return this.mItemId;
        }

        public byte getItemType() {
            return 0;
        }

        void setItem(MailItem item) {
        }

        boolean itemIsLoaded() {
            return false;
        }

        public String getSubject() {
            return this.mSubject;
        }

        public String getName() {
            return this.mName;
        }

        public MailItem getMailItem() throws ServiceException {
            return null;
        }
    }
}

