/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.CalendarItemHit;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.ZimbraHit;
import java.util.ArrayList;
import java.util.List;

abstract class ResultValidator {
    protected int mNumExpected = -1;

    ResultValidator() {
    }

    ResultValidator(int numExpected) {
        this.mNumExpected = numExpected;
    }

    int numExpected() {
        return this.mNumExpected;
    }

    boolean numReceived(int num) {
        return this.mNumExpected == num || this.mNumExpected == -1;
    }

    public Object getExpected(int num) {
        return "";
    }

    public abstract void validate(ZimbraHit var1) throws ServiceException;

    public static class ExpectedHitValidator
    extends ResultValidator {
        List<ExpectedHit> mExpected = new ArrayList<ExpectedHit>();
        int curHit = 0;

        ExpectedHitValidator(ExpectedHit ... hits) {
            super(hits.length);
            for (ExpectedHit e : hits) {
                this.mExpected.add(e);
            }
        }

        static boolean checkSubject(String received, String expected) {
            String upperSub = received.toUpperCase();
            if (upperSub.startsWith("RE:  ")) {
                upperSub = upperSub.substring(5);
            } else if (upperSub.startsWith("RE: ")) {
                upperSub = upperSub.substring(4);
            } else if (upperSub.startsWith("RE:")) {
                upperSub = upperSub.substring(3);
            } else if (upperSub.startsWith("FW:  ")) {
                upperSub = upperSub.substring(5);
            } else if (upperSub.startsWith("FW: ")) {
                upperSub = upperSub.substring(4);
            } else if (upperSub.startsWith("FW:")) {
                upperSub = upperSub.substring(3);
            }
            return upperSub.equals(expected.toUpperCase());
        }

        public void validate(ZimbraHit hit) throws ServiceException {
            if (this.curHit >= this.mExpected.size()) {
                throw ServiceException.FAILURE("Too many hits on hit " + this.curHit + ", got: " + hit.toString() + this.getExpectedList(), null);
            }
            ExpectedHit expected = this.mExpected.get(this.curHit);
            if (!expected.check(hit)) {
                throw ServiceException.FAILURE("Invalid hit:\n  Current Hit:\n\t" + hit.toString() + "\n" + this.getExpectedList(), null);
            }
            ++this.curHit;
        }

        public String getExpectedList() {
            StringBuilder sb = new StringBuilder("  Expected: \n");
            int i = 0;
            for (ExpectedHit e : this.mExpected) {
                sb.append("\t").append(i).append(") ").append(e.toString()).append("\n");
                ++i;
            }
            return sb.toString();
        }

        public Object getExpected(int num) {
            return this.mExpected.get(num);
        }
    }

    static class ExpectedMessageHit
    extends ExpectedHit {
        String mSubject;

        public ExpectedMessageHit(String subject) {
            this.mSubject = subject;
        }

        public boolean check(ZimbraHit hit) throws ServiceException {
            if (!(hit instanceof MessageHit)) {
                return false;
            }
            return ExpectedHitValidator.checkSubject(hit.getSubject(), this.mSubject);
        }

        public String toString() {
            return "Message subject=" + this.mSubject;
        }
    }

    static class ExpectedCalendarItemHit
    extends ExpectedHit {
        String mUid;

        public ExpectedCalendarItemHit(String uid) {
            this.mUid = uid;
        }

        public boolean check(ZimbraHit hit) throws ServiceException {
            return hit instanceof CalendarItemHit;
        }

        public String toString() {
            return "CalendarItem uid=" + this.mUid;
        }
    }

    static class QueryResult
    extends ExpectedHit {
        public String mSubject;

        public QueryResult(String subject) {
            this.mSubject = subject;
        }

        public String toString() {
            return this.mSubject;
        }

        public boolean check(ZimbraHit hit) throws ServiceException {
            String subject = hit.getSubject();
            return ExpectedHitValidator.checkSubject(subject, this.mSubject);
        }
    }

    static abstract class ExpectedHit {
        ExpectedHit() {
        }

        public abstract boolean check(ZimbraHit var1) throws ServiceException;
    }
}

