/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.index.FilterQueryOperation;
import com.zimbra.cs.index.ProxiedQueryResults;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.QueryTarget;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.UnionQueryOperation;
import com.zimbra.cs.index.ZimbraHit;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteQueryOperation
extends FilterQueryOperation {
    private ProxiedQueryResults mResults = null;
    private QueryTarget mTarget = null;

    RemoteQueryOperation() {
    }

    boolean tryAddOredOperation(QueryOperation op) {
        QueryTargetSet targets = op.getQueryTargets();
        assert (targets.countExplicitTargets() == 1);
        assert (targets.hasExternalTargets());
        for (QueryTarget t : targets) {
            assert (t != QueryTarget.LOCAL);
            if (t == QueryTarget.UNSPECIFIED) continue;
            if (this.mTarget == null) {
                this.mTarget = t;
                continue;
            }
            if (this.mTarget.equals(t)) continue;
            return false;
        }
        assert (this.mTarget != null);
        if (this.mOp == null) {
            this.mOp = new UnionQueryOperation();
        }
        ((UnionQueryOperation)this.mOp).add(op);
        return true;
    }

    public String toString() {
        return "REMOTE[" + this.mTarget.toString() + "]:" + this.mOp.toString();
    }

    protected void setup(SoapProtocol proto, AuthToken authToken, SearchParams params) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.id, this.mTarget.toString(), authToken);
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(this.mTarget.toString());
        }
        Server remoteServer = prov.getServer(acct);
        if (ZimbraLog.index.isDebugEnabled()) {
            ZimbraLog.index.debug("RemoteQuery of \"" + this.mOp.toQueryString() + "\" sent to " + this.mTarget.toString() + " on server " + remoteServer.getName());
        }
        params.setQueryStr(this.mOp.toQueryString());
        this.mResults = new ProxiedQueryResults(proto, authToken, this.mTarget.toString(), remoteServer.getName(), params, params.getMode());
    }

    @Override
    public void resetIterator() throws ServiceException {
        if (this.mResults != null) {
            this.mResults.resetIterator();
        }
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        if (this.mResults != null) {
            return this.mResults.getNext();
        }
        return null;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        if (this.mResults != null) {
            return this.mResults.peekNext();
        }
        return null;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        if (this.mResults != null) {
            this.mResults.doneWithSearchResults();
        }
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        if (this.mResults != null) {
            return this.mResults.getResultInfo();
        }
        return new ArrayList<QueryInfo>();
    }
}

