/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.cs.index.RefCountedIndexReader;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;

class RefCountedIndexSearcher {
    private Searcher mSearcher;
    private RefCountedIndexReader mReader;
    private int mCount = 1;
    private Sort mSort = null;

    RefCountedIndexSearcher(RefCountedIndexReader reader) {
        this.mReader = reader;
        this.mSearcher = new IndexSearcher(this.mReader.getReader());
    }

    synchronized void setSort(Sort sort) {
        this.mSort = sort;
    }

    synchronized Sort getSort() {
        return this.mSort;
    }

    synchronized Searcher getSearcher() {
        return this.mSearcher;
    }

    synchronized IndexReader getReader() {
        return this.mReader.getReader();
    }

    synchronized void forceClose() {
        this.mReader.forceClose();
        this.mReader = null;
    }

    synchronized void release() {
        this.mSort = null;
        --this.mCount;
        assert (this.mCount >= 0);
        if (0 == this.mCount) {
            this.mReader.release();
            this.mReader = null;
        }
    }

    synchronized RefCountedIndexSearcher addRef() {
        assert (this.mCount > 0);
        ++this.mCount;
        return this;
    }

    synchronized TopDocs search(Query query, Filter filter, int num) throws IOException {
        if (this.mSort == null) {
            return this.getSearcher().search(query, filter, num);
        }
        return this.getSearcher().search(query, filter, num, this.mSort);
    }
}

