/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.ILuceneIndex;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;

final class RefCountedIndexReader {
    private ILuceneIndex mIdx;
    private IndexReader mReader;
    private int mCount = 1;
    private long mAccessTime;
    private boolean mRequiresReopen = false;

    RefCountedIndexReader(ILuceneIndex idx, IndexReader reader) {
        this.mIdx = idx;
        this.mReader = reader;
        this.mAccessTime = System.currentTimeMillis();
    }

    synchronized IndexReader getReader() {
        return this.mReader;
    }

    synchronized void addRef() {
        this.mAccessTime = System.currentTimeMillis();
        ++this.mCount;
    }

    synchronized void forceClose() {
        this.closeIt();
    }

    synchronized void release() {
        --this.mCount;
        assert (this.mCount >= 0);
        if (0 == this.mCount) {
            this.closeIt();
        }
    }

    synchronized boolean markForReopen() {
        if (this.mCount != 1) {
            return false;
        }
        this.mRequiresReopen = true;
        return true;
    }

    synchronized boolean requiresReopen() {
        assert (!this.mRequiresReopen || this.mCount == 1);
        return this.mRequiresReopen;
    }

    synchronized void reopened(IndexReader newReader) {
        assert (this.mRequiresReopen && this.mCount == 1);
        this.mRequiresReopen = false;
        this.mReader = newReader;
    }

    synchronized int getRefCount() {
        return this.mCount;
    }

    synchronized long getAccessTime() {
        return this.mAccessTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIt() {
        try {
            try {
                this.mReader.close();
            }
            catch (IOException e) {
                ZimbraLog.im.debug((Object)"Caught exception while closing IndexReader: ", e);
                Object var3_2 = null;
                this.mReader = null;
                this.mIdx.onReaderClose(this);
            }
            Object var3_1 = null;
            this.mReader = null;
            this.mIdx.onReaderClose(this);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mReader = null;
            this.mIdx.onReaderClose(this);
            throw throwable;
        }
    }
}

