/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.LocalizedSortBy;
import com.zimbra.cs.index.ProxiedHit;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.ResultsPager;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TaskHit;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReSortingQueryResults
implements ZimbraQueryResults {
    static final int MAX_BUFFERED_HITS = 10000;
    private ZimbraQueryResults mResults;
    private SortBy mDesiredSort;
    private List<ZimbraHit> mHitBuffer = null;
    private int mIterOffset = 0;
    private SearchParams mParams = null;

    ReSortingQueryResults(ZimbraQueryResults results, SortBy desiredSort, SearchParams params) throws ServiceException {
        this.mResults = results;
        this.mDesiredSort = desiredSort;
        this.mParams = params;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        this.mResults.doneWithSearchResults();
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        return this.mResults.estimateResultSize();
    }

    @Override
    public ZimbraHit getFirstHit() throws ServiceException {
        this.mIterOffset = 0;
        return this.getNext();
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        if (this.hasNext()) {
            ZimbraHit toRet = this.peekNext();
            ++this.mIterOffset;
            return toRet;
        }
        return null;
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        return this.mResults.getResultInfo();
    }

    @Override
    public SortBy getSortBy() {
        return this.mDesiredSort;
    }

    @Override
    public boolean hasNext() throws ServiceException {
        List<ZimbraHit> buffer = this.getHitBuffer();
        return this.mIterOffset < buffer.size();
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        List<ZimbraHit> buffer = this.getHitBuffer();
        if (this.hasNext()) {
            return buffer.get(this.mIterOffset);
        }
        return null;
    }

    @Override
    public void resetIterator() throws ServiceException {
        this.mIterOffset = 0;
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        List<ZimbraHit> buffer = this.getHitBuffer();
        this.mIterOffset = hitNo >= buffer.size() ? buffer.size() : hitNo;
        return this.getNext();
    }

    private List<ZimbraHit> getHitBuffer() throws ServiceException {
        if (this.mHitBuffer == null) {
            this.bufferAllHits();
        }
        return this.mHitBuffer;
    }

    private boolean isTaskSort() {
        switch (this.mDesiredSort.getType()) {
            case TASK_DUE_ASCENDING: 
            case TASK_DUE_DESCENDING: 
            case TASK_STATUS_ASCENDING: 
            case TASK_STATUS_DESCENDING: 
            case TASK_PERCENT_COMPLETE_ASCENDING: 
            case TASK_PERCENT_COMPLETE_DESCENDING: {
                return true;
            }
        }
        return false;
    }

    private void bufferAllHits() throws ServiceException {
        ZimbraHit cur;
        Comparator<ZimbraHit> comp;
        assert (this.mHitBuffer == null);
        this.mHitBuffer = new ArrayList<ZimbraHit>();
        switch (this.mDesiredSort.getType()) {
            default: {
                comp = new Comparator<ZimbraHit>(){

                    @Override
                    public int compare(ZimbraHit lhs, ZimbraHit rhs) {
                        return TaskHit.compareByDueDate(true, lhs, rhs);
                    }
                };
                break;
            }
            case TASK_DUE_DESCENDING: {
                comp = new Comparator<ZimbraHit>(){

                    @Override
                    public int compare(ZimbraHit lhs, ZimbraHit rhs) {
                        return TaskHit.compareByDueDate(false, lhs, rhs);
                    }
                };
                break;
            }
            case TASK_STATUS_ASCENDING: {
                comp = new Comparator<ZimbraHit>(){

                    @Override
                    public int compare(ZimbraHit lhs, ZimbraHit rhs) {
                        return TaskHit.compareByStatus(true, lhs, rhs);
                    }
                };
                break;
            }
            case TASK_STATUS_DESCENDING: {
                comp = new Comparator<ZimbraHit>(){

                    @Override
                    public int compare(ZimbraHit lhs, ZimbraHit rhs) {
                        return TaskHit.compareByStatus(false, lhs, rhs);
                    }
                };
                break;
            }
            case TASK_PERCENT_COMPLETE_ASCENDING: {
                comp = new Comparator<ZimbraHit>(){

                    @Override
                    public int compare(ZimbraHit lhs, ZimbraHit rhs) {
                        return TaskHit.compareByCompletionPercent(true, lhs, rhs);
                    }
                };
                break;
            }
            case TASK_PERCENT_COMPLETE_DESCENDING: {
                comp = new Comparator<ZimbraHit>(){

                    @Override
                    public int compare(ZimbraHit lhs, ZimbraHit rhs) {
                        return TaskHit.compareByCompletionPercent(false, lhs, rhs);
                    }
                };
                break;
            }
            case NAME_LOCALIZED_ASCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                comp = ((LocalizedSortBy)this.mDesiredSort).getZimbraHitComparator();
            }
        }
        while ((cur = this.mResults.getNext()) != null) {
            if (this.isTaskSort() && !(cur instanceof TaskHit) && !(cur instanceof ProxiedHit)) {
                throw ServiceException.FAILURE("Invalid hit type, can only task-sort Tasks", null);
            }
            boolean skipHit = false;
            if (this.mParams != null && this.mParams.hasCursor()) {
                ResultsPager.DummyHit firstHit = null;
                if (this.mParams.getPrevSortValueStr() != null) {
                    firstHit = new ResultsPager.DummyHit(this.mParams.getPrevSortValueStr(), this.mParams.getPrevSortValueStr(), this.mParams.getPrevSortValueLong(), this.mParams.getPrevMailItemId().getId());
                }
                ResultsPager.DummyHit endHit = null;
                if (this.mParams.getEndSortValueStr() != null) {
                    endHit = new ResultsPager.DummyHit(this.mParams.getEndSortValueStr(), this.mParams.getEndSortValueStr(), this.mParams.getEndSortValueLong(), 0);
                }
                if (firstHit != null && comp.compare(cur, firstHit) < 0) {
                    skipHit = true;
                }
                if (endHit != null && comp.compare(cur, endHit) >= 0) {
                    skipHit = true;
                }
            }
            if (!skipHit) {
                this.mHitBuffer.add(cur);
            }
            if (this.mHitBuffer.size() < 10000) continue;
            break;
        }
        Collections.sort(this.mHitBuffer, comp);
    }
}

