/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import java.io.IOException;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SingleInstanceLockFactory;

public class RawIndexEditor {
    private FSDirectory mIdxDirectory = null;

    RawIndexEditor(String idxPath) throws IOException {
        this.mIdxDirectory = FSDirectory.getDirectory((String)idxPath);
        if (this.mIdxDirectory.getLockFactory() == null || !(this.mIdxDirectory.getLockFactory() instanceof SingleInstanceLockFactory)) {
            this.mIdxDirectory.setLockFactory(new SingleInstanceLockFactory());
        }
    }

    public static String Format(String s, int len) {
        StringBuffer toRet = new StringBuffer(len + 1);
        int curOff = 0;
        if (s.length() < len) {
            for (curOff = 0; curOff < len - s.length(); ++curOff) {
                toRet.append(" ");
            }
        }
        int sOff = 0;
        while (curOff < len) {
            toRet.append(s.charAt(sOff));
            ++sOff;
            ++curOff;
        }
        toRet.append("  ");
        return toRet.toString();
    }

    public boolean dumpDocument(Document d, boolean isDeleted) {
        String dateStr;
        Field f;
        if (isDeleted) {
            System.out.print("DELETED ");
        }
        String subj = (f = d.getField("subject")) != null ? f.stringValue() : "MISSING_SUBJECT";
        f = d.getField("l.mbox_blob_id");
        String blobId = f != null ? f.stringValue() : "MISSING";
        String part = d.get("l.partname");
        if (part == null) {
            part = "NULL_PART";
        }
        dateStr = (dateStr = d.get("l.date")) == null ? "" : DateField.stringToDate(dateStr).toString();
        String sizeStr = d.get("l.size");
        if (sizeStr == null) {
            sizeStr = "";
        }
        System.out.println(RawIndexEditor.Format(blobId, 10) + RawIndexEditor.Format(dateStr, 30) + RawIndexEditor.Format(part, 10) + RawIndexEditor.Format(sizeStr, 10) + "\"" + subj + "\"");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpAll() throws IOException {
        IndexReader reader = IndexReader.open(this.mIdxDirectory);
        try {
            int maxDoc = reader.maxDoc();
            System.out.println("There are " + maxDoc + " documents in this index.");
            for (int i = 0; i < maxDoc; ++i) {
                this.dumpDocument(reader.document(i), reader.isDeleted(i));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    void run() throws IOException {
        this.dumpAll();
    }

    public static void main(String[] args) {
        String idxParentDir = args[0];
        try {
            RawIndexEditor editor = new RawIndexEditor(idxParentDir);
            editor.run();
        }
        catch (IOException e) {
            System.err.println("Caught IOException " + e);
        }
    }
}

