/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

class QueryTarget {
    public static QueryTarget UNSPECIFIED = new QueryTarget();
    public static QueryTarget LOCAL = new QueryTarget();
    public static QueryTarget IS_REMOTE = new QueryTarget();
    private String mTarget;

    private QueryTarget() {
        this.mTarget = null;
    }

    public QueryTarget(String target) {
        this.mTarget = target;
    }

    public boolean isCompatibleLocal() {
        return this == UNSPECIFIED || this == LOCAL;
    }

    public boolean isCompatible(String targetAcctId) {
        if (this.isCompatibleLocal()) {
            return false;
        }
        if (this == IS_REMOTE) {
            return false;
        }
        return this.mTarget.equals(targetAcctId);
    }

    public String toString() {
        if (this == UNSPECIFIED) {
            return "UNSPECIFIED";
        }
        if (this == LOCAL) {
            return "LOCAL";
        }
        return this.mTarget;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            QueryTarget o = (QueryTarget)other;
            if (this.mTarget == null || o.mTarget == null) {
                return this == other;
            }
            return this.mTarget.equals(o.mTarget);
        }
        return false;
    }

    public int hashCode() {
        if (this.mTarget != null) {
            return this.mTarget.hashCode();
        }
        return 0;
    }
}

