/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ConvQueryResults;
import com.zimbra.cs.index.ItemPreloadingGrouper;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.MsgQueryResults;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.UngroupedQueryResults;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import java.io.IOException;

abstract class QueryOperation
implements Cloneable,
ZimbraQueryResults {
    static final int MIN_CHUNK_SIZE = 26;
    static final int MAX_CHUNK_SIZE = 5000;
    protected SearchParams mParams;
    private static final float MESSAGES_PER_CONV_ESTIMATE = 2.25f;
    private boolean mIsToplevelQueryOp = false;
    private ZimbraQueryResultsImpl mResults;
    private Mailbox mMailbox;

    QueryOperation() {
    }

    abstract String toQueryString();

    public SortBy getSortBy() {
        return this.mParams.getSortBy();
    }

    final ZimbraQueryResults run(Mailbox mbox, MailboxIndex mbidx, SearchParams params, int chunkSize) throws IOException, ServiceException {
        this.mParams = params;
        this.mIsToplevelQueryOp = true;
        if (++chunkSize < 26) {
            chunkSize = 26;
        } else if (chunkSize > 5000) {
            chunkSize = 5000;
        }
        Grouping retType = Grouping.ITEM;
        byte[] types = this.mParams.getTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == 4) {
                retType = Grouping.CONVERSATION;
                break;
            }
            if (types[i] != 5) continue;
            retType = Grouping.MESSAGE;
            break;
        }
        boolean preloadOuterResults = false;
        int outerChunkSize = chunkSize;
        boolean usePreloadingGrouper = true;
        if (this.mParams.getMode() == Mailbox.SearchResultMode.IDS) {
            usePreloadingGrouper = false;
        }
        switch (retType) {
            case CONVERSATION: {
                if (this.mParams.getPrefetch() && usePreloadingGrouper) {
                    this.setupResults(mbox, new ConvQueryResults(new ItemPreloadingGrouper(this, chunkSize += 2, mbox), types, this.mParams.getSortBy(), this.mParams.getMode()));
                    chunkSize = (int)((float)chunkSize * 2.25f);
                } else {
                    ++chunkSize;
                    this.setupResults(mbox, new ConvQueryResults(this, types, this.mParams.getSortBy(), this.mParams.getMode()));
                    chunkSize = (int)((float)chunkSize * 2.25f);
                }
                preloadOuterResults = true;
                break;
            }
            case MESSAGE: {
                if (this.mParams.getPrefetch() && usePreloadingGrouper) {
                    this.setupResults(mbox, new MsgQueryResults(new ItemPreloadingGrouper(this, chunkSize += 2, mbox), types, this.mParams.getSortBy(), this.mParams.getMode()));
                    break;
                }
                ++chunkSize;
                this.setupResults(mbox, new MsgQueryResults(this, types, this.mParams.getSortBy(), this.mParams.getMode()));
                break;
            }
            case ITEM: {
                if (this.mParams.getPrefetch() && usePreloadingGrouper) {
                    this.setupResults(mbox, new UngroupedQueryResults(new ItemPreloadingGrouper(this, ++chunkSize, mbox), types, this.mParams.getSortBy(), this.mParams.getMode()));
                    break;
                }
                this.setupResults(mbox, new UngroupedQueryResults(this, types, this.mParams.getSortBy(), this.mParams.getMode()));
            }
        }
        this.prepare(this.mMailbox, this.mResults, mbidx, this.mParams, chunkSize);
        if (usePreloadingGrouper && preloadOuterResults && this.mParams.getPrefetch()) {
            return new ItemPreloadingGrouper(this.mResults, outerChunkSize, mbox);
        }
        return this.mResults;
    }

    public boolean hasNext() throws ServiceException {
        return this.peekNext() != null;
    }

    protected abstract void prepare(Mailbox var1, ZimbraQueryResultsImpl var2, MailboxIndex var3, SearchParams var4, int var5) throws IOException, ServiceException;

    public ZimbraHit getFirstHit() throws ServiceException {
        this.resetIterator();
        return this.getNext();
    }

    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        this.resetIterator();
        for (int i = 0; i < hitNo; ++i) {
            if (!this.hasNext()) {
                return null;
            }
            this.getNext();
        }
        return this.getNext();
    }

    abstract QueryTargetSet getQueryTargets();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    protected boolean isTopLevelQueryOp() {
        return this.mIsToplevelQueryOp;
    }

    protected final Mailbox getMailbox() {
        return this.mMailbox;
    }

    protected final ZimbraQueryResultsImpl getResultsSet() {
        return this.mResults;
    }

    protected final void setupResults(Mailbox mbx, ZimbraQueryResultsImpl res) {
        this.mMailbox = mbx;
        this.mResults = res;
    }

    abstract QueryOperation ensureSpamTrashSetting(Mailbox var1, boolean var2, boolean var3) throws ServiceException;

    abstract boolean hasSpamTrashSetting();

    abstract void forceHasSpamTrashSetting();

    abstract boolean hasNoResults();

    abstract boolean hasAllResults();

    abstract QueryOperation expandLocalRemotePart(Mailbox var1) throws ServiceException;

    abstract QueryOperation optimize(Mailbox var1) throws ServiceException;

    protected abstract QueryOperation combineOps(QueryOperation var1, boolean var2);

    protected abstract void depthFirstRecurse(RecurseCallback var1);

    static interface RecurseCallback {
        public void recurseCallback(QueryOperation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Grouping {
        CONVERSATION,
        MESSAGE,
        ITEM;

    }
}

